/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBExtensionFilter;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.impl.ContainerManagedEntityExtensionImpl;
import com.ibm.ejs.models.base.extensions.ejbext.impl.LocalModelledPersistentAttributeFilter;
import com.ibm.etools.ejb.CMPAttribute;
import com.ibm.etools.ejb.CMRField;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBRelationshipRole;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.ejb.Query;
import com.ibm.etools.ejb.QueryMethod;
import com.ibm.etools.ejb.Session;
import com.ibm.etools.ejb.util.CMPSpecAdapter;
import com.ibm.etools.java.ArrayType;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaPackage;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.JavaVisibilityKind;
import com.ibm.etools.java.Method;
import com.ibm.etools.java.impl.JavaClassImpl;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.LogEntry;
import com.ibm.etools.validation.ejb.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class ValidationRuleUtility {
    public static long method_and_field_counter = 1L;
    private static final String[] _reservedWords = new String[]{"SELECT", "FROM", "WHERE", "DISTINCT", "OBJECT", "NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "AS", "UNKNOWN", "EMPTY", "MEMBER", "OF", "IS"};
    private static final String COMMA = ", ";

    public static JavaClass getCMRFieldType(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, CMRField cMRField) {
        EJBRelationshipRole eJBRelationshipRole = cMRField.getRole();
        if (!eJBRelationshipRole.isMany()) {
            ContainerManagedEntity containerManagedEntity = eJBRelationshipRole.getTypeEntity();
            if (containerManagedEntity == null) {
                return null;
            }
            JavaClass javaClass2 = containerManagedEntity.getLocalInterface();
            try {
                ValidationRuleUtility.isValidTypeHierarchy((EnterpriseBean)containerManagedEntity, (JavaHelpers)javaClass2);
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
            return javaClass2;
        }
        return cMRField.getCollectionType();
    }

    public static final FinderDescriptor getFinderDescriptor(ContainerManagedEntityExtension containerManagedEntityExtension, Method method) {
        if (containerManagedEntityExtension == null || method == null) {
            return null;
        }
        if (containerManagedEntityExtension instanceof ContainerManagedEntityExtensionImpl) {
            return ((ContainerManagedEntityExtensionImpl)containerManagedEntityExtension).getFinderDescriptor(method);
        }
        return null;
    }

    public static final boolean followsFinderExceptionRules(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsFinderException(enterpriseBean, method);
    }

    public static final boolean followsObjectNotFoundExceptionRules(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        JavaHelpers javaHelpers = ValidationRuleUtility.getType("java.util.Enumeration", enterpriseBean);
        if (ValidationRuleUtility.isAssignableFrom(method.getReturnType(), javaHelpers)) {
            return !ValidationRuleUtility.throwsObjectNotFoundException(enterpriseBean, method);
        }
        JavaHelpers javaHelpers2 = ValidationRuleUtility.getType("java.util.Collection", enterpriseBean);
        if (ValidationRuleUtility.isAssignableFrom(method.getReturnType(), javaHelpers2)) {
            return !ValidationRuleUtility.throwsObjectNotFoundException(enterpriseBean, method);
        }
        return true;
    }

    private static Method getMethod(String string, JavaParameter[] javaParameterArray, List list) {
        if (list == null) {
            return null;
        }
        Method method = null;
        JavaParameter[] javaParameterArray2 = null;
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            method = (Method)iterator.next();
            if (!method.getName().equals(string) || (javaParameterArray2 = method.listParametersWithoutReturn()).length != javaParameterArray.length) continue;
            bl = true;
            int n = 0;
            while (n < javaParameterArray2.length) {
                JavaHelpers javaHelpers;
                JavaHelpers javaHelpers2 = (JavaHelpers)javaParameterArray2[n].getEType();
                if (!ValidationRuleUtility.isSameType(javaHelpers2, javaHelpers = (JavaHelpers)javaParameterArray[n].getEType())) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(String string, JavaHelpers[] javaHelpersArray, List list) {
        if (list == null) {
            return null;
        }
        Method method = null;
        JavaParameter[] javaParameterArray = null;
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            method = (Method)iterator.next();
            if (!method.getName().equals(string) || (javaParameterArray = method.listParametersWithoutReturn()).length != javaHelpersArray.length) continue;
            bl = true;
            int n = 0;
            while (n < javaParameterArray.length) {
                JavaHelpers javaHelpers;
                JavaHelpers javaHelpers2 = (JavaHelpers)javaParameterArray[n].getEType();
                if (!ValidationRuleUtility.isSameType(javaHelpers2, javaHelpers = javaHelpersArray[n])) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            return method;
        }
        return null;
    }

    public static Method getMethod(Method method, String string, List list) {
        if (list == null) {
            return null;
        }
        return ValidationRuleUtility.getMethod(string, method.listParametersWithoutReturn(), list);
    }

    public static Method getMethodExtended(JavaClass javaClass, Method method, String string) throws InvalidInputException {
        if (javaClass == null || method == null || string == null) {
            return null;
        }
        return ValidationRuleUtility.getMethodExtended(javaClass, string, method.listParametersWithoutReturn());
    }

    public static Method getMethodExtended(JavaClass javaClass, String string, JavaParameter[] javaParameterArray) {
        if (javaClass.isInterface()) {
            return ValidationRuleUtility.getMethodInterfaceExtended(javaClass, string, javaParameterArray);
        }
        Method method = null;
        EList eList = null;
        do {
            if ((method = ValidationRuleUtility.getMethod(string, javaParameterArray, (List)(eList = javaClass.getMethods()))) != null) {
                return method;
            }
            javaClass = javaClass.getSupertype();
        } while (method == null && javaClass != null);
        return null;
    }

    public static Method getMethodExtended(JavaClass javaClass, String string, JavaHelpers[] javaHelpersArray) {
        return ValidationRuleUtility.getMethodExtended(javaClass, string, javaHelpersArray, null);
    }

    public static Method getMethodExtended(JavaClass javaClass, String string, JavaHelpers[] javaHelpersArray, JavaHelpers javaHelpers) {
        if (javaClass.isInterface()) {
            return ValidationRuleUtility.getMethodInterfaceExtended(javaClass, string, javaHelpersArray);
        }
        Method method = null;
        EList eList = null;
        do {
            if ((method = ValidationRuleUtility.getMethod(string, javaHelpersArray, (List)(eList = javaClass.getMethods()))) != null) {
                if (javaHelpers != null) {
                    JavaHelpers javaHelpers2 = method.getReturnType();
                    if (ValidationRuleUtility.isAssignableFrom(javaHelpers2, javaHelpers)) {
                        return method;
                    }
                } else {
                    return method;
                }
            }
            javaClass = javaClass.getSupertype();
        } while (method == null && javaClass != null);
        return null;
    }

    public static Method getMethodInterfaceExtended(JavaClass javaClass, String string, JavaParameter[] javaParameterArray) {
        if (javaClass == null) {
            return null;
        }
        Method method = ValidationRuleUtility.getMethod(string, javaParameterArray, (List)javaClass.getMethods());
        if (method != null) {
            return method;
        }
        EList eList = javaClass.getImplementsInterfaces();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            javaClass = (JavaClass)iterator.next();
            method = ValidationRuleUtility.getMethodInterfaceExtended(javaClass, string, javaParameterArray);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Method getMethodInterfaceExtended(JavaClass javaClass, String string, JavaHelpers[] javaHelpersArray) {
        if (javaClass == null) {
            return null;
        }
        Method method = ValidationRuleUtility.getMethod(string, javaHelpersArray, (List)javaClass.getMethods());
        if (method != null) {
            return method;
        }
        EList eList = javaClass.getImplementsInterfaces();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            javaClass = (JavaClass)iterator.next();
            method = ValidationRuleUtility.getMethodInterfaceExtended(javaClass, string, javaHelpersArray);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static final Set getNotSubsetExceptions(EnterpriseBean enterpriseBean, Method method, Method method2) {
        if (method2 == null || method == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
        EList eList = method2.getJavaExceptions();
        EList eList2 = method.getJavaExceptions();
        int n = 0;
        while (n < eList2.size()) {
            JavaClass javaClass = (JavaClass)eList2.get(n);
            if (!(ValidationRuleUtility.isRuntimeException(javaClass, enterpriseBean) || ValidationRuleUtility.isRemoteException(javaClass, enterpriseBean) || ValidationRuleUtility.isExceptionInList(javaClass, (List)eList))) {
                hashSet.add(javaClass);
            }
            ++n;
        }
        return hashSet;
    }

    public static boolean isEJBHomeMethod(EnterpriseBean enterpriseBean, Method method) {
        return ValidationRuleUtility.isSameType(enterpriseBean, method.getContainingJavaClass(), "javax.ejb.EJBHome");
    }

    public static boolean isEJBObjectMethod(EnterpriseBean enterpriseBean, Method method) {
        return ValidationRuleUtility.isSameType(enterpriseBean, method.getContainingJavaClass(), "javax.ejb.EJBObject");
    }

    public static final boolean isExceptionInList(JavaClass javaClass, List list) {
        if (javaClass == null || list == null) {
            return false;
        }
        if (!javaClass.isExistingType()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass, (JavaHelpers)javaClass2)) continue;
            return true;
        }
        return false;
    }

    public static final String getQualifiedName(JavaHelpers javaHelpers) {
        if (javaHelpers == null) {
            return "";
        }
        return javaHelpers.getJavaName();
    }

    public static final String getParmsAsString(Method method) {
        if (method == null) {
            return "";
        }
        return ValidationRuleUtility.getParmsAsString(method.listParametersWithoutReturn());
    }

    public static final String getParmsAsString(JavaParameter[] javaParameterArray) {
        if (javaParameterArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < javaParameterArray.length) {
            JavaHelpers javaHelpers = javaParameterArray[n].getJavaType();
            stringBuffer.append(javaHelpers == null ? "null" : javaHelpers.getJavaName());
            stringBuffer.append(COMMA);
            ++n;
        }
        return stringBuffer.substring(0, stringBuffer.length() - 2);
    }

    public static final String getParmsAsString(JavaHelpers[] javaHelpersArray) {
        if (javaHelpersArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < javaHelpersArray.length) {
            JavaHelpers javaHelpers = javaHelpersArray[n];
            stringBuffer.append(javaHelpers == null ? "null" : javaHelpers.getJavaName());
            stringBuffer.append(COMMA);
            ++n;
        }
        return stringBuffer.substring(0, stringBuffer.length() - 2);
    }

    public static final JavaHelpers getType(EClassifier eClassifier) {
        if (eClassifier == null) {
            return null;
        }
        JavaHelpers javaHelpers = (JavaHelpers)eClassifier;
        return javaHelpers;
    }

    public static JavaHelpers getType(String string, EnterpriseBean enterpriseBean) throws InvalidInputException {
        if (string == null || string.equals("") || enterpriseBean == null) {
            throw new InvalidInputException();
        }
        Resource resource = enterpriseBean.eResource();
        if (resource == null) {
            throw new InvalidInputException();
        }
        return ValidationRuleUtility.getType(string, resource.getResourceSet());
    }

    public static JavaHelpers getType(String string, ResourceSet resourceSet) throws InvalidInputException {
        return ValidationRuleUtility.getType(string, resourceSet, true);
    }

    public static JavaHelpers getType(String string, ResourceSet resourceSet, boolean bl) throws InvalidInputException {
        if (string == null || string.equals("") || resourceSet == null) {
            MsgLogger msgLogger = Logger.getMsgLogger();
            if (msgLogger.isLoggingLevel(7)) {
                LogEntry logEntry = Logger.getLogEntry();
                logEntry.setSourceID("ValidationRuleUtility.getType(String, ResourceSet, boolean)");
                logEntry.setText("invalid parameter; javaClassName = {0} and resourceSet = {1}");
                logEntry.setTokens(new String[]{string, String.valueOf(resourceSet)});
                logEntry.appendStackTrace();
                msgLogger.write(7, (Object)logEntry);
            }
            throw new InvalidInputException();
        }
        JavaHelpers javaHelpers = JavaClassImpl.reflect((String)string, (ResourceSet)resourceSet);
        if (bl) {
            ValidationRuleUtility.isValidType(javaHelpers);
        }
        return javaHelpers;
    }

    public static final JavaHelpers getType(Field field) {
        if (field == null) {
            return null;
        }
        return (JavaHelpers)field.getEType();
    }

    public static final boolean onClass(JavaClass javaClass, Method method) {
        if (javaClass == null || method == null) {
            return false;
        }
        return javaClass.equals(method.getJavaClass());
    }

    public static final boolean onClass(JavaClass javaClass, Field field) {
        if (javaClass == null || field == null) {
            return false;
        }
        return javaClass.equals(field.getJavaClass());
    }

    public static final boolean isApplicationException(JavaClass javaClass, EnterpriseBean enterpriseBean) {
        if (javaClass == null) {
            return false;
        }
        try {
            if (ValidationRuleUtility.isSameType((JavaHelpers)javaClass, ValidationRuleUtility.getType("javax.ejb.EJBException", enterpriseBean))) {
                return false;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return !ValidationRuleUtility.isRemoteException(javaClass, enterpriseBean);
    }

    public static final boolean isRemoteMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        try {
            JavaHelpers javaHelpers = ValidationRuleUtility.getType("java.rmi.Remote", enterpriseBean);
            if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass, javaHelpers)) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        return false;
    }

    public static final boolean isReservedWord(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toUpperCase();
        int n = 0;
        while (n < _reservedWords.length) {
            if (string2.equals(_reservedWords[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final boolean isRuntimeException(JavaClass javaClass, EnterpriseBean enterpriseBean) {
        if (javaClass == null) {
            return false;
        }
        try {
            JavaHelpers javaHelpers = ValidationRuleUtility.getType("java.lang.RuntimeException", enterpriseBean);
            return ValidationRuleUtility.isException(javaClass, javaHelpers.getWrapper());
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static final boolean isRemoteException(JavaClass javaClass, EnterpriseBean enterpriseBean) {
        if (javaClass == null) {
            return false;
        }
        try {
            JavaHelpers javaHelpers = ValidationRuleUtility.getType("java.rmi.RemoteException", enterpriseBean);
            return ValidationRuleUtility.isException(javaClass, javaHelpers.getWrapper());
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static final boolean isException(JavaClass javaClass, JavaClass javaClass2) {
        if (javaClass == null || javaClass2 == null) {
            return false;
        }
        return ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass, (JavaHelpers)javaClass2);
    }

    public static boolean isAssignableFromCollection(JavaHelpers javaHelpers, EnterpriseBean enterpriseBean) throws InvalidInputException {
        JavaHelpers javaHelpers2 = ValidationRuleUtility.getType("java.util.Collection", enterpriseBean);
        return ValidationRuleUtility.isAssignableFrom(javaHelpers, javaHelpers2);
    }

    public static boolean isAssignableFromEnumeration(JavaHelpers javaHelpers, EnterpriseBean enterpriseBean) throws InvalidInputException {
        JavaHelpers javaHelpers2 = ValidationRuleUtility.getType("java.util.Enumeration", enterpriseBean);
        return ValidationRuleUtility.isAssignableFrom(javaHelpers, javaHelpers2);
    }

    public static boolean isAssignableFromSet(JavaHelpers javaHelpers, EnterpriseBean enterpriseBean) throws InvalidInputException {
        JavaHelpers javaHelpers2 = ValidationRuleUtility.getType("java.util.Set", enterpriseBean);
        return ValidationRuleUtility.isAssignableFrom(javaHelpers, javaHelpers2);
    }

    public static boolean isAssignableFrom(JavaHelpers javaHelpers, JavaHelpers javaHelpers2) {
        if (javaHelpers == null || javaHelpers2 == null) {
            return false;
        }
        if (javaHelpers.isPrimitive() || javaHelpers2.isPrimitive()) {
            if (javaHelpers.isPrimitive() && javaHelpers2.isPrimitive()) {
                return javaHelpers.getPrimitive().equals(javaHelpers2.getPrimitive());
            }
            return false;
        }
        if (javaHelpers.isArray() && javaHelpers2.isArray()) {
            JavaClass javaClass = javaHelpers.getWrapper();
            JavaClass javaClass2 = javaHelpers2.getWrapper();
            if (javaClass == null || javaHelpers2 == null) {
                return false;
            }
            JavaHelpers javaHelpers3 = ((ArrayType)javaClass).getFinalComponentType();
            JavaHelpers javaHelpers4 = ((ArrayType)javaClass2).getFinalComponentType();
            return ValidationRuleUtility.isAssignableFrom(javaHelpers3, javaHelpers4);
        }
        return javaHelpers2.getWrapper().isAssignableFrom((EClassifier)javaHelpers.getWrapper());
    }

    public static final boolean isAssociatedWithQuery(ContainerManagedEntity containerManagedEntity, Method method) {
        EList eList = containerManagedEntity.getQueries();
        Iterator iterator = eList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Query query = (Query)iterator.next();
            QueryMethod queryMethod = query.getQueryMethod();
            if (queryMethod == null || queryMethod.getName() == null || queryMethod.getName().equals("") || !queryMethod.getName().equals(method.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static final boolean isBeanManagedSession(EnterpriseBean enterpriseBean) {
        if (enterpriseBean == null) {
            return false;
        }
        if (enterpriseBean.isEntity()) {
            return false;
        }
        return ((Session)enterpriseBean).getTransactionType().getValue() == 0;
    }

    public static boolean isClinitMethod(EnterpriseBean enterpriseBean, Method method) {
        if (method == null) {
            return false;
        }
        return method.getName().equals("<clinit>");
    }

    public static final boolean isJNDINamingContext(Field field) {
        return true;
    }

    public static boolean isJavaLangObjectField(EnterpriseBean enterpriseBean, Field field) {
        return ValidationRuleUtility.isSameType(enterpriseBean, field.getContainingJavaClass(), "java.lang.Object");
    }

    public static boolean isOwnedBy(EnterpriseBean enterpriseBean, Method method, String string) {
        return ValidationRuleUtility.isSameType(enterpriseBean, method.getContainingJavaClass(), string);
    }

    public static boolean isSameType(EnterpriseBean enterpriseBean, JavaClass javaClass, String string) {
        try {
            JavaHelpers javaHelpers = ValidationRuleUtility.getType(string, enterpriseBean);
            if (javaHelpers == null) {
                return false;
            }
            JavaClass javaClass2 = javaHelpers.getWrapper();
            return ValidationRuleUtility.isSameType((JavaHelpers)javaClass, (JavaHelpers)javaClass2);
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static boolean isSameType(JavaHelpers javaHelpers, JavaHelpers javaHelpers2) {
        if (javaHelpers == null) {
            return false;
        }
        if (javaHelpers2 == null) {
            return false;
        }
        if (javaHelpers.isPrimitive() && javaHelpers2.isPrimitive()) {
            return javaHelpers.getPrimitive().equals(javaHelpers2.getPrimitive());
        }
        if (javaHelpers.isArray() && javaHelpers2.isArray()) {
            ArrayType arrayType = (ArrayType)javaHelpers;
            ArrayType arrayType2 = (ArrayType)javaHelpers2;
            return ValidationRuleUtility.isSameType(arrayType.getFinalComponentType(), arrayType2.getFinalComponentType());
        }
        if (javaHelpers.getWrapper() != null && javaHelpers2.getWrapper() != null) {
            return javaHelpers.getWrapper().equals(javaHelpers2.getWrapper());
        }
        return false;
    }

    public static boolean isJavaLangObjectMethod(EnterpriseBean enterpriseBean, Method method) {
        return ValidationRuleUtility.isSameType(enterpriseBean, method.getContainingJavaClass(), "java.lang.Object");
    }

    public static final boolean isLegalRMI_IIOPInheritance(JavaClass javaClass) {
        return true;
    }

    public static final boolean isLegalRMI_IIOPType(EnterpriseBean enterpriseBean, JavaHelpers javaHelpers) throws InvalidInputException {
        if (javaHelpers == null) {
            return false;
        }
        return ValidationRuleUtility.isSerializable(javaHelpers, enterpriseBean);
    }

    public static final boolean isLocalType(EnterpriseBean enterpriseBean, JavaHelpers javaHelpers) {
        JavaHelpers javaHelpers2;
        try {
            if (ValidationRuleUtility.isSameType(javaHelpers, ValidationRuleUtility.getType("java.lang.Object", enterpriseBean))) {
                return false;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)enterpriseBean.getLocalInterface(), javaHelpers)) {
            return true;
        }
        if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)enterpriseBean.getLocalHomeInterface(), javaHelpers)) {
            return true;
        }
        try {
            javaHelpers2 = ValidationRuleUtility.getType("javax.ejb.EJBLocalHome", enterpriseBean);
            if (ValidationRuleUtility.isAssignableFrom(javaHelpers2, javaHelpers)) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        try {
            javaHelpers2 = ValidationRuleUtility.getType("javax.ejb.EJBLocalObject", enterpriseBean);
            if (ValidationRuleUtility.isAssignableFrom(javaHelpers2, javaHelpers)) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    public static ContainerManagedEntityExtension getCMPExtension(ContainerManagedEntity containerManagedEntity) {
        if (containerManagedEntity != null) {
            return (ContainerManagedEntityExtension)EjbExtensionsHelper.getEjbExtension((EnterpriseBean)containerManagedEntity);
        }
        return null;
    }

    public static final boolean usesUnknownPrimaryKey(EnterpriseBean enterpriseBean) {
        if (enterpriseBean.isContainerManagedEntity()) {
            return ValidationRuleUtility.usesUnknownPrimaryKey((ContainerManagedEntity)enterpriseBean);
        }
        return false;
    }

    public static final boolean usesUnknownPrimaryKey(ContainerManagedEntity containerManagedEntity) {
        if (containerManagedEntity == null) {
            return false;
        }
        try {
            if (ValidationRuleUtility.isSameType((JavaHelpers)containerManagedEntity.getPrimaryKey(), ValidationRuleUtility.getType("java.lang.Object", (EnterpriseBean)containerManagedEntity))) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (containerManagedEntity.isVersion2_X()) {
            ContainerManagedEntityExtension containerManagedEntityExtension = ValidationRuleUtility.getCMPExtension(containerManagedEntity);
            if (containerManagedEntityExtension == null) {
                return false;
            }
            List list = containerManagedEntityExtension.getFilteredFeatures((EJBExtensionFilter)LocalModelledPersistentAttributeFilter.singleton());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CMPAttribute cMPAttribute = (CMPAttribute)iterator.next();
                if (!ValidationRuleUtility.isUnknownPrimaryKey(cMPAttribute)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isUnidirectionalRelationship(IValidationContext iValidationContext, EJBRelationshipRole eJBRelationshipRole) {
        Entity entity = eJBRelationshipRole.getSource().getEntityBean();
        if (entity == null) {
            return false;
        }
        if (!entity.isContainerManagedEntity()) {
            return false;
        }
        CMRField cMRField = eJBRelationshipRole.getCmrField();
        if (cMRField == null) {
            return false;
        }
        EJBRelationshipRole eJBRelationshipRole2 = eJBRelationshipRole.getOpposite();
        if (eJBRelationshipRole2 == null) {
            return false;
        }
        CMRField cMRField2 = eJBRelationshipRole2.getCmrField();
        return cMRField2 == null;
    }

    public static final boolean isUnknownPrimaryKey(CMPAttribute cMPAttribute) {
        if (cMPAttribute == null) {
            return false;
        }
        return "wasGenUnknownkeyValue".equals(cMPAttribute.getName());
    }

    public static final boolean isPrimitivePrimaryKey(ContainerManagedEntity containerManagedEntity) {
        if (containerManagedEntity == null) {
            return false;
        }
        return containerManagedEntity.getPrimaryKeyAttribute() != null && CMPSpecAdapter.isValidPrimKeyField((ContainerManagedEntity)containerManagedEntity);
    }

    public static final boolean isPublic(Field field) {
        if (field == null) {
            return false;
        }
        return JavaVisibilityKind.PUBLIC_LITERAL == field.getJavaVisibility();
    }

    public static final boolean isPublic(Method method) {
        if (method == null) {
            return false;
        }
        return JavaVisibilityKind.PUBLIC_LITERAL == method.getJavaVisibility();
    }

    public static final boolean isSerializable(JavaHelpers javaHelpers, EnterpriseBean enterpriseBean) throws InvalidInputException {
        ArrayType arrayType;
        if (javaHelpers == null) {
            return true;
        }
        ValidationRuleUtility.isValidType(javaHelpers);
        if (javaHelpers.isPrimitive()) {
            return true;
        }
        if (javaHelpers.isArray()) {
            arrayType = (ArrayType)javaHelpers;
            if (arrayType.isPrimitiveArray()) {
                return true;
            }
            javaHelpers = arrayType.getFinalComponentType();
        }
        if (ValidationRuleUtility.isAssignableFrom(javaHelpers, (JavaHelpers)(arrayType = ValidationRuleUtility.getType("java.rmi.Remote", enterpriseBean)))) {
            return true;
        }
        JavaHelpers javaHelpers2 = ValidationRuleUtility.getType("java.io.Serializable", enterpriseBean);
        return ValidationRuleUtility.isAssignableFrom(javaHelpers, javaHelpers2);
    }

    public static final boolean isStateful(EnterpriseBean enterpriseBean) {
        if (enterpriseBean == null) {
            return false;
        }
        if (enterpriseBean.isEntity()) {
            return false;
        }
        return ((Session)enterpriseBean).getSessionType().getValue() == 0;
    }

    public static final boolean isStateless(EnterpriseBean enterpriseBean) {
        if (enterpriseBean == null) {
            return false;
        }
        if (enterpriseBean.isEntity()) {
            return false;
        }
        return ((Session)enterpriseBean).getSessionType().getValue() == 1;
    }

    public static boolean isUnnamedPackage(JavaPackage javaPackage) {
        if (javaPackage == null) {
            return true;
        }
        String string = javaPackage.getName();
        return string == null || string.equals("");
    }

    public static final boolean isValidJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        boolean bl = true;
        int n = 1;
        while (n < cArray.length) {
            if (!Character.isJavaIdentifierPart(cArray[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static final boolean isValidSessionTypeElement(Session session) {
        if (session == null) {
            return false;
        }
        if (!session.isSetSessionType()) {
            return false;
        }
        if (session.getSessionType() == null) {
            return false;
        }
        if (session.getSessionType().getValue() == 0) {
            return true;
        }
        return session.getSessionType().getValue() == 1;
    }

    public static final boolean isValidTransactionTypeElement(Session session) {
        if (session == null) {
            return false;
        }
        if (!session.isSetTransactionType()) {
            return false;
        }
        if (session.getTransactionType() == null) {
            return false;
        }
        if (session.getTransactionType().getValue() == 0) {
            return true;
        }
        return session.getTransactionType().getValue() == 1;
    }

    public static final void isValidType(JavaHelpers javaHelpers) throws InvalidInputException {
        if (javaHelpers == null) {
            MsgLogger msgLogger = Logger.getMsgLogger();
            if (msgLogger.isLoggingLevel(7)) {
                LogEntry logEntry = Logger.getLogEntry();
                logEntry.setSourceID("ValidationRuleUtility.isValidType");
                logEntry.setText("type is null");
                logEntry.appendStackTrace();
                msgLogger.write(7, (Object)logEntry);
            }
            throw new InvalidInputException();
        }
        if (javaHelpers.getWrapper() != null) {
            JavaClass javaClass = javaHelpers.getWrapper();
            if (javaHelpers.isArray()) {
                ArrayType arrayType = (ArrayType)javaHelpers;
                ValidationRuleUtility.isValidType(arrayType.getFinalComponentType());
            } else if (!javaClass.isExistingType()) {
                MsgLogger msgLogger = Logger.getMsgLogger();
                if (msgLogger.isLoggingLevel(7)) {
                    LogEntry logEntry = Logger.getLogEntry();
                    logEntry.setSourceID("ValidationRuleUtility.isValidType");
                    logEntry.setText("!wrapper.isExistingType(); type is " + javaClass.getJavaName());
                    msgLogger.write(7, (Object)logEntry);
                }
                throw new InvalidInputException(javaClass);
            }
        }
    }

    public static final void isValidTypeHierarchy(EnterpriseBean enterpriseBean, JavaHelpers javaHelpers) throws InvalidInputException {
        JavaClass javaClass;
        if (javaHelpers == null) {
            MsgLogger msgLogger = Logger.getMsgLogger();
            if (msgLogger.isLoggingLevel(7)) {
                LogEntry logEntry = Logger.getLogEntry();
                logEntry.setSourceID("ValidationRuleUtility.isValidTypeHierarchy");
                logEntry.setText("type is null");
                logEntry.appendStackTrace();
                msgLogger.write(7, (Object)logEntry);
            }
            throw new InvalidInputException();
        }
        ValidationRuleUtility.isValidType(javaHelpers);
        JavaHelpers javaHelpers2 = ValidationRuleUtility.getType("java.lang.Object", enterpriseBean);
        if (ValidationRuleUtility.isSameType(javaHelpers, javaHelpers2)) {
            return;
        }
        JavaClass javaClass2 = javaHelpers.getWrapper();
        if (javaClass2 == null) {
            MsgLogger msgLogger = Logger.getMsgLogger();
            if (msgLogger.isLoggingLevel(7)) {
                LogEntry logEntry = Logger.getLogEntry();
                logEntry.setSourceID("ValidationRuleUtility.isValidTypeHierarchy");
                logEntry.setText("type.getWrapper() returns null; type is " + javaHelpers.getJavaName());
                msgLogger.write(7, (Object)logEntry);
            }
            throw new InvalidInputException();
        }
        if (!javaClass2.isInterface()) {
            javaClass = javaClass2.getSupertype();
            ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass);
        }
        if ((javaClass = javaClass2.getImplementsInterfaces()) != null) {
            Iterator iterator = javaClass.iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass3 = (JavaClass)iterator.next();
                ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass3);
            }
        }
    }

    public static final boolean throwsRemoteExceptionOrParent(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsExceptionOrParent(enterpriseBean, method, "java.rmi.RemoteException");
    }

    public static final boolean doesNotThrowRemoteException(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        return !ValidationRuleUtility.throwsException(enterpriseBean, method, "java.rmi.RemoteException");
    }

    public static final boolean throwsObjectNotFoundException(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsException(enterpriseBean, method, "javax.ejb.ObjectNotFoundException");
    }

    public static final boolean throwsFinderException(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsException(enterpriseBean, method, "javax.ejb.FinderException");
    }

    public static final boolean throwsCreateException(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsException(enterpriseBean, method, "javax.ejb.CreateException");
    }

    public static final boolean throwsApplicationException(Method method, EnterpriseBean enterpriseBean) {
        EList eList = method.getJavaExceptions();
        if (eList.size() == 0) {
            return false;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (!ValidationRuleUtility.isApplicationException(javaClass, enterpriseBean)) continue;
            return true;
        }
        return false;
    }

    public static final boolean throwsException(EnterpriseBean enterpriseBean, Method method, String string) throws InvalidInputException {
        if (method == null) {
            return false;
        }
        EList eList = method.getJavaExceptions();
        Iterator iterator = eList.iterator();
        JavaClass javaClass = ValidationRuleUtility.getType(string, enterpriseBean).getWrapper();
        while (iterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass2, (JavaHelpers)javaClass)) continue;
            return true;
        }
        return false;
    }

    public static final boolean throwsExceptionOrParent(EnterpriseBean enterpriseBean, Method method, String string) throws InvalidInputException {
        if (method == null) {
            return false;
        }
        JavaClass javaClass = ValidationRuleUtility.getType(string, enterpriseBean).getWrapper();
        EList eList = method.getJavaExceptions();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass2, (JavaHelpers)javaClass)) {
                return true;
            }
            if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass, (JavaHelpers)javaClass2)) continue;
            return true;
        }
        return false;
    }

    public static final boolean usesCollectionClass(EnterpriseBean enterpriseBean, Method method) {
        if (enterpriseBean == null || method == null) {
            return false;
        }
        JavaParameter[] javaParameterArray = method.listParametersWithoutReturn();
        if (javaParameterArray != null) {
            int n = 0;
            while (n < javaParameterArray.length) {
                JavaParameter javaParameter = javaParameterArray[n];
                try {
                    if (ValidationRuleUtility.isAssignableFromCollection(javaParameter.getJavaType(), enterpriseBean)) {
                        return true;
                    }
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
                ++n;
            }
        }
        try {
            if (ValidationRuleUtility.isAssignableFromCollection(method.getReturnType(), enterpriseBean)) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    public static final boolean usesLocalTypes(EnterpriseBean enterpriseBean, Method method) {
        if (enterpriseBean == null || method == null) {
            return false;
        }
        JavaParameter[] javaParameterArray = method.listParametersWithoutReturn();
        if (javaParameterArray != null) {
            int n = 0;
            while (n < javaParameterArray.length) {
                JavaParameter javaParameter = javaParameterArray[n];
                if (ValidationRuleUtility.isLocalType(enterpriseBean, javaParameter.getJavaType())) {
                    return true;
                }
                ++n;
            }
        }
        return ValidationRuleUtility.isLocalType(enterpriseBean, method.getReturnType());
    }
}

