/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.Method;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.MessageLimitException;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.AValidationRule;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.LogEntry;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.util.RoleHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AValidateEJB
extends AValidationRule {
    private List roleMethodNames;

    public void reset() {
        super.reset();
        if (this.roleMethodNames != null) {
            this.roleMethodNames.clear();
            this.roleMethodNames = null;
        }
    }

    protected ContainerManagedEntityExtension getCMPExtension(IValidationContext iValidationContext, EnterpriseBean enterpriseBean) {
        if (enterpriseBean != null && enterpriseBean.isContainerManagedEntity()) {
            return (ContainerManagedEntityExtension)EjbExtensionsHelper.getEjbExtension((EnterpriseBean)enterpriseBean);
        }
        return null;
    }

    protected List getRoleMethodNames(IValidationContext iValidationContext, EnterpriseBean enterpriseBean) {
        try {
            if (this.roleMethodNames == null && enterpriseBean != null) {
                this.roleMethodNames = RoleHelper.getRoleMethodNamesExtended(iValidationContext, this.getCMPExtension(iValidationContext, enterpriseBean));
            }
            return this.roleMethodNames;
        }
        catch (Throwable throwable) {
            MsgLogger msgLogger = iValidationContext.getMsgLogger();
            if (msgLogger.isLoggingLevel(6)) {
                msgLogger.write(6, (Object)throwable);
            }
            return Collections.EMPTY_LIST;
        }
    }

    protected boolean isEjbRelationshipRoleMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        if (method == null) {
            return false;
        }
        return this.getRoleMethodNames(iValidationContext, enterpriseBean).contains(method.getName());
    }

    protected boolean isValid(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, List[] listArray) throws InvalidInputException {
        ValidationRuleUtility.isValidType(ValidationRuleUtility.getType(field));
        return !field.getName().equals("serialVersionUID");
    }

    protected boolean isValid(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws InvalidInputException {
        if (method == null) {
            throw new InvalidInputException();
        }
        return true;
    }

    public void primValidate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws InvalidInputException {
    }

    public abstract void primValidate(IValidationContext var1, EnterpriseBean var2, JavaClass var3, Method var4) throws InvalidInputException;

    protected abstract void primValidateExistence(IValidationContext var1, EnterpriseBean var2, JavaClass var3, Method var4) throws InvalidInputException;

    protected abstract List[] getMethodsExtended(IValidationContext var1, EnterpriseBean var2, JavaClass var3);

    protected abstract List[] getFieldsExtended(IValidationContext var1, EnterpriseBean var2, JavaClass var3);

    protected final void reflectionError(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws MessageLimitException {
        iValidationContext.removeMessages(javaClass);
        IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2907", 1, enterpriseBean, javaClass, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
        iValidationContext.addMessage(iMessage);
    }

    protected final void reflectionWarning(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, InvalidInputException invalidInputException) {
        String[] stringArray = null;
        String string = invalidInputException.getJavaClass() == null ? "?" : invalidInputException.getJavaClass().getQualifiedName();
        stringArray = ValidationRuleUtility.onClass(javaClass, field) ? new String[]{String.valueOf(field.getName()), String.valueOf(string)} : new String[]{string};
        IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2433", 2, enterpriseBean, javaClass, field, stringArray, (IValidationRule)this);
        iValidationContext.addMessage(iMessage);
    }

    protected final void reflectionWarning(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, InvalidInputException invalidInputException) {
        String[] stringArray = null;
        String string = invalidInputException.getJavaClass() == null ? "?" : invalidInputException.getJavaClass().getQualifiedName();
        stringArray = ValidationRuleUtility.onClass(javaClass, method) ? new String[]{method.getMethodElementSignature(), string} : new String[]{string};
        IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2433", 2, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
        iValidationContext.addMessage(iMessage);
    }

    public final void validate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationException {
        iValidationContext.terminateIfCancelled();
        EnterpriseBean enterpriseBean = (EnterpriseBean)object;
        JavaClass javaClass = (JavaClass)object2;
        try {
            ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass);
            iValidationContext.subtask("STATUS_VALIDATING", new String[]{javaClass.getQualifiedName()});
            this.validateClass(iValidationContext, enterpriseBean, javaClass);
            this.validateMethods(iValidationContext, enterpriseBean, javaClass);
            this.validateFields(iValidationContext, enterpriseBean, javaClass);
        }
        catch (InvalidInputException invalidInputException) {
            this.reflectionError(iValidationContext, enterpriseBean, javaClass);
            return;
        }
        catch (MessageLimitException messageLimitException) {
            throw messageLimitException;
        }
        catch (ValidationCancelledException validationCancelledException) {
            throw validationCancelledException;
        }
    }

    public final void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, List[] listArray) throws InvalidInputException {
        if (this.isValid(iValidationContext, enterpriseBean, javaClass, field, listArray)) {
            this.primValidate(iValidationContext, enterpriseBean, javaClass, field);
        }
    }

    public final void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws InvalidInputException {
        if (this.isValid(iValidationContext, enterpriseBean, javaClass, method, listArray)) {
            this.primValidate(iValidationContext, enterpriseBean, javaClass, method);
        }
    }

    protected final void validateExistence(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws InvalidInputException {
        if (this.isValid(iValidationContext, enterpriseBean, javaClass, method, listArray)) {
            this.primValidateExistence(iValidationContext, enterpriseBean, javaClass, method);
        }
    }

    public void validateClass(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
    }

    public final void validateFields(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws ValidationCancelledException, InvalidInputException, ValidationException {
        iValidationContext.terminateIfCancelled();
        List list = javaClass.getFieldsExtended();
        Iterator iterator = list.iterator();
        Field field = null;
        List[] listArray = this.getFieldsExtended(iValidationContext, enterpriseBean, javaClass);
        while (iterator.hasNext()) {
            iValidationContext.terminateIfCancelled();
            field = (Field)iterator.next();
            if (field == null) {
                MsgLogger msgLogger = iValidationContext.getMsgLogger();
                if (!msgLogger.isLoggingLevel(7)) continue;
                LogEntry logEntry = iValidationContext.getLogEntry();
                logEntry.setSourceID("AValidateEJB.validateFields()");
                logEntry.setText("A field is null on " + javaClass);
                msgLogger.write(7, (Object)logEntry);
                continue;
            }
            try {
                this.validate(iValidationContext, enterpriseBean, javaClass, field, listArray);
            }
            catch (InvalidInputException invalidInputException) {
                this.reflectionWarning(iValidationContext, enterpriseBean, javaClass, field, invalidInputException);
            }
        }
        iValidationContext.terminateIfCancelled();
    }

    public final void validateLegalRMIMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        this.validateLegalRMIMethodWithoutExceptions(iValidationContext, enterpriseBean, javaClass, method);
        this.validateLegalRMIMethodExceptions(iValidationContext, enterpriseBean, javaClass, method);
    }

    public final void validateLegalRMIMethodArguments(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaParameter[] javaParameterArray = method.listParametersWithoutReturn();
        int n = 0;
        while (n < javaParameterArray.length) {
            iValidationContext.terminateIfCancelled();
            if (!ValidationRuleUtility.isLegalRMI_IIOPType(enterpriseBean, javaParameterArray[n].getJavaType())) {
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2413", 4, enterpriseBean, javaClass, method, new String[]{javaParameterArray[n].getQualifiedName()}, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
            ++n;
        }
    }

    public final void validateLegalRMIMethodExceptions(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.throwsRemoteExceptionOrParent(enterpriseBean, method)) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2414", 1, enterpriseBean, javaClass, method, new String[]{"java.rmi.RemoteException"}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public final void validateLegalRMIMethodReturnType(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isLegalRMI_IIOPType(enterpriseBean, method.getReturnType())) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2412", 4, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public final void validateLegalRMIMethodWithoutExceptions(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        this.validateLegalRMIMethodArguments(iValidationContext, enterpriseBean, javaClass, method);
        this.validateLegalRMIMethodReturnType(iValidationContext, enterpriseBean, javaClass, method);
    }

    protected abstract void validateMethodExists(IValidationContext var1, EnterpriseBean var2, JavaClass var3) throws InvalidInputException;

    public final void validateMethods(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws ValidationCancelledException, InvalidInputException, ValidationException {
        iValidationContext.terminateIfCancelled();
        Method[] methodArray = javaClass.listMethodExtended();
        Method method = null;
        List[] listArray = this.getMethodsExtended(iValidationContext, enterpriseBean, javaClass);
        int n = 0;
        while (n < methodArray.length) {
            iValidationContext.terminateIfCancelled();
            method = methodArray[n];
            if (method == null) {
                MsgLogger msgLogger = iValidationContext.getMsgLogger();
                if (msgLogger.isLoggingLevel(7)) {
                    LogEntry logEntry = iValidationContext.getLogEntry();
                    logEntry.setSourceID("AValidateEJB.validateMethods()");
                    logEntry.setText("On " + javaClass + ", there is a null method.");
                    msgLogger.write(7, (Object)logEntry);
                }
            } else {
                try {
                    this.validateExistence(iValidationContext, enterpriseBean, javaClass, method, listArray);
                    this.validate(iValidationContext, enterpriseBean, javaClass, method, listArray);
                }
                catch (InvalidInputException invalidInputException) {
                    this.reflectionWarning(iValidationContext, enterpriseBean, javaClass, method, invalidInputException);
                }
            }
            ++n;
        }
        this.validateMethodExists(iValidationContext, enterpriseBean, javaClass);
        iValidationContext.terminateIfCancelled();
    }
}

