/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.AValidateBean;
import java.util.Iterator;
import java.util.Set;

public abstract class AValidateEntityBean
extends AValidateBean {
    protected static final String JAVAX_EJB_ENTITYBEAN = "javax.ejb.EntityBean";
    protected static final String SETENTITYCONTEXT = "setEntityContext";
    protected static final String UNSETENTITYCONTEXT = "unsetEntityContext";
    protected static final String EJBLOAD = "ejbLoad";
    protected static final String EJBSTORE = "ejbStore";
    protected static final String JAVAX_EJB_ENTITYCONTEXT = "javax.ejb.EntityContext";
    private boolean hasValidConstructor = false;
    private boolean hasAConstructor = false;
    private boolean hasSetEntityContext = false;
    private boolean hasUnsetEntityContext = false;
    private boolean hasEjbActivate = false;
    private boolean hasEjbPassivate = false;
    private boolean hasEjbRemove = false;
    private boolean hasEjbLoad = false;
    private boolean hasEjbStore = false;

    public Method getMatchingHomeFindMethodExtended(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return null;
        }
        if (enterpriseBean == null) {
            return null;
        }
        return ValidationRuleUtility.getMethodExtended(enterpriseBean.getHomeInterface(), method, "find");
    }

    protected String getParentName() {
        return JAVAX_EJB_ENTITYBEAN;
    }

    public boolean isFrameworkMethod(String string) {
        if (string == null) {
            return false;
        }
        if (super.isFrameworkMethod(string)) {
            return true;
        }
        if (string.equals(EJBLOAD)) {
            return true;
        }
        if (string.equals(EJBSTORE)) {
            return true;
        }
        if (string.equals(SETENTITYCONTEXT)) {
            return true;
        }
        return string.equals(UNSETENTITYCONTEXT);
    }

    public void primValidate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        String string = method.getName();
        if (string.equals("ejbCreate")) {
            this.validateEjbCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if (string.equals("ejbPostCreate")) {
            this.validateEjbPostCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if (string.equals("finalize")) {
            this.validateFinalize(iValidationContext, enterpriseBean, javaClass, method);
        } else if (string.startsWith("ejbFind")) {
            this.validateEjbFindMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if (this.isBusinessMethod(iValidationContext, enterpriseBean, javaClass, method)) {
            this.validateBusinessMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else {
            this.validateHelperMethod(iValidationContext, enterpriseBean, javaClass, method);
        }
        iValidationContext.terminateIfCancelled();
    }

    protected void primValidateExistence(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        String string = method.getName();
        if (!this.hasSetEntityContext && string.equals(SETENTITYCONTEXT)) {
            JavaParameter[] javaParameterArray = method.listParametersWithoutReturn();
            if (javaParameterArray.length == 1 && ValidationRuleUtility.isAssignableFrom(javaParameterArray[0].getJavaType(), ValidationRuleUtility.getType(JAVAX_EJB_ENTITYCONTEXT, enterpriseBean))) {
                this.hasSetEntityContext = true;
            }
        } else if (!this.hasUnsetEntityContext && string.equals(UNSETENTITYCONTEXT)) {
            if (method.listParametersWithoutReturn().length == 0) {
                this.hasUnsetEntityContext = true;
            }
        } else if (!this.hasEjbActivate && string.equals("ejbActivate")) {
            if (method.listParametersWithoutReturn().length == 0) {
                this.hasEjbActivate = true;
            }
        } else if (!this.hasEjbPassivate && string.equals("ejbPassivate")) {
            if (method.listParametersWithoutReturn().length == 0) {
                this.hasEjbPassivate = true;
            }
        } else if (!this.hasEjbRemove && string.equals("ejbRemove")) {
            if (method.listParametersWithoutReturn().length == 0) {
                this.hasEjbRemove = true;
            }
        } else if (!this.hasEjbLoad && string.equals(EJBLOAD)) {
            if (method.listParametersWithoutReturn().length == 0) {
                this.hasEjbLoad = true;
            }
        } else if (!this.hasEjbStore && string.equals(EJBSTORE)) {
            if (method.listParametersWithoutReturn().length == 0) {
                this.hasEjbStore = true;
            }
        } else if (!this.hasValidConstructor && method.isConstructor()) {
            this.hasAConstructor = true;
            if (ValidationRuleUtility.isPublic(method) && method.listParametersWithoutReturn().length == 0) {
                this.hasValidConstructor = true;
            }
        }
        iValidationContext.terminateIfCancelled();
    }

    public void validateBusinessMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        IMessage iMessage;
        iValidationContext.terminateIfCancelled();
        super.validateBusinessMethod(iValidationContext, enterpriseBean, javaClass, method);
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2408.bus", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isStatic()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2410.bus", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isFinal()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2409.bus", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateLegalRMIMethodWithoutExceptions(iValidationContext, enterpriseBean, javaClass, method);
        this.validateBusinessMethodNoRemoteException(iValidationContext, enterpriseBean, javaClass, method);
    }

    protected void validateBusinessMethodNoRemoteException(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        this.validateNoRemoteException(iValidationContext, enterpriseBean, javaClass, method, "CHKJ2400.bus");
    }

    public void validateClass(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        super.validateClass(iValidationContext, enterpriseBean, javaClass);
        this.verifyFieldExists(iValidationContext, enterpriseBean, javaClass);
    }

    public void validateEjbCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        IMessage iMessage;
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2408.ejbCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isStatic()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2410.ejbCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isFinal()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2409.ejbCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (ValidationRuleUtility.usesUnknownPrimaryKey(enterpriseBean)) {
            this.validateLegalRMIMethodArguments(iValidationContext, enterpriseBean, javaClass, method);
        } else {
            this.validateLegalRMIMethodWithoutExceptions(iValidationContext, enterpriseBean, javaClass, method);
        }
        this.validateEjbCreateMethod_keyDep(iValidationContext, enterpriseBean, javaClass, method);
        this.validateNoRemoteException(iValidationContext, enterpriseBean, javaClass, method, "CHKJ2400.ejbCreate");
        iMessage = ValidationRuleUtility.getMethodExtended(javaClass, "ejbPostCreate", method.listParametersWithoutReturn());
        if (iMessage == null) {
            IMessage iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2002", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage2);
        }
        this.validateEjbCreateMethod_homeDep(iValidationContext, enterpriseBean, javaClass, method);
    }

    public void validateEjbCreateMethod_keyDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        Object object = null;
        object = ValidationRuleUtility.usesUnknownPrimaryKey(enterpriseBean) ? ValidationRuleUtility.getType("java.lang.Object", enterpriseBean) : ((Entity)enterpriseBean).getPrimaryKey();
        iValidationContext.terminateIfCancelled();
        JavaHelpers javaHelpers = method.getReturnType();
        if (!ValidationRuleUtility.isAssignableFrom(javaHelpers, object)) {
            String string = object == null ? "<primary-key>" : object.getJavaName();
            String[] stringArray = new String[]{string};
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2406", 2, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public void validateEjbFindMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
    }

    public void validateEjbFindMethod_homeDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        JavaClass javaClass2 = enterpriseBean.getHomeInterface();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        String string = "f" + method.getName().substring(4);
        Method method2 = ValidationRuleUtility.getMethodExtended(javaClass2, method, string);
        if (method2 == null) {
            return;
        }
        Set set = ValidationRuleUtility.getNotSubsetExceptions(enterpriseBean, method, method2);
        if (set.size() > 0) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass3 = (JavaClass)iterator.next();
                String[] stringArray = new String[]{javaClass3.getQualifiedName(), javaClass2.getQualifiedName()};
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2420", 1, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    public void validateEjbPostCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        IMessage iMessage;
        String string;
        IMessage iMessage2;
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2408.ejbPostCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage2);
        }
        if (method.isStatic()) {
            iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2410.ejbPostCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage2);
        }
        if (method.isFinal()) {
            iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2409.ejbPostCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage2);
        }
        iValidationContext.terminateIfCancelled();
        iMessage2 = method.getReturnType();
        String string2 = string = iMessage2 == null ? "" : iMessage2.getQualifiedName();
        if (!string.equals("void")) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2418", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateNoRemoteException(iValidationContext, enterpriseBean, javaClass, method, "CHKJ2400.ejbPostCreate");
        iMessage = ValidationRuleUtility.getMethodExtended(javaClass, "ejbCreate", method.listParametersWithoutReturn());
        if (iMessage == null) {
            IMessage iMessage3 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2028", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage3);
        }
        this.validateEjbPostCreateMethod_homeDep(iValidationContext, enterpriseBean, javaClass, method);
    }

    public void validateEjbPostCreateMethod_homeDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaClass javaClass2 = enterpriseBean.getHomeInterface();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        Method method2 = this.getMatchingHomeCreateMethodExtended(iValidationContext, enterpriseBean, javaClass, method);
        if (method2 == null) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2029", 2, enterpriseBean, javaClass, method, new String[]{javaClass2.getName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
            return;
        }
        Set set = ValidationRuleUtility.getNotSubsetExceptions(enterpriseBean, method, method2);
        if (set.size() > 0) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass3 = (JavaClass)iterator.next();
                String[] stringArray = new String[]{javaClass3.getQualifiedName(), javaClass2.getQualifiedName()};
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2420", 1, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    protected void validateFinalize(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        if (method == null) {
            return;
        }
        if (method.listParametersWithoutReturn().length == 0) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2007", 2, enterpriseBean, javaClass, method, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    protected void validateMethodExists(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        IMessage iMessage;
        String[] stringArray = new String[]{javaClass.getQualifiedName()};
        if (!this.hasValidConstructor && this.hasAConstructor) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2006", 1, enterpriseBean, javaClass, stringArray, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.hasSetEntityContext) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2033", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.hasUnsetEntityContext) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2034", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.hasEjbActivate) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2035", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.hasEjbPassivate) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2036", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.hasEjbRemove) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2037", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.hasEjbLoad) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2038", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.hasEjbStore) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2039", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public abstract void verifyFieldExists(IValidationContext var1, EnterpriseBean var2, JavaClass var3) throws InvalidInputException;

    public void preValidate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationCancelledException, ValidationException {
        super.preValidate(iValidationContext, object, object2);
        this.hasValidConstructor = false;
        this.hasAConstructor = false;
        this.hasSetEntityContext = false;
        this.hasUnsetEntityContext = false;
        this.hasEjbActivate = false;
        this.hasEjbPassivate = false;
        this.hasEjbRemove = false;
        this.hasEjbLoad = false;
        this.hasEjbStore = false;
    }
}

