/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.AValidateHome;
import java.util.HashSet;

public abstract class AValidateEntityHome
extends AValidateHome {
    private HashSet findByPKMethods = new HashSet();

    public void reset() {
        super.reset();
        this.findByPKMethods.clear();
    }

    protected void incrementFindByPrimaryKeyCount(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        if (method == null) {
            return;
        }
        if (method.getName().equals("findByPrimaryKey")) {
            this.findByPKMethods.add(method);
        }
    }

    public boolean isSingleObjectFinder(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return false;
        }
        JavaClass javaClass2 = enterpriseBean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        return ValidationRuleUtility.isAssignableFrom(method.getReturnType(), (JavaHelpers)javaClass2);
    }

    public void primValidate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        String string = method.getName();
        if (string.equals("create")) {
            this.validateCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if (string.startsWith("find")) {
            this.validateFindMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2005", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    protected void primValidateExistence(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        if ("findByPrimaryKey".equals(method.getName())) {
            this.incrementFindByPrimaryKeyCount(iValidationContext, enterpriseBean, javaClass, method);
        }
    }

    public void validateClass(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        super.validateClass(iValidationContext, enterpriseBean, javaClass);
    }

    public void validateCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        this.validateCreateMethod_beanDep(iValidationContext, enterpriseBean, javaClass, method);
        iValidationContext.terminateIfCancelled();
        this.validateCreateMethod_remoteDep(iValidationContext, enterpriseBean, javaClass, method);
        if (!ValidationRuleUtility.throwsCreateException(enterpriseBean, method)) {
            String[] stringArray = new String[]{"javax.ejb.CreateException"};
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2414", 1, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateLegalRMIMethod(iValidationContext, enterpriseBean, javaClass, method);
    }

    public void validateCreateMethod_beanDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        super.validateCreateMethod_beanDep(iValidationContext, enterpriseBean, javaClass, method);
        this.validateMatchingBeanPostCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
    }

    public void validateFindByPrimaryKeyMethod_keyDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        JavaHelpers javaHelpers;
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        boolean bl = false;
        Entity entity = (Entity)enterpriseBean;
        JavaClass javaClass2 = entity.getPrimaryKey();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        iValidationContext.terminateIfCancelled();
        JavaParameter[] javaParameterArray = method.listParametersWithoutReturn();
        if (javaParameterArray.length == 1) {
            javaHelpers = javaParameterArray[0].getJavaType();
            if (ValidationRuleUtility.isAssignableFrom(javaHelpers, (JavaHelpers)javaClass2)) {
                if (this.isSingleObjectFinder(iValidationContext, enterpriseBean, javaClass, method)) {
                    bl = true;
                }
            } else if (ValidationRuleUtility.isSameType(javaHelpers, ValidationRuleUtility.getType("java.lang.Object", (EnterpriseBean)entity))) {
                bl = true;
            }
        }
        if (!bl) {
            javaHelpers = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2405", 2, enterpriseBean, javaClass, method, new String[]{javaClass2.getQualifiedName()}, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)javaHelpers);
        }
    }

    public void validateFindByPrimaryKeyMethod_remoteDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (!this.isSingleObjectFinder(iValidationContext, enterpriseBean, javaClass, method)) {
            String string = enterpriseBean.getRemoteInterface().getName();
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2403", 2, enterpriseBean, javaClass, method, new String[]{string}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public void validateFindMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        JavaHelpers javaHelpers;
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        this.validateFindMethod_remoteDep(iValidationContext, enterpriseBean, javaClass, method);
        if (!ValidationRuleUtility.throwsFinderException(enterpriseBean, method)) {
            String[] stringArray = new String[]{"javax.ejb.FinderException"};
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2414", 1, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        boolean bl = true;
        boolean bl2 = true;
        if (method.getName().equals("findByPrimaryKey")) {
            this.validateFindByPrimaryKeyMethod_keyDep(iValidationContext, enterpriseBean, javaClass, method);
            if (ValidationRuleUtility.usesUnknownPrimaryKey(enterpriseBean)) {
                bl = false;
            }
        }
        boolean bl3 = bl2 = !ValidationRuleUtility.isAssignableFrom(javaHelpers = method.getReturnType(), ValidationRuleUtility.getType("java.util.Enumeration", enterpriseBean)) && !ValidationRuleUtility.isAssignableFrom(javaHelpers, ValidationRuleUtility.getType("java.util.Collection", enterpriseBean));
        if (bl) {
            this.validateLegalRMIMethodArguments(iValidationContext, enterpriseBean, javaClass, method);
        }
        if (bl2) {
            this.validateLegalRMIMethodReturnType(iValidationContext, enterpriseBean, javaClass, method);
        }
        this.validateLegalRMIMethodExceptions(iValidationContext, enterpriseBean, javaClass, method);
    }

    public void validateFindMethod_remoteDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        JavaHelpers javaHelpers;
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaClass javaClass2 = enterpriseBean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        if (!(method.getName().equals("findByPrimaryKey") || ValidationRuleUtility.isAssignableFromCollection(javaHelpers = method.getReturnType(), enterpriseBean) || ValidationRuleUtility.isAssignableFromEnumeration(javaHelpers, enterpriseBean) || ValidationRuleUtility.isAssignableFrom(javaHelpers, (JavaHelpers)javaClass2))) {
            String[] stringArray = new String[]{javaClass2.getName()};
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2403", 2, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.getName().equals("findByPrimaryKey")) {
            this.validateFindByPrimaryKeyMethod_remoteDep(iValidationContext, enterpriseBean, javaClass, method);
        }
    }

    public void validateMatchingBeanCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        super.validateMatchingBeanCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
        JavaClass javaClass2 = enterpriseBean.getEjbClass();
        Method method2 = ValidationRuleUtility.getMethodExtended(javaClass2, method, "ejbCreate");
        if (method2 == null) {
            return;
        }
    }

    public void validateMatchingBeanFindMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        String string = "ejbF" + method.getName().substring(1);
        JavaClass javaClass2 = enterpriseBean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        Method method2 = ValidationRuleUtility.getMethodExtended(javaClass2, method, string);
        if (method2 == null) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2030", 1, enterpriseBean, javaClass, method, new String[]{javaClass2.getName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
            return;
        }
        iValidationContext.terminateIfCancelled();
        JavaHelpers javaHelpers = method.getReturnType();
        JavaHelpers javaHelpers2 = method2.getReturnType();
        if (!ValidationRuleUtility.isAssignableFrom(javaHelpers, javaHelpers2)) {
            boolean bl = ValidationRuleUtility.isAssignableFrom(javaHelpers, (JavaHelpers)enterpriseBean.getRemoteInterface());
            boolean bl2 = ValidationRuleUtility.isAssignableFrom(javaHelpers2, (JavaHelpers)((Entity)enterpriseBean).getPrimaryKey());
            if (!bl || !bl2) {
                JavaHelpers javaHelpers3 = bl2 ? enterpriseBean.getRemoteInterface() : javaHelpers2;
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2415", 1, enterpriseBean, javaClass, method, new String[]{javaHelpers3.getJavaName(), javaClass2.getName()}, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    public void validateMatchingBeanPostCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaClass javaClass2 = enterpriseBean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        Method method2 = ValidationRuleUtility.getMethodExtended(javaClass2, method, "ejbPostCreate");
        if (method2 == null) {
            return;
        }
    }

    protected void validateMethodExists(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        if (this.findByPKMethods.size() == 0) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2011", 1, enterpriseBean, javaClass, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }
}

