/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl;

import com.ibm.etools.ejb.CMPAttribute;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.AValidateEntityBean;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.IMessagePrefixEjb11Constants;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidateCMPBean
extends AValidateEntityBean
implements IMessagePrefixEjb11Constants {
    private List _containerManagedFields = null;
    private static final String MSSGID = ".eb";
    private static final String EXT = ".eb.ejb11";
    private static final String BEXT = ".eb.i.ejb11";
    private static final String MEXT = ".eb.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_CMP_BEANCLASS;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_CMP_HOME, IValidationRuleList.EJB11_CMP_REMOTE};
    private static final Map MESSAGE_IDS = new HashMap();

    public void reset() {
        super.reset();
        this._containerManagedFields = null;
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    protected List getContainerManagedFields() {
        return this._containerManagedFields;
    }

    protected boolean hasContainerManagedField() {
        return this.getContainerManagedFields().size() > 0;
    }

    public boolean isContainerManagedField(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) {
        if (field == null) {
            return false;
        }
        return this.getContainerManagedFields().contains(field);
    }

    protected boolean isContainerManagedHome_homeDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws InvalidInputException {
        if (field == null) {
            return false;
        }
        if (enterpriseBean == null) {
            return false;
        }
        JavaClass javaClass2 = enterpriseBean.getHomeInterface();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        return ValidationRuleUtility.isAssignableFrom(ValidationRuleUtility.getType(field), (JavaHelpers)javaClass2);
    }

    protected boolean isContainerManagedRemote_remoteDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws InvalidInputException {
        if (field == null) {
            return false;
        }
        if (enterpriseBean == null) {
            return false;
        }
        JavaClass javaClass2 = enterpriseBean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        return ValidationRuleUtility.isAssignableFrom(ValidationRuleUtility.getType(field), (JavaHelpers)javaClass2);
    }

    private List loadContainerManagedFields(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) {
        if (enterpriseBean == null) {
            return Collections.EMPTY_LIST;
        }
        List list = null;
        try {
            list = ((ContainerManagedEntity)enterpriseBean).getPersistentAttributeFields();
        }
        catch (Throwable throwable) {
            MsgLogger msgLogger = iValidationContext.getMsgLogger();
            if (msgLogger.isLoggingLevel(6)) {
                msgLogger.write(6, (Object)throwable);
            }
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public void primValidate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws InvalidInputException {
        super.primValidate(iValidationContext, enterpriseBean, javaClass, field);
        iValidationContext.terminateIfCancelled();
        this.validateContainerManagedField(iValidationContext, enterpriseBean, javaClass, field);
    }

    public void validateBusinessMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        if (!this.isEjbRelationshipRoleMethod(iValidationContext, enterpriseBean, javaClass, method)) {
            super.validateBusinessMethod(iValidationContext, enterpriseBean, javaClass, method);
        }
    }

    protected void validateBusinessMethodNoRemoteException(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        if (!this.isEjbRelationshipRoleMethod(iValidationContext, enterpriseBean, javaClass, method)) {
            super.validateBusinessMethodNoRemoteException(iValidationContext, enterpriseBean, javaClass, method);
        }
    }

    public void validateClass(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        super.validateClass(iValidationContext, enterpriseBean, javaClass);
        this.validatePrimitivePrimaryKey(iValidationContext, enterpriseBean, javaClass);
    }

    protected void validateContainerManagedField(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws InvalidInputException {
        if (this.isContainerManagedField(iValidationContext, enterpriseBean, javaClass, field)) {
            IMessage iMessage;
            if (field == null) {
                return;
            }
            iValidationContext.terminateIfCancelled();
            if (!ValidationRuleUtility.isPublic(field)) {
                iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2203", 1, enterpriseBean, javaClass, field, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
            if (field.isTransient()) {
                iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2201", 1, enterpriseBean, javaClass, field, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
            this.validateContainerManagedField_dependent(iValidationContext, enterpriseBean, javaClass, field);
        }
    }

    protected void validateContainerManagedField_dependent(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws InvalidInputException {
        if (field == null) {
            return;
        }
        JavaHelpers javaHelpers = ValidationRuleUtility.getType(field);
        if (!ValidationRuleUtility.isSerializable(javaHelpers, enterpriseBean)) {
            iValidationContext.terminateIfCancelled();
            if (!this.isContainerManagedHome_homeDep(iValidationContext, enterpriseBean, javaClass, field) || this.isContainerManagedRemote_remoteDep(iValidationContext, enterpriseBean, javaClass, field)) {
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2202", 2, enterpriseBean, javaClass, field, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    public void validateEjbFindMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        if (method == null) {
            throw new InvalidInputException();
        }
        IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2004", 2, enterpriseBean, javaClass, method, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
        iValidationContext.addMessage(iMessage);
    }

    public void validateEjbPostCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        super.validateEjbPostCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
    }

    protected void validatePrimitivePrimaryKey(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
        if (ValidationRuleUtility.isPrimitivePrimaryKey(containerManagedEntity)) {
            CMPAttribute cMPAttribute = containerManagedEntity.getPrimaryKeyAttribute();
            Field field = cMPAttribute == null ? null : cMPAttribute.getField();
            JavaClass javaClass2 = containerManagedEntity.getPrimaryKey();
            if (field == null || !ValidationRuleUtility.isAssignableFrom(cMPAttribute.getType(), (JavaHelpers)javaClass2)) {
                String[] stringArray = new String[]{cMPAttribute.getName(), javaClass2.getName()};
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2207", 1, enterpriseBean, javaClass, field, stringArray, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    public void verifyFieldExists(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        if (!this.hasContainerManagedField()) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2032", 2, enterpriseBean, javaClass, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public void preValidate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationCancelledException, ValidationException {
        super.preValidate(iValidationContext, object, object2);
        this._containerManagedFields = this.loadContainerManagedFields(iValidationContext, (EnterpriseBean)object, (JavaClass)object2);
    }

    static {
        MESSAGE_IDS.put("CHKJ2002", new String[]{"CHKJ2002.eb.i.ejb11", "CHKJ2002.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2004", new String[]{"CHKJ2004.eb.i.ejb11", "CHKJ2004.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2006", new String[]{"CHKJ2006.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2007", new String[]{"CHKJ2007.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2013", new String[]{"CHKJ2013.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2014", new String[]{"CHKJ2014.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2015", new String[]{"CHKJ2015.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2022", new String[]{"CHKJ2022.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2028", new String[]{"CHKJ2028.eb.i.ejb11", "CHKJ2028.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2029", new String[]{"CHKJ2029.eb.i.ejb11", "CHKJ2029.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2032", new String[]{"CHKJ2032.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2033", new String[]{"CHKJ2033.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2034", new String[]{"CHKJ2034.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2035", new String[]{"CHKJ2035.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2036", new String[]{"CHKJ2036.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2037", new String[]{"CHKJ2037.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2038", new String[]{"CHKJ2038.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2039", new String[]{"CHKJ2039.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2103", new String[]{"CHKJ2103.ejb11"});
        MESSAGE_IDS.put("CHKJ2200", new String[]{"CHKJ2200.i.ejb11", "CHKJ2200.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2201", new String[]{"CHKJ2201.eb.i.ejb11", "CHKJ2201.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2202", new String[]{"CHKJ2202.eb.i.ejb11", "CHKJ2202.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2203", new String[]{"CHKJ2203.eb.i.ejb11", "CHKJ2203.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2207", new String[]{"CHKJ2207.eb.ejb11", "CHKJ2207.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.bus", new String[]{"CHKJ2400.bus.eb.i.ejb11", "CHKJ2400.bus.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.ejbCreate", new String[]{"CHKJ2400.ejbCreate.eb.i.ejb11", "CHKJ2400.ejbCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.ejbFind", new String[]{"CHKJ2400.ejbFind.eb.i.ejb11", "CHKJ2400.ejbFind.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.ejbPostCreate", new String[]{"CHKJ2400.ejbPostCreate.eb.i.ejb11", "CHKJ2400.ejbPostCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2406", new String[]{"CHKJ2406.eb.i.ejb11", "CHKJ2406.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.bus", new String[]{"CHKJ2408.bus.eb.i.ejb11", "CHKJ2408.bus.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.ejbCreate", new String[]{"CHKJ2408.ejbCreate.eb.i.ejb11", "CHKJ2408.ejbCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.ejbPostCreate", new String[]{"CHKJ2408.ejbPostCreate.eb.i.ejb11", "CHKJ2408.ejbPostCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.bus", new String[]{"CHKJ2409.bus.eb.i.ejb11", "CHKJ2409.bus.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.ejbCreate", new String[]{"CHKJ2409.ejbCreate.eb.i.ejb11", "CHKJ2409.ejbCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.ejbFind", new String[]{"CHKJ2409.ejbFind.eb.i.ejb11", "CHKJ2409.ejbFind.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.ejbPostCreate", new String[]{"CHKJ2409.ejbPostCreate.eb.i.ejb11", "CHKJ2409.ejbPostCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.bus", new String[]{"CHKJ2410.bus.eb.i.ejb11", "CHKJ2410.bus.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.ejbCreate", new String[]{"CHKJ2410.ejbCreate.eb.i.ejb11", "CHKJ2410.ejbCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.ejbFind", new String[]{"CHKJ2410.ejbFind.eb.i.ejb11", "CHKJ2410.ejbFind.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.ejbPostCreate", new String[]{"CHKJ2410.ejbPostCreate.eb.i.ejb11", "CHKJ2410.ejbPostCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2411", new String[]{"CHKJ2411.eb.i.ejb11", "CHKJ2411.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2412", new String[]{"CHKJ2412.eb.i.ejb11", "CHKJ2412.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2413", new String[]{"CHKJ2413.eb.i.ejb11", "CHKJ2413.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2414", new String[]{"CHKJ2414.eb.i.ejb11", "CHKJ2414.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2418", new String[]{"CHKJ2418.eb.i.ejb11", "CHKJ2418.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2420", new String[]{"CHKJ2420.eb.i.ejb11", "CHKJ2420.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2432", new String[]{"CHKJ2432.eb.i.ejb11", "CHKJ2432.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2456", new String[]{"CHKJ2456.i", "CHKJ2456.m"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }
}

