/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbRelationshipRole;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.AValidateEntityHome;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.IMessagePrefixEjb11Constants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

public class ValidateCMPHome
extends AValidateEntityHome
implements IMessagePrefixEjb11Constants {
    private ContainerManagedEntityExtension cmpExt = null;
    private Set associationFinders = new HashSet();
    private static final String MSSGID = ".eh";
    private static final String EXT = ".eh.ejb11";
    private static final String BEXT = ".eh.i.ejb11";
    private static final String MEXT = ".eh.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_CMP_HOME;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_CMP_BEANCLASS, IValidationRuleList.EJB11_EJBEXT};
    private static final Map MESSAGE_IDS = new HashMap();

    public void reset() {
        super.reset();
        this.cmpExt = null;
        this.associationFinders.clear();
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    public void preValidate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationCancelledException, ValidationException {
        super.preValidate(iValidationContext, object, object2);
        EnterpriseBean enterpriseBean = (EnterpriseBean)object;
        JavaClass javaClass = (JavaClass)object2;
        this.cmpExt = (ContainerManagedEntityExtension)EjbExtensionsHelper.getEjbExtension((EnterpriseBean)enterpriseBean);
        if (this.cmpExt != null && !this.cmpExt.isDefault()) {
            EList eList = this.cmpExt.getLocalRelationshipRoles();
            int n = 0;
            while (n < eList.size()) {
                EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)eList.get(n);
                String string = this.getFinderMethodName(iValidationContext, enterpriseBean, javaClass, ejbRelationshipRole);
                if (string != null) {
                    this.associationFinders.add(string);
                }
                ++n;
            }
        }
    }

    protected JavaClass getCustomFinderObject(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        while (true) {
            JavaHelpers javaHelpers;
            JavaClass javaClass2 = enterpriseBean.getEjbClass();
            ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
            try {
                javaHelpers = ValidationRuleUtility.getType(this.getFinderObjectName(iValidationContext, enterpriseBean, javaClass, javaClass2), enterpriseBean);
                if (javaHelpers != null && javaHelpers.getWrapper() != null) {
                    return javaHelpers.getWrapper();
                }
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
            javaHelpers = EjbExtensionsHelper.getSupertype((EnterpriseBean)enterpriseBean);
            if (javaHelpers == null) {
                return null;
            }
            enterpriseBean = javaHelpers;
        }
    }

    private String getFinderMethodName(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, EjbRelationshipRole ejbRelationshipRole) {
        try {
            if (ejbRelationshipRole == null || ejbRelationshipRole.getOpposite() == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer("find");
            String string = ejbRelationshipRole.getOpposite().getName();
            String string2 = ejbRelationshipRole.getName();
            stringBuffer.append(Character.toUpperCase(string.charAt(0)));
            stringBuffer.append(string.substring(1));
            stringBuffer.append("By");
            stringBuffer.append(Character.toUpperCase(string2.charAt(0)));
            stringBuffer.append(string2.substring(1));
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            MsgLogger msgLogger = iValidationContext.getMsgLogger();
            if (msgLogger.isLoggingLevel(6)) {
                msgLogger.write(6, (Object)throwable);
            }
            return null;
        }
    }

    protected String getFinderObjectName(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, JavaClass javaClass2) {
        if (javaClass2 == null) {
            return "";
        }
        return javaClass2.getQualifiedName() + "FinderObject";
    }

    public void validateFindMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        super.validateFindMethod(iValidationContext, enterpriseBean, javaClass, method);
        if (method == null) {
            return;
        }
        this.validateFindMethod_beanDep(iValidationContext, enterpriseBean, javaClass, method);
    }

    public void validateFindMethod_beanDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        Method method2;
        String[] stringArray;
        FinderDescriptor finderDescriptor;
        if (method == null) {
            return;
        }
        if (method.getName().equals("findByPrimaryKey")) {
            return;
        }
        boolean bl = false;
        if (this.associationFinders.contains(method.getName())) {
            bl = true;
        } else {
            finderDescriptor = ValidationRuleUtility.getFinderDescriptor(this.cmpExt, method);
            if (finderDescriptor == null) {
                stringArray = this.getCustomFinderObject(iValidationContext, enterpriseBean, javaClass);
                if (stringArray != null && (method2 = ValidationRuleUtility.getMethodExtended((JavaClass)stringArray, method, method.getName())) != null) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (!bl) {
            finderDescriptor = enterpriseBean.getEjbClass();
            ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)finderDescriptor);
            stringArray = new String[]{this.getFinderObjectName(iValidationContext, enterpriseBean, javaClass, (JavaClass)finderDescriptor)};
            method2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2102", 1, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)method2);
        }
    }

    static {
        MESSAGE_IDS.put("CHKJ2005", new String[]{"CHKJ2005.eh.i.ejb11", "CHKJ2005.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2011", new String[]{"CHKJ2011.eh.ejb11"});
        MESSAGE_IDS.put("CHKJ2012", new String[]{"CHKJ2012.eh.ejb11"});
        MESSAGE_IDS.put("CHKJ2017", new String[]{"CHKJ2017.eh.ejb11"});
        MESSAGE_IDS.put("CHKJ2026", new String[]{"CHKJ2026.eh.i.ejb11", "CHKJ2026.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2030", new String[]{"CHKJ2030.eh.i.ejb11", "CHKJ2030.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2102", new String[]{"CHKJ2102.eh.ejb11"});
        MESSAGE_IDS.put("CHKJ2104", new String[]{"CHKJ2104.ejb11"});
        MESSAGE_IDS.put("CHKJ2402", new String[]{"CHKJ2402.eh.i.ejb11", "CHKJ2402.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2403", new String[]{"CHKJ2403.eh.i.ejb11", "CHKJ2403.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2405", new String[]{"CHKJ2405.eh.i.ejb11", "CHKJ2405.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2412", new String[]{"CHKJ2412.eh.i.ejb11", "CHKJ2412.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2413", new String[]{"CHKJ2413.eh.i.ejb11", "CHKJ2413.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2414", new String[]{"CHKJ2414.eh.i.ejb11", "CHKJ2414.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2415", new String[]{"CHKJ2415.eh.i.ejb11", "CHKJ2415.eh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }
}

