/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl;

import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.AValidateKeyClass;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.IMessagePrefixEjb11Constants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

public class ValidateCMPKey
extends AValidateKeyClass
implements IMessagePrefixEjb11Constants {
    private boolean hasAConstructor = false;
    private boolean hasDefaultConstructor = false;
    private Set _beanFieldNames = new HashSet();
    private static final String MSSGID = ".eb";
    private static final String EXT = ".eb.ejb11";
    private static final String BEXT = ".eb.i.ejb11";
    private static final String MEXT = ".eb.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_CMP_KEYCLASS;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_CMP_BEANCLASS};
    private static final Map MESSAGE_IDS = new HashMap();

    public void reset() {
        super.reset();
        this._beanFieldNames.clear();
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public Object getTarget(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)object;
        if (ValidationRuleUtility.isPrimitivePrimaryKey(containerManagedEntity)) {
            return null;
        }
        return containerManagedEntity.getPrimaryKey();
    }

    public final Object getId() {
        return ID;
    }

    protected void buildFieldNameList(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) {
        iValidationContext.terminateIfCancelled();
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
        if (containerManagedEntity == null) {
            return;
        }
        if (!ValidationRuleUtility.isPrimitivePrimaryKey(containerManagedEntity)) {
            List list = containerManagedEntity.getPersistentAttributeFields();
            Field field = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                field = (Field)iterator.next();
                try {
                    ValidationRuleUtility.isValidType(ValidationRuleUtility.getType(field));
                    this._beanFieldNames.add(field.getName());
                }
                catch (InvalidInputException invalidInputException) {
                    this.reflectionWarning(iValidationContext, enterpriseBean, javaClass, field, invalidInputException);
                }
            }
        }
    }

    public void primValidate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws InvalidInputException {
        ContainerManagedEntity containerManagedEntity;
        if (!ValidationRuleUtility.isPublic(field)) {
            containerManagedEntity = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2205", 2, enterpriseBean, javaClass, field, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)containerManagedEntity);
        }
        containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
        if (!this._beanFieldNames.contains(field.getName())) {
            JavaClass javaClass2 = containerManagedEntity.getEjbClass();
            ValidationRuleUtility.isValidType((JavaHelpers)javaClass2);
            String[] stringArray = new String[]{containerManagedEntity.getName(), containerManagedEntity.getEjbClass().getName()};
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2206", 2, enterpriseBean, javaClass, field, stringArray, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public void primValidate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
    }

    protected void primValidateExistence(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        if (method.isConstructor()) {
            this.hasAConstructor = true;
            if (ValidationRuleUtility.isPublic(method) && method.listParametersWithoutReturn().length == 0) {
                this.hasDefaultConstructor = true;
            }
        }
    }

    public void validateClass(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        EList eList;
        ContainerManagedEntity containerManagedEntity;
        super.validateClass(iValidationContext, enterpriseBean, javaClass);
        iValidationContext.terminateIfCancelled();
        if (!javaClass.isPublic()) {
            containerManagedEntity = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2020", 1, enterpriseBean, javaClass, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)containerManagedEntity);
        }
        this.buildFieldNameList(iValidationContext, enterpriseBean, javaClass);
        containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
        if (!(ValidationRuleUtility.usesUnknownPrimaryKey(containerManagedEntity) || (eList = containerManagedEntity.getKeyAttributes()) != null && eList.size() != 0)) {
            JavaClass javaClass2 = containerManagedEntity.getPrimaryKey();
            String string = containerManagedEntity.getName() == null ? "null" : containerManagedEntity.getName();
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2829", 1, enterpriseBean, javaClass2, new String[]{javaClass2.getName(), string}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public void validateMethodExists(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        super.validateMethodExists(iValidationContext, enterpriseBean, javaClass);
        if (!this.hasDefaultConstructor && this.hasAConstructor) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2021", 1, enterpriseBean, javaClass, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public void preValidate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationCancelledException, ValidationException {
        super.preValidate(iValidationContext, object, object2);
        this.hasAConstructor = false;
        this.hasDefaultConstructor = false;
    }

    static {
        MESSAGE_IDS.put("CHKJ2001", new String[]{"CHKJ2001.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2019", new String[]{"CHKJ2019.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2020", new String[]{"CHKJ2020.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2021", new String[]{"CHKJ2021.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2205", new String[]{"CHKJ2205.eb.i.ejb11", "CHKJ2205.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2206", new String[]{"CHKJ2206.eb.i.ejb11", "CHKJ2206.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2829", new String[]{"CHKJ2829.ejb11"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }
}

