/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.AValidateBean;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.IMessagePrefixEjb11Constants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ValidateSessionBean
extends AValidateBean
implements IMessagePrefixEjb11Constants {
    private boolean hasValidConstructor = false;
    private boolean hasAConstructor = false;
    private boolean hasDefaultCreateMethod = false;
    private Set createMethods = new HashSet();
    private static final String MSSGID = ".sb";
    private static final String EXT = ".sb.ejb11";
    private static final String BEXT = ".sb.i.ejb11";
    private static final String MEXT = ".sb.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_SESSION_BEANCLASS;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_SESSION_HOME, IValidationRuleList.EJB11_SESSION_REMOTE};
    private static final Map MESSAGE_IDS = new HashMap();

    public void reset() {
        super.reset();
        this.createMethods.clear();
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    protected final String getParentName() {
        return "javax.ejb.SessionBean";
    }

    protected boolean hasCreateMethod() {
        if (this.hasDefaultCreateMethod) {
            return true;
        }
        return this.createMethods.size() > 0;
    }

    protected void incrementCreateMethodCount(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        if (method == null) {
            return;
        }
        if (method.listParametersWithoutReturn().length == 0 && !this.hasDefaultCreateMethod) {
            this.hasDefaultCreateMethod = true;
        } else {
            this.createMethods.add(method);
        }
    }

    public boolean isFrameworkMethod(String string) {
        if (super.isFrameworkMethod(string)) {
            return true;
        }
        return string.equals("setSessionContext");
    }

    public void primValidate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        String string = method.getName();
        if (string.equals("ejbCreate")) {
            this.validateEjbCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if (string.equals("finalize")) {
            this.validateFinalizeMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if (method.isConstructor()) {
            this.validateConstructor(iValidationContext, enterpriseBean, javaClass, method);
        } else if (this.isBusinessMethod(iValidationContext, enterpriseBean, javaClass, method)) {
            this.validateBusinessMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if (!this.isFrameworkMethod(string)) {
            this.validateHelperMethod(iValidationContext, enterpriseBean, javaClass, method);
        }
        iValidationContext.terminateIfCancelled();
    }

    protected void primValidateExistence(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        if ("ejbCreate".equals(method.getName())) {
            this.incrementCreateMethodCount(iValidationContext, enterpriseBean, javaClass, method);
        } else if (method.isConstructor()) {
            this.validateConstructor(iValidationContext, enterpriseBean, javaClass, method);
        }
    }

    public void validateBusinessMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        super.validateBusinessMethod(iValidationContext, enterpriseBean, javaClass, method);
        this.validateLegalRMIMethodWithoutExceptions(iValidationContext, enterpriseBean, javaClass, method);
        this.validateBusinessModifiersAndExceptions(iValidationContext, enterpriseBean, javaClass, method);
    }

    public void validateClass(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        super.validateClass(iValidationContext, enterpriseBean, javaClass);
        this.validateClass_remoteDep(iValidationContext, enterpriseBean, javaClass);
    }

    public void validateClass_remoteDep(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        JavaClass javaClass2 = enterpriseBean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass2);
        if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass, (JavaHelpers)javaClass2)) {
            String[] stringArray = new String[]{javaClass.getQualifiedName(), javaClass2.getQualifiedName()};
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2040", 4, enterpriseBean, javaClass, stringArray, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    protected void validateConstructor(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        if (method == null) {
            return;
        }
        this.hasAConstructor = true;
        if (!this.hasValidConstructor && ValidationRuleUtility.isPublic(method) && method.listParametersWithoutReturn().length == 0) {
            this.hasValidConstructor = true;
        }
    }

    public void validateEjbCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        String string;
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaHelpers javaHelpers = method.getReturnType();
        String string2 = string = javaHelpers == null ? "" : javaHelpers.getQualifiedName();
        if (!string.equals("void")) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2401", 1, enterpriseBean, javaClass, method, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateLegalRMIMethodArguments(iValidationContext, enterpriseBean, javaClass, method);
        this.validateEjbCreateModifiersAndExceptions(iValidationContext, enterpriseBean, javaClass, method);
        this.validateEjbCreateMethod_homeDep(iValidationContext, enterpriseBean, javaClass, method);
    }

    protected void validateFinalizeMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        if (method == null) {
            return;
        }
        if (method.listParametersWithoutReturn().length == 0) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2007", 2, enterpriseBean, javaClass, method, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    protected void validateMethodExists(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        Object object;
        String[] stringArray = new String[]{javaClass.getQualifiedName()};
        if (!this.hasValidConstructor && this.hasAConstructor) {
            object = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2006", 1, enterpriseBean, javaClass, stringArray, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)object);
        }
        if (!this.hasCreateMethod()) {
            object = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2008", 1, enterpriseBean, javaClass, stringArray, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)object);
        }
        if (ValidationRuleUtility.isStateless(enterpriseBean) && this.createMethods.size() > 0) {
            object = this.createMethods.iterator();
            while (object.hasNext()) {
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2025", 1, enterpriseBean, javaClass, (Method)object.next(), stringArray, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    public void validateBusinessModifiersAndExceptions(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        IMessage iMessage;
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2408.bus", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isStatic()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2410.bus", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isFinal()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2409.bus", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateNoRemoteException(iValidationContext, enterpriseBean, javaClass, method, "CHKJ2400.bus");
    }

    public void validateEjbCreateModifiersAndExceptions(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        IMessage iMessage;
        iValidationContext.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2408.ejbCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isStatic()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2410.ejbCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isFinal()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2409.ejbCreate", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateNoRemoteException(iValidationContext, enterpriseBean, javaClass, method, "CHKJ2400.ejbCreate");
    }

    public void preValidate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationCancelledException, ValidationException {
        super.preValidate(iValidationContext, object, object2);
        this.hasValidConstructor = false;
        this.hasAConstructor = false;
        this.hasDefaultCreateMethod = false;
    }

    static {
        MESSAGE_IDS.put("CHKJ2006", new String[]{"CHKJ2006.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2007", new String[]{"CHKJ2007.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2008", new String[]{"CHKJ2008.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2013", new String[]{"CHKJ2013.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2014", new String[]{"CHKJ2014.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2015", new String[]{"CHKJ2015.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2022", new String[]{"CHKJ2022.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2025", new String[]{"CHKJ2025.sb.i.ejb11", "CHKJ2025.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2040", new String[]{"CHKJ2040.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2103", new String[]{"CHKJ2103.ejb11"});
        MESSAGE_IDS.put("CHKJ2200", new String[]{"CHKJ2200.i.ejb11", "CHKJ2200.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.bus", new String[]{"CHKJ2400.bus.sb.i.ejb11", "CHKJ2400.bus.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.ejbCreate", new String[]{"CHKJ2400.ejbCreate.sb.i.ejb11", "CHKJ2400.ejbCreate.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2401", new String[]{"CHKJ2401.sb.i.ejb11", "CHKJ2401.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.bus", new String[]{"CHKJ2408.bus.sb.i.ejb11", "CHKJ2408.bus.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.ejbCreate", new String[]{"CHKJ2408.ejbCreate.sb.i.ejb11", "CHKJ2408.ejbCreate.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.bus", new String[]{"CHKJ2409.bus.sb.i.ejb11", "CHKJ2409.bus.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.ejbCreate", new String[]{"CHKJ2409.ejbCreate.sb.i.ejb11", "CHKJ2409.ejbCreate.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.bus", new String[]{"CHKJ2410.bus.sb.i.ejb11", "CHKJ2410.bus.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.ejbCreate", new String[]{"CHKJ2410.ejbCreate.sb.i.ejb11", "CHKJ2410.ejbCreate.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2411", new String[]{"CHKJ2411.sb.i.ejb11", "CHKJ2411.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2412", new String[]{"CHKJ2412.sb.i.ejb11", "CHKJ2412.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2413", new String[]{"CHKJ2413.sb.i.ejb11", "CHKJ2413.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2414", new String[]{"CHKJ2414.sb.i.ejb11", "CHKJ2414.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2420", new String[]{"CHKJ2420.sb.i.ejb11", "CHKJ2420.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2432", new String[]{"CHKJ2432.sb.i.ejb11", "CHKJ2432.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2456", new String[]{"CHKJ2456.i", "CHKJ2456.m"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }
}

