/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.AValidateHome;
import com.ibm.etools.validation.ejb.ejb11.rules.impl.IMessagePrefixEjb11Constants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ValidateSessionHome
extends AValidateHome
implements IMessagePrefixEjb11Constants {
    private boolean hasDefaultCreateMethod = false;
    private Set createMethods = new HashSet();
    private static final String MSSGID = ".sh";
    private static final String EXT = ".sh.ejb11";
    private static final String BEXT = ".sh.i.ejb11";
    private static final String MEXT = ".sh.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_SESSION_HOME;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_SESSION_BEANCLASS, IValidationRuleList.EJB11_SESSION_REMOTE};
    private static final Map MESSAGE_IDS = new HashMap();

    public void reset() {
        super.reset();
        this.createMethods.clear();
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    protected boolean hasCreateMethod() {
        if (this.hasDefaultCreateMethod) {
            return true;
        }
        return this.createMethods.size() > 0;
    }

    protected void incrementCreateMethodCount(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        if (method == null) {
            return;
        }
        if (method.listParametersWithoutReturn().length == 0 && !this.hasDefaultCreateMethod) {
            this.hasDefaultCreateMethod = true;
        } else {
            this.createMethods.add(method);
        }
    }

    public void primValidate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        String string = method.getName();
        if (string.equals("create")) {
            this.validateCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2419", 1, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        iValidationContext.terminateIfCancelled();
    }

    protected void primValidateExistence(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        if ("create".equals(method.getName())) {
            this.incrementCreateMethodCount(iValidationContext, enterpriseBean, javaClass, method);
        }
    }

    public void validateClass(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        iValidationContext.terminateIfCancelled();
        super.validateClass(iValidationContext, enterpriseBean, javaClass);
    }

    protected void validateCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws InvalidInputException {
        if (method == null) {
            return;
        }
        this.validateLegalRMIMethod(iValidationContext, enterpriseBean, javaClass, method);
        this.validateCreateMethod_beanDep(iValidationContext, enterpriseBean, javaClass, method);
        if (!ValidationRuleUtility.throwsCreateException(enterpriseBean, method)) {
            String[] stringArray = new String[]{"javax.ejb.CreateException"};
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2414", 1, enterpriseBean, javaClass, method, stringArray, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateCreateMethod_remoteDep(iValidationContext, enterpriseBean, javaClass, method);
    }

    protected void validateMethodExists(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException {
        Object object;
        String[] stringArray = new String[]{javaClass.getQualifiedName()};
        if (!this.hasCreateMethod()) {
            object = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2010", 1, enterpriseBean, javaClass, stringArray, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)object);
        }
        if (ValidationRuleUtility.isStateless(enterpriseBean) && this.createMethods.size() > 0) {
            object = this.createMethods.iterator();
            while (object.hasNext()) {
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2024", 1, enterpriseBean, javaClass, (Method)object.next(), stringArray, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    public void preValidate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationCancelledException, ValidationException {
        super.preValidate(iValidationContext, object, object2);
        this.hasDefaultCreateMethod = false;
    }

    static {
        MESSAGE_IDS.put("CHKJ2005", new String[]{"CHKJ2005.sh.i.ejb11", "CHKJ2005.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2010", new String[]{"CHKJ2010.sh.ejb11"});
        MESSAGE_IDS.put("CHKJ2011", new String[]{"CHKJ2011.sh.ejb11"});
        MESSAGE_IDS.put("CHKJ2012", new String[]{"CHKJ2012.sh.ejb11"});
        MESSAGE_IDS.put("CHKJ2017", new String[]{"CHKJ2017.sh.ejb11"});
        MESSAGE_IDS.put("CHKJ2024", new String[]{"CHKJ2024.sh.i.ejb11", "CHKJ2024.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2026", new String[]{"CHKJ2026.sh.i.ejb11", "CHKJ2026.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2104", new String[]{"CHKJ2104.ejb11"});
        MESSAGE_IDS.put("CHKJ2402", new String[]{"CHKJ2402.sh.i.ejb11", "CHKJ2402.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2403", new String[]{"CHKJ2403.sh.i.ejb11", "CHKJ2403.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2405", new String[]{"CHKJ2405.sh.i.ejb11", "CHKJ2405.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2412", new String[]{"CHKJ2412.sh.i.ejb11", "CHKJ2412.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2413", new String[]{"CHKJ2413.sh.i.ejb11", "CHKJ2413.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2414", new String[]{"CHKJ2414.sh.i.ejb11", "CHKJ2414.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2415", new String[]{"CHKJ2415.sh.i.ejb11", "CHKJ2415.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2419", new String[]{"CHKJ2419.sh.i.ejb11", "CHKJ2419.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }
}

