/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb11.rules.impl.util;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbRelationshipRole;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.ejb.IValidationContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class RoleHelper {
    static final String KEY_GETTER_NAME_PATTERN = "get{0}Key";
    static final String KEY_SETTER_NAME_PATTERN = "privateSet{0}Key";
    static final String LINK_GETTER_NAME_PATTERN = "get{0}Link";
    static final String ADD_NAME_PREFIX = "add";
    static final String GETTER_NAME_PREFIX = "get";
    static final String REMOVE_NAME_PREFIX = "remove";
    static final String SECONDARY_ADD_NAME_PREFIX = "secondaryAdd";
    static final String SECONDARY_REMOVE_NAME_PREFIX = "secondaryRemove";
    static final String SECONDARY_SETTER_NAME_PREFIX = "secondarySet";
    static final String SETTER_NAME_PREFIX = "set";

    public static void collectRoleMethodNames(EjbRelationshipRole ejbRelationshipRole, List list) {
        block14: {
            if (ejbRelationshipRole == null || list == null) {
                return;
            }
            list.add(RoleHelper.getLinkGetterName(ejbRelationshipRole));
            if (ejbRelationshipRole.isForward()) {
                list.add(RoleHelper.getKeyGetterName(ejbRelationshipRole));
                list.add(RoleHelper.getKeySetterName(ejbRelationshipRole));
            }
            if (ejbRelationshipRole.isNavigable()) {
                list.add(RoleHelper.getGetterName(ejbRelationshipRole));
            }
            if (!RoleHelper.isMany(ejbRelationshipRole)) {
                try {
                    if (ejbRelationshipRole.getOpposite() == null) break block14;
                    if (!ejbRelationshipRole.getOpposite().isKey()) {
                        list.add(RoleHelper.getSetterName(ejbRelationshipRole));
                    }
                    if (!ejbRelationshipRole.isKey()) {
                        list.add(RoleHelper.getSecondarySetterName(ejbRelationshipRole));
                    }
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                list.add(RoleHelper.getSecondaryAddName(ejbRelationshipRole));
                list.add(RoleHelper.getSecondaryRemoveName(ejbRelationshipRole));
                if (ejbRelationshipRole.isNavigable()) {
                    try {
                        if (ejbRelationshipRole.getOpposite() != null && !ejbRelationshipRole.getOpposite().isKey()) {
                            list.add(RoleHelper.getAddName(ejbRelationshipRole));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (ejbRelationshipRole.getOpposite() != null && !ejbRelationshipRole.getOpposite().getMultiplicity().isRequired()) {
                        list.add(RoleHelper.getRemoveName(ejbRelationshipRole));
                    }
                }
            }
        }
    }

    public static void collectRoleMethodNamesExtended(IValidationContext iValidationContext, ContainerManagedEntityExtension containerManagedEntityExtension, List list) {
        if (containerManagedEntityExtension == null || list == null) {
            return;
        }
        List list2 = containerManagedEntityExtension.getRelationshipRoles();
        int n = 0;
        while (n < list2.size()) {
            block4: {
                EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)list2.get(n);
                try {
                    RoleHelper.collectRoleMethodNames(ejbRelationshipRole, list);
                }
                catch (Throwable throwable) {
                    MsgLogger msgLogger = iValidationContext.getMsgLogger();
                    if (!msgLogger.isLoggingLevel(6)) break block4;
                    msgLogger.write(6, (Object)throwable);
                }
            }
            ++n;
        }
    }

    public static final String firstAsUppercase(String string) {
        if (string != null && string.length() > 0 && !Character.isUpperCase(string.charAt(0))) {
            char[] cArray = string.toCharArray();
            cArray[0] = Character.toUpperCase(cArray[0]);
            return String.valueOf(cArray);
        }
        return string;
    }

    protected static String format(String string, String[] stringArray) {
        return MessageFormat.format(string, stringArray);
    }

    public static String getAddName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return ADD_NAME_PREFIX + string;
    }

    public static String getGetterName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return GETTER_NAME_PREFIX + string;
    }

    public static String getKeyGetterName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return RoleHelper.format(KEY_GETTER_NAME_PATTERN, new String[]{string});
    }

    public static String getKeySetterName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return RoleHelper.format(KEY_SETTER_NAME_PATTERN, new String[]{string});
    }

    public static String getLinkGetterName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return RoleHelper.format(LINK_GETTER_NAME_PATTERN, new String[]{string});
    }

    public static String getRemoveName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return REMOVE_NAME_PREFIX + string;
    }

    public static List getRoleMethodNamesExtended(IValidationContext iValidationContext, ContainerManagedEntityExtension containerManagedEntityExtension) {
        ArrayList arrayList = new ArrayList();
        if (containerManagedEntityExtension != null) {
            RoleHelper.collectRoleMethodNamesExtended(iValidationContext, containerManagedEntityExtension, arrayList);
        }
        return arrayList;
    }

    public static String getSecondaryAddName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return SECONDARY_ADD_NAME_PREFIX + string;
    }

    public static String getSecondaryRemoveName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return SECONDARY_REMOVE_NAME_PREFIX + string;
    }

    public static String getSecondarySetterName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return SECONDARY_SETTER_NAME_PREFIX + string;
    }

    public static String getSetterName(EjbRelationshipRole ejbRelationshipRole) {
        if (ejbRelationshipRole == null) {
            return null;
        }
        String string = RoleHelper.firstAsUppercase(ejbRelationshipRole.getName());
        return SETTER_NAME_PREFIX + string;
    }

    public static boolean isMany(EjbRelationshipRole ejbRelationshipRole) {
        return ejbRelationshipRole != null && ejbRelationshipRole.getMultiplicity().isMany();
    }
}

