/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb20.rules.impl;

import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IMethodAndFieldConstants;
import com.ibm.etools.validation.ejb.ITypeConstants;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb20.rules.IEJBType;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.ATypeVRule;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class ABeanClassVRule
extends ATypeVRule
implements IEJBType {
    protected static final long[] BASE_TYPES = new long[]{ITypeConstants.JAVA_LANG_OBJECT};
    protected static final int MESSAGE_REMOTE_EXCEPTION_SEVERITY = 2;

    public long[] getBaseTypes() {
        return BASE_TYPES;
    }

    public Object getTarget(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        return ((EnterpriseBean)object).getEjbClass();
    }

    public long getDefaultMethodType() {
        return IMethodAndFieldConstants.HELPER;
    }

    public void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage iMessage;
        if (!this.followAbstractRules(javaClass)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2014", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.followPublicRules(javaClass)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2022", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.followFinalRules(javaClass)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2015", 2, enterpriseBean, javaClass, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateAppendixB(iValidationContext, enterpriseBean, javaClass);
    }

    public static final List getRemoteHomeMethodsExtended(List[] listArray) {
        return listArray[0];
    }

    public static final List getLocalHomeMethodsExtended(List[] listArray) {
        return listArray[1];
    }

    public static final List getRemoteComponentMethodsExtended(List[] listArray) {
        return listArray[2];
    }

    public static final List getLocalComponentMethodsExtended(List[] listArray) {
        return listArray[3];
    }

    public static final List getBeanClassMethodsExtended(List[] listArray) {
        return listArray[4];
    }

    public final List[] getMethodsExtended(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) {
        List[] listArray = new List[5];
        JavaClass javaClass2 = enterpriseBean.getHomeInterface();
        listArray[0] = javaClass2 != null ? javaClass2.getMethodsExtended() : null;
        JavaClass javaClass3 = enterpriseBean.getLocalHomeInterface();
        listArray[1] = javaClass3 != null ? javaClass3.getMethodsExtended() : null;
        JavaClass javaClass4 = enterpriseBean.getRemoteInterface();
        listArray[2] = javaClass4 != null ? javaClass4.getMethodsExtended() : null;
        JavaClass javaClass5 = enterpriseBean.getLocalInterface();
        listArray[3] = javaClass5 != null ? javaClass5.getMethodsExtended() : null;
        JavaClass javaClass6 = enterpriseBean.getEjbClass();
        listArray[4] = javaClass6 != null ? javaClass6.getMethodsExtended() : null;
        return listArray;
    }

    public final List[] getFieldsExtended(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) {
        return null;
    }

    protected abstract boolean shouldBeFinal(JavaClass var1);

    protected abstract boolean shouldBePublic(JavaClass var1);

    protected abstract boolean shouldBeAbstract(JavaClass var1);

    protected abstract boolean shouldValidateTransientField();

    protected abstract JavaHelpers getEjbCreateReturnType(EnterpriseBean var1, Method var2) throws InvalidInputException;

    protected abstract String getEjbCreateReturnTypeName(EnterpriseBean var1, Method var2) throws InvalidInputException;

    public abstract String getMatchingHomeMethodName(IValidationContext var1, EnterpriseBean var2, JavaClass var3, Method var4, List[] var5);

    public String getMatchingEjbHomeMethodName(IValidationContext iValidationContext, Method method) {
        String string = method.getName();
        StringBuffer stringBuffer = new StringBuffer(Character.toLowerCase(string.charAt(0)));
        stringBuffer.append(method.getName().substring(8));
        return stringBuffer.toString();
    }

    public String getMatchingEjbCreateMethodName(IValidationContext iValidationContext, Method method) {
        StringBuffer stringBuffer = new StringBuffer("c");
        stringBuffer.append(method.getName().substring(4));
        return stringBuffer.toString();
    }

    public String getMatchingEjbPostCreateMethodName(IValidationContext iValidationContext, Method method) {
        StringBuffer stringBuffer = new StringBuffer("c");
        stringBuffer.append(method.getName().substring(8));
        return stringBuffer.toString();
    }

    public String getMatchingEjbFindMethodName(IValidationContext iValidationContext, Method method) {
        StringBuffer stringBuffer = new StringBuffer("f");
        stringBuffer.append(method.getName().substring(4));
        return stringBuffer.toString();
    }

    public String getMatchingBusinessMethodName(IValidationContext iValidationContext, Method method) {
        return method.getName();
    }

    public String getNoMatchingMethodName(IValidationContext iValidationContext, Method method) {
        return null;
    }

    public final boolean followFinalRules(JavaClass javaClass) {
        if (this.shouldBeFinal(javaClass)) {
            return javaClass.isFinal();
        }
        return !javaClass.isFinal();
    }

    public final boolean followPublicRules(JavaClass javaClass) {
        if (this.shouldBePublic(javaClass)) {
            return javaClass.isPublic();
        }
        return !javaClass.isPublic();
    }

    public final boolean followAbstractRules(JavaClass javaClass) {
        if (this.shouldBeAbstract(javaClass)) {
            return javaClass.isAbstract();
        }
        return !javaClass.isAbstract();
    }

    public void validateEjbCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
        String string;
        IMessage iMessage;
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2421", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isFinal()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2422", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isStatic()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2423", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if ((iMessage = this.getEjbCreateReturnType(enterpriseBean, method)) == null || !ValidationRuleUtility.isAssignableFrom(method.getReturnType(), (JavaHelpers)iMessage)) {
            string = iMessage == null ? this.getEjbCreateReturnTypeName(enterpriseBean, method) : iMessage.getJavaName();
            IMessage iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2424", 2, enterpriseBean, javaClass, method, new String[]{string}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage2);
        }
        this.validateRMI_IIOPTypeRules(iValidationContext, enterpriseBean, javaClass, method, listArray, true);
        if (this.validateEjbCreateMethodExceptions() && !this.followRemoteExceptionRules(enterpriseBean, method)) {
            string = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2503.ejbCreate", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)string);
        }
    }

    public boolean validateEjbCreateMethodExceptions() {
        return true;
    }

    public void validateEjbPostCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage iMessage;
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2426", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isFinal()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2427", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isStatic()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2428", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!method.isVoid()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2505.ejbPostCreate", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!this.followRemoteExceptionRules(enterpriseBean, method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2503.ejbPostCreate", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public final void validateEjbHomeMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
        Object object;
        if (!ValidationRuleUtility.isPublic(method)) {
            object = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2431", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)object);
        }
        if (method.isStatic()) {
            object = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2439", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)object);
        }
        this.validateRMI_IIOPTypeRules(iValidationContext, enterpriseBean, javaClass, method, listArray, true);
        if (!this.followRemoteExceptionRules(enterpriseBean, method)) {
            object = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2503.ejbHome", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)object);
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(Character.toLowerCase(method.getName().charAt(7)));
        ((StringBuffer)object).append(method.getName().substring(8));
        String string = ((StringBuffer)object).toString();
        Method method2 = ValidationRuleUtility.getMethod(method, string, ABeanClassVRule.getRemoteHomeMethodsExtended(listArray));
        if (method2 != null) {
            return;
        }
        Method method3 = ValidationRuleUtility.getMethod(method, string, ABeanClassVRule.getLocalHomeMethodsExtended(listArray));
        if (method3 != null) {
            return;
        }
        IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2430", 4, enterpriseBean, javaClass, method, new String[]{string}, (IValidationRule)this);
        iValidationContext.addMessage(iMessage);
    }

    public final void validateBusinessMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage iMessage;
        if (method.getName().startsWith("ejb")) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2411", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2441", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isFinal()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2442", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isStatic()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2443", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateRMI_IIOPTypeRules(iValidationContext, enterpriseBean, javaClass, method, listArray, true);
        if (!this.followRemoteExceptionRules(enterpriseBean, method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2503.bus", this.getMessageRemoteExceptionSeverity(), enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        this.validateMatchingComponentMethod(iValidationContext, enterpriseBean, javaClass, method, listArray);
    }

    public void validateEjbRemoveMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage iMessage;
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2492", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isFinal()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2493", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (method.isStatic()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2494", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!method.isVoid()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2505.ejbRemove", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
        if (this.shouldValidateTransientField()) {
            this.validateTransientField(iValidationContext, enterpriseBean, javaClass, field);
        }
    }

    public void validateTransientField(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws ValidationCancelledException, InvalidInputException, ValidationException {
    }

    public long getFieldType(EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) {
        if (field == null) {
            return IMethodAndFieldConstants.EXCLUDED_FIELD;
        }
        if (field.getName().equals("serialVersionUID")) {
            return IMethodAndFieldConstants.SERIALVERSIONUID;
        }
        return IMethodAndFieldConstants.OTHER_FIELD;
    }

    public void validateMatchingMethodExceptions(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, JavaClass javaClass2, Method method2) {
        Set set = ValidationRuleUtility.getNotSubsetExceptions(enterpriseBean, method2, method);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass3 = (JavaClass)iterator.next();
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2456", 2, enterpriseBean, javaClass, method, new String[]{javaClass3.getJavaName(), javaClass2.getJavaName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public final void validateMatchingHomeMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
        Method method2;
        Method method3 = ValidationRuleUtility.getMethod(method, this.getMatchingHomeMethodName(iValidationContext, enterpriseBean, javaClass, method, listArray), ABeanClassVRule.getRemoteHomeMethodsExtended(listArray));
        if (method3 != null) {
            this.validateMatchingMethodExceptions(iValidationContext, enterpriseBean, javaClass, method, enterpriseBean.getHomeInterface(), method3);
        }
        if ((method2 = ValidationRuleUtility.getMethod(method, this.getMatchingHomeMethodName(iValidationContext, enterpriseBean, javaClass, method, listArray), ABeanClassVRule.getLocalHomeMethodsExtended(listArray))) != null) {
            this.validateMatchingMethodExceptions(iValidationContext, enterpriseBean, javaClass, method, enterpriseBean.getLocalHomeInterface(), method2);
        }
    }

    public final void validateMatchingComponentMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
        Method method2;
        Method method3 = ValidationRuleUtility.getMethod(method, method.getName(), ABeanClassVRule.getRemoteComponentMethodsExtended(listArray));
        if (method3 != null) {
            this.validateMatchingMethodExceptions(iValidationContext, enterpriseBean, javaClass, method, enterpriseBean.getRemoteInterface(), method3);
        }
        if ((method2 = ValidationRuleUtility.getMethod(method, method.getName(), ABeanClassVRule.getLocalComponentMethodsExtended(listArray))) != null) {
            this.validateMatchingMethodExceptions(iValidationContext, enterpriseBean, javaClass, method, enterpriseBean.getLocalInterface(), method2);
        }
    }

    protected void validateAppendixB(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) {
        block4: {
            if (enterpriseBean == null) {
                return;
            }
            EnterpriseBean enterpriseBean2 = EjbExtensionsHelper.getSupertype((EnterpriseBean)enterpriseBean);
            JavaClass javaClass2 = null;
            if (enterpriseBean2 == null) break block4;
            javaClass2 = enterpriseBean2.getEjbClass();
            try {
                ValidationRuleUtility.isValidType((JavaHelpers)javaClass);
                ValidationRuleUtility.isValidType((JavaHelpers)javaClass2);
                if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass, (JavaHelpers)javaClass2)) {
                    String[] stringArray = new String[]{javaClass.getQualifiedName(), javaClass2.getQualifiedName()};
                    IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2103", 1, enterpriseBean, javaClass, stringArray, (IValidationRule)this);
                    iValidationContext.addMessage(iMessage);
                }
            }
            catch (InvalidInputException invalidInputException) {
                String[] stringArray = new String[]{invalidInputException.getJavaClass().getQualifiedName(), enterpriseBean.getName()};
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2849", 2, enterpriseBean, stringArray, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    public final boolean followRemoteExceptionRules(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException, ValidationCancelledException {
        return ValidationRuleUtility.doesNotThrowRemoteException(enterpriseBean, method);
    }
}

