/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb20.rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.MessageLimitException;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.ClassUtility;
import com.ibm.etools.validation.ejb.IMethodAndFieldConstants;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb20.rules.IEJBInterfaceType;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.ATypeVRule;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public abstract class AInterfaceTypeVRule
extends ATypeVRule
implements IEJBInterfaceType {
    public static final List getBeanClassMethodsExtended(List[] listArray) {
        return listArray[0];
    }

    public final List[] getMethodsExtended(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) {
        List[] listArray = new List[1];
        JavaClass javaClass2 = enterpriseBean.getEjbClass();
        listArray[0] = javaClass2.getMethodsExtended();
        return listArray;
    }

    public final List[] getFieldsExtended(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) {
        return null;
    }

    public void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
    }

    public void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
        this.validateApplicationExceptionRules(iValidationContext, enterpriseBean, javaClass, method);
    }

    public final boolean isEJBInterfaceMethod(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        long[] lArray = this.getSupertypes();
        int n = 0;
        while (n < lArray.length) {
            if (ClassUtility.getUtility().isClassType(enterpriseBean, method.getJavaClass(), lArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final JavaHelpers getOverExposedLocalType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
        if ((this.isRemote() & 1) == 1) {
            JavaHelpers javaHelpers;
            JavaParameter[] javaParameterArray = method.listParametersWithoutReturn();
            if (javaParameterArray != null) {
                int n = 0;
                while (n < javaParameterArray.length) {
                    JavaParameter javaParameter = javaParameterArray[n];
                    if (ValidationRuleUtility.isLocalType(enterpriseBean, javaParameter.getJavaType())) {
                        return javaParameter.getJavaType();
                    }
                    ++n;
                }
            }
            if (ValidationRuleUtility.isLocalType(enterpriseBean, javaHelpers = method.getReturnType())) {
                return javaHelpers;
            }
            return null;
        }
        return null;
    }

    public long getFieldType(EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) {
        if (field == null) {
            return IMethodAndFieldConstants.EXCLUDED_FIELD;
        }
        if (field.getName().equals("serialVersionUID")) {
            return IMethodAndFieldConstants.SERIALVERSIONUID;
        }
        return IMethodAndFieldConstants.OTHER_FIELD;
    }

    public void validateApplicationExceptionRules(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws ValidationCancelledException, MessageLimitException {
        EList eList = method.getJavaExceptions();
        if (eList.size() == 0) {
            return;
        }
        Iterator iterator = eList.iterator();
        try {
            JavaHelpers javaHelpers = ValidationRuleUtility.getType("java.lang.Exception", enterpriseBean);
            JavaHelpers javaHelpers2 = ValidationRuleUtility.getType("java.lang.RuntimeException", enterpriseBean);
            while (iterator.hasNext()) {
                IMessage iMessage;
                JavaClass javaClass2 = (JavaClass)iterator.next();
                if (!ValidationRuleUtility.isApplicationException(javaClass2, enterpriseBean)) continue;
                if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass2, javaHelpers)) {
                    iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2404", 2, enterpriseBean, javaClass, method, new String[]{javaClass2.getName()}, (IValidationRule)this);
                    iValidationContext.addMessage(iMessage);
                    continue;
                }
                if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass2, javaHelpers2)) continue;
                iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2416", 2, enterpriseBean, javaClass, method, new String[]{javaClass2.getName()}, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
            return;
        }
        catch (InvalidInputException invalidInputException) {
            return;
        }
    }
}

