/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb20.rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.Method;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.MessageLimitException;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.AValidationRule;
import com.ibm.etools.validation.ejb.ClassUtility;
import com.ibm.etools.validation.ejb.IMethodAndFieldConstants;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.LogEntry;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb20.rules.IClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.IEJBType;
import com.ibm.etools.validation.ejb.ejb20.rules.IMethodType;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.MethodUtility;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;

public abstract class ATypeVRule
extends AValidationRule
implements IClassVRule,
IEJBType {
    private static final int NO_FIELDS = 0;
    private long _methodList = 0L;
    private long _fieldList = 0L;

    public final void validate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationException {
        LogEntry logEntry;
        iValidationContext.subtask("STATUS_VALIDATING", new String[]{((JavaClass)object2).getJavaName()});
        MsgLogger msgLogger = iValidationContext.getMsgLogger();
        if (msgLogger.isLoggingLevel(7)) {
            logEntry = iValidationContext.getLogEntry();
            logEntry.setSourceID("EJB20Validator - validate");
            logEntry.setText(this.getClass().getName() + "::validate(" + object + ", " + object2);
            msgLogger.write(7, (Object)logEntry);
        }
        try {
            List[] listArray;
            iValidationContext.terminateIfCancelled();
            logEntry = (EnterpriseBean)object;
            JavaClass javaClass = (JavaClass)object2;
            try {
                ValidationRuleUtility.isValidTypeHierarchy((EnterpriseBean)logEntry, (JavaHelpers)javaClass);
            }
            catch (InvalidInputException invalidInputException) {
                this.reflectionError(iValidationContext, (EnterpriseBean)logEntry, javaClass);
                return;
            }
            if (ValidationRuleUtility.isUnnamedPackage(javaClass.getJavaPackage())) {
                listArray = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2041", 4, (EnterpriseBean)logEntry, javaClass, (IValidationRule)this);
                iValidationContext.addMessage((IMessage)listArray);
            }
            try {
                this.validate(iValidationContext, (EnterpriseBean)logEntry, javaClass);
                iValidationContext.terminateIfCancelled();
                listArray = this.getMethodsExtended(iValidationContext, (EnterpriseBean)logEntry, javaClass);
                this.validate(iValidationContext, (EnterpriseBean)logEntry, javaClass, javaClass.listMethodExtended(), listArray);
                iValidationContext.terminateIfCancelled();
                List[] listArray2 = this.getFieldsExtended(iValidationContext, (EnterpriseBean)logEntry, javaClass);
                this.validate(iValidationContext, (EnterpriseBean)logEntry, javaClass, javaClass.listFieldExtended(), listArray2);
                iValidationContext.terminateIfCancelled();
                this.validateSupertypes(iValidationContext, (EnterpriseBean)logEntry, javaClass);
                iValidationContext.terminateIfCancelled();
                this.validateMethodsWhichMustExist(iValidationContext, (EnterpriseBean)logEntry, javaClass);
                iValidationContext.terminateIfCancelled();
            }
            catch (InvalidInputException invalidInputException) {
                this.reflectionError(iValidationContext, (EnterpriseBean)logEntry, javaClass);
                return;
            }
        }
        catch (ValidationCancelledException validationCancelledException) {}
    }

    protected final void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field[] fieldArray, List[] listArray) throws ValidationException {
        try {
            iValidationContext.terminateIfCancelled();
            Field field = null;
            int n = 0;
            while (n < fieldArray.length) {
                LogEntry logEntry;
                MsgLogger msgLogger;
                iValidationContext.terminateIfCancelled();
                field = fieldArray[n];
                if (field == null) {
                    msgLogger = iValidationContext.getMsgLogger();
                    if (msgLogger.isLoggingLevel(5)) {
                        logEntry = iValidationContext.getLogEntry();
                        logEntry.setSourceID("EJB20Validator - validate fields");
                        logEntry.setText("A field is null on " + javaClass.getQualifiedName());
                        msgLogger.write(5, (Object)logEntry);
                    }
                } else {
                    try {
                        msgLogger = iValidationContext.getMsgLogger();
                        if (msgLogger.isLoggingLevel(7)) {
                            logEntry = iValidationContext.getLogEntry();
                            logEntry.setSourceID("EJB20Validator - validate fields");
                            logEntry.setText("Validating field " + field.getName() + "on clazz " + javaClass + " and isValid returns " + this.isValid(enterpriseBean, javaClass, field));
                            msgLogger.write(7, (Object)logEntry);
                        }
                        if (this.isValid(enterpriseBean, javaClass, field)) {
                            this.register(iValidationContext, enterpriseBean, javaClass, field, listArray);
                            this.validate(iValidationContext, enterpriseBean, javaClass, field, listArray);
                        }
                    }
                    catch (InvalidInputException invalidInputException) {
                        this.reflectionWarning(iValidationContext, enterpriseBean, javaClass, field, invalidInputException);
                    }
                }
                ++n;
            }
            iValidationContext.terminateIfCancelled();
        }
        catch (ValidationCancelledException validationCancelledException) {}
    }

    protected final boolean isValid(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws InvalidInputException {
        if (this.isOwnedByBase(enterpriseBean, method)) {
            return false;
        }
        return (this.getMethodType(enterpriseBean, javaClass, method, listArray) & IMethodAndFieldConstants.EXCLUDED_METHOD) != IMethodAndFieldConstants.EXCLUDED_METHOD;
    }

    protected final boolean isOwnedByBase(EnterpriseBean enterpriseBean, Field field) throws InvalidInputException {
        if (field == null) {
            return false;
        }
        long[] lArray = this.getBaseTypes();
        if (lArray == null) {
            return false;
        }
        int n = 0;
        while (n < lArray.length) {
            if (ClassUtility.getUtility().isClassType(enterpriseBean, field.getJavaClass(), lArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected final boolean isOwnedByBase(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        if (method == null) {
            return false;
        }
        long[] lArray = this.getBaseTypes();
        if (lArray == null) {
            return false;
        }
        int n = 0;
        while (n < lArray.length) {
            if (ClassUtility.getUtility().isClassType(enterpriseBean, method.getJavaClass(), lArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected final boolean isValid(EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) throws InvalidInputException {
        if (this.isOwnedByBase(enterpriseBean, field)) {
            return false;
        }
        return (this.getFieldType(enterpriseBean, javaClass, field) & IMethodAndFieldConstants.EXCLUDED_FIELD) != IMethodAndFieldConstants.EXCLUDED_FIELD;
    }

    protected final void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method[] methodArray, List[] listArray) throws ValidationException {
        try {
            iValidationContext.terminateIfCancelled();
            Method method = null;
            int n = 0;
            while (n < methodArray.length) {
                LogEntry logEntry;
                MsgLogger msgLogger;
                iValidationContext.terminateIfCancelled();
                method = methodArray[n];
                if (method == null) {
                    msgLogger = iValidationContext.getMsgLogger();
                    if (msgLogger.isLoggingLevel(5)) {
                        logEntry = iValidationContext.getLogEntry();
                        logEntry.setSourceID("EJB20Validator - validate methods");
                        logEntry.setText("On " + javaClass.getQualifiedName() + ", there is a null method.");
                        msgLogger.write(5, (Object)logEntry);
                    }
                } else {
                    try {
                        msgLogger = iValidationContext.getMsgLogger();
                        if (msgLogger.isLoggingLevel(7)) {
                            logEntry = iValidationContext.getLogEntry();
                            logEntry.setSourceID("EJB20Validator - validate methods");
                            logEntry.setText("Validating method " + method.getMethodElementSignature() + " on clazz " + javaClass + " and isValid returns " + this.isValid(enterpriseBean, javaClass, method, listArray));
                            msgLogger.write(7, (Object)logEntry);
                        }
                        if (this.isValid(enterpriseBean, javaClass, method, listArray)) {
                            this.register(iValidationContext, enterpriseBean, javaClass, method, listArray);
                            if (this.isMethodAllowedToExist(enterpriseBean, javaClass, method, listArray)) {
                                this.validate(iValidationContext, enterpriseBean, javaClass, method, listArray);
                            } else {
                                this.validateMethodWhichMustNotExist(iValidationContext, enterpriseBean, javaClass, method, listArray);
                            }
                        } else if (!this.isOwnedByBase(enterpriseBean, method) && (MethodUtility.getUtility().getMethodTypeId(enterpriseBean, javaClass, method, listArray, this) & IMethodAndFieldConstants.EXCLUDED_METHOD) == IMethodAndFieldConstants.EXCLUDED_METHOD) {
                            logEntry = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2502", 4, enterpriseBean, javaClass, method, new String[]{method.getName()}, (IValidationRule)this);
                            iValidationContext.addMessage((IMessage)logEntry);
                        }
                    }
                    catch (InvalidInputException invalidInputException) {
                        this.reflectionWarning(iValidationContext, enterpriseBean, javaClass, method, invalidInputException);
                    }
                }
                ++n;
            }
            iValidationContext.terminateIfCancelled();
        }
        catch (ValidationCancelledException validationCancelledException) {}
    }

    public final void register(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, List[] listArray) throws InvalidInputException, ValidationCancelledException, ValidationException {
        this._fieldList |= this.getFieldType(enterpriseBean, javaClass, field);
    }

    private boolean isDefaultConstructor(long l) {
        return (l & IMethodAndFieldConstants.CONSTRUCTOR_NOPARM) == IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
    }

    private boolean doesPublicDefaultConstructorExist() {
        return (this._methodList & IMethodAndFieldConstants.CONSTRUCTOR_NOPARM) == IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
    }

    private boolean isDefaultConstructorInsertedByCompiler() {
        return (this._methodList & IMethodAndFieldConstants.CONSTRUCTOR) != IMethodAndFieldConstants.CONSTRUCTOR;
    }

    protected final boolean isMethodAllowedToExist(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
        long[] lArray = this.getMethodsWhichMustNotExist();
        if (lArray != null) {
            int n = 0;
            while (n < lArray.length) {
                long l = lArray[n];
                long l2 = MethodUtility.getUtility().getMethodTypeId(enterpriseBean, javaClass, method, listArray, this);
                if ((l2 & l) == l) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public final void validateMethodsWhichMustExist(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException, ValidationCancelledException, ValidationException {
        long[] lArray = this.getMethodsWhichMustExist();
        if (lArray != null) {
            int n = 0;
            while (n < lArray.length) {
                long l = lArray[n];
                boolean bl = false;
                if (this.isDefaultConstructor(l)) {
                    if (!this.doesPublicDefaultConstructorExist() && !this.isDefaultConstructorInsertedByCompiler()) {
                        bl = true;
                    }
                } else {
                    boolean bl2 = bl = !this.exists(l);
                }
                if (bl) {
                    MsgLogger msgLogger;
                    IMethodType iMethodType = MethodUtility.getUtility().getMethodType(l);
                    if (iMethodType == null) {
                        msgLogger = iValidationContext.getMsgLogger();
                        if (msgLogger.isLoggingLevel(7)) {
                            LogEntry logEntry = iValidationContext.getLogEntry();
                            logEntry.setSourceID("EJB20Validator - validate methods which must exist");
                            logEntry.setText("Method type is null: " + l);
                            msgLogger.write(7, (Object)logEntry);
                        }
                    } else {
                        msgLogger = MessageUtility.getUtility().getMessage(iValidationContext, (Object)iMethodType.getMessageId_messageMissing(), 2, enterpriseBean, javaClass, new String[]{iMethodType.getMethodName(enterpriseBean, javaClass, null)}, (IValidationRule)this);
                        iValidationContext.addMessage((IMessage)msgLogger);
                    }
                }
                ++n;
            }
        }
    }

    public final void validateMethodWhichMustNotExist(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws InvalidInputException, ValidationCancelledException, ValidationException {
        IMethodType iMethodType = MethodUtility.getUtility().getMethodType(enterpriseBean, javaClass, method, listArray, this);
        if (iMethodType == null) {
            MsgLogger msgLogger = iValidationContext.getMsgLogger();
            if (msgLogger.isLoggingLevel(7)) {
                LogEntry logEntry = iValidationContext.getLogEntry();
                logEntry.setSourceID("EJB20Validator - validate method which must not exist");
                logEntry.setText("Method type is null: " + MethodUtility.getUtility().getMethodType(enterpriseBean, javaClass, method, listArray, this));
                msgLogger.write(7, (Object)logEntry);
            }
            return;
        }
        IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)iMethodType.getMessageId_messageExists(), 4, enterpriseBean, javaClass, method, new String[]{iMethodType.getMethodName(enterpriseBean, javaClass, method)}, (IValidationRule)this);
        iValidationContext.addMessage(iMessage);
    }

    public abstract long getFieldType(EnterpriseBean var1, JavaClass var2, Field var3);

    public abstract long[] getBaseTypes();

    public abstract int getMessageRemoteExceptionSeverity();

    public final long getMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
        if (method == null) {
            return IMethodAndFieldConstants.EXCLUDED_METHOD;
        }
        long l = MethodUtility.getUtility().getMethodTypeId(enterpriseBean, javaClass, method, listArray, this);
        if ((l & IMethodAndFieldConstants.CLINIT) == IMethodAndFieldConstants.CLINIT) {
            return IMethodAndFieldConstants.EXCLUDED_METHOD;
        }
        return l;
    }

    public final void register(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws InvalidInputException, ValidationCancelledException, ValidationException {
        this._methodList |= MethodUtility.getUtility().getMethodTypeId(enterpriseBean, javaClass, method, listArray, this);
    }

    public final void validateSupertypes(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws InvalidInputException, ValidationCancelledException, ValidationException {
        IMessage iMessage;
        JavaHelpers javaHelpers;
        int n;
        long[] lArray = this.getSupertypes();
        if (lArray != null) {
            n = 0;
            while (n < lArray.length) {
                javaHelpers = ClassUtility.getUtility().getSupertype(enterpriseBean, lArray[n]);
                if (javaHelpers != null && !ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass, javaHelpers)) {
                    iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2017", 1, enterpriseBean, javaClass, new String[]{javaHelpers.getJavaName()}, (IValidationRule)this);
                    iValidationContext.addMessage(iMessage);
                }
                ++n;
            }
        }
        if ((lArray = this.getShouldNotBeSupertypes()) != null) {
            n = 0;
            while (n < lArray.length) {
                javaHelpers = ClassUtility.getUtility().getSupertype(enterpriseBean, lArray[n]);
                if (javaHelpers != null && ValidationRuleUtility.isAssignableFrom((JavaHelpers)javaClass, javaHelpers)) {
                    iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2040", 4, enterpriseBean, javaClass, (IValidationRule)this);
                    iValidationContext.addMessage(iMessage);
                }
                ++n;
            }
        }
    }

    public void reset() {
        super.reset();
        this._methodList = 0L;
        this._fieldList = 0L;
    }

    protected final void reflectionError(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws MessageLimitException {
        iValidationContext.removeMessages(javaClass);
        IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2907", 1, enterpriseBean, javaClass, new String[]{javaClass.getQualifiedName()}, (IValidationRule)this);
        iValidationContext.addMessage(iMessage);
    }

    protected final void reflectionWarning(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, InvalidInputException invalidInputException) throws MessageLimitException {
        iValidationContext.removeMessages(field);
        iValidationContext.removeMessages(javaClass, field.getName());
        IMessage iMessage = this.getReflectionWarning(iValidationContext, invalidInputException, enterpriseBean, javaClass, (EObject)field);
        iValidationContext.addMessage(iMessage);
    }

    protected final void reflectionWarning(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, InvalidInputException invalidInputException) throws MessageLimitException {
        iValidationContext.removeMessages(method);
        iValidationContext.removeMessages(javaClass, method.getSignature());
        IMessage iMessage = this.getReflectionWarning(iValidationContext, invalidInputException, enterpriseBean, javaClass, (EObject)method);
        iValidationContext.addMessage(iMessage);
    }

    protected final IMessage getReflectionWarning(IValidationContext iValidationContext, InvalidInputException invalidInputException, EnterpriseBean enterpriseBean, JavaClass javaClass, EObject eObject) {
        String string;
        if (invalidInputException == null) {
            return null;
        }
        JavaClass javaClass2 = invalidInputException.getJavaClass();
        String string2 = javaClass2 == null ? "?" : javaClass2.getQualifiedName();
        IMessage iMessage = null;
        if (eObject instanceof Field) {
            string = ((Field)eObject).getName();
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2433", 2, enterpriseBean, javaClass, (Field)eObject, new String[]{string, string2}, (IValidationRule)this);
        } else if (eObject instanceof Method) {
            string = ((Method)eObject).getMethodElementSignature();
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2433", 2, enterpriseBean, javaClass, (Method)eObject, new String[]{string, string2}, (IValidationRule)this);
        } else {
            string = ((XMIResource)eObject.eResource()).getID(eObject);
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2433", 2, enterpriseBean, javaClass, new String[]{string, string2}, (IValidationRule)this);
        }
        if (javaClass2 == null && (string = iValidationContext.getMsgLogger()).isLoggingLevel(7)) {
            LogEntry logEntry = iValidationContext.getLogEntry();
            logEntry.setSourceID("getMessageId(IValidationContext, InvalidInputException, boolean)");
            logEntry.setText("InvalidInputException thrown on unknown class");
            logEntry.setTargetException(invalidInputException);
            string.write(7, (Object)logEntry);
        }
        return iMessage;
    }

    public final JavaClass getComponentInterface(EnterpriseBean enterpriseBean) {
        if ((this.isRemote() & 1) == 1) {
            return enterpriseBean.getRemoteInterface();
        }
        return enterpriseBean.getLocalInterface();
    }

    public final boolean exists(long l) {
        return (this._methodList & l) == l;
    }

    public final JavaClass getHomeInterface(EnterpriseBean enterpriseBean) {
        if ((this.isRemote() & 1) == 1) {
            return enterpriseBean.getHomeInterface();
        }
        return enterpriseBean.getLocalHomeInterface();
    }

    public boolean followRemoteExceptionRules(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException, ValidationCancelledException {
        if ((this.isRemote() & 1) == 1) {
            return ValidationRuleUtility.throwsRemoteExceptionOrParent(enterpriseBean, method);
        }
        if ((this.isRemote() & 2) == 2) {
            return ValidationRuleUtility.doesNotThrowRemoteException(enterpriseBean, method);
        }
        return true;
    }

    public final void validateRMI_IIOPTypeRules(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray, boolean bl) throws InvalidInputException, MessageLimitException {
        if ((this.isRemote() & 1) == 1) {
            IMethodType iMethodType;
            Object object;
            JavaParameter[] javaParameterArray = method.listParametersWithoutReturn();
            int n = 0;
            while (n < javaParameterArray.length) {
                object = javaParameterArray[n];
                if (!ValidationRuleUtility.isLegalRMI_IIOPType(enterpriseBean, object.getJavaType()) && (iMethodType = MethodUtility.getUtility().getMethodType(enterpriseBean, javaClass, method, listArray, this)) != null) {
                    IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)iMethodType.getMessageId_messageRMI_IIOPParm(), 4, enterpriseBean, javaClass, method, new String[]{object.getJavaType().getJavaName()}, (IValidationRule)this);
                    iValidationContext.addMessage(iMessage);
                }
                ++n;
            }
            if (bl && !ValidationRuleUtility.isLegalRMI_IIOPType(enterpriseBean, method.getReturnType()) && (object = MethodUtility.getUtility().getMethodType(enterpriseBean, javaClass, method, listArray, this)) != null) {
                iMethodType = MessageUtility.getUtility().getMessage(iValidationContext, (Object)object.getMessageId_messageRMI_IIOPParm(), 4, enterpriseBean, javaClass, method, new String[]{method.getReturnType().getJavaName()}, (IValidationRule)this);
                iValidationContext.addMessage((IMessage)iMethodType);
            }
        } else {
            return;
        }
    }

    public final boolean followRMI_IIOPInheritanceRules(EnterpriseBean enterpriseBean, JavaClass javaClass) {
        if ((this.isRemote() & 1) == 1) {
            return ValidationRuleUtility.isLegalRMI_IIOPInheritance(javaClass);
        }
        return true;
    }

    public void validateSerialVersionUID(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) {
    }
}

