/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb20.rules.impl;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBExtensionFilter;
import com.ibm.ejs.models.base.extensions.ejbext.impl.LocalModelledPersistentAttributeFilter;
import com.ibm.etools.ejb.CMPAttribute;
import com.ibm.etools.ejb.CMRField;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IMethodAndFieldConstants;
import com.ibm.etools.validation.ejb.ITypeConstants;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.AEntityBeanClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.IMessagePrefixEjb20Constants;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.MethodUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CMPBeanClassVRule
extends AEntityBeanClassVRule
implements IMessagePrefixEjb20Constants {
    private static final Object ID = IValidationRuleList.EJB20_CMP_BEANCLASS;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB20_CMP_HOME, IValidationRuleList.EJB20_CMP_LOCALHOME, IValidationRuleList.EJB20_CMP_REMOTE, IValidationRuleList.EJB20_CMP_LOCAL, IValidationRuleList.EJB20_CMP_KEYCLASS};
    private static final Map MESSAGE_IDS = new HashMap();
    private static final String MSSGID = ".cb";
    private static final String EXT = ".cb.ejb20";
    private static final String BEXT = ".cb.i.ejb20";
    private static final String MEXT = ".cb.m.ejb20";
    private final long[] SUPERTYPES = new long[]{ITypeConstants.JAVAX_EJB_ENTITYBEAN};
    private final long[] SHOULD_NOT_BE_SUPERTYPES = new long[]{ITypeConstants.LOCAL_COMPONENT_INTERFACE, ITypeConstants.REMOTE_COMPONENT_INTERFACE};
    private final boolean SHOULD_BE_ABSTRACT = true;
    private final boolean SHOULD_BE_FINAL = false;
    private final boolean SHOULD_BE_PUBLIC = true;
    private final boolean SHOULD_VALIDATE_TRANSIENT_FIELD = false;
    private final long[] METHODS_WHICH_MUST_EXIST = new long[]{IMethodAndFieldConstants.CONSTRUCTOR_NOPARM, IMethodAndFieldConstants.SETENTITYCONTEXT, IMethodAndFieldConstants.UNSETENTITYCONTEXT_NOPARM, IMethodAndFieldConstants.EJBACTIVATE_NOPARM, IMethodAndFieldConstants.EJBPASSIVATE_NOPARM, IMethodAndFieldConstants.EJBREMOVE_NOPARM, IMethodAndFieldConstants.EJBLOAD_NOPARM, IMethodAndFieldConstants.EJBSTORE_NOPARM};
    private final long[] METHODS_WHICH_MUST_NOT_EXIST = new long[]{IMethodAndFieldConstants.EJBFIND, IMethodAndFieldConstants.FINALIZE_NOPARM};
    private final long[] KNOWN_METHOD_TYPES = new long[]{IMethodAndFieldConstants.CLINIT, IMethodAndFieldConstants.CONSTRUCTOR_NOPARM, IMethodAndFieldConstants.CONSTRUCTOR, IMethodAndFieldConstants.EJBCREATE, IMethodAndFieldConstants.EJBPOSTCREATE, IMethodAndFieldConstants.EJBHOME, IMethodAndFieldConstants.FINALIZE_NOPARM, IMethodAndFieldConstants.EJBFIND, IMethodAndFieldConstants.ACCESSOR, IMethodAndFieldConstants.EJBFINDBYPRIMARYKEY, IMethodAndFieldConstants.SETENTITYCONTEXT, IMethodAndFieldConstants.UNSETENTITYCONTEXT_NOPARM, IMethodAndFieldConstants.EJBACTIVATE_NOPARM, IMethodAndFieldConstants.EJBPASSIVATE_NOPARM, IMethodAndFieldConstants.EJBREMOVE_NOPARM, IMethodAndFieldConstants.EJBLOAD_NOPARM, IMethodAndFieldConstants.EJBSTORE_NOPARM, IMethodAndFieldConstants.EJBSELECT, IMethodAndFieldConstants.FINALIZE_NOPARM, IMethodAndFieldConstants.BUSINESS};

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final int getMessageRemoteExceptionSeverity() {
        return 2;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    public final long[] getSupertypes() {
        return this.SUPERTYPES;
    }

    public final boolean shouldValidateTransientField() {
        return false;
    }

    public final long[] getShouldNotBeSupertypes() {
        return this.SHOULD_NOT_BE_SUPERTYPES;
    }

    public final boolean shouldBeAbstract(JavaClass javaClass) {
        return true;
    }

    public final boolean shouldBeFinal(JavaClass javaClass) {
        return false;
    }

    public final boolean shouldBePublic(JavaClass javaClass) {
        return true;
    }

    public final int isRemote() {
        return 4;
    }

    public final long[] getMethodsWhichMustExist() {
        return this.METHODS_WHICH_MUST_EXIST;
    }

    public final long[] getMethodsWhichMustNotExist() {
        return this.METHODS_WHICH_MUST_NOT_EXIST;
    }

    public final JavaHelpers getEjbCreateReturnType(EnterpriseBean enterpriseBean, Method method) {
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
        if (ValidationRuleUtility.usesUnknownPrimaryKey(containerManagedEntity)) {
            try {
                return ValidationRuleUtility.getType("java.lang.Object", (EnterpriseBean)containerManagedEntity);
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return ((Entity)enterpriseBean).getPrimaryKey();
    }

    public final String getEjbCreateReturnTypeName(EnterpriseBean enterpriseBean, Method method) {
        JavaHelpers javaHelpers = this.getEjbCreateReturnType(enterpriseBean, method);
        if (javaHelpers == null) {
            return "<primary-key>";
        }
        return javaHelpers.getJavaName();
    }

    public final void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws ValidationCancelledException, InvalidInputException, ValidationException {
        ContainerManagedEntityExtension containerManagedEntityExtension;
        super.validate(iValidationContext, enterpriseBean, javaClass);
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
        List list = containerManagedEntity.getCMRFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            containerManagedEntityExtension = (CMRField)iterator.next();
            if (containerManagedEntityExtension == null || containerManagedEntityExtension.isDerived()) continue;
            this.validateCmrField(iValidationContext, containerManagedEntity, javaClass, (CMRField)containerManagedEntityExtension);
        }
        containerManagedEntityExtension = ValidationRuleUtility.getCMPExtension(containerManagedEntity);
        if (containerManagedEntityExtension == null) {
            return;
        }
        List list2 = containerManagedEntityExtension.getFilteredFeatures((EJBExtensionFilter)LocalModelledPersistentAttributeFilter.singleton());
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            CMPAttribute cMPAttribute = (CMPAttribute)iterator.next();
            if (cMPAttribute == null || cMPAttribute.isDerived()) continue;
            this.validateCmpField(iValidationContext, containerManagedEntity, javaClass, cMPAttribute);
        }
    }

    public void validateEjbCreateMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
        super.validateEjbCreateMethod(iValidationContext, enterpriseBean, javaClass, method, listArray);
        if (!ValidationRuleUtility.throwsCreateException(enterpriseBean, method)) {
            IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2497", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public final void validateEjbSelectMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage iMessage;
        JavaHelpers javaHelpers = method.getReturnType();
        JavaHelpers javaHelpers2 = ValidationRuleUtility.getType("java.util.Collection", enterpriseBean);
        if (!ValidationRuleUtility.isAssignableFrom(javaHelpers, (JavaHelpers)enterpriseBean.getLocalInterface()) && !ValidationRuleUtility.isAssignableFrom(javaHelpers, javaHelpers2)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2486", 4, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2487", 4, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!method.isAbstract()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2485", 4, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!ValidationRuleUtility.throwsFinderException(enterpriseBean, method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2488", 4, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!ValidationRuleUtility.followsObjectNotFoundExceptionRules(enterpriseBean, method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2478", 4, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!ValidationRuleUtility.isAssociatedWithQuery((ContainerManagedEntity)(iMessage = (ContainerManagedEntity)enterpriseBean), method)) {
            IMessage iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2496", 4, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage2);
        }
    }

    public final long[] getKnownMethodTypes() {
        return this.KNOWN_METHOD_TYPES;
    }

    public void validateCmpField(IValidationContext iValidationContext, ContainerManagedEntity containerManagedEntity, JavaClass javaClass, CMPAttribute cMPAttribute) throws ValidationCancelledException, InvalidInputException, ValidationException {
        Method method;
        JavaClass javaClass2;
        String string = cMPAttribute.getName();
        if (string == null || string.equals("")) {
            return;
        }
        if (!Character.isLowerCase(string.charAt(0))) {
            javaClass2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2480", 4, (EnterpriseBean)containerManagedEntity, javaClass, cMPAttribute.getField(), (IValidationRule)this);
            iValidationContext.addMessage((IMessage)javaClass2);
        }
        if (!ValidationRuleUtility.isUnknownPrimaryKey(cMPAttribute)) {
            IMessage iMessage;
            javaClass2 = containerManagedEntity.getEjbClass();
            method = ValidationRuleUtility.getMethodExtended(javaClass2, cMPAttribute.getGetterName(), new JavaHelpers[0], cMPAttribute.getType());
            if (method == null) {
                iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2050.acc", 1, (EnterpriseBean)containerManagedEntity, javaClass, new String[]{cMPAttribute.getGetterName()}, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            } else {
                this.validateCMPAccessorMethod(iValidationContext, (EnterpriseBean)containerManagedEntity, javaClass, method, cMPAttribute);
            }
            iMessage = new IMessage[]{cMPAttribute.getType()};
            Method method2 = ValidationRuleUtility.getMethodExtended(javaClass2, cMPAttribute.getSetterName(), (JavaHelpers[])iMessage);
            if (method2 == null) {
                String string2 = cMPAttribute.getSetterName() + "(" + ValidationRuleUtility.getParmsAsString((JavaHelpers[])iMessage) + ")";
                IMessage iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2050.acc", 1, (EnterpriseBean)containerManagedEntity, javaClass, new String[]{string2}, (IValidationRule)this);
                iValidationContext.addMessage(iMessage2);
            } else {
                this.validateCMPAccessorMethod(iValidationContext, (EnterpriseBean)containerManagedEntity, javaClass, method2, cMPAttribute);
            }
        }
        if ((javaClass2 = cMPAttribute.getField()) != null && javaClass.getFieldExtended(cMPAttribute.getName()) != null) {
            method = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2454", 2, (EnterpriseBean)containerManagedEntity, javaClass, (Field)javaClass2, new String[]{cMPAttribute.getName()}, (IValidationRule)this);
            iValidationContext.addMessage((IMessage)method);
        }
    }

    public void validateCmrField(IValidationContext iValidationContext, ContainerManagedEntity containerManagedEntity, JavaClass javaClass, CMRField cMRField) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage iMessage;
        Object object;
        IMessage iMessage2;
        JavaClass javaClass2;
        String string = cMRField.getName();
        if (string == null || string.equals("")) {
            return;
        }
        if (!Character.isLowerCase(string.charAt(0))) {
            javaClass2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2480", 4, (EnterpriseBean)containerManagedEntity, javaClass, cMRField.getField(), (IValidationRule)this);
            iValidationContext.addMessage((IMessage)javaClass2);
        }
        javaClass2 = containerManagedEntity.getEjbClass();
        JavaClass javaClass3 = ValidationRuleUtility.getCMRFieldType(iValidationContext, (EnterpriseBean)containerManagedEntity, javaClass, cMRField);
        if (javaClass3 == null) {
            return;
        }
        Method method = ValidationRuleUtility.getMethodExtended(javaClass2, cMRField.getGetterName(), new JavaHelpers[0], (JavaHelpers)javaClass3);
        if (method == null) {
            iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2050.acc", 1, (EnterpriseBean)containerManagedEntity, javaClass, new String[]{cMRField.getGetterName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage2);
        } else {
            this.validateCMRAccessorMethod(iValidationContext, (EnterpriseBean)containerManagedEntity, javaClass, method, cMRField);
        }
        iMessage2 = new IMessage[]{javaClass3};
        Method method2 = ValidationRuleUtility.getMethodExtended(javaClass2, cMRField.getSetterName(), (JavaHelpers[])iMessage2);
        if (method2 == null) {
            object = cMRField.getSetterName() + "(" + ValidationRuleUtility.getParmsAsString((JavaHelpers[])iMessage2) + ")";
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2050.acc", 1, (EnterpriseBean)containerManagedEntity, javaClass, new String[]{object}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        } else {
            this.validateCMRAccessorMethod(iValidationContext, (EnterpriseBean)containerManagedEntity, javaClass, method2, cMRField);
        }
        object = cMRField.getField();
        if (object != null && javaClass.getFieldExtended(cMRField.getName()) != null) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2454", 2, (EnterpriseBean)containerManagedEntity, javaClass, (Field)object, new String[]{cMRField.getName()}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    protected void validateCMRAccessorMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, CMRField cMRField) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage iMessage;
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2449", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!method.isAbstract()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2450", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    protected void validateCMPAccessorMethod(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, CMPAttribute cMPAttribute) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage iMessage;
        if (!ValidationRuleUtility.isPublic(method)) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2449", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
        if (!method.isAbstract()) {
            iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2450", 2, enterpriseBean, javaClass, method, (IValidationRule)this);
            iValidationContext.addMessage(iMessage);
        }
    }

    public void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
        long l = MethodUtility.getUtility().getMethodTypeId(enterpriseBean, javaClass, method, listArray, this);
        if ((l & IMethodAndFieldConstants.EJBCREATE) == IMethodAndFieldConstants.EJBCREATE) {
            this.validateEjbCreateMethod(iValidationContext, enterpriseBean, javaClass, method, listArray);
        } else if ((l & IMethodAndFieldConstants.EJBPOSTCREATE) == IMethodAndFieldConstants.EJBPOSTCREATE) {
            this.validateEjbPostCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if ((l & IMethodAndFieldConstants.EJBHOME) == IMethodAndFieldConstants.EJBHOME) {
            this.validateEjbHomeMethod(iValidationContext, enterpriseBean, javaClass, method, listArray);
        } else if ((l & IMethodAndFieldConstants.EJBREMOVE_NOPARM) == IMethodAndFieldConstants.EJBREMOVE_NOPARM) {
            this.validateEjbRemoveMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if ((l & IMethodAndFieldConstants.ACCESSOR) != IMethodAndFieldConstants.ACCESSOR && (l & IMethodAndFieldConstants.BUSINESS) == IMethodAndFieldConstants.BUSINESS) {
            this.validateBusinessMethod(iValidationContext, enterpriseBean, javaClass, method, listArray);
        }
    }

    public String getMatchingHomeMethodName(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
        long l = MethodUtility.getUtility().getMethodTypeId(enterpriseBean, javaClass, method, listArray, this);
        if ((l & IMethodAndFieldConstants.EJBCREATE) == IMethodAndFieldConstants.EJBCREATE) {
            return this.getMatchingEjbCreateMethodName(iValidationContext, method);
        }
        if ((l & IMethodAndFieldConstants.EJBPOSTCREATE) == IMethodAndFieldConstants.EJBPOSTCREATE) {
            return this.getMatchingEjbPostCreateMethodName(iValidationContext, method);
        }
        if ((l & IMethodAndFieldConstants.EJBHOME) == IMethodAndFieldConstants.EJBHOME) {
            return this.getMatchingEjbHomeMethodName(iValidationContext, method);
        }
        if ((l & IMethodAndFieldConstants.EJBREMOVE_NOPARM) == IMethodAndFieldConstants.EJBREMOVE_NOPARM) {
            return this.getNoMatchingMethodName(iValidationContext, method);
        }
        if ((l & IMethodAndFieldConstants.ACCESSOR) == IMethodAndFieldConstants.ACCESSOR) {
            return this.getNoMatchingMethodName(iValidationContext, method);
        }
        if ((l & IMethodAndFieldConstants.BUSINESS) == IMethodAndFieldConstants.BUSINESS) {
            return this.getMatchingBusinessMethodName(iValidationContext, method);
        }
        return this.getNoMatchingMethodName(iValidationContext, method);
    }

    static {
        MESSAGE_IDS.put("CHKJ2481", new String[]{"CHKJ2481.cb.i.ejb20", "CHKJ2481.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2482", new String[]{"CHKJ2482.cb.i.ejb20", "CHKJ2482.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2483", new String[]{"CHKJ2483.cb.i.ejb20", "CHKJ2483.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2484", new String[]{"CHKJ2484.cb.i.ejb20", "CHKJ2484.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2489", new String[]{"CHKJ2489.cb.i.ejb20", "CHKJ2489.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2205", new String[]{"CHKJ2205.cb.i.ejb20", "CHKJ2205.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2206", new String[]{"CHKJ2206.cb.i.ejb20", "CHKJ2206.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2014", new String[]{"CHKJ2014.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2015", new String[]{"CHKJ2015.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2017", new String[]{"CHKJ2017.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2022", new String[]{"CHKJ2022.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2040", new String[]{"CHKJ2040.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.acc", new String[]{"CHKJ2050.acc.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.constr", new String[]{"CHKJ2050.constr.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbCreate", new String[]{"CHKJ2050.ejbCreate.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbFindByPrimaryKey", new String[]{"CHKJ2050.ejbFindByPrimaryKey.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.setEntityContext", new String[]{"CHKJ2050.setEntityContext.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.unsetEntityContext", new String[]{"CHKJ2050.unsetEntityContext.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbActivate", new String[]{"CHKJ2050.ejbActivate.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbPassivate", new String[]{"CHKJ2050.ejbPassivate.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbRemove", new String[]{"CHKJ2050.ejbRemove.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbLoad", new String[]{"CHKJ2050.ejbLoad.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbStore", new String[]{"CHKJ2050.ejbStore.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbSelect", new String[]{"CHKJ2050.ejbSelect.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbFind", new String[]{"CHKJ2050.ejbFind.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbPostCreate", new String[]{"CHKJ2050.ejbPostCreate.cb.ejb20"});
        MESSAGE_IDS.put("CHKJ2103", new String[]{"CHKJ2103.ejb20"});
        MESSAGE_IDS.put("CHKJ2404", new String[]{"CHKJ2404.i.ejb20", "CHKJ2404.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2411", new String[]{"CHKJ2411.cb.i.ejb20", "CHKJ2411.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2416", new String[]{"CHKJ2416.i.ejb20", "CHKJ2416.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2421", new String[]{"CHKJ2421.cb.i.ejb20", "CHKJ2421.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2422", new String[]{"CHKJ2422.cb.i.ejb20", "CHKJ2422.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2423", new String[]{"CHKJ2423.cb.i.ejb20", "CHKJ2423.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2424", new String[]{"CHKJ2424.cb.i.ejb20", "CHKJ2424.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2426", new String[]{"CHKJ2426.cb.i.ejb20", "CHKJ2426.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2427", new String[]{"CHKJ2427.cb.i.ejb20", "CHKJ2427.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2428", new String[]{"CHKJ2428.cb.i.ejb20", "CHKJ2428.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2430", new String[]{"CHKJ2430.cb.i.ejb20", "CHKJ2430.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2431", new String[]{"CHKJ2431.cb.i.ejb20", "CHKJ2431.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2439", new String[]{"CHKJ2439.cb.i.ejb20", "CHKJ2439.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2441", new String[]{"CHKJ2441.cb.i.ejb20", "CHKJ2441.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2442", new String[]{"CHKJ2442.cb.i.ejb20", "CHKJ2442.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2443", new String[]{"CHKJ2443.cb.i.ejb20", "CHKJ2443.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2449", new String[]{"CHKJ2449.cb.i.ejb20", "CHKJ2449.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2450", new String[]{"CHKJ2450.cb.i.ejb20", "CHKJ2450.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2454", new String[]{"CHKJ2454.cb.i.ejb20", "CHKJ2454.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2456", new String[]{"CHKJ2456.i", "CHKJ2456.m"});
        MESSAGE_IDS.put("CHKJ2478", new String[]{"CHKJ2478.cb.i.ejb20", "CHKJ2478.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2480", new String[]{"CHKJ2480.cb.i.ejb20", "CHKJ2480.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2485", new String[]{"CHKJ2485.cb.i.ejb20", "CHKJ2485.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2486", new String[]{"CHKJ2486.cb.i.ejb20", "CHKJ2486.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2487", new String[]{"CHKJ2487.cb.i.ejb20", "CHKJ2487.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2488", new String[]{"CHKJ2488.cb.i.ejb20", "CHKJ2488.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2492", new String[]{"CHKJ2492.cb.i.ejb20", "CHKJ2492.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2493", new String[]{"CHKJ2493.cb.i.ejb20", "CHKJ2493.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2494", new String[]{"CHKJ2494.cb.i.ejb20", "CHKJ2494.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2496", new String[]{"CHKJ2496.cb.i.ejb20", "CHKJ2496.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2497", new String[]{"CHKJ2497.cb.i.ejb20", "CHKJ2497.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.ejbCreate", new String[]{"CHKJ2500.ejbCreate.cb.i.ejb20", "CHKJ2500.ejbCreate.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.ejbFind", new String[]{"CHKJ2500.ejbCreate.cb.i.ejb20", "CHKJ2500.ejbCreate.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.bus", new String[]{"CHKJ2500.ejbCreate.cb.i.ejb20", "CHKJ2500.ejbCreate.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.ejbHome", new String[]{"CHKJ2500.ejbHome.cb.i.ejb20", "CHKJ2500.ejbHome.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2502.finalize", new String[]{"CHKJ2502.finalize.cb.i.ejb20", "CHKJ2502.finalize.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2502.ejbFind", new String[]{"CHKJ2502.ejbFind.cb.i.ejb20", "CHKJ2502.ejbFind.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2503.bus", new String[]{"CHKJ2503.bus.cb.i.ejb20", "CHKJ2503.bus.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2503.ejbCreate", new String[]{"CHKJ2503.ejbCreate.cb.i.ejb20", "CHKJ2503.ejbCreate.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2503.ejbPostCreate", new String[]{"CHKJ2503.ejbPostCreate.cb.i.ejb20", "CHKJ2503.ejbPostCreate.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2503.ejbHome", new String[]{"CHKJ2503.ejbHome.cb.i.ejb20", "CHKJ2503.ejbHome.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2505.ejbPostCreate", new String[]{"CHKJ2505.ejbPostCreate.cb.i.ejb20", "CHKJ2505.ejbPostCreate.cb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2505.ejbRemove", new String[]{"CHKJ2505.ejbRemove.cb.i.ejb20", "CHKJ2505.ejbRemove.cb.m.ejb20"});
    }
}

