/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb20.rules.impl;

import com.ibm.etools.ejb.CMRField;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IMethodAndFieldConstants;
import com.ibm.etools.validation.ejb.ITypeConstants;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb20.rules.IComponentType;
import com.ibm.etools.validation.ejb.ejb20.rules.IRemoteType;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.AComponentVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.IMessagePrefixEjb20Constants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CMPRemoteComponentVRule
extends AComponentVRule
implements IRemoteType,
IComponentType,
IMessagePrefixEjb20Constants {
    private static final Object ID = IValidationRuleList.EJB20_CMP_REMOTE;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB20_CMP_BEANCLASS};
    private static final Map MESSAGE_IDS;
    private static final String MSSGID = ".crc";
    private static final String EXT = ".crc.ejb20";
    private static final String BEXT = ".crc.i.ejb20";
    private static final String MEXT = ".crc.m.ejb20";
    private final long[] SUPERTYPES = new long[]{ITypeConstants.JAVAX_EJB_EJBOBJECT};
    private final long[] SHOULD_NOT_BE_SUPERTYPES = null;
    private final long[] METHODS_WHICH_MUST_EXIST = null;
    private static final long[] METHODS_WHICH_MUST_NOT_EXIST;
    private final long[] KNOWN_METHOD_TYPES = new long[]{IMethodAndFieldConstants.CLINIT};

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final int getMessageRemoteExceptionSeverity() {
        return 1;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    public final long[] getBaseTypes() {
        return this.getSupertypes();
    }

    public final long[] getSupertypes() {
        return this.SUPERTYPES;
    }

    public final long[] getShouldNotBeSupertypes() {
        return this.SHOULD_NOT_BE_SUPERTYPES;
    }

    public final int isRemote() {
        return 1;
    }

    public final long[] getMethodsWhichMustExist() {
        return this.METHODS_WHICH_MUST_EXIST;
    }

    public final long[] getMethodsWhichMustNotExist() {
        return METHODS_WHICH_MUST_NOT_EXIST;
    }

    public final long[] getKnownMethodTypes() {
        return this.KNOWN_METHOD_TYPES;
    }

    public void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass) throws ValidationCancelledException, InvalidInputException, ValidationException {
        super.validate(iValidationContext, enterpriseBean, javaClass);
        ContainerManagedEntity containerManagedEntity = (ContainerManagedEntity)enterpriseBean;
        List list = containerManagedEntity.getCMRFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMessage iMessage;
            JavaClass javaClass2;
            CMRField cMRField = (CMRField)iterator.next();
            if (cMRField == null || cMRField.isDerived() || (javaClass2 = ValidationRuleUtility.getCMRFieldType(iValidationContext, (EnterpriseBean)containerManagedEntity, javaClass, cMRField)) == null) continue;
            Method method = ValidationRuleUtility.getMethodExtended(javaClass, cMRField.getGetterName(), new JavaHelpers[0], (JavaHelpers)javaClass2);
            if (method != null) {
                iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2473", 2, (EnterpriseBean)containerManagedEntity, javaClass, method, new String[]{cMRField.getGetterName()}, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
            iMessage = new IMessage[]{javaClass2};
            Method method2 = ValidationRuleUtility.getMethodExtended(javaClass, cMRField.getSetterName(), (JavaHelpers[])iMessage);
            if (method2 == null) continue;
            String string = cMRField.getSetterName() + "(" + ValidationRuleUtility.getParmsAsString((JavaHelpers[])iMessage) + ")";
            IMessage iMessage2 = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2473", 2, (EnterpriseBean)containerManagedEntity, javaClass, method2, new String[]{string}, (IValidationRule)this);
            iValidationContext.addMessage(iMessage2);
        }
    }

    static {
        METHODS_WHICH_MUST_NOT_EXIST = null;
        MESSAGE_IDS = new HashMap();
        MESSAGE_IDS.put("CHKJ2017", new String[]{"CHKJ2017.crc.ejb20"});
        MESSAGE_IDS.put("CHKJ2023", new String[]{"CHKJ2023.crc.i.ejb20", "CHKJ2023.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2404", new String[]{"CHKJ2404.i.ejb20", "CHKJ2404.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2105", new String[]{"CHKJ2105.ejb20"});
        MESSAGE_IDS.put("CHKJ2416", new String[]{"CHKJ2416.i.ejb20", "CHKJ2416.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2468", new String[]{"CHKJ2468.crc.i.ejb20", "CHKJ2468.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2469", new String[]{"CHKJ2469.crc.i.ejb20", "CHKJ2469.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2470", new String[]{"CHKJ2470.crc.i.ejb20", "CHKJ2470.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2471", new String[]{"CHKJ2471.crc.i.ejb20", "CHKJ2471.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2472", new String[]{"CHKJ2472.crc.i.ejb20", "CHKJ2472.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2473", new String[]{"CHKJ2473.crc.i.ejb20", "CHKJ2473.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2474", new String[]{"CHKJ2474.crc.i.ejb20", "CHKJ2474.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.bus", new String[]{"CHKJ2500.bus.crc.i.ejb20", "CHKJ2500.bus.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.create", new String[]{"CHKJ2500.create.crc.i.ejb20", "CHKJ2500.create.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.home", new String[]{"CHKJ2500.home.crc.i.ejb20", "CHKJ2500.home.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2503.bus", new String[]{"CHKJ2503.bus.crc.i.ejb20", "CHKJ2503.bus.crc.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }
}

