/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb20.rules.impl;

import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.ejb.MessageDriven;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.MessageLimitException;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.AValidationRule;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRule;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.LogEntry;
import com.ibm.etools.validation.ejb.MessageUtility;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.IMessagePrefixEjb20Constants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EJBExt20VRule
extends AValidationRule
implements IMessagePrefixEjb20Constants {
    private static final Map MESSAGE_IDS;
    private static final Object[] DEPENDS_ON;

    public Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public Object getId() {
        return IValidationRuleList.EJB20_EJBEXT;
    }

    public Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public Object getTarget(Object object, Object object2) {
        return null;
    }

    public boolean areBeanComponentsReflected(EnterpriseBean enterpriseBean) {
        try {
            ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)enterpriseBean.getEjbClass());
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (enterpriseBean instanceof MessageDriven) {
            return true;
        }
        try {
            if (enterpriseBean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_HomeInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)enterpriseBean.getHomeInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (enterpriseBean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)enterpriseBean.getRemoteInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (enterpriseBean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalHomeInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)enterpriseBean.getLocalHomeInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (enterpriseBean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)enterpriseBean.getLocalInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (enterpriseBean.isEntity()) {
            JavaClass javaClass = ((Entity)enterpriseBean).getPrimaryKey();
            try {
                if (((Entity)enterpriseBean).eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEntity_PrimaryKey())) {
                    ValidationRuleUtility.isValidTypeHierarchy(enterpriseBean, (JavaHelpers)javaClass);
                }
            }
            catch (InvalidInputException invalidInputException) {
                return false;
            }
        }
        return true;
    }

    public void validate(IValidationContext iValidationContext, Object object, Object object2) throws ValidationCancelledException, ValidationException {
        LogEntry logEntry;
        MsgLogger msgLogger = iValidationContext.getMsgLogger();
        if (msgLogger.isLoggingLevel(7)) {
            logEntry = iValidationContext.getLogEntry();
            logEntry.setSourceID("EJB20Validator - validate");
            logEntry.setText(this.getClass().getName() + "::validate(" + object + ", " + object2);
            msgLogger.write(7, (Object)logEntry);
        }
        logEntry = null;
        if (object == null) {
            logEntry = (EJBJar)object2;
            this.validate(iValidationContext, (EJBJar)logEntry);
        } else {
            logEntry = (EJBJar)iValidationContext.loadModel("EJB_MODEL");
            EnterpriseBean enterpriseBean = (EnterpriseBean)object;
            this.validate(iValidationContext, (EJBJar)logEntry, enterpriseBean);
        }
    }

    public void validate(IValidationContext iValidationContext, EJBJar eJBJar) throws ValidationCancelledException, ValidationException {
        EList eList = eJBJar.getEnterpriseBeans();
        Iterator iterator = eList.iterator();
        EnterpriseBean enterpriseBean = null;
        while (iterator.hasNext()) {
            enterpriseBean = (EnterpriseBean)iterator.next();
            if (enterpriseBean == null) continue;
            this.validate(iValidationContext, eJBJar, enterpriseBean);
        }
    }

    public void validate(IValidationContext iValidationContext, EJBJar eJBJar, EnterpriseBean enterpriseBean) throws ValidationCancelledException, ValidationException {
        block5: {
            try {
                if (!this.areBeanComponentsReflected(enterpriseBean)) {
                    return;
                }
                this.validateAppendixB(iValidationContext, eJBJar, enterpriseBean);
            }
            catch (MessageLimitException messageLimitException) {
                throw messageLimitException;
            }
            catch (ValidationCancelledException validationCancelledException) {
                throw validationCancelledException;
            }
            catch (Throwable throwable) {
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2852", 2, enterpriseBean, new String[]{"ibm-ejb-jar-ext.xmi", enterpriseBean.getName()}, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
                MsgLogger msgLogger = iValidationContext.getMsgLogger();
                if (!msgLogger.isLoggingLevel(4)) break block5;
                msgLogger.write(4, (Object)throwable);
            }
        }
    }

    protected void validateAppendixB(IValidationContext iValidationContext, EJBJar eJBJar, EnterpriseBean enterpriseBean) {
        if (enterpriseBean == null) {
            return;
        }
        if (!enterpriseBean.isEntity()) {
            return;
        }
        JavaClass javaClass = ((Entity)enterpriseBean).getPrimaryKey();
        EnterpriseBean enterpriseBean2 = EjbExtensionsHelper.getSupertype((EnterpriseBean)enterpriseBean);
        JavaClass javaClass2 = null;
        if (enterpriseBean2 != null && enterpriseBean2 instanceof Entity) {
            javaClass2 = ((Entity)enterpriseBean2).getPrimaryKey();
            if (javaClass == null || javaClass2 == null || !javaClass.equals(javaClass2)) {
                String[] stringArray = new String[]{enterpriseBean.getName(), javaClass2.getQualifiedName()};
                IMessage iMessage = MessageUtility.getUtility().getMessage(iValidationContext, (Object)"CHKJ2106", 1, enterpriseBean, stringArray, (IValidationRule)this);
                iValidationContext.addMessage(iMessage);
            }
        }
    }

    static {
        DEPENDS_ON = null;
        MESSAGE_IDS = new HashMap();
        MESSAGE_IDS.put("CHKJ2106", new String[]{"CHKJ2106.ejb20"});
        MESSAGE_IDS.put("CHKJ2849", new String[]{"CHKJ2849.ejb20"});
        MESSAGE_IDS.put("CHKJ2852", new String[]{"CHKJ2852"});
    }
}

