/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb20.rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.ejb.IFieldType;
import com.ibm.etools.validation.ejb.IMethodAndFieldConstants;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb20.rules.IEJBType;
import com.ibm.etools.validation.ejb.ejb20.rules.IMethodType;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.ABeanClassVRule;
import java.util.Arrays;
import java.util.List;

public final class MethodUtility {
    private static MethodUtility _inst = null;
    private long[] _methodTypeIndex;
    private IMethodType[] _methodTypes;
    private long[] _fieldTypeIndex;
    private IFieldType[] _fieldTypes;

    private MethodUtility() {
        this.buildTypeList();
    }

    public static MethodUtility getUtility() {
        if (_inst == null) {
            _inst = new MethodUtility();
        }
        return _inst;
    }

    protected IMethodType[] getMethodTypes() {
        return this._methodTypes;
    }

    public IFieldType getFieldType(long l) {
        int n = Arrays.binarySearch(this._fieldTypeIndex, l);
        if (n > this._fieldTypes.length) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (this._fieldTypes[n].getId() != l) {
            return null;
        }
        return this._fieldTypes[n];
    }

    public IMethodType getMethodType(long l) {
        int n = Arrays.binarySearch(this._methodTypeIndex, l);
        if (n > this._methodTypes.length) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (this._methodTypes[n].getId() != l) {
            return null;
        }
        return this._methodTypes[n];
    }

    public long getMethodTypeId(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray, IEJBType iEJBType) {
        IMethodType iMethodType = this.getMethodType(enterpriseBean, javaClass, method, listArray, iEJBType);
        if (iMethodType == null) {
            return iEJBType.getDefaultMethodType();
        }
        return iMethodType.getId();
    }

    public long getFieldTypeId(EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, IEJBType iEJBType) {
        IFieldType iFieldType = this.getFieldType(enterpriseBean, javaClass, field, iEJBType);
        if (iFieldType == null) {
            return IMethodAndFieldConstants.EXCLUDED_FIELD;
        }
        return iFieldType.getId();
    }

    public IFieldType getFieldType(EnterpriseBean enterpriseBean, JavaClass javaClass, Field field, IEJBType iEJBType) {
        IFieldType[] iFieldTypeArray = this._fieldTypes;
        if (iFieldTypeArray == null) {
            return null;
        }
        int n = 0;
        while (n < iFieldTypeArray.length) {
            IFieldType iFieldType = iFieldTypeArray[n];
            if (iFieldType != null && iFieldType.isFieldType(enterpriseBean, javaClass, field)) {
                return iFieldType;
            }
            ++n;
        }
        return null;
    }

    public IMethodType getMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray, IEJBType iEJBType) {
        long[] lArray = iEJBType.getKnownMethodTypes();
        if (lArray == null) {
            return null;
        }
        int n = 0;
        while (n < lArray.length) {
            IMethodType iMethodType = this.getMethodType(lArray[n]);
            if (iMethodType != null && !iMethodType.isDefaultType() && iMethodType.isMethodType(enterpriseBean, javaClass, method, listArray)) {
                return iMethodType;
            }
            ++n;
        }
        return this.getMethodType(iEJBType.getDefaultMethodType());
    }

    private void buildTypeList() {
        int n = 29;
        this._methodTypeIndex = new long[n];
        this._methodTypes = new IMethodType[n];
        int n2 = 0;
        int n3 = 1;
        this._fieldTypeIndex = new long[n3];
        this._fieldTypes = new IFieldType[n3];
        int n4 = 0;
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.ACCESSOR;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.ACCESSOR;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.acc";
            }

            public String getMessageId_messageExists() {
                return "ACCESSOR::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "ACCESSOR::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "ACCESSOR::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "ACCESSOR::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.BUSINESS;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.BUSINESS;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                if (method == null) {
                    return "";
                }
                return method.getName();
            }

            public String getMessageId_messageMissing() {
                return "BUSINESS::getMessageId_messageMissing";
            }

            public String getMessageId_messageExists() {
                return "BUSINESS::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.bus";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.business";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.bus";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (ValidationRuleUtility.getMethod(method, method.getName(), ABeanClassVRule.getRemoteComponentMethodsExtended(listArray)) != null) {
                    return true;
                }
                return ValidationRuleUtility.getMethod(method, method.getName(), ABeanClassVRule.getRemoteComponentMethodsExtended(listArray)) != null;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.CLINIT;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CLINIT;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "clinit";
            }

            public String getMessageId_messageMissing() {
                return "CLINIT::getMessageId_messageMissing";
            }

            public String getMessageId_messageExists() {
                return "CLINIT::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CLINIT::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "CLINIT::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CLINIT::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("<clinit>");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.CONSTRUCTOR;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CONSTRUCTOR;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return javaClass.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.constr";
            }

            public String getMessageId_messageExists() {
                return "CONSTRUCTOR::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CONSTRUCTOR::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "CONSTRUCTOR::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CONSTRUCTOR::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.isConstructor();
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return javaClass.getName() + "()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.constr";
            }

            public String getMessageId_messageExists() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.isConstructor() && ValidationRuleUtility.isPublic(method) && method.getParameters().size() == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.CREATE;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CREATE;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "create";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.create";
            }

            public String getMessageId_messageExists() {
                return "CREATE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.create";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.create";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.create";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("create");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.CREATE_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CREATE_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "create()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.create";
            }

            public String getMessageId_messageExists() {
                return "CREATE_NOPARM::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.create";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.create";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.create";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("create") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBACTIVATE_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBACTIVATE_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "ejbActivate()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbActivate";
            }

            public String getMessageId_messageExists() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbActivate") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBCREATE;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBCREATE;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "ejbCreate";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbCreate";
            }

            public String getMessageId_messageExists() {
                return "EJBCREATE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbCreate";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBCREATE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbCreate";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbCreate");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBCREATE_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBCREATE_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "ejbCreate()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbCreate";
            }

            public String getMessageId_messageExists() {
                return "EJBCREATE_NOPARM::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbCreate";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBCREATE_NOPARM::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBCREATE_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbCreate") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBFIND;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBFIND;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                if (method == null) {
                    return "ejbFind";
                }
                return method.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbFind";
            }

            public String getMessageId_messageExists() {
                return "CHKJ2502.ejbFind";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbFind";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBFIND::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbFind";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbFind");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBFINDBYPRIMARYKEY;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBFINDBYPRIMARYKEY;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                StringBuffer stringBuffer = new StringBuffer("ejbFindByPrimaryKey(");
                String string = "";
                if (enterpriseBean instanceof Entity) {
                    JavaClass javaClass2 = ((Entity)enterpriseBean).getPrimaryKey();
                    string = javaClass2 == null ? "<primary-key>" : javaClass2.getQualifiedName();
                }
                stringBuffer.append(string);
                stringBuffer.append(")");
                return stringBuffer.toString();
            }

            public boolean isDefaultType() {
                return false;
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbFindByPrimaryKey";
            }

            public String getMessageId_messageExists() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbFind";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbFind") && method.getName().equals("ejbFindByPrimaryKey");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBHOME;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBHOME;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                if (method == null) {
                    return "ejbHome";
                }
                return method.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbHome";
            }

            public String getMessageId_messageExists() {
                return "EJBHOME::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbHome";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBHOME::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbHome";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbHome");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBLOAD_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBLOAD_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "ejbLoad()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbLoad";
            }

            public String getMessageId_messageExists() {
                return "EJBLOAD::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBLOAD::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBLOAD::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBLOAD::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbLoad") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBPASSIVATE_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBPASSIVATE_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "ejbPassivate()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbPassivate";
            }

            public String getMessageId_messageExists() {
                return "EJBPASSIVATE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBPASSIVATE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBPASSIVATE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBPASSIVATE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbPassivate") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBPOSTCREATE;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBPOSTCREATE;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "ejbPostCreate";
            }

            public String getMessageId_messageMissing() {
                return "EJBPOSTCREATE::getMessageId_messageMissing";
            }

            public String getMessageId_messageExists() {
                return "EJBPOSTCREATE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbPostCreate";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBPOSTCREATE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBPOSTCREATE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbPostCreate");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBREMOVE_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBREMOVE_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "ejbRemove()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbRemove";
            }

            public String getMessageId_messageExists() {
                return "EJBREMOVE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBREMOVE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBREMOVE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBREMOVE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbRemove") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBSELECT;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBSELECT;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                if (method == null) {
                    return "ejbSelect";
                }
                return method.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbSelect";
            }

            public String getMessageId_messageExists() {
                return "EJBSELECT::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBSELECT::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBSELECT::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBSELECT::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbSelect");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EJBSTORE_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBSTORE_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "ejbStore()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbStore";
            }

            public String getMessageId_messageExists() {
                return "EJBSTORE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBSTORE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBSTORE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBSTORE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbStore") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.EQUALS;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EQUALS;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "equals(Object)";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.equals";
            }

            public String getMessageId_messageExists() {
                return "EQUALS::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EQUALS::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EQUALS::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EQUALS::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                JavaParameter[] javaParameterArray;
                if (method == null) {
                    return false;
                }
                if (method.getName().startsWith("equals") && (javaParameterArray = method.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers javaHelpers = ValidationRuleUtility.getType("java.lang.Object", enterpriseBean);
                        JavaHelpers javaHelpers2 = javaParameterArray[0].getJavaType();
                        if (javaHelpers.equals(javaHelpers2)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException invalidInputException) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.FIND;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.FIND;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                if (method == null) {
                    return "find";
                }
                return method.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.find";
            }

            public String getMessageId_messageExists() {
                return "FIND::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.find";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.find";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.find";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("find");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.FINDBYPRIMARYKEY;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.FINDBYPRIMARYKEY;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "findByPrimaryKey";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.findByPrimaryKey";
            }

            public String getMessageId_messageExists() {
                return "CHKJ2500.find";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.find";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.find";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.find";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("find") && method.getName().startsWith("findByPrimaryKey");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.FINALIZE_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.FINALIZE_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "finalize()";
            }

            public String getMessageId_messageMissing() {
                return "FINALIZE::getMessageId_messageExists";
            }

            public String getMessageId_messageExists() {
                return "CHKJ2502.finalize";
            }

            public String getMessageId_messageRemoteException() {
                return "FINALIZE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "FINALIZE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "FINALIZE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("finalize") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.HASHCODE_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.HASHCODE_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "hashCode()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.hashCode";
            }

            public String getMessageId_messageExists() {
                return "HASHCODE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "HASHCODE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "HASHCODE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "HASHCODE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("hashCode") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.HOME;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.HOME;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "home";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.home";
            }

            public String getMessageId_messageExists() {
                return "HOME::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.home";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.home";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.home";
            }

            public boolean isDefaultType() {
                return true;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                return method != null;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.ONMESSAGE;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.ONMESSAGE;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "onMessage";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.onMessage";
            }

            public String getMessageId_messageExists() {
                return "ONMESSAGE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "ONMESSAGE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "ONMESSAGE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "ONMESSAGE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                JavaParameter[] javaParameterArray;
                if (method == null) {
                    return false;
                }
                if (method.getName().equals("onMessage") && (javaParameterArray = method.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers javaHelpers = ValidationRuleUtility.getType("javax.jms.Message", enterpriseBean);
                        JavaHelpers javaHelpers2 = javaParameterArray[0].getJavaType();
                        if (javaHelpers.equals(javaHelpers2)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException invalidInputException) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.SETENTITYCONTEXT;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.SETENTITYCONTEXT;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "setEntityContext";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.setEntityContext";
            }

            public String getMessageId_messageExists() {
                return "SETENTITYCONTEXT::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "SETENTITYCONTEXT::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "SETENTITYCONTEXT::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "SETENTITYCONTEXT::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                JavaParameter[] javaParameterArray;
                if (method == null) {
                    return false;
                }
                if (method.getName().equals("setEntityContext") && (javaParameterArray = method.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers javaHelpers = ValidationRuleUtility.getType("javax.ejb.EntityContext", enterpriseBean);
                        JavaHelpers javaHelpers2 = javaParameterArray[0].getJavaType();
                        if (javaHelpers.equals(javaHelpers2)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException invalidInputException) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[n2] = IMethodAndFieldConstants.UNSETENTITYCONTEXT_NOPARM;
        this._methodTypes[n2++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.UNSETENTITYCONTEXT_NOPARM;
            }

            public String getMethodName(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method) {
                return "unsetEntityContext()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.unsetEntityContext";
            }

            public String getMessageId_messageExists() {
                return "UNSETENTITYCONTEXT::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "UNSETENTITYCONTEXT::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "UNSETENTITYCONTEXT::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "UNSETENTITYCONTEXT::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("unsetEntityContext") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._fieldTypeIndex[n4] = IMethodAndFieldConstants.SERIALVERSIONUID;
        this._fieldTypes[n4++] = new IFieldType(){

            public long getId() {
                return IMethodAndFieldConstants.SERIALVERSIONUID;
            }

            public boolean isFieldType(EnterpriseBean enterpriseBean, JavaClass javaClass, Field field) {
                if (field == null) {
                    return false;
                }
                return field.getName().equals("serialVersionUID");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
    }
}

