/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.ejb.ejb20.rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.ejb.IMethodAndFieldConstants;
import com.ibm.etools.validation.ejb.ITypeConstants;
import com.ibm.etools.validation.ejb.IValidationContext;
import com.ibm.etools.validation.ejb.IValidationRuleList;
import com.ibm.etools.validation.ejb.InvalidInputException;
import com.ibm.etools.validation.ejb.ValidationCancelledException;
import com.ibm.etools.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.ASessionBeanClassVRule;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.IMessagePrefixEjb20Constants;
import com.ibm.etools.validation.ejb.ejb20.rules.impl.MethodUtility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StatefulSessionBeanClassVRule
extends ASessionBeanClassVRule
implements IMessagePrefixEjb20Constants {
    private static final Object ID = IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB20_STATEFUL_SESSION_HOME, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL, IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE};
    private static final Map MESSAGE_IDS = new HashMap();
    private static final String MSSGID = ".sb";
    private static final String EXT = ".sb.ejb20";
    private static final String BEXT = ".sb.i.ejb20";
    private static final String MEXT = ".sb.m.ejb20";
    private static final String SMSSGID = ".sfb";
    private final long[] SUPERTYPES = new long[]{ITypeConstants.JAVAX_EJB_SESSIONBEAN};
    private final long[] SHOULD_NOT_BE_SUPERTYPES = new long[]{ITypeConstants.LOCAL_COMPONENT_INTERFACE, ITypeConstants.REMOTE_COMPONENT_INTERFACE};
    private final boolean SHOULD_BE_ABSTRACT = false;
    private final boolean SHOULD_BE_FINAL = false;
    private final boolean SHOULD_BE_PUBLIC = true;
    private final boolean SHOULD_VALIDATE_TRANSIENT_FIELD = true;
    private final long[] METHODS_WHICH_MUST_EXIST = new long[]{IMethodAndFieldConstants.EJBCREATE, IMethodAndFieldConstants.CONSTRUCTOR_NOPARM, IMethodAndFieldConstants.EJBREMOVE_NOPARM, IMethodAndFieldConstants.EJBPASSIVATE_NOPARM};
    private final long[] METHODS_WHICH_MUST_NOT_EXIST = new long[]{IMethodAndFieldConstants.FINALIZE_NOPARM};
    private final long[] KNOWN_METHOD_TYPES = new long[]{IMethodAndFieldConstants.CLINIT, IMethodAndFieldConstants.CONSTRUCTOR_NOPARM, IMethodAndFieldConstants.CONSTRUCTOR, IMethodAndFieldConstants.EJBCREATE, IMethodAndFieldConstants.EJBCREATE_NOPARM, IMethodAndFieldConstants.EJBREMOVE_NOPARM, IMethodAndFieldConstants.EJBACTIVATE_NOPARM, IMethodAndFieldConstants.EJBPASSIVATE_NOPARM, IMethodAndFieldConstants.FINALIZE_NOPARM, IMethodAndFieldConstants.BUSINESS};

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final int getMessageRemoteExceptionSeverity() {
        return 2;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    public final long[] getSupertypes() {
        return this.SUPERTYPES;
    }

    public final boolean shouldValidateTransientField() {
        return true;
    }

    public final long[] getShouldNotBeSupertypes() {
        return this.SHOULD_NOT_BE_SUPERTYPES;
    }

    public final boolean shouldBeAbstract(JavaClass javaClass) {
        return false;
    }

    public final boolean shouldBeFinal(JavaClass javaClass) {
        return false;
    }

    public final boolean shouldBePublic(JavaClass javaClass) {
        return true;
    }

    public final int isRemote() {
        return 4;
    }

    public final long[] getMethodsWhichMustExist() {
        return this.METHODS_WHICH_MUST_EXIST;
    }

    public final long[] getMethodsWhichMustNotExist() {
        return this.METHODS_WHICH_MUST_NOT_EXIST;
    }

    public final JavaHelpers getEjbCreateReturnType(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.getType("void", enterpriseBean);
    }

    public final String getEjbCreateReturnTypeName(EnterpriseBean enterpriseBean, Method method) throws InvalidInputException {
        return "void";
    }

    public final long[] getKnownMethodTypes() {
        return this.KNOWN_METHOD_TYPES;
    }

    public void validate(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) throws ValidationCancelledException, InvalidInputException, ValidationException {
        long l = MethodUtility.getUtility().getMethodTypeId(enterpriseBean, javaClass, method, listArray, this);
        if ((l & IMethodAndFieldConstants.EJBCREATE) == IMethodAndFieldConstants.EJBCREATE) {
            this.validateEjbCreateMethod(iValidationContext, enterpriseBean, javaClass, method, listArray);
        } else if ((l & IMethodAndFieldConstants.EJBPOSTCREATE) == IMethodAndFieldConstants.EJBPOSTCREATE) {
            this.validateEjbPostCreateMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if ((l & IMethodAndFieldConstants.EJBREMOVE_NOPARM) == IMethodAndFieldConstants.EJBREMOVE_NOPARM) {
            this.validateEjbRemoveMethod(iValidationContext, enterpriseBean, javaClass, method);
        } else if ((l & IMethodAndFieldConstants.BUSINESS) == IMethodAndFieldConstants.BUSINESS) {
            this.validateBusinessMethod(iValidationContext, enterpriseBean, javaClass, method, listArray);
        }
    }

    public String getMatchingHomeMethodName(IValidationContext iValidationContext, EnterpriseBean enterpriseBean, JavaClass javaClass, Method method, List[] listArray) {
        long l = MethodUtility.getUtility().getMethodTypeId(enterpriseBean, javaClass, method, listArray, this);
        if ((l & IMethodAndFieldConstants.EJBCREATE) == IMethodAndFieldConstants.EJBCREATE) {
            return this.getMatchingEjbCreateMethodName(iValidationContext, method);
        }
        if ((l & IMethodAndFieldConstants.EJBPOSTCREATE) == IMethodAndFieldConstants.EJBPOSTCREATE) {
            return this.getMatchingEjbPostCreateMethodName(iValidationContext, method);
        }
        if ((l & IMethodAndFieldConstants.EJBREMOVE_NOPARM) == IMethodAndFieldConstants.EJBREMOVE_NOPARM) {
            return this.getNoMatchingMethodName(iValidationContext, method);
        }
        if ((l & IMethodAndFieldConstants.BUSINESS) == IMethodAndFieldConstants.BUSINESS) {
            return this.getMatchingBusinessMethodName(iValidationContext, method);
        }
        return this.getNoMatchingMethodName(iValidationContext, method);
    }

    static {
        MESSAGE_IDS.put("CHKJ2014", new String[]{"CHKJ2014.sb.ejb20"});
        MESSAGE_IDS.put("CHKJ2015", new String[]{"CHKJ2015.sb.ejb20"});
        MESSAGE_IDS.put("CHKJ2017", new String[]{"CHKJ2017.sb.ejb20"});
        MESSAGE_IDS.put("CHKJ2022", new String[]{"CHKJ2022.sb.ejb20"});
        MESSAGE_IDS.put("CHKJ2040", new String[]{"CHKJ2040.sb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.constr", new String[]{"CHKJ2050.constr.sb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbCreate", new String[]{"CHKJ2050.ejbCreate.sfb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbRemove", new String[]{"CHKJ2050.ejbRemove.sb.ejb20"});
        MESSAGE_IDS.put("CHKJ2050.ejbPassivate", new String[]{"CHKJ2050.ejbPassivate.sb.ejb20"});
        MESSAGE_IDS.put("CHKJ2103", new String[]{"CHKJ2103.ejb20"});
        MESSAGE_IDS.put("CHKJ2404", new String[]{"CHKJ2404.i.ejb20", "CHKJ2404.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2411", new String[]{"CHKJ2411.sb.i.ejb20", "CHKJ2411.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2416", new String[]{"CHKJ2416.i.ejb20", "CHKJ2416.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2421", new String[]{"CHKJ2421.sb.i.ejb20", "CHKJ2421.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2422", new String[]{"CHKJ2422.sb.i.ejb20", "CHKJ2422.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2423", new String[]{"CHKJ2423.sb.i.ejb20", "CHKJ2423.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2424", new String[]{"CHKJ2424.sb.i.ejb20", "CHKJ2424.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2426", new String[]{"CHKJ2426.sb.i.ejb20", "CHKJ2426.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2427", new String[]{"CHKJ2427.sb.i.ejb20", "CHKJ2427.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2428", new String[]{"CHKJ2428.sb.i.ejb20", "CHKJ2428.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2431", new String[]{"CHKJ2431.sb.i.ejb20", "CHKJ2431.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2439", new String[]{"CHKJ2439.sb.i.ejb20", "CHKJ2439.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2441", new String[]{"CHKJ2441.sb.i.ejb20", "CHKJ2441.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2442", new String[]{"CHKJ2442.sb.i.ejb20", "CHKJ2442.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2443", new String[]{"CHKJ2443.sb.i.ejb20", "CHKJ2443.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2452", new String[]{"CHKJ2452.sb.i.ejb20", "CHKJ2452.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2453", new String[]{"CHKJ2453.sb.i.ejb20", "CHKJ2453.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2456", new String[]{"CHKJ2456.i", "CHKJ2456.m"});
        MESSAGE_IDS.put("CHKJ2493", new String[]{"CHKJ2493.sb.i.ejb20", "CHKJ2493.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2494", new String[]{"CHKJ2494.sb.i.ejb20", "CHKJ2494.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.ejbCreate", new String[]{"CHKJ2500.ejbCreate.sb.i.ejb20", "CHKJ2500.ejbCreate.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2500.bus", new String[]{"CHKJ2500.bus.sb.i.ejb20", "CHKJ2500.bus.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2502.finalize", new String[]{"CHKJ2502.finalize.sb.i.ejb20", "CHKJ2502.finalize.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2503.bus", new String[]{"CHKJ2503.bus.sb.i.ejb20", "CHKJ2503.bus.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2503.ejbCreate", new String[]{"CHKJ2503.ejbCreate.sb.i.ejb20", "CHKJ2503.ejbCreate.sb.m.ejb20"});
        MESSAGE_IDS.put("CHKJ2505.ejbRemove", new String[]{"CHKJ2505.ejbRemove.sb.i.ejb20", "CHKJ2505.ejbRemove.sb.m.ejb20"});
    }
}

