/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.j2ee;

import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.etools.j2ee.common.impl.ResourceRefImpl;
import com.ibm.etools.j2ee.common.impl.SecurityRoleImpl;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.IValidator;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.j2ee.J2EEMessageConstants;
import com.ibm.etools.wft.nls.J2EEResourceHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;

public abstract class J2EEValidator
implements IValidator,
J2EEMessageConstants {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected IReporter _reporter;
    protected IFileDelta[] _changedFiles;
    protected IHelper _helper;

    public J2EEValidator() {
        this.initialize();
    }

    public void addError(String string) {
        this.addError(this.getBaseName(), string, null);
    }

    public void addError(String string, String[] stringArray) {
        this.addError(this.getBaseName(), string, stringArray);
    }

    public void addError(String string, String string2) {
        this.addError(string, string2, null);
    }

    public void addError(String string, String string2, String[] stringArray) {
        this.addError(string, string2, stringArray, null);
    }

    public void addError(String string, String string2, String[] stringArray, Object object) {
        this._reporter.addMessage((IValidator)this, (IMessage)new Message(string, 1, string2, stringArray, object));
    }

    public void addError(String string, String string2, String[] stringArray, Object object, String string3) {
        Message message = new Message(string, 1, string2, stringArray, object);
        message.setGroupName(string3);
        this._reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void addError(String string, String string2, String[] stringArray, Object object, String string3, int n) {
        Message message = new Message(string, 1, string2, stringArray, object);
        message.setLineNo(n);
        message.setGroupName(string3);
        this._reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void addInfo(String string) {
        this.addInfo(this.getBaseName(), string, null);
    }

    public void addInfo(String string, String[] stringArray) {
        this.addInfo(this.getBaseName(), string, stringArray);
    }

    public void addInfo(String string, String string2) {
        this.addInfo(string, string2, null);
    }

    public void addInfo(String string, String string2, String[] stringArray) {
        this.addInfo(string, string2, stringArray, null);
    }

    public void addInfo(String string, String string2, String[] stringArray, Object object) {
        this._reporter.addMessage((IValidator)this, (IMessage)new Message(string, 4, string2, stringArray, object));
    }

    public void addWarning(String string) {
        this.addWarning(this.getBaseName(), string, null);
    }

    public void addWarning(String string, String[] stringArray) {
        this.addWarning(this.getBaseName(), string, stringArray);
    }

    public void addWarning(String string, String string2) {
        this.addWarning(string, string2, null);
    }

    public void addWarning(String string, String string2, String[] stringArray) {
        this.addWarning(string, string2, stringArray, null);
    }

    public void addWarning(String string, String string2, String[] stringArray, Object object) {
        this._reporter.addMessage((IValidator)this, (IMessage)new Message(string, 2, string2, stringArray, object));
    }

    public void addWarning(String string, String string2, String[] stringArray, Object object, String string3) {
        Message message = new Message(string, 2, string2, stringArray, object);
        message.setGroupName(string3);
        this._reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void cleanup() {
    }

    public void cleanup(IReporter iReporter) {
    }

    public String[] get1Param(String string) {
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    public String[] get2Param(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        return stringArray;
    }

    public String[] get3Param(String string, String string2, String string3) {
        String[] stringArray = new String[]{string, string2};
        stringArray[2] = string3;
        return stringArray;
    }

    public abstract String getBaseName();

    public String getMessage(String string, String string2, String[] stringArray, Locale locale) {
        return J2EEResourceHandler.getExternalizedMessage((String)string, (String)string2, this.getClass(), (Object[])stringArray, (Locale)locale);
    }

    public String getMessage(String string, String string2, Locale locale) {
        return J2EEResourceHandler.getExternalizedMessage((String)string, (String)string2, this.getClass(), (Locale)locale);
    }

    public String getName() {
        return this.getName(Locale.getDefault());
    }

    public String getName(Locale locale) {
        return this.getMessage(this.getBaseName(), "validator.name", locale);
    }

    public String[] getParam1(String string) {
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    protected void initialize() {
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        this._helper = iHelper;
        this._reporter = iReporter;
        this._changedFiles = iFileDeltaArray;
        if (iHelper == null || iReporter == null) {
            return;
        }
    }

    public void validateEJBRefManadatoryElements(EjbRef ejbRef, String string) {
        String string2;
        String[] stringArray = new String[]{ejbRef.getName(), string};
        if (ejbRef.getName() == null || ejbRef.getName().trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFNAME", stringArray, ejbRef);
        }
        if (ejbRef.isSetType()) {
            if (ejbRef.getType() == null) {
                this.addWarning("erefvalidation", "ERROR_EAR_INVALID_EREFTYPE", stringArray);
            }
        } else {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFTYPE", stringArray);
        }
        if ((string2 = ejbRef.getHome()) == null || string2.trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFHOME", stringArray, ejbRef);
        }
        if (ejbRef.getRemote() == null || ejbRef.getRemote().trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFREMOTE", stringArray, ejbRef);
        }
    }

    public void validateResourceRefs(List list) {
        int n = list.size();
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string = ((ResourceRefImpl)list.get(n2)).getName();
            String[] stringArray = new String[]{string};
            if (!hashSet.add(string)) {
                this.addError("erefvalidation", "ERROR_EAR_DUPLICATE_RESREF", stringArray, list.get(n2));
            }
            ++n2;
        }
    }

    public void validateWEBRolesWithEARRoles(EList eList, EList eList2) {
        int n = eList2.size();
        int n2 = 0;
        while (n2 < n) {
            SecurityRoleImpl securityRoleImpl = (SecurityRoleImpl)eList2.get(n2);
            String[] stringArray = new String[]{securityRoleImpl.getRoleName()};
            if (!eList.contains((Object)securityRoleImpl)) {
                this.addError("warvalidation", "ERROR_EAR_MISSING_EJB_ROLE", stringArray, securityRoleImpl);
            }
            ++n2;
        }
    }
}

