/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation.war;

import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.etools.j2ee.common.EnvEntry;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.common.SecurityRoleRef;
import com.ibm.etools.j2ee.common.impl.EJBLocalRefImpl;
import com.ibm.etools.j2ee.common.impl.EjbRefImpl;
import com.ibm.etools.j2ee.common.impl.ResourceRefImpl;
import com.ibm.etools.java.impl.JavaClassImpl;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.IValidator;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.validation.j2ee.J2EEValidator;
import com.ibm.etools.validation.war.ResourceHandler;
import com.ibm.etools.validation.war.WARMessageConstants;
import com.ibm.etools.webapplication.AuthConstraint;
import com.ibm.etools.webapplication.ContextParam;
import com.ibm.etools.webapplication.ErrorCodeErrorPage;
import com.ibm.etools.webapplication.ErrorPage;
import com.ibm.etools.webapplication.ExceptionTypeErrorPage;
import com.ibm.etools.webapplication.Filter;
import com.ibm.etools.webapplication.FilterMapping;
import com.ibm.etools.webapplication.HTTPMethodType;
import com.ibm.etools.webapplication.InitParam;
import com.ibm.etools.webapplication.JSPType;
import com.ibm.etools.webapplication.LoginConfig;
import com.ibm.etools.webapplication.MimeMapping;
import com.ibm.etools.webapplication.SecurityConstraint;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.ServletMapping;
import com.ibm.etools.webapplication.SessionConfig;
import com.ibm.etools.webapplication.TagLibRef;
import com.ibm.etools.webapplication.TransportGuaranteeType;
import com.ibm.etools.webapplication.UserDataConstraint;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.etools.webapplication.WebResourceCollection;
import com.ibm.etools.webapplication.WelcomeFile;
import com.ibm.etools.webapplication.WelcomeFileList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class WarValidator
extends J2EEValidator
implements WARMessageConstants {
    protected WARFile warFile;
    protected WebApp webDD;
    private Hashtable httpMethods = null;

    public boolean checkIfValidFileForIncValidation(IFileDelta iFileDelta) {
        String string = iFileDelta.getFileName();
        return string.endsWith("xml") || string.endsWith("jsp") || string.endsWith("html") || string.endsWith("java");
    }

    public Hashtable getAndValidateSecurityRoles(EList eList) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (eList.isEmpty()) {
            return hashtable;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            SecurityRole securityRole = (SecurityRole)iterator.next();
            String string = securityRole.getRoleName();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_Security_Role_Name_6")};
                this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, securityRole);
                continue;
            }
            if (hashtable.get(string) != null) {
                stringArray = new String[]{string};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", stringArray, securityRole);
                continue;
            }
            hashtable.put(string, "Yea");
        }
        return hashtable;
    }

    public String getBaseName() {
        return "warvalidation";
    }

    public String getName() {
        return ResourceHandler.getString("Web_Archive_Validator_8");
    }

    public String getName(Locale locale) {
        return this.getMessage(null, "webArchiveValidator.name", locale);
    }

    protected boolean isHttpMethod(String string) {
        String[] stringArray;
        if (this.httpMethods == null) {
            stringArray = new String[]{"GET", "PUT", "HEAD", "TRACE", "POST", "DELETE", "OPTIONS"};
            this.httpMethods = new Hashtable();
            int n = 0;
            while (n < stringArray.length) {
                this.httpMethods.put(stringArray[n], "bla");
                ++n;
            }
        }
        return this.httpMethods.get(stringArray = string.trim()) != null;
    }

    public void validate() throws ValidationException {
        this.validateMimeMapping();
        this.validateContextParameters();
        this.validateTagLibs();
        this.validateServletMappings(this.webDD.getServletMappings());
        this.validateWelcomeFileList(this.webDD.getFileList());
        this.validateErrorPages(this.webDD.getErrorPages());
        this.validateSecurityAndServlets();
        this.validateFilters(this.webDD.getFilters());
        this.validateFilterMappings(this.webDD.getFilterMappings());
        this.validateRefs();
        this.validateLoginConfig(this.webDD.getLoginConfig());
        this.validateEnvironmentEntries(this.webDD.getEnvEntries());
        this.validateOther();
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        super.validate(iHelper, iReporter, iFileDeltaArray);
        this._reporter.removeAllMessages((IValidator)this, null);
        try {
            this.warFile = (WARFile)this._helper.loadModel("WAR_VALIDATION");
            if (this.warFile == null) {
                Message message = new Message(this.getBaseName(), 1, "ERROR_INVALID_WAR_FILE");
                throw new ValidationException((IMessage)message);
            }
            this.webDD = this.warFile.getDeploymentDescriptor();
            this.validate();
        }
        catch (ValidationException validationException) {
            throw validationException;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.toString()};
            Message message = new Message(this.getBaseName(), 1, "ERROR_WAR_VALIDATION_FAILED", stringArray);
            throw new ValidationException((IMessage)message, (Throwable)exception);
        }
    }

    public void validate(Object object) throws ValidationException {
        try {
            this.warFile = (WARFile)object;
            this.webDD = this.warFile.getDeploymentDescriptor();
            this.validate();
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.toString()};
            Message message = new Message(this.getBaseName(), 1, "ERROR_WAR_VALIDATION_FAILED", stringArray);
            throw new ValidationException((IMessage)message);
        }
    }

    public void validateAuthConstraint(AuthConstraint authConstraint, Hashtable hashtable) {
        EList eList = authConstraint.getRoles();
        if (eList != null && !eList.isEmpty()) {
            Iterator iterator = eList.iterator();
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            while (iterator.hasNext()) {
                String[] stringArray;
                String string = (String)iterator.next();
                if (string == null || string.trim().equals("")) {
                    stringArray = new String[]{ResourceHandler.getString("of_Type_Role_Name_19")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, authConstraint);
                    continue;
                }
                if (hashtable2.get(string.trim()) != null) {
                    stringArray = new String[]{string};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", stringArray, authConstraint);
                    continue;
                }
                hashtable2.put(string.trim(), "Yea");
                this.validateAuthSecRole("", string, hashtable, (EObject)authConstraint);
            }
        }
    }

    public void validateContextParameters() {
        Object object;
        String string;
        Iterator iterator;
        String[] stringArray;
        Object object2;
        Object object3;
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Iterator iterator2 = this.webDD.getContexts().iterator();
        while (iterator2.hasNext()) {
            object3 = (ContextParam)iterator2.next();
            object2 = object3.getParamName();
            if (object2 != null) {
                object2 = ((String)object2).trim();
            }
            if (object2 == null || ((String)object2).equals("")) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_Parameter_Name_25")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, object3);
                continue;
            }
            if (hashtable.get(object2) != null) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_Parameter_Name_25") + ": " + (String)object2};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", stringArray, object3);
                continue;
            }
            hashtable.put(object2, "Yea");
        }
        object3 = this.webDD.getServlets().iterator();
        while (object3.hasNext()) {
            object2 = (Servlet)object3.next();
            stringArray = object2.getParams().iterator();
            hashtable.clear();
            while (stringArray.hasNext()) {
                iterator = (InitParam)stringArray.next();
                string = iterator.getParamName();
                if (string != null) {
                    string = string.trim();
                }
                if (string == null || string.equals("")) {
                    object = new String[]{ResourceHandler.getString("of_Type_Parameter_Name_32")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", (String[])object, iterator);
                    continue;
                }
                if (hashtable.get(string) != null) {
                    object = new String[]{ResourceHandler.getString("of_Type_Parameter_Name_25") + ": " + string};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", (String[])object, iterator);
                    continue;
                }
                hashtable.put(string, "Yea");
            }
        }
        object2 = this.webDD.getFilters().iterator();
        while (object2.hasNext()) {
            stringArray = (String[])object2.next();
            iterator = stringArray.getInitParams().iterator();
            hashtable.clear();
            while (iterator.hasNext()) {
                String[] stringArray2;
                string = (InitParam)iterator.next();
                object = string.getParamName();
                if (object != null) {
                    object = ((String)object).trim();
                }
                if (object == null || ((String)object).equals("")) {
                    stringArray2 = new String[]{ResourceHandler.getString("of_Type_Parameter_Name_39")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray2, string);
                    continue;
                }
                if (hashtable.get(object) != null) {
                    stringArray2 = new String[]{ResourceHandler.getString("of_Type_Parameter_Name_25") + ": " + (String)object};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", stringArray2, string);
                    continue;
                }
                hashtable.put(object, "Yea");
            }
        }
    }

    public void validateEJBRefs(EjbRefImpl ejbRefImpl) {
        EARFile eARFile = this.warFile.getEARFile();
        EnterpriseBean enterpriseBean = null;
        if (eARFile != null) {
            enterpriseBean = eARFile.getEnterpiseBeanFromRef((EjbRef)ejbRefImpl, this.warFile.getURI());
        }
        if (enterpriseBean != null) {
            EList eList = enterpriseBean.getEjbRefs();
            int n = eList.size();
            HashSet<String> hashSet = new HashSet<String>(n);
            int n2 = 0;
            while (n2 < n) {
                String string = ((EjbRefImpl)eList.get(n2)).getName();
                String[] stringArray = new String[]{enterpriseBean.getName()};
                if (!hashSet.add(string)) {
                    this.addWarning("warvalidation", "ERROR_EAR_DUPLICATE_ROLES", stringArray, (EjbRefImpl)eList.get(n2));
                }
                ++n2;
            }
        }
    }

    public void validateEJBRefs(List list) {
        int n = list.size();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Object object;
                EjbRefImpl ejbRefImpl;
                block5: {
                    block2: {
                        String[] stringArray;
                        block3: {
                            ejbRefImpl = (EjbRefImpl)list.get(n2);
                            if (ejbRefImpl.isSetType() && (object = ejbRefImpl.getType().getName()) == null) {
                                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EJB_REF_TYPE", null, ejbRefImpl);
                            }
                            if (ejbRefImpl.getName() == null) break block2;
                            object = ejbRefImpl.getName();
                            if (!((String)(object = ((String)object).trim())).equals("")) break block3;
                            stringArray = new String[]{ResourceHandler.getString("of_Type_ejb-ref-name_44")};
                            this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, ejbRefImpl);
                            break block4;
                        }
                        if (hashtable.get(object) == null) break block5;
                        stringArray = new String[]{object};
                        this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_EJB_REF", stringArray, ejbRefImpl);
                        break block4;
                    }
                    object = new String[]{ResourceHandler.getString("of_Type_ejb-ref-name_44")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", (String[])object, ejbRefImpl);
                    break block4;
                }
                hashtable.put(object, "Yea");
                this.validateEJBRefs(ejbRefImpl);
                this.validateEJBRefManadatoryElements((EjbRef)ejbRefImpl, this.webDD.getDisplayName());
            }
            ++n2;
        }
    }

    public void validateEJBLocalRefs(List list) {
        int n = list.size();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            EJBLocalRefImpl eJBLocalRefImpl = (EJBLocalRefImpl)list.get(n2);
            if (eJBLocalRefImpl.isSetType() && (object = eJBLocalRefImpl.getType().getName()) == null) {
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EJB_REF_TYPE", null, eJBLocalRefImpl);
            }
            if (eJBLocalRefImpl.getName() != null) {
                String[] stringArray;
                object = eJBLocalRefImpl.getName();
                if (((String)(object = ((String)object).trim())).equals("")) {
                    stringArray = new String[]{ResourceHandler.getString("of_Type_ejb-ref-name_44")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, eJBLocalRefImpl);
                } else if (hashtable.get(object) != null) {
                    stringArray = new String[]{object};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_EJB_REF", stringArray, eJBLocalRefImpl);
                } else {
                    hashtable.put(object, "Yea");
                }
            } else {
                object = new String[]{ResourceHandler.getString("of_Type_ejb-ref-name_44")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", (String[])object, eJBLocalRefImpl);
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void validateErrorPages(EList var1_1) {
        var2_2 = var1_1.iterator();
        if (var1_1 != null && !var1_1.isEmpty()) ** GOTO lbl42
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (ErrorPage)var2_2.next();
            var4_4 = var3_3.getLocation();
            if (var4_4 == null || var4_4.equals("")) {
                var5_5 = new ErrorCodeErrorPage[]{ResourceHandler.getString("of_Type_Error_Location_47")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", var5_5, var3_3);
            }
            if (!var4_4.startsWith("/")) {
                var5_5 = new String[]{ResourceHandler.getString("of_Type_Error_Location_49")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ERROR_PAGE", var5_5, var3_3);
            }
            if (var3_3.isErrorCode()) {
                var5_5 = (String[])var3_3;
                var6_6 = var5_5.getErrorCode();
                var7_7 = false;
                if (var6_6.length() == 3) {
                    try {
                        var8_9 = new Integer(var6_6);
                        var9_11 = var8_9.intValue();
                        if (var9_11 >= 100 && var9_11 < 600) {
                            var7_7 = true;
                        }
                    }
                    catch (NumberFormatException var8_10) {
                        // empty catch block
                    }
                }
                if (var7_7) continue;
                var8_9 = new String[]{var6_6};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ERROR_CODE", (String[])var8_9, var5_5);
                continue;
            }
            if (!var3_3.isExceptionType()) continue;
            var5_5 = (ExceptionTypeErrorPage)var3_3;
            var6_6 = var5_5.getExceptionType();
            var7_8 = "java.lang.Exception";
            var8_9 = var5_5.getExceptionTypeName();
            if (var6_6 != null) {
                var9_12 = var6_6.eResource().getResourceSet();
                if (var9_12 == null || var6_6.inheritsFrom(JavaClassImpl.reflect((String)var7_8, (ResourceSet)var9_12).getWrapper())) continue;
                var10_14 = new String[]{var8_9};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EXCEPTION_TYPE", var10_14, var5_5);
                continue;
            }
            var9_13 = new String[]{""};
            this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EXCEPTION_TYPE", var9_13, var5_5);
lbl42:
            // 7 sources

            ** while (var2_2.hasNext())
        }
lbl43:
        // 1 sources

    }

    public void validateLoginConfig(LoginConfig loginConfig) {
        if (loginConfig != null) {
            String string = loginConfig.getAuthMethod().getName();
            if (string == null) {
                String[] stringArray = new String[]{};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_AUTH_METHOD", stringArray, loginConfig);
            } else if (!string.equals("FORM")) {
                String[] stringArray = new String[]{string};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_IGNORE_FORM_LOGIN", stringArray, loginConfig);
            }
        }
    }

    public void validateEnvironmentEntries(EList eList) {
        if (eList.isEmpty()) {
            return;
        }
        Iterator iterator = eList.iterator();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            String string;
            EnvEntry envEntry = (EnvEntry)iterator.next();
            if (envEntry.getType().getName() == null) {
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ENV_ENTRY", null, envEntry);
            }
            if ((string = envEntry.getName()) == null) continue;
            if (hashtable.get(string) != null) {
                String[] stringArray = new String[]{ResourceHandler.getString("of_Type_Env_Entry_Name___88") + ": " + string};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", stringArray, envEntry);
                continue;
            }
            hashtable.put(string, "Yea");
        }
    }

    public void validateMimeMapping() {
        if (this.webDD.getMimeMappings().isEmpty()) {
            return;
        }
        Iterator iterator = this.webDD.getMimeMappings().iterator();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            String[] stringArray;
            MimeMapping mimeMapping = (MimeMapping)iterator.next();
            String string = mimeMapping.getExtension();
            String string2 = mimeMapping.getMimeType();
            if (string != null) {
                string = string.trim();
            }
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                stringArray = new String[]{string == null || string.trim().equals("") ? ResourceHandler.getString("of_Type_Mime_Extension_54") : ResourceHandler.getString("of_Type_Mime_Type_55")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, mimeMapping);
                continue;
            }
            if (hashtable.get(string) != null) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_Mime_Extension___56") + ": " + string};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", stringArray, mimeMapping);
                continue;
            }
            hashtable.put(string, "Yea");
        }
    }

    public void validateOther() {
        int n;
        SessionConfig sessionConfig = this.webDD.getSessionConfig();
        if (sessionConfig != null && (n = sessionConfig.getSessionTimeout()) == 0) {
            this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_SESSION_TIMEOUT", null, sessionConfig);
        }
    }

    public void validateRefs() {
        EList eList;
        EList eList2;
        EList eList3 = this.webDD.getEjbRefs();
        if (!eList3.isEmpty()) {
            this.validateEJBRefs((List)eList3);
        }
        if (!(eList2 = this.webDD.getEjbLocalRefs()).isEmpty()) {
            this.validateEJBLocalRefs((List)eList2);
        }
        if (!(eList = this.webDD.getResourceRefs()).isEmpty()) {
            int n = eList.size();
            HashSet<String[]> hashSet = new HashSet<String[]>(n);
            boolean bl = this.warFile.getDeploymentDescriptor().isVersion2_2Descriptor();
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray;
                String[] stringArray2;
                ResourceRefImpl resourceRefImpl = (ResourceRefImpl)eList.get(n2);
                String string = resourceRefImpl.getAuth().getName();
                if (string == null) {
                    stringArray2 = new String[]{resourceRefImpl.getName()};
                    stringArray = bl ? "MESSAGE_WAR_VALIDATION_RES_AUTH_REQUIRED_22" : "MESSAGE_WAR_VALIDATION_RES_AUTH_REQUIRED_23";
                    this.addWarning("warvalidation", (String)stringArray, stringArray2, resourceRefImpl);
                } else if (bl && string.equals("Application")) {
                    stringArray2 = new String[]{resourceRefImpl.getName()};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_RES_AUTH_INVALID_22", stringArray2, resourceRefImpl);
                } else if (!bl && string.equals("SERVLET")) {
                    stringArray2 = new String[]{resourceRefImpl.getName()};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_RES_AUTH_INVALID_23", stringArray2, resourceRefImpl);
                }
                stringArray2 = resourceRefImpl.getResSharingScope().getName();
                if (!bl && stringArray2 == null) {
                    stringArray = new String[]{};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_RES_SHARING_SCOPE", stringArray, resourceRefImpl);
                }
                stringArray = resourceRefImpl.getName();
                String[] stringArray3 = new String[]{stringArray};
                if (!hashSet.add(stringArray)) {
                    this.addError("erefvalidation", "ERROR_EAR_DUPLICATE_RESREF", stringArray3, resourceRefImpl);
                }
                ++n2;
            }
        }
    }

    protected void validateAuthSecRole(String string, String string2, Hashtable hashtable, EObject eObject) {
        String string3 = string2;
        String string4 = string;
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string4 != null) {
            string4 = string4.trim();
        }
        if (string3 != null && !string3.equals("*") && !string3.equals("") && hashtable.get(string3) == null && hashtable.get(string4) == null) {
            String[] stringArray = new String[]{string3};
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE_NAME", stringArray, eObject);
        }
    }

    protected void validateSecRole(String string, String string2, Hashtable hashtable, EObject eObject) {
        String[] stringArray;
        String string3 = string2;
        String string4 = string;
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string4 != null) {
            string4 = string4.trim();
        }
        if (string3 == null || string3.equals("")) {
            stringArray = new String[]{string3};
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE_NAME", stringArray, eObject);
        }
        if (!(string3 != null && string3.equals("*") || string4 == null || hashtable.get(string4) != null)) {
            stringArray = new String[]{string4};
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE", stringArray, eObject);
        }
    }

    public void validateSecurityAndServlets() {
        EARFile eARFile;
        EList eList = this.webDD.getSecurityRoles();
        Hashtable hashtable = this.getAndValidateSecurityRoles(eList);
        this.validateServlets(this.webDD.getServlets(), hashtable);
        this.validateSecurityConstraints(this.webDD.getConstraints(), hashtable);
        if (!eList.isEmpty() && (eARFile = this.warFile.getEARFile()) != null) {
            EList eList2 = eARFile.getDeploymentDescriptor().getSecurityRoles();
            this.validateWEBRolesWithEARRoles(eList2, eList);
        }
    }

    public void validateSecurityConstraints(EList eList, Hashtable hashtable) {
        if (eList.isEmpty()) {
            return;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TransportGuaranteeType transportGuaranteeType;
            UserDataConstraint userDataConstraint;
            AuthConstraint authConstraint;
            SecurityConstraint securityConstraint = (SecurityConstraint)iterator.next();
            EList eList2 = securityConstraint.getWebResourceCollections();
            if (eList2 == null || eList2.isEmpty()) {
                authConstraint = new AuthConstraint[]{ResourceHandler.getString("of_Type_Web_Resource_Collection_64")};
                this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", (String[])authConstraint, securityConstraint);
                continue;
            }
            this.validateWebResourceCollections(eList2);
            authConstraint = securityConstraint.getAuthConstraint();
            if (authConstraint != null) {
                this.validateAuthConstraint(authConstraint, hashtable);
            }
            if ((userDataConstraint = securityConstraint.getUserDataConstraint()) == null || userDataConstraint.getTransportGuarantee() == null || (transportGuaranteeType = userDataConstraint.getTransportGuarantee()) != null) continue;
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_TRANSPORT", new String[0], userDataConstraint);
        }
    }

    public void validateFilters(EList eList) {
        if (eList.isEmpty()) {
            return;
        }
        Iterator iterator = eList.iterator();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            String[] stringArray;
            Filter filter = (Filter)iterator.next();
            String string = filter.getName();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_Filter_Name_66")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, filter);
                continue;
            }
            if (hashtable.get(string) != null) {
                stringArray = new String[]{string};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_FILTER", stringArray, filter);
                continue;
            }
            hashtable.put(string, "Yea");
        }
    }

    public void validateFilterMappings(EList eList) {
        if (eList.isEmpty()) {
            return;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string;
            FilterMapping filterMapping = (FilterMapping)iterator.next();
            if (filterMapping.getUrlPattern() != null) {
                string = filterMapping.getUrlPattern();
                stringArray = new String[]{string};
                if (string == null) {
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", stringArray, filterMapping);
                    continue;
                }
                if (filterMapping.getFilter() == null || filterMapping.getFilter().equals("")) {
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_FILTER_MAPPING", stringArray, filterMapping);
                    continue;
                }
                try {
                    if (!string.equals("")) continue;
                    throw new Exception(ResourceHandler.getString("Invalid_URL_70"));
                }
                catch (Exception exception) {
                    stringArray = new String[]{filterMapping.getUrlPattern()};
                    this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", stringArray, filterMapping);
                }
                continue;
            }
            if (filterMapping.getServletName() == null) continue;
            string = filterMapping.getServletName();
            stringArray = new String[]{string};
            if (filterMapping.getServlet() == null) {
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_SERVLET_MAPPING", stringArray, filterMapping);
                continue;
            }
            if (filterMapping.getFilter() != null && !filterMapping.getFilter().equals("")) continue;
            this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_FILTER_MAPPING", stringArray, filterMapping);
        }
    }

    public void validateServletMappings(EList eList) {
        if (eList.isEmpty()) {
            return;
        }
        Iterator iterator = eList.iterator();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            String[] stringArray;
            ServletMapping servletMapping = (ServletMapping)iterator.next();
            String string = servletMapping.getUrlPattern();
            if (string != null) {
                if (hashtable.get(string = string.trim()) != null) {
                    stringArray = new String[]{servletMapping.getUrlPattern()};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_MAPPING", stringArray, servletMapping);
                    continue;
                }
                hashtable.put(servletMapping.getUrlPattern(), "Yea");
            }
            if (string == null || servletMapping.getServlet() == null || servletMapping.getServlet().equals("")) {
                stringArray = new String[]{string};
                if (string == null) {
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", stringArray, servletMapping);
                    continue;
                }
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_SERVLET_MAPPING", stringArray, servletMapping);
                continue;
            }
            try {
                if (!string.equals("")) continue;
                throw new Exception(ResourceHandler.getString("Invalid_URL_75"));
            }
            catch (Exception exception) {
                String[] stringArray2 = new String[]{servletMapping.getUrlPattern()};
                this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", stringArray2, servletMapping);
            }
        }
    }

    public void validateServlets(EList eList, Hashtable hashtable) {
        if (eList.isEmpty()) {
            return;
        }
        Iterator iterator = eList.iterator();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            Object object;
            Iterator iterator2;
            String[] stringArray;
            Servlet servlet = (Servlet)iterator.next();
            String string = servlet.getServletName();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_Servlet_Name_77")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, servlet);
                continue;
            }
            if (hashtable2.get(string) != null) {
                stringArray = new String[]{string};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_SERVLET", stringArray, servlet);
                continue;
            }
            hashtable2.put(string, "Yea");
            stringArray = servlet.getSecurityRoleRefs();
            if (!stringArray.isEmpty()) {
                iterator2 = stringArray.iterator();
                while (iterator2.hasNext()) {
                    object = (SecurityRoleRef)iterator2.next();
                    this.validateSecRole(object.getLink(), object.getName(), hashtable, (EObject)object);
                }
            }
            if (!servlet.getWebType().isJspType() || (object = (iterator2 = (JSPType)servlet.getWebType()).getJspFile()) == null || ((String)object).length() <= 0 || ((String)object).charAt(0) == '/') continue;
            String[] stringArray2 = new String[]{object, string};
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_JSPFILE_REF", stringArray2, servlet);
        }
    }

    public void validateTagLibs() {
        if (this.webDD.getTagLibs().isEmpty()) {
            return;
        }
        Iterator iterator = this.webDD.getTagLibs().iterator();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            String[] stringArray;
            TagLibRef tagLibRef = (TagLibRef)iterator.next();
            String string = tagLibRef.getTaglibURI();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_Taglib_80")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", stringArray, tagLibRef);
                continue;
            }
            if (hashtable.get(string) != null) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_TagLib___81") + ": " + string};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", stringArray, tagLibRef);
                continue;
            }
            hashtable.put(string, "Yea");
        }
    }

    public void validateWebResourceCollections(EList eList) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EList eList2;
            WebResourceCollection webResourceCollection = (WebResourceCollection)iterator.next();
            String string = webResourceCollection.getWebResourceName();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                eList2 = new EList[]{ResourceHandler.getString("of_Type_Web_Resource_Name_84")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", (String[])eList2, webResourceCollection);
            }
            if ((eList2 = webResourceCollection.getHTTPs()).isEmpty()) continue;
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                HTTPMethodType hTTPMethodType = (HTTPMethodType)iterator2.next();
                String string2 = hTTPMethodType.getHttpMethod();
                if (string2 != null && this.isHttpMethod(string2)) continue;
                String[] stringArray = new String[]{string2};
                this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_HTTP_CMD", stringArray, hTTPMethodType);
            }
        }
    }

    public void validateWelcomeFileList(WelcomeFileList welcomeFileList) {
        if (welcomeFileList == null) {
            return;
        }
        Iterator iterator = welcomeFileList.getFile().iterator();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            String[] stringArray;
            WelcomeFile welcomeFile = (WelcomeFile)iterator.next();
            String string = welcomeFile.getWelcomeFile();
            if (string == null || string.length() == 0) {
                stringArray = new String[1];
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_NO_WELCOME_FILE", stringArray, welcomeFile);
            } else if (string.startsWith("/") || string.endsWith("/")) {
                stringArray = new String[1];
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_WELCOME_FILE", stringArray, welcomeFile);
            }
            string = string.trim();
            if (hashtable.get(string) != null) {
                stringArray = new String[]{ResourceHandler.getString("of_Type_Welcome_File_Name__87") + ": " + string};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", stringArray, welcomeFile);
                continue;
            }
            hashtable.put(string, "Yea");
        }
    }
}

