/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;

public class CopyResourceAction
extends SelectionListenerAction
implements ISelectionValidator {
    public static final String ID = "org.eclipse.ui.CopyResourceAction";
    private Shell shell;
    protected CopyFilesAndFoldersOperation operation;

    public static IPath getNewNameFor(IPath originalName, IWorkspace workspace) {
        return CopyFilesAndFoldersOperation.getAutoNewNameFor(originalName, workspace);
    }

    public CopyResourceAction(Shell shell) {
        this(shell, WorkbenchMessages.getString("CopyResourceAction.title"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.copy_resource_action_context");
    }

    CopyResourceAction(Shell shell, String name) {
        super(name);
        this.setToolTipText(WorkbenchMessages.getString("CopyResourceAction.toolTip"));
        this.setId(ID);
        Assert.isNotNull(shell);
        this.shell = shell;
    }

    protected CopyFilesAndFoldersOperation createOperation() {
        return new CopyFilesAndFoldersOperation(this.getShell());
    }

    IContainer getInitialContainer() {
        List resources = this.getSelectedResources();
        if (resources.size() > 0) {
            IResource resource = (IResource)resources.get(0);
            return resource.getParent();
        }
        return null;
    }

    protected IResource[] getResources(List resourceList) {
        return resourceList.toArray(new IResource[resourceList.size()]);
    }

    Shell getShell() {
        return this.shell;
    }

    public String isValid(Object destination) {
        IWorkspaceRoot root = WorkbenchPlugin.getPluginWorkspace().getRoot();
        IContainer container = (IContainer)root.findMember((IPath)destination);
        if (container != null) {
            CopyFilesAndFoldersOperation operation = this.createOperation();
            List sources = this.getSelectedResources();
            IResource[] resources = sources.toArray(new IResource[sources.size()]);
            return operation.validateDestination(container, resources);
        }
        return null;
    }

    IPath queryDestinationResource() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.shell, this.getInitialContainer(), true, WorkbenchMessages.getString("CopyResourceAction.selectDestination"));
        dialog.setValidator(this);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return (IPath)result[0];
        }
        return null;
    }

    public void run() {
        this.operation = this.createOperation();
        IPath destination = this.queryDestinationResource();
        if (destination == null) {
            return;
        }
        IWorkspaceRoot root = WorkbenchPlugin.getPluginWorkspace().getRoot();
        IContainer container = (IContainer)root.findMember(destination);
        if (container == null) {
            return;
        }
        List sources = this.getSelectedResources();
        this.runOperation(this.getResources(sources), container);
        this.operation = null;
    }

    protected void runOperation(IResource[] resources, IContainer destination) {
        this.operation.copyResources(resources, destination);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() == 0) {
            return false;
        }
        IContainer firstParent = ((IResource)selectedResources.get(0)).getParent();
        if (firstParent == null) {
            return false;
        }
        Iterator resourcesEnum = selectedResources.iterator();
        while (resourcesEnum.hasNext()) {
            IResource currentResource = (IResource)resourcesEnum.next();
            if (currentResource.getType() == 4) {
                return false;
            }
            if (currentResource.getParent().equals((Object)firstParent)) continue;
            return false;
        }
        return true;
    }
}

