/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.NewWizard;

public class NewWizardAction
extends Action {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private String categoryId = null;
    private IWorkbenchWindow window;

    public NewWizardAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("NewWizardAction.text"));
        this.window = window;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD_HOVER"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setToolTipText(WorkbenchMessages.getString("NewWizardAction.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.new_action_context");
        this.setActionDefinitionId("org.eclipse.ui.newWizard");
    }

    public NewWizardAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String id) {
        this.categoryId = id;
    }

    public void run() {
        NewWizard wizard = new NewWizard();
        wizard.setCategoryId(this.categoryId);
        ISelection selection = this.window.getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
        } else {
            IEditorInput input;
            IWorkbenchPart part = this.window.getPartService().getActivePart();
            if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
                selectionToPass = new StructuredSelection((Object)((IFileEditorInput)input).getFile());
            }
        }
        wizard.init(this.window.getWorkbench(), (IStructuredSelection)selectionToPass);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("NewWizardAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("NewWizardAction");
        }
        wizard.setDialogSettings(wizardSettings);
        wizard.setForcePreviousAndNextButtons(true);
        Shell parent = this.window.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.new_wizard_context");
        dialog.open();
    }
}

