/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;

public abstract class PerspectiveMenu
extends ContributionItem {
    private static final int MAX_PERSPECTIVE_ITEMS = 9;
    private static IPerspectiveRegistry reg;
    private IWorkbenchWindow window;
    private boolean showActive = false;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            PerspectiveMenu.this.dirty = true;
        }
    };
    private Comparator comparator = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object ob1, Object ob2) {
            IPerspectiveDescriptor d1 = (IPerspectiveDescriptor)ob1;
            IPerspectiveDescriptor d2 = (IPerspectiveDescriptor)ob2;
            return this.collator.compare(d1.getLabel(), d2.getLabel());
        }
    };
    private static Hashtable imageCache;

    static {
        imageCache = new Hashtable(11);
    }

    public PerspectiveMenu(IWorkbenchWindow window, String id) {
        super(id);
        this.window = window;
        if (reg == null) {
            reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        }
    }

    void createMenuItem(Menu menu, int index, final IPerspectiveDescriptor desc, boolean bCheck) {
        MenuItem mi = new MenuItem(menu, bCheck ? 16 : 8, index);
        mi.setText(desc.getLabel());
        Image image = this.getImage(desc);
        if (image != null) {
            mi.setImage(image);
        }
        mi.setSelection(bCheck);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerspectiveMenu.this.run(desc, e);
            }
        });
        WorkbenchHelp.setHelp(mi, "org.eclipse.ui.open_perspective_action_context");
    }

    void createOtherItem(Menu menu, int index) {
        MenuItem mi = new MenuItem(menu, 8, index);
        mi.setText(WorkbenchMessages.getString("PerspectiveMenu.otherItem"));
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerspectiveMenu.this.runOther(e);
            }
        });
        WorkbenchHelp.setHelp(mi, "org.eclipse.ui.open_perspective_other_action_context");
    }

    public void fill(Menu menu, int index) {
        IWorkbenchPage activePage;
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        String checkID = null;
        if (this.showActive && (activePage = this.window.getActivePage()) != null && activePage.getPerspective() != null) {
            checkID = activePage.getPerspective().getId();
        }
        ArrayList persps = this.getPerspectiveItems();
        Collections.sort(persps, this.comparator);
        int i = 0;
        while (i < persps.size()) {
            IPerspectiveDescriptor desc = (IPerspectiveDescriptor)persps.get(i);
            this.createMenuItem(menu, index++, desc, desc.getId().equals(checkID));
            ++i;
        }
        if (persps.size() > 0) {
            new MenuItem(menu, 2, index++);
        }
        this.createOtherItem(menu, index);
        this.dirty = false;
    }

    private Image getImage(IPerspectiveDescriptor perspDesc) {
        ImageDescriptor imageDesc = perspDesc.getImageDescriptor();
        if (imageDesc == null) {
            imageDesc = WorkbenchImages.getImageDescriptor("IMG_CTOOL_DEF_PERSPECTIVE_HOVER");
        }
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ArrayList getPerspectiveShortcuts() {
        ArrayList<IPerspectiveDescriptor> list = new ArrayList<IPerspectiveDescriptor>();
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return list;
        }
        ArrayList ids = ((WorkbenchPage)page).getPerspectiveActionIds();
        if (ids == null) {
            return list;
        }
        int i = 0;
        while (i < ids.size()) {
            String perspID = (String)ids.get(i);
            IPerspectiveDescriptor desc = reg.findPerspectiveWithId(perspID);
            if (desc != null && !list.contains(desc)) {
                list.add(desc);
            }
            ++i;
        }
        return list;
    }

    private int getPerspectiveMru(List dest, int destStart, int count) {
        Workbench wb = (Workbench)WorkbenchPlugin.getDefault().getWorkbench();
        return wb.getPerspectiveHistory().copyItems(dest, destStart, count);
    }

    protected ArrayList getPerspectiveItems() {
        ArrayList shortcuts = this.getPerspectiveShortcuts();
        int emptySlots = shortcuts.size();
        if (emptySlots < 9) {
            emptySlots = 9;
        }
        ArrayList<IPerspectiveDescriptor> list = new ArrayList<IPerspectiveDescriptor>(emptySlots);
        String id = reg.getDefaultPerspective();
        IPerspectiveDescriptor desc = reg.findPerspectiveWithId(id);
        if (desc != null) {
            list.add(desc);
            --emptySlots;
        }
        int size = shortcuts.size();
        int i = 0;
        while (i < size && emptySlots > 0) {
            if (!list.contains(shortcuts.get(i))) {
                list.add((IPerspectiveDescriptor)shortcuts.get(i));
                --emptySlots;
            }
            ++i;
        }
        if (emptySlots > 0) {
            ArrayList mru = new ArrayList(9);
            int count = this.getPerspectiveMru(mru, 0, 9);
            int i2 = 0;
            while (i2 < count && emptySlots > 0) {
                if (!list.contains(mru.get(i2))) {
                    list.add((IPerspectiveDescriptor)mru.get(i2));
                    --emptySlots;
                }
                ++i2;
            }
        }
        return list;
    }

    protected boolean getShowActive() {
        return this.showActive;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    protected abstract void run(IPerspectiveDescriptor var1);

    protected void run(IPerspectiveDescriptor desc, SelectionEvent event) {
        this.run(desc);
    }

    void runOther(SelectionEvent event) {
        SelectPerspectiveDialog dlg = new SelectPerspectiveDialog(this.window.getShell(), reg);
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        IPerspectiveDescriptor desc = dlg.getSelection();
        if (desc != null) {
            this.run(desc, event);
        }
    }

    protected void showActive(boolean b) {
        this.showActive = b;
    }
}

