/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.zip.CRC32;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.NewConfigurationInfo;
import org.eclipse.ui.internal.WorkbenchMessages;

public class AboutInfo
extends NewConfigurationInfo {
    private String appName;
    private ImageDescriptor windowImage;
    private ImageDescriptor aboutImage;
    private ImageDescriptor featureImage;
    private String aboutText;
    private URL welcomePageURL;
    private String welcomePerspective;
    private String tipsAndTricksHref;
    private String featureImageName;
    private Long featureImageCRC;
    private boolean calculatedImageCRC = false;
    private static final int BYTE_ARRAY_SIZE = 2048;

    public AboutInfo(String featureId, PluginVersionIdentifier versionId) {
        super(featureId, versionId, "about.ini", "about.properties", "about.mappings");
    }

    public ImageDescriptor getAboutImage() {
        return this.aboutImage;
    }

    public ImageDescriptor getFeatureImage() {
        return this.featureImage;
    }

    public String getFeatureImageName() {
        return this.featureImageName;
    }

    public Long getFeatureImageCRC() {
        if (!this.calculatedImageCRC && this.featureImageName != null) {
            this.featureImageCRC = this.calculateFeatureImageCRC();
            this.calculatedImageCRC = true;
        }
        return this.featureImageCRC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long calculateFeatureImageCRC() {
        Long l;
        ByteArrayOutputStream out;
        block19: {
            URL url = null;
            if (this.featureImageName != null) {
                IPluginDescriptor desc = this.getDescriptor();
                if (desc == null) {
                    return null;
                }
                url = desc.find(new Path("$nl$").append(this.featureImageName));
            }
            if (url == null) {
                return null;
            }
            InputStream in = null;
            out = null;
            try {
                try {
                    in = url.openStream();
                    out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[2048];
                    int readResult = 2048;
                    while (true) {
                        if (readResult != 2048) {
                            byte[] contents = out.toByteArray();
                            CRC32 crc = new CRC32();
                            crc.update(contents);
                            l = new Long(crc.getValue());
                            Object var8_10 = null;
                            if (in == null) break block19;
                            break;
                        }
                        readResult = in.read(buffer);
                        if (readResult <= 0) continue;
                        out.write(buffer, 0, readResult);
                    }
                }
                catch (IOException iOException) {
                    Long l2 = null;
                    Object var8_11 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (out == null) return l2;
                    try {
                        out.close();
                        return l2;
                    }
                    catch (IOException iOException3) {}
                    return l2;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (in != null) {
                    try {}
                    catch (IOException iOException) {}
                    in.close();
                }
                if (out == null) throw throwable;
                try {}
                catch (IOException iOException) {
                    throw throwable;
                }
                out.close();
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            in.close();
        }
        if (out == null) return l;
        try {}
        catch (IOException iOException) {}
        out.close();
        return l;
    }

    public String getFeatureLabel() {
        if (this.getDescriptor() == null) {
            return null;
        }
        return this.getDescriptor().getLabel();
    }

    public String getAboutText() {
        return this.aboutText;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getProductName() {
        IPluginDescriptor desc = this.getDescriptor();
        if (desc == null) {
            return null;
        }
        return desc.getLabel();
    }

    public String getProviderName() {
        IPluginDescriptor desc = this.getDescriptor();
        if (desc == null) {
            return null;
        }
        return desc.getProviderName();
    }

    public String getVersion() {
        PluginVersionIdentifier versionId = this.getVersionId();
        if (versionId == null) {
            return null;
        }
        return versionId.toString();
    }

    public URL getWelcomePageURL() {
        return this.welcomePageURL;
    }

    public String getWelcomePerspective() {
        return this.welcomePerspective;
    }

    public String getTipsAndTricksHref() {
        return this.tipsAndTricksHref;
    }

    public ImageDescriptor getWindowImage() {
        return this.windowImage;
    }

    protected void readINIFile(URL iniURL, URL propertiesURL, URL mappingsURL) throws CoreException {
        Properties ini = new Properties();
        InputStream is = null;
        try {
            try {
                is = iniURL.openStream();
                ini.load(is);
            }
            catch (IOException e) {
                this.reportINIFailure(e, "Cannot read about info file " + iniURL);
                Object var7_8 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var7_10 = null;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        PropertyResourceBundle bundle = null;
        if (propertiesURL != null) {
            InputStream bundleStream = null;
            try {
                try {
                    bundleStream = propertiesURL.openStream();
                    bundle = new PropertyResourceBundle(bundleStream);
                }
                catch (IOException e) {
                    this.reportINIFailure(e, "Cannot read about properties file " + propertiesURL);
                    bundle = null;
                }
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                try {
                    if (bundleStream != null) {
                        bundleStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            Object var9_18 = null;
            try {
                if (bundleStream != null) {
                    bundleStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        PropertyResourceBundle mappingsBundle = null;
        if (mappingsURL != null) {
            InputStream bundleStream = null;
            try {
                try {
                    bundleStream = mappingsURL.openStream();
                    mappingsBundle = new PropertyResourceBundle(bundleStream);
                }
                catch (IOException e) {
                    this.reportINIFailure(e, "Cannot read about mappings file " + mappingsURL);
                    mappingsBundle = null;
                }
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                try {
                    if (bundleStream != null) {
                        bundleStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            Object var10_16 = null;
            try {
                if (bundleStream != null) {
                    bundleStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        ArrayList<String> mappingsList = new ArrayList<String>();
        if (mappingsBundle != null) {
            boolean found = true;
            int i = 0;
            while (found) {
                try {
                    String readValue = mappingsBundle.getString(Integer.toString(i));
                    if ("$featureVersion".equals(readValue) && (readValue = this.getVersion()) == null) {
                        readValue = WorkbenchMessages.getString("AboutDialog.notSpecified");
                    }
                    mappingsList.add(readValue);
                }
                catch (MissingResourceException missingResourceException) {
                    found = false;
                }
                ++i;
            }
        }
        String[] mappingsArray = mappingsList.toArray(new String[mappingsList.size()]);
        Hashtable<String, String> runtimeMappings = new Hashtable<String, String>();
        String featureVersion = this.getVersion();
        if (featureVersion == null) {
            featureVersion = WorkbenchMessages.getString("AboutDialog.notSpecified");
        }
        runtimeMappings.put("{featureVersion}", featureVersion);
        this.windowImage = this.getImage(ini, "windowImage");
        this.aboutText = (String)((Hashtable)ini).get("aboutText");
        this.aboutText = this.getResourceString(this.aboutText, bundle, mappingsArray, runtimeMappings);
        this.aboutImage = this.getImage(ini, "aboutImage");
        this.featureImageName = (String)((Hashtable)ini).get("featureImage");
        this.featureImage = this.getImage(ini, "featureImage");
        this.welcomePageURL = this.getURL(ini, "welcomePage");
        this.welcomePerspective = (String)((Hashtable)ini).get("welcomePerspective");
        this.tipsAndTricksHref = (String)((Hashtable)ini).get("tipsAndTricksHref");
        this.appName = (String)((Hashtable)ini).get("appName");
        this.appName = this.getResourceString(this.appName, bundle, mappingsArray, null);
    }

    private URL getURL(Properties ini, String key) {
        URL url = null;
        String fileName = (String)((Hashtable)ini).get(key);
        if (fileName != null) {
            IPluginDescriptor desc = this.getDescriptor();
            if (desc == null) {
                return null;
            }
            url = desc.find((IPath)new Path(fileName));
        }
        return url;
    }

    private ImageDescriptor getImage(Properties ini, String key) {
        URL url = this.getURL(ini, key);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }
}

