/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CloseAllAction
extends PartEventAction
implements IPageListener {
    private IWorkbenchWindow workbench;

    public CloseAllAction(IWorkbenchWindow aWorkbench) {
        super(WorkbenchMessages.getString("CloseAllAction.text"));
        this.workbench = aWorkbench;
        this.setToolTipText(WorkbenchMessages.getString("CloseAllAction.toolTip"));
        this.setEnabled(false);
        this.setId("closeAll");
        this.updateState();
        aWorkbench.addPageListener(this);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.close_all_action_context");
    }

    public void pageActivated(IWorkbenchPage page) {
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        this.updateState();
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.updateState();
    }

    public void partOpened(IWorkbenchPart part) {
        this.updateState();
    }

    public void run() {
        IWorkbenchPage page = this.workbench.getActivePage();
        if (page != null) {
            page.closeAllEditors(true);
        }
    }

    private void updateState() {
        WorkbenchPage page = (WorkbenchPage)this.workbench.getActivePage();
        if (page != null) {
            this.setEnabled(page.getSortedEditors().length >= 1);
        } else {
            this.setEnabled(false);
        }
    }
}

