/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.CoolBarManager;
import org.eclipse.ui.internal.CoolItemToolBarManager;
import org.eclipse.ui.part.CoolItemGroupMarker;

public class CoolBarContributionItem
extends ContributionItem {
    private boolean visible = true;
    private CoolItemToolBarManager toolBarManager;
    private boolean orderBefore = false;
    private boolean orderAfter = false;

    public CoolBarContributionItem() {
    }

    public CoolBarContributionItem(CoolBarManager parent, String id) {
        this(parent, new CoolItemToolBarManager(parent.getStyle()), id);
    }

    public CoolBarContributionItem(CoolBarManager parent, CoolItemToolBarManager tBarMgr, String id) {
        super(id);
        this.toolBarManager = tBarMgr;
        tBarMgr.setParentMgr(parent);
        tBarMgr.setCoolBarItem(this);
    }

    protected ToolBar createControl() {
        ToolBar tBar = null;
        CoolBar parentControl = this.getParentManager().getControl();
        if (parentControl != null) {
            tBar = this.toolBarManager.createControl((Composite)parentControl);
        }
        return tBar;
    }

    public void dispose() {
        if (this.toolBarManager != null) {
            this.toolBarManager.removeAll();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof CoolBarContributionItem) {
            CoolBarContributionItem item = (CoolBarContributionItem)((Object)object);
            return this.getId().equals(item.getId());
        }
        return false;
    }

    public void fill(Composite parent) {
    }

    public void fill(Menu parent, int index) {
    }

    public void fill(ToolBar parent, int index) {
    }

    public ToolBar getControl() {
        ToolBar tBar = this.toolBarManager.getControl();
        if (tBar == null) {
            tBar = this.createControl();
        }
        return tBar;
    }

    public IContributionItem[] getItems() {
        return this.toolBarManager.getItems();
    }

    public CoolBarManager getParentManager() {
        return this.getToolBarManager().getParentManager();
    }

    public CoolItemToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    public boolean hasDisplayableItems() {
        IContributionItem[] items = this.toolBarManager.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (!item.isSeparator() && !item.isGroupMarker() && item.isVisible()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEmpty() {
        IContributionItem[] items = this.toolBarManager.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (!item.isSeparator()) {
                if (item instanceof CoolItemGroupMarker) {
                    return false;
                }
                if (!item.isGroupMarker()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isGroupMarker() {
        return true;
    }

    protected boolean isOrderAfter() {
        return this.orderAfter;
    }

    protected boolean isOrderBefore() {
        return this.orderBefore;
    }

    public boolean isSeparator() {
        return false;
    }

    public boolean isVisible() {
        if (this.getParentManager() == null) {
            return true;
        }
        return this.visible;
    }

    protected void setOrderAfter(boolean orderAfter) {
        this.orderAfter = orderAfter;
    }

    protected void setOrderBefore(boolean orderBefore) {
        this.orderBefore = orderBefore;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.getParentManager() != null) {
            this.getParentManager().markDirty();
        }
    }

    public void setVisible(boolean visible, boolean forceVisibility) {
        if (visible) {
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (forceVisibility) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
        } else if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void update(boolean force) {
        this.toolBarManager.update(force);
    }
}

