/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.CoolBarManager;
import org.eclipse.ui.internal.CoolItemToolBarManager;
import org.eclipse.ui.part.CoolItemGroupMarker;

public class CoolItemMultiToolBarManager
extends CoolItemToolBarManager {
    ArrayList coolBarItems = new ArrayList();
    boolean active = false;
    String id;
    boolean coolItemsCreated = false;

    public void add(IAction action) {
        if (!this.coolItemsCreated) {
            super.add(action);
            return;
        }
        CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)this.coolBarItems.get(this.coolBarItems.size() - 1));
        cbItem.getToolBarManager().add(action);
        if (cbItem.hasDisplayableItems()) {
            this.setVisible(true);
        }
    }

    public void add(IContributionItem item) {
        if (!this.coolItemsCreated) {
            super.add(item);
            return;
        }
        CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)this.coolBarItems.get(this.coolBarItems.size() - 1));
        cbItem.getToolBarManager().add(item);
        if (cbItem.hasDisplayableItems()) {
            this.setVisible(true);
        }
    }

    public void appendToGroup(String groupName, IAction action) {
        if (!this.coolItemsCreated) {
            super.appendToGroup(groupName, action);
            return;
        }
        CoolBarContributionItem cbItem = this.findGroup(groupName);
        if (cbItem != null) {
            cbItem.getToolBarManager().add(action);
            if (cbItem.hasDisplayableItems()) {
                this.setVisible(true);
            }
        } else {
            cbItem = this.findGroupFor(groupName);
            if (cbItem != null) {
                cbItem.getToolBarManager().appendToGroup(groupName, action);
                if (cbItem.hasDisplayableItems()) {
                    this.setVisible(true);
                }
            }
        }
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        if (!this.coolItemsCreated) {
            super.appendToGroup(groupName, item);
            return;
        }
        CoolBarContributionItem cbItem = this.findGroup(groupName);
        if (cbItem != null) {
            cbItem.getToolBarManager().add(item);
            if (cbItem.hasDisplayableItems()) {
                this.setVisible(true);
            }
        } else {
            cbItem = this.findGroupFor(groupName);
            if (cbItem != null) {
                cbItem.getToolBarManager().appendToGroup(groupName, item);
                if (cbItem.hasDisplayableItems()) {
                    this.setVisible(true);
                }
            }
        }
    }

    public ToolBar createControl(Composite parent) {
        if (!this.coolItemsCreated) {
            return super.createControl(parent);
        }
        return null;
    }

    public void dispose() {
        if (!this.coolItemsCreated) {
            super.dispose();
            return;
        }
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            cbItem.getToolBarManager().dispose();
        }
        super.dispose();
    }

    public IContributionItem find(String id) {
        if (!this.coolItemsCreated) {
            return super.find(id);
        }
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            IContributionItem item = cbItem.getToolBarManager().find(id);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    protected CoolBarContributionItem findGroup(String id) {
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            if (!cbItem.getId().equals(id)) continue;
            return cbItem;
        }
        return null;
    }

    protected CoolBarContributionItem findGroupFor(String id) {
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            IContributionItem item = cbItem.getToolBarManager().find(id);
            if (item == null) continue;
            return cbItem;
        }
        return null;
    }

    public ToolBar getControl() {
        if (!this.coolItemsCreated) {
            return super.getControl();
        }
        return null;
    }

    public void prependToGroup(String groupName, IAction action) {
        if (!this.coolItemsCreated) {
            super.prependToGroup(groupName, action);
            return;
        }
        CoolBarContributionItem cbItem = this.findGroup(groupName);
        if (cbItem != null) {
            cbItem.getToolBarManager().prependToGroup(groupName, action);
            if (cbItem.hasDisplayableItems()) {
                this.setVisible(true);
            }
        } else {
            cbItem = this.findGroupFor(groupName);
            if (cbItem != null) {
                cbItem.getToolBarManager().prependToGroup(groupName, action);
                if (cbItem.hasDisplayableItems()) {
                    this.setVisible(true);
                }
            }
        }
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        if (!this.coolItemsCreated) {
            super.prependToGroup(groupName, item);
            return;
        }
        CoolBarContributionItem cbItem = this.findGroup(groupName);
        if (cbItem != null) {
            cbItem.getToolBarManager().prependToGroup(groupName, item);
            if (cbItem.hasDisplayableItems()) {
                this.setVisible(true);
            }
        } else {
            cbItem = this.findGroupFor(groupName);
            if (cbItem != null) {
                cbItem.getToolBarManager().prependToGroup(groupName, item);
                if (cbItem.hasDisplayableItems()) {
                    this.setVisible(true);
                }
            }
        }
    }

    public void update(boolean force) {
        if (!this.coolItemsCreated) {
            super.update(force);
            return;
        }
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            cbItem.getToolBarManager().update(force);
        }
        this.getParentManager().update(force);
    }

    public CoolItemMultiToolBarManager(CoolBarManager parentManager, String id, boolean active) {
        super(parentManager.getStyle());
        this.parentManager = parentManager;
        this.active = active;
        this.id = id;
    }

    public void createCoolBarContributionItems() {
        if (!this.isCoolItemGrouped()) {
            this.add((IContributionItem)new GroupMarker("group.editor"));
            CoolBarContributionItem coolBarItem = new CoolBarContributionItem(this.parentManager, this, this.id);
            this.parentManager.add((IContributionItem)coolBarItem);
            this.setVisible(this.active);
            return;
        }
        ArrayList groupedItems = this.getGroups();
        if (groupedItems.size() > 0) {
            this.coolItemsCreated = true;
        }
        Iterator groupIter = ((AbstractList)groupedItems).iterator();
        while (groupIter.hasNext()) {
            ArrayList items = (ArrayList)groupIter.next();
            if (items.isEmpty()) continue;
            String groupId = ((IContributionItem)items.get(0)).getId();
            CoolItemToolBarManager tBarMgr = this.createGroup(groupId);
            Iterator itemIter = ((AbstractList)items).iterator();
            while (itemIter.hasNext()) {
                tBarMgr.add((IContributionItem)itemIter.next());
            }
        }
    }

    protected CoolItemToolBarManager createGroup(String groupId) {
        CoolItemToolBarManager tBarMgr = new CoolItemToolBarManager(this.parentManager.getStyle());
        tBarMgr.setOverrides(this.getOverrides());
        CoolBarContributionItem coolBarItem = new CoolBarContributionItem(this.parentManager, tBarMgr, groupId);
        this.parentManager.add((IContributionItem)coolBarItem);
        this.coolBarItems.add(coolBarItem);
        coolBarItem.setVisible(this.active);
        return tBarMgr;
    }

    protected CoolBarContributionItem getCoolBarItem() {
        if (!this.coolItemsCreated) {
            return super.getCoolBarItem();
        }
        return null;
    }

    public IContributionItem[] getItems() {
        if (!this.coolItemsCreated) {
            return super.getItems();
        }
        ArrayList<IContributionItem> allItems = new ArrayList<IContributionItem>();
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            IContributionItem[] items = cbItem.getToolBarManager().getItems();
            int i = 0;
            while (i < items.length) {
                allItems.add(items[i]);
                ++i;
            }
        }
        IContributionItem[] items = new IContributionItem[allItems.size()];
        allItems.toArray(items);
        return items;
    }

    protected boolean hasDynamicItems() {
        if (!this.coolItemsCreated) {
            return super.hasDynamicItems();
        }
        return false;
    }

    protected ArrayList getGroups() {
        ArrayList groups = new ArrayList();
        IContributionItem[] items = this.getItems();
        if (items.length == 0) {
            return groups;
        }
        ArrayList<Object> group = new ArrayList<Object>();
        IContributionItem firstItem = items[0];
        int start = 0;
        if (this.isCoolItemMarker(firstItem)) {
            group.add(firstItem);
            start = 1;
        } else {
            group.add((Object)new CoolItemGroupMarker(this.id));
        }
        int i = start;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (this.isCoolItemMarker(item)) {
                groups.add(group);
                group = new ArrayList();
                group.add(item);
            } else {
                group.add(item);
            }
            ++i;
        }
        groups.add(group);
        return groups;
    }

    public void insertAfter(String ID, IAction action) {
        if (!this.coolItemsCreated) {
            super.insertAfter(ID, action);
            return;
        }
        CoolBarContributionItem cbItem = this.findGroupFor(ID);
        if (cbItem != null) {
            cbItem.getToolBarManager().insertAfter(ID, action);
            if (cbItem.hasDisplayableItems()) {
                this.setVisible(true);
            }
        }
    }

    public void insertAfter(String ID, IContributionItem item) {
        if (!this.coolItemsCreated) {
            super.insertAfter(ID, item);
            return;
        }
        CoolBarContributionItem cbItem = this.findGroupFor(ID);
        if (cbItem != null) {
            cbItem.getToolBarManager().insertAfter(ID, item);
            if (cbItem.hasDisplayableItems()) {
                this.setVisible(true);
            }
        }
    }

    public void insertBefore(String ID, IAction action) {
        if (!this.coolItemsCreated) {
            super.insertBefore(ID, action);
            return;
        }
        CoolBarContributionItem cbItem = this.findGroupFor(ID);
        if (cbItem != null) {
            cbItem.getToolBarManager().insertBefore(ID, action);
            if (cbItem.hasDisplayableItems()) {
                this.setVisible(true);
            }
        }
    }

    public void insertBefore(String ID, IContributionItem item) {
        if (!this.coolItemsCreated) {
            super.insertBefore(ID, item);
            return;
        }
        CoolBarContributionItem cbItem = this.findGroupFor(ID);
        if (cbItem != null) {
            cbItem.getToolBarManager().insertBefore(ID, item);
            if (cbItem.hasDisplayableItems()) {
                this.setVisible(true);
            }
        }
    }

    public boolean isDirty() {
        if (!this.coolItemsCreated) {
            return super.isDirty();
        }
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            if (!cbItem.getToolBarManager().isDirty()) continue;
            return true;
        }
        return super.isDirty();
    }

    protected boolean isCoolItemMarker(IContributionItem item) {
        return item instanceof CoolItemGroupMarker;
    }

    protected boolean isCoolItemGrouped() {
        IContributionItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (this.isCoolItemMarker(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IContributionItem remove(IContributionItem item) {
        if (!this.coolItemsCreated) {
            return super.remove(item);
        }
        CoolBarContributionItem cbItem = this.findGroupFor(item.getId());
        if (cbItem != null) {
            IContributionItem removed = cbItem.getToolBarManager().remove(item);
            if (!cbItem.hasDisplayableItems()) {
                cbItem.setVisible(false);
            }
            return removed;
        }
        return null;
    }

    public IContributionItem remove(String ID) {
        if (!this.coolItemsCreated) {
            return super.remove(ID);
        }
        CoolBarContributionItem cbItem = this.findGroupFor(ID);
        if (cbItem != null) {
            IContributionItem removed = cbItem.getToolBarManager().remove(ID);
            if (!cbItem.hasDisplayableItems()) {
                cbItem.setVisible(false);
            }
            return removed;
        }
        return null;
    }

    public void removeAll() {
        if (!this.coolItemsCreated) {
            super.removeAll();
            return;
        }
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            cbItem.getToolBarManager().removeAll();
        }
        this.coolBarItems.clear();
        this.setDirty(true);
    }

    protected void setCoolBarItem(CoolBarContributionItem coolBarItem) {
        if (!this.coolItemsCreated) {
            super.setCoolBarItem(coolBarItem);
        }
    }

    protected void setVisible(boolean set) {
        super.setVisible(set);
        if (!this.coolItemsCreated) {
            return;
        }
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            cbItem.setVisible(set);
        }
    }

    protected void setVisible(boolean set, boolean forceVisibility) {
        super.setVisible(set, forceVisibility);
        if (!this.coolItemsCreated) {
            return;
        }
        Iterator e = ((AbstractList)this.coolBarItems).iterator();
        while (e.hasNext()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
            cbItem.setVisible(set, forceVisibility);
        }
    }
}

