/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.CoolBarManager;
import org.eclipse.ui.internal.CoolItemGroup;
import org.eclipse.ui.internal.CoolItemGroupSeparator;
import org.eclipse.ui.internal.ICoolItemGroup;
import org.eclipse.ui.internal.PluginActionCoolBarContributionItem;

public class CoolItemToolBarManager
extends ToolBarManager {
    CoolBarManager parentManager;
    CoolBarContributionItem coolBarItem;

    public CoolItemToolBarManager(int style) {
        super(style);
    }

    void addBaseGroup(String groupId, boolean separator) {
        ICoolItemGroup group = separator ? new CoolItemGroupSeparator(groupId, this.coolBarItem.getId()) : new CoolItemGroup(groupId, this.coolBarItem.getId());
        int index = this.findGroupInsertionPoint(this.coolBarItem.getId());
        this.insert(index, (IContributionItem)group);
    }

    void addAdjunctItemToGroup(String groupId, String contributingId, IContributionItem actionContribution) {
        int index = this.findItemInsertionPointInGroup(contributingId, groupId);
        this.insert(index, actionContribution);
    }

    void addBaseItemToGroup(String groupId, IContributionItem actionContribution) {
        int index = this.findItemInsertionPointInGroup(this.coolBarItem.getId(), groupId);
        this.insert(index, actionContribution);
    }

    void addAdjunctGroup(String groupId, String contributingId) {
        CoolItemGroupSeparator group = new CoolItemGroupSeparator(groupId, contributingId);
        int index = this.findGroupInsertionPoint(contributingId);
        this.insert(index, (IContributionItem)group);
    }

    public ToolBar createControl(Composite parent) {
        ToolBar tBar = super.createControl(parent);
        tBar.setMenu(this.parentManager.getCoolBarMenu());
        return tBar;
    }

    public void dispose() {
        ToolBar tBar = this.getControl();
        if (tBar != null) {
            tBar.setMenu(null);
        }
        super.dispose();
    }

    protected CoolBarContributionItem getCoolBarItem() {
        return this.coolBarItem;
    }

    protected int findEndOfGroup(String groupId) {
        int i = this.indexOf(groupId);
        if (i == -1) {
            return i;
        }
        ++i;
        IContributionItem[] items = this.getItems();
        while (i < items.length) {
            ContributionItem item = (ContributionItem)items[i];
            if (item instanceof ICoolItemGroup) break;
            ++i;
        }
        return i;
    }

    protected int findGroupInsertionPoint(String contributingId) {
        IContributionItem[] items = this.getItems();
        int i = 0;
        IContributionItem lastGroup = null;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (item instanceof ICoolItemGroup) {
                ICoolItemGroup itemGroup = (ICoolItemGroup)item;
                int compare = contributingId.compareTo(itemGroup.getContributingId());
                if (compare < 0) break;
                if (compare == 0) {
                    lastGroup = item;
                }
            }
            ++i;
        }
        if (lastGroup != null) {
            i = this.findEndOfGroup(lastGroup.getId());
        }
        return i;
    }

    protected int findItemInsertionPointInGroup(String contributingId, String groupId) {
        int startIndex = this.indexOf(groupId);
        if (startIndex == -1) {
            return -1;
        }
        ++startIndex;
        IContributionItem[] items = this.getItems();
        while (startIndex < items.length) {
            String id;
            int compare;
            IContributionItem item = items[startIndex];
            if (item instanceof ICoolItemGroup || (compare = contributingId.compareTo(id = item instanceof PluginActionCoolBarContributionItem ? ((PluginActionCoolBarContributionItem)item).getActionSetId() : this.coolBarItem.getId())) == 0 || compare < 0) break;
            ++startIndex;
        }
        return startIndex;
    }

    protected CoolBarManager getParentManager() {
        return this.parentManager;
    }

    protected boolean isVisible() {
        if (this.coolBarItem == null) {
            return false;
        }
        return this.coolBarItem.isVisible();
    }

    protected void itemAdded(IContributionItem item) {
        super.itemAdded(item);
        this.update(true);
        this.parentManager.updateSizeFor(this.coolBarItem);
    }

    protected void itemRemoved(IContributionItem item) {
        super.itemRemoved(item);
        this.update(true);
        this.parentManager.updateSizeFor(this.coolBarItem);
    }

    protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
    }

    protected void setCoolBarItem(CoolBarContributionItem coolBarItem) {
        this.coolBarItem = coolBarItem;
    }

    protected void setParentMgr(CoolBarManager parentManager) {
        this.parentManager = parentManager;
    }

    protected void setVisible(boolean set) {
        if (this.coolBarItem != null) {
            this.coolBarItem.setVisible(set);
        }
    }

    protected void setVisible(boolean set, boolean forceVisibility) {
        if (this.coolBarItem != null) {
            this.coolBarItem.setVisible(set, forceVisibility);
        }
    }
}

