/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.commands.Manager;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.Stroke;

public class CyclePartAction
extends PageEventAction {
    String commandForward = null;
    String commandBackward = null;
    boolean forward;
    private Object selection;

    protected CyclePartAction(IWorkbenchWindow window, boolean forward) {
        super("", window);
        this.forward = forward;
        this.setText();
        window.getPartService().addPartListener(this);
        this.updateState();
    }

    protected void setText() {
        if (this.forward) {
            this.setText(WorkbenchMessages.getString("CyclePartAction.next.text"));
            this.setToolTipText(WorkbenchMessages.getString("CyclePartAction.next.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.cycle_part_forward_action_context");
        } else {
            this.setText(WorkbenchMessages.getString("CyclePartAction.prev.text"));
            this.setToolTipText(WorkbenchMessages.getString("CyclePartAction.prev.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.cycle_part_backward_action_context");
        }
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        this.updateState();
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        this.updateState();
    }

    protected void dispose() {
    }

    protected void updateState() {
        WorkbenchPage page = (WorkbenchPage)this.getActivePage();
        if (page == null) {
            this.setEnabled(false);
            return;
        }
        int count = page.getViewReferences().length;
        if (page.getSortedEditors().length > 0) {
            ++count;
        }
        this.setEnabled(count >= 1);
    }

    public void runWithEvent(Event e) {
        IWorkbenchPage page = this.getActivePage();
        this.openDialog((WorkbenchPage)page);
        this.activate(page, this.selection);
    }

    public void activate(IWorkbenchPage page, Object selection) {
        if (selection != null) {
            IWorkbenchPart part;
            if (selection instanceof IEditorReference) {
                page.setEditorAreaVisible(true);
            }
            if ((part = ((IWorkbenchPartReference)selection).getPart(true)) != null) {
                page.activate(part);
            }
        }
    }

    private void openDialog(WorkbenchPage page) {
        block9: {
            this.selection = null;
            final Shell dialog = new Shell(this.getWorkbenchWindow().getShell(), 0);
            Display display = dialog.getDisplay();
            dialog.setLayout((Layout)new FillLayout());
            Table table = new Table((Composite)dialog, 65540);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableColumn tc = new TableColumn(table, 0);
            tc.setResizable(false);
            tc.setText(this.getTableHeader());
            this.addItems(table, page);
            int tableItemCount = table.getItemCount();
            switch (tableItemCount) {
                case 0: {
                    break;
                }
                case 1: {
                    table.setSelection(0);
                    break;
                }
                default: {
                    table.setSelection(this.forward ? 1 : table.getItemCount() - 1);
                }
            }
            tc.pack();
            table.pack();
            Rectangle tableBounds = table.getBounds();
            tableBounds.height = Math.min(tableBounds.height, table.getItemHeight() * 22);
            table.setBounds(tableBounds);
            dialog.pack();
            tc.setWidth(table.getClientArea().width);
            table.setFocus();
            table.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    CyclePartAction.this.cancel(dialog);
                }
            });
            Rectangle dialogBounds = dialog.getBounds();
            Rectangle displayBounds = display.getClientArea();
            Rectangle parentBounds = dialog.getParent().getBounds();
            dialogBounds.x = parentBounds.x + (parentBounds.width - dialogBounds.width) / 2;
            dialogBounds.y = parentBounds.y + (parentBounds.height - dialogBounds.height) / 2;
            if (!displayBounds.contains(dialogBounds.x, dialogBounds.y) || !displayBounds.contains(dialogBounds.x + dialogBounds.width, dialogBounds.y + dialogBounds.height)) {
                dialogBounds.x = (displayBounds.width - dialogBounds.width) / 2;
                dialogBounds.y = (displayBounds.height - dialogBounds.height) / 2;
            }
            dialogBounds.height = dialogBounds.height + 3 - table.getHorizontalBar().getSize().y;
            dialog.setBounds(dialogBounds);
            table.removeHelpListener(this.getHelpListener());
            table.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent event) {
                }
            });
            try {
                dialog.open();
                this.addMouseListener(table, dialog);
                this.addKeyListener(table, dialog);
                while (!dialog.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (!dialog.isDisposed()) {
                    this.cancel(dialog);
                }
                throw throwable;
            }
            Object var11_13 = null;
            if (dialog.isDisposed()) break block9;
            this.cancel(dialog);
        }
    }

    protected String getTableHeader() {
        return WorkbenchMessages.getString("CyclePartAction.header");
    }

    protected void addItems(Table table, WorkbenchPage page) {
        IWorkbenchPartReference[] refs = page.getSortedParts();
        boolean includeEditor = true;
        int i = refs.length - 1;
        while (i >= 0) {
            if (refs[i] instanceof IEditorReference) {
                if (includeEditor) {
                    IEditorReference activeEditor = (IEditorReference)refs[i];
                    TableItem item = new TableItem(table, 0);
                    item.setText(WorkbenchMessages.getString("CyclePartAction.editor"));
                    item.setImage(activeEditor.getTitleImage());
                    item.setData((Object)activeEditor);
                    includeEditor = false;
                }
            } else {
                TableItem item = new TableItem(table, 0);
                item.setText(refs[i].getTitle());
                item.setImage(refs[i].getTitleImage());
                item.setData((Object)refs[i]);
            }
            --i;
        }
    }

    private void addKeyListener(final Table table, final Shell dialog) {
        table.addKeyListener(new KeyListener(){
            private boolean firstKey = true;
            private boolean quickReleaseMode = false;

            public void keyPressed(KeyEvent e) {
                int size;
                List strokes;
                Sequence sequence;
                Iterator iterator;
                Map commandMap;
                SortedSet sequenceSet;
                int keyCode = e.keyCode;
                int stateMask = e.stateMask;
                char character = e.character;
                int accelerator = stateMask | (keyCode != 0 ? keyCode : (int)CyclePartAction.convertCharacter(character));
                boolean acceleratorForward = false;
                boolean acceleratorBackward = false;
                if (CyclePartAction.this.commandForward != null && (sequenceSet = (SortedSet)(commandMap = Manager.getInstance().getKeyMachine().getCommandMap()).get(CyclePartAction.this.commandForward)) != null) {
                    iterator = sequenceSet.iterator();
                    while (iterator.hasNext()) {
                        sequence = (Sequence)iterator.next();
                        strokes = sequence.getStrokes();
                        size = strokes.size();
                        if (size <= 0 || accelerator != ((Stroke)strokes.get(size - 1)).getValue()) continue;
                        acceleratorForward = true;
                        break;
                    }
                }
                if (CyclePartAction.this.commandBackward != null && (sequenceSet = (SortedSet)(commandMap = Manager.getInstance().getKeyMachine().getCommandMap()).get(CyclePartAction.this.commandBackward)) != null) {
                    iterator = sequenceSet.iterator();
                    while (iterator.hasNext()) {
                        sequence = (Sequence)iterator.next();
                        strokes = sequence.getStrokes();
                        size = strokes.size();
                        if (size <= 0 || accelerator != ((Stroke)strokes.get(size - 1)).getValue()) continue;
                        acceleratorBackward = true;
                        break;
                    }
                }
                if (character == '\r' || character == '\n') {
                    CyclePartAction.this.ok(dialog, table);
                } else if (acceleratorForward) {
                    if (this.firstKey && e.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    int index = table.getSelectionIndex();
                    table.setSelection((index + 1) % table.getItemCount());
                } else if (acceleratorBackward) {
                    int index;
                    if (this.firstKey && e.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    table.setSelection((index = table.getSelectionIndex()) >= 1 ? index - 1 : table.getItemCount() - 1);
                } else if (keyCode != 65536 && keyCode != 0x400000 && keyCode != 262144 && keyCode != 131072 && keyCode != 0x1000002 && keyCode != 0x1000001 && keyCode != 0x1000003 && keyCode != 0x1000004) {
                    CyclePartAction.this.cancel(dialog);
                }
                this.firstKey = false;
            }

            public void keyReleased(KeyEvent e) {
                int keyCode = e.keyCode;
                int stateMask = e.stateMask;
                char character = e.character;
                int cfr_ignored_0 = stateMask | (keyCode != 0 ? keyCode : (int)CyclePartAction.convertCharacter(character));
                if ((this.firstKey || this.quickReleaseMode) && keyCode == stateMask) {
                    CyclePartAction.this.ok(dialog, table);
                }
            }
        });
    }

    private static char convertCharacter(char c) {
        return c >= '\u0000' && c <= '\u001f' ? (char)(c + 64) : Character.toUpperCase(c);
    }

    private void ok(Shell dialog, Table table) {
        TableItem[] items = table.getSelection();
        if (items != null && items.length == 1) {
            this.selection = items[0].getData();
        }
        dialog.close();
        this.dispose();
    }

    private void cancel(Shell dialog) {
        this.selection = null;
        dialog.close();
        this.dispose();
    }

    private void addMouseListener(final Table table, final Shell dialog) {
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                CyclePartAction.this.ok(dialog, table);
            }

            public void mouseDown(MouseEvent e) {
                CyclePartAction.this.ok(dialog, table);
            }

            public void mouseUp(MouseEvent e) {
                CyclePartAction.this.ok(dialog, table);
            }
        });
    }
}

