/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.CTabPartDragDrop;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorList;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartDragDrop;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class EditorWorkbook
extends LayoutPart
implements ILayoutContainer,
IPropertyListener {
    private static final int INACTIVE = 0;
    private static final int ACTIVE_FOCUS = 1;
    private static final int ACTIVE_NOFOCUS = 2;
    private static int tabLocation = -1;
    private int activeState = 0;
    private boolean assignFocusOnSelection = true;
    private boolean ignoreTabFocusHide = false;
    private boolean handleTabSelection = true;
    private boolean mouseDownListenerAdded = false;
    private boolean isZoomed = false;
    private Composite parent;
    private CTabFolder tabFolder;
    private EditorArea editorArea;
    private EditorPane visibleEditor;
    private Map mapPartToDragMonitor = new HashMap();
    private Map mapTabToEditor = new HashMap();
    private List editors = new ArrayList();
    private ToolBar pullDownBar;
    private ToolItem pullDownButton;
    private EditorList editorList;
    private ViewForm listComposite;

    public EditorWorkbook(EditorArea editorArea) {
        super("editor workbook");
        this.editorArea = editorArea;
        this.setID(this.toString());
        if (tabLocation == -1) {
            tabLocation = this.getPreferenceStore().getInt("EDITOR_TAB_POSITION");
        }
    }

    public void add(LayoutPart part) {
        if (part instanceof EditorPane) {
            EditorPane editorPane = (EditorPane)part;
            this.editors.add(editorPane);
            editorPane.setWorkbook(this);
            editorPane.setZoomed(this.isZoomed);
            if (this.tabFolder != null) {
                this.createTab(editorPane);
                this.createPage(editorPane);
                this.setVisibleEditor(editorPane);
            }
        }
    }

    public boolean allowsBorder() {
        return false;
    }

    public void becomeActiveWorkbook(boolean hasFocus) {
        EditorArea area = this.getEditorArea();
        if (area != null) {
            area.setActiveWorkbook(this, hasFocus);
        }
    }

    public void createControl(Composite parent) {
        if (this.tabFolder != null) {
            return;
        }
        this.parent = parent;
        this.tabFolder = new CTabFolder(parent, 0x800 | tabLocation);
        this.tabFolder.setTabList(new Control[0]);
        this.tabFolder.setData((Object)this);
        this.tabFolder.addCTabFolderListener((CTabFolderListener)new CTabFolderAdapter(){

            public void itemClosed(CTabFolderEvent e) {
                e.doit = false;
                EditorPane pane = (EditorPane)EditorWorkbook.this.mapTabToEditor.get(e.item);
                pane.doHide();
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPane pane;
                if (EditorWorkbook.this.handleTabSelection && (pane = (EditorPane)EditorWorkbook.this.mapTabToEditor.get(e.item)) != null) {
                    EditorWorkbook.this.setVisibleEditor(pane);
                    if (EditorWorkbook.this.assignFocusOnSelection) {
                        EditorWorkbook.this.ignoreTabFocusHide = true;
                        pane.setFocus();
                        EditorWorkbook.this.ignoreTabFocusHide = false;
                    }
                }
            }
        });
        this.tabFolder.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                EditorWorkbook.this.setControlSize();
            }
        });
        this.tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Rectangle clientArea = EditorWorkbook.this.tabFolder.getClientArea();
                if ((EditorWorkbook.this.tabFolder.getStyle() & 0x80) != 0 ? event.y > clientArea.y : event.y < clientArea.y + clientArea.height) {
                    return;
                }
                EditorWorkbook.this.doZoom();
            }

            public void mouseDown(MouseEvent e) {
                if (EditorWorkbook.this.visibleEditor != null) {
                    CTabItem item = EditorWorkbook.this.getTab(EditorWorkbook.this.visibleEditor);
                    EditorWorkbook.this.visibleEditor.setFocus();
                    Rectangle bounds = item.getBounds();
                    if (bounds.contains(e.x, e.y)) {
                        if (e.button == 3) {
                            EditorWorkbook.this.visibleEditor.showPaneMenu((Control)EditorWorkbook.this.tabFolder, new Point(e.x, e.y));
                        } else if (e.button == 1 && EditorWorkbook.this.overImage(item, e.x)) {
                            EditorWorkbook.this.visibleEditor.showPaneMenu();
                        }
                    }
                }
            }
        });
        if (!this.mouseDownListenerAdded && this.getEditorArea() != null) {
            this.tabFolder.addListener(3, this.getEditorArea().getMouseDownListener());
            this.mouseDownListenerAdded = true;
        }
        this.enableDrop(this);
        this.editorList = new EditorList(this.getEditorArea().getWorkbenchWindow(), this);
        this.pullDownBar = new ToolBar((Composite)this.tabFolder, 0x800000);
        this.pullDownButton = new ToolItem(this.pullDownBar, 8);
        Image hotImage = WorkbenchImages.getImage("IMG_LCL_VIEW_MENU_HOVER");
        this.pullDownButton.setDisabledImage(hotImage);
        this.pullDownButton.setImage(hotImage);
        this.pullDownButton.setToolTipText(WorkbenchMessages.getString("EditorList.button.toolTip"));
        this.pullDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorWorkbook.this.openEditorList();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("EDITORLIST_PULLDOWN_ACTIVE")) {
            this.tabFolder.setTopRight((Control)this.pullDownBar);
            this.pullDownBar.setVisible(true);
        } else {
            this.pullDownBar.setVisible(false);
            this.tabFolder.setTopRight(null);
        }
        this.tabFolder.MIN_TAB_WIDTH = store.getInt("EDITOR_TAB_WIDTH");
        Iterator iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            EditorPane pane = (EditorPane)iterator.next();
            this.createTab(pane);
            this.createPage(pane);
        }
        if (this.visibleEditor != null) {
            this.setVisibleEditor(this.visibleEditor);
        } else if (this.getItemCount() > 0) {
            this.setVisibleEditor((EditorPane)this.editors.get(0));
        }
    }

    private void closeEditorList() {
        this.editorList.destroyControl();
    }

    public void openEditorList() {
        if (this.listComposite != null) {
            return;
        }
        Shell parent = this.getEditorArea().getWorkbenchWindow().getShell();
        this.listComposite = new ViewForm((Composite)parent, 2048);
        this.listComposite.setVisible(false);
        this.listComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EditorWorkbook.this.listComposite = null;
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (EditorWorkbook.this.listComposite != null) {
                    EditorWorkbook.this.closeEditorList();
                }
            }
        });
        Control editorListControl = this.editorList.createControl((Composite)this.listComposite);
        editorListControl.setVisible(false);
        Table editorsTable = (Table)editorListControl;
        TableItem[] items = editorsTable.getItems();
        if (items.length == 0) {
            this.listComposite.dispose();
            return;
        }
        this.listComposite.setContent(editorListControl);
        this.listComposite.pack();
        this.setEditorListBounds(parent);
        this.listComposite.setVisible(true);
        this.listComposite.moveAbove(null);
        editorListControl.setVisible(true);
        editorListControl.setFocus();
        editorsTable.showSelection();
        editorListControl.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (EditorWorkbook.this.listComposite != null) {
                    EditorWorkbook.this.closeEditorList();
                }
            }
        });
    }

    private void setEditorListBounds(Shell parent) {
        Rectangle r = this.listComposite.getBounds();
        int width = r.width;
        int height = Math.min(r.height, 20 * ((Table)this.editorList.getControl()).getItemHeight());
        Rectangle bounds = this.tabFolder.getClientArea();
        Point point = new Point(bounds.x + bounds.width - width, bounds.y);
        if (tabLocation == 1024) {
            point.y = bounds.y + bounds.height - height - 1;
        }
        point = this.tabFolder.toDisplay(point);
        point = parent.toControl(point);
        this.listComposite.setBounds(this.listComposite.computeTrim(point.x, point.y, width, height));
    }

    public void resizeEditorList() {
        Shell parent = this.getEditorArea().getWorkbenchWindow().getShell();
        this.listComposite.pack();
        this.setEditorListBounds(parent);
    }

    public void showPaneMenu() {
        if (this.visibleEditor != null) {
            CTabItem item = this.getTab(this.visibleEditor);
            Rectangle bounds = item.getBounds();
            this.visibleEditor.showPaneMenu((Control)this.tabFolder, new Point(bounds.x, bounds.height));
        }
    }

    boolean overImage(EditorPane pane, int x) {
        CTabItem item = this.getTab(pane);
        return this.overImage(item, x);
    }

    private boolean overImage(CTabItem item, int x) {
        Rectangle imageBounds = item.getImage().getBounds();
        return x < item.getBounds().x + imageBounds.x + imageBounds.width;
    }

    private void createPage(EditorPane editorPane) {
        editorPane.createControl(this.parent);
        editorPane.setContainer(this);
        this.enableDrop(editorPane);
        IEditorReference editorRef = editorPane.getEditorReference();
        this.updateEditorTab(editorRef);
        editorRef.addPropertyListener(this);
        if (this.mapPartToDragMonitor.size() == 1) {
            this.enableTabDrag(this, null);
        }
    }

    private CTabItem createTab(EditorPane editorPane) {
        return this.createTab(editorPane, this.tabFolder.getItemCount());
    }

    private CTabItem createTab(EditorPane editorPane, int index) {
        CTabItem tab = new CTabItem(this.tabFolder, 0, index);
        this.mapTabToEditor.put(tab, editorPane);
        this.enableTabDrag(editorPane, tab);
        this.updateEditorTab((IEditorReference)editorPane.getPartReference());
        if (this.tabFolder.getItemCount() == 1 && this.tabFolder.getTopRight() != null) {
            this.pullDownBar.setVisible(true);
        }
        return tab;
    }

    private void disableTabDrag(LayoutPart part) {
        PartDragDrop partDragDrop = (PartDragDrop)this.mapPartToDragMonitor.get(part);
        if (partDragDrop != null) {
            partDragDrop.dispose();
            this.mapPartToDragMonitor.remove(part);
        }
    }

    public void dispose() {
        if (this.tabFolder == null) {
            return;
        }
        int i = 0;
        while (i < this.editors.size()) {
            this.removeListeners((EditorPane)this.editors.get(i));
            ++i;
        }
        this.editors.clear();
        this.setVisibleEditor(null);
        i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem tab = this.tabFolder.getItem(i);
            if (tab.getDisabledImage() != null) {
                tab.getDisabledImage().dispose();
            }
            ++i;
        }
        this.tabFolder.dispose();
        this.tabFolder = null;
        this.mouseDownListenerAdded = false;
        this.mapTabToEditor.clear();
    }

    private void doZoom() {
        if (this.visibleEditor == null) {
            return;
        }
        this.visibleEditor.getPage().toggleZoom(this.visibleEditor.getPartReference());
    }

    void drawGradient() {
        int[] bgPercents;
        Color[] bgColors;
        Color fgColor;
        if (this.tabFolder == null) {
            return;
        }
        switch (this.activeState) {
            case 1: {
                if (this.getShellActivated()) {
                    fgColor = WorkbenchColors.getSystemColor(30);
                    bgColors = WorkbenchColors.getActiveEditorGradient();
                    bgPercents = WorkbenchColors.getActiveEditorGradientPercents();
                    break;
                }
                fgColor = WorkbenchColors.getSystemColor(33);
                bgColors = WorkbenchColors.getDeactivatedEditorGradient();
                bgPercents = WorkbenchColors.getDeactivatedEditorGradientPercents();
                break;
            }
            case 2: {
                fgColor = WorkbenchColors.getSystemColor(24);
                bgColors = WorkbenchColors.getActiveNoFocusEditorGradient();
                bgPercents = WorkbenchColors.getActiveNoFocusEditorGradientPercents();
                break;
            }
            default: {
                fgColor = null;
                bgColors = null;
                bgPercents = null;
            }
        }
        this.tabFolder.setSelectionForeground(fgColor);
        this.tabFolder.setSelectionBackground(bgColors, bgPercents);
        this.tabFolder.update();
    }

    private void enableDrop(LayoutPart part) {
        Control control = part.getControl();
        if (control != null) {
            control.setData((Object)this);
        }
    }

    private void enableTabDrag(LayoutPart part, CTabItem tab) {
        CTabPartDragDrop dragSource = new CTabPartDragDrop(part, this.tabFolder, tab);
        this.mapPartToDragMonitor.put(part, dragSource);
        dragSource.addDropListener(this.getEditorArea().getPartDropListener());
    }

    public Rectangle getBounds() {
        if (this.tabFolder == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.tabFolder.getBounds();
    }

    public int getMinimumHeight() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed() && this.getItemCount() > 0) {
            return this.tabFolder.computeTrim((int)0, (int)0, (int)0, (int)0).height - 1;
        }
        return super.getMinimumHeight();
    }

    public LayoutPart[] getChildren() {
        int nSize = this.editors.size();
        LayoutPart[] children = new LayoutPart[nSize];
        this.editors.toArray(children);
        return children;
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public EditorArea getEditorArea() {
        return this.editorArea;
    }

    public int getItemCount() {
        return this.editors.size();
    }

    public Composite getParent() {
        return this.parent;
    }

    private CTabItem getTab(LayoutPart child) {
        Iterator tabs = this.mapTabToEditor.keySet().iterator();
        while (tabs.hasNext()) {
            CTabItem tab = (CTabItem)tabs.next();
            if (this.mapTabToEditor.get(tab) != child) continue;
            return tab;
        }
        return null;
    }

    public Control[] getTabList() {
        if (this.tabFolder == null) {
            return new Control[0];
        }
        if (this.visibleEditor == null) {
            return new Control[]{this.tabFolder};
        }
        if ((this.tabFolder.getStyle() & 0x80) != 0) {
            return new Control[]{this.tabFolder, this.visibleEditor.getControl()};
        }
        return new Control[]{this.visibleEditor.getControl(), this.tabFolder};
    }

    public void showVisibleEditor() {
        if (this.tabFolder != null) {
            this.tabFolder.showSelection();
        }
    }

    public EditorPane getVisibleEditor() {
        return this.visibleEditor;
    }

    public boolean isActiveWorkbook() {
        return this.getEditorArea().isActiveWorkbook(this);
    }

    public boolean isDragAllowed(Point p) {
        if (this.isZoomed) {
            return false;
        }
        if (this.getEditorArea().getEditorWorkbookCount() == 1) {
            return false;
        }
        return this.visibleEditor != null && !this.overImage(this.visibleEditor, p.x);
    }

    public void openTracker(LayoutPart part) {
        CTabPartDragDrop dnd = (CTabPartDragDrop)this.mapPartToDragMonitor.get(part);
        dnd.openTracker();
    }

    public void propertyChanged(Object source, int property) {
        if ((property == 257 || property == 1) && source instanceof IEditorPart) {
            this.updateEditorTab((IEditorPart)source);
        }
    }

    public void remove(LayoutPart child) {
        int tabIndex = this.editors.indexOf(child);
        if (tabIndex < 0) {
            return;
        }
        this.editors.remove(child);
        this.removeListeners((EditorPane)child);
        if (this.visibleEditor == child) {
            EditorPane nextEditor = null;
            int maxIndex = this.editors.size() - 1;
            if (maxIndex >= 0) {
                tabIndex = Math.min(tabIndex, maxIndex);
                nextEditor = (EditorPane)this.editors.get(tabIndex);
            }
            if (this.tabFolder != null) {
                this.removeTab(this.getTab(child));
                child.setContainer(null);
                if (this.tabFolder.getItemCount() == 0) {
                    this.pullDownBar.setVisible(false);
                }
            }
            this.setVisibleEditor(nextEditor);
        } else if (this.tabFolder != null) {
            this.removeTab(this.getTab(child));
            child.setContainer(null);
            if (this.tabFolder.getItemCount() == 0) {
                this.pullDownBar.setVisible(false);
            }
        }
    }

    public void removeAll() {
        this.handleTabSelection = false;
        this.setVisibleEditor(null);
        if (this.tabFolder != null) {
            Iterator tabs = this.mapTabToEditor.keySet().iterator();
            while (tabs.hasNext()) {
                CTabItem tab = (CTabItem)tabs.next();
                if (tab.getDisabledImage() != null) {
                    tab.getDisabledImage().dispose();
                }
                tab.dispose();
                EditorPane child = (EditorPane)this.mapTabToEditor.get(tab);
                this.removeListeners(child);
                child.setContainer(null);
            }
            this.pullDownBar.setVisible(false);
        }
        this.mapTabToEditor.clear();
        this.editors.clear();
        this.handleTabSelection = true;
    }

    private void removeListeners(EditorPane editor) {
        if (editor == null) {
            return;
        }
        this.disableTabDrag(editor);
        if (this.mapPartToDragMonitor.size() == 1) {
            this.disableTabDrag(this);
        }
        editor.getPartReference().removePropertyListener(this);
    }

    private void removeTab(CTabItem tab) {
        if (this.tabFolder != null && tab != null) {
            this.mapTabToEditor.remove(tab);
            if (tab.getDisabledImage() != null) {
                tab.getDisabledImage().dispose();
            }
            this.assignFocusOnSelection = false;
            tab.dispose();
            this.assignFocusOnSelection = true;
        }
    }

    public void reorderTab(EditorPane pane, int x, int y) {
        int targetIndex;
        CTabItem targetTab;
        CTabItem sourceTab = this.getTab(pane);
        if (sourceTab == null) {
            return;
        }
        Point location = new Point(1, 1);
        if ((this.tabFolder.getStyle() & 0x400) != 0) {
            location.y = this.tabFolder.getSize().y - 4;
        }
        if (x > location.x) {
            location.x = x;
        }
        if ((targetTab = this.tabFolder.getItem(location)) == null) {
            if (this.tabFolder.indexOf(sourceTab) != this.tabFolder.getItemCount() - 1) {
                this.reorderTab(pane, sourceTab, -1);
            }
            return;
        }
        if (targetTab == sourceTab) {
            return;
        }
        int sourceIndex = this.tabFolder.indexOf(sourceTab);
        if (sourceIndex == (targetIndex = this.tabFolder.indexOf(targetTab)) - 1) {
            return;
        }
        if (sourceIndex < targetIndex) {
            --targetIndex;
        }
        this.reorderTab(pane, sourceTab, targetIndex);
    }

    public void reorderTab(EditorPane pane, int newIndex) {
        this.reorderTab(pane, this.getTab(pane), newIndex);
    }

    private void reorderTab(EditorPane pane, CTabItem sourceTab, int newIndex) {
        int oldIndex = this.tabFolder.indexOf(sourceTab);
        if (newIndex < 0) {
            if (oldIndex == this.tabFolder.getItemCount() - 1) {
                return;
            }
            if (oldIndex == newIndex) {
                return;
            }
        }
        boolean wasVisible = this.tabFolder.getSelection() == sourceTab;
        this.disableTabDrag(pane);
        this.removeTab(sourceTab);
        CTabItem newTab = newIndex < 0 ? this.createTab(pane) : this.createTab(pane, newIndex);
        CTabPartDragDrop partDragDrop = (CTabPartDragDrop)this.mapPartToDragMonitor.get(pane);
        partDragDrop.setTab(newTab);
        this.editors.remove(pane);
        if (newIndex < 0) {
            this.editors.add(pane);
        } else {
            this.editors.add(newIndex, pane);
        }
        if (wasVisible) {
            this.tabFolder.setSelection(newTab);
            this.setVisibleEditor(pane);
        }
    }

    public void replace(LayoutPart oldPart, LayoutPart newPart) {
    }

    private void setActiveState(int state) {
        if (this.activeState != state) {
            this.activeState = state;
            this.drawGradient();
        }
    }

    public void setBounds(Rectangle r) {
        if (this.tabFolder != null) {
            this.tabFolder.setBounds(r);
            this.setControlSize();
        }
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
        if (!this.mouseDownListenerAdded && this.getEditorArea() != null && this.tabFolder != null) {
            this.tabFolder.addListener(3, this.getEditorArea().getMouseDownListener());
            this.mouseDownListenerAdded = true;
        }
    }

    private void setControlSize() {
        if (this.visibleEditor == null || this.tabFolder == null) {
            return;
        }
        Rectangle bounds = PartTabFolder.calculatePageBounds(this.tabFolder);
        this.visibleEditor.setBounds(bounds);
        this.visibleEditor.moveAbove((Control)this.tabFolder);
    }

    public void setVisibleEditor(EditorPane comp) {
        IWorkbenchPart part;
        if (this.tabFolder == null) {
            this.visibleEditor = comp;
            return;
        }
        if (comp != null && (part = comp.getPartReference().getPart(true)) == null) {
            comp = null;
        }
        if (this.visibleEditor != null && this.visibleEditor != comp) {
            this.visibleEditor.setVisible(false);
        }
        this.visibleEditor = comp;
        if (this.visibleEditor != null) {
            CTabItem key = this.getTab(this.visibleEditor);
            if (key != null) {
                int index = this.tabFolder.indexOf(key);
                this.tabFolder.setSelection(index);
            }
            this.setControlSize();
            if (this.visibleEditor != null) {
                this.visibleEditor.setVisible(true);
            }
            this.becomeActiveWorkbook(this.activeState == 1);
        }
    }

    public void tabFocusHide() {
        if (this.tabFolder == null || this.ignoreTabFocusHide) {
            return;
        }
        if (this.isActiveWorkbook()) {
            this.setActiveState(2);
        } else {
            this.setActiveState(0);
        }
    }

    public void tabFocusShow(boolean hasFocus) {
        if (this.tabFolder == null) {
            return;
        }
        if (hasFocus) {
            this.setActiveState(1);
        } else {
            this.setActiveState(2);
        }
    }

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        if (dragSource instanceof EditorPane || dragSource instanceof EditorWorkbook) {
            return this;
        }
        return this.getEditorArea();
    }

    public void updateEditorTab(IEditorPart part) {
        PartPane pane = ((EditorSite)part.getSite()).getPane();
        String title = part.getTitle();
        boolean isDirty = part.isDirty();
        Image image = part.getTitleImage();
        String toolTip = part.getTitleToolTip();
        this.updateEditorTab(pane, title, isDirty, image, toolTip);
    }

    public void updateEditorTab(IEditorReference ref) {
        PartPane pane = ((WorkbenchPartReference)((Object)ref)).getPane();
        String title = ref.getTitle();
        boolean isDirty = ref.isDirty();
        Image image = ref.getTitleImage();
        String toolTip = ref.getTitleToolTip();
        this.updateEditorTab(pane, title, isDirty, image, toolTip);
    }

    public void updateEditorTab(PartPane pane, String title, boolean isDirty, Image image, String toolTip) {
        CTabItem tab = this.getTab(pane);
        if (tab == null) {
            return;
        }
        if (isDirty) {
            title = "*" + title;
        }
        tab.setText(title);
        boolean useColorIcons = ActionContributionItem.getUseColorIconsInToolbars();
        if (image == null || image.isDisposed()) {
            Image disableImage;
            tab.setImage(null);
            if (!useColorIcons && (disableImage = tab.getDisabledImage()) != null) {
                disableImage.dispose();
                tab.setDisabledImage(null);
            }
        } else if (!image.equals((Object)tab.getImage())) {
            tab.setImage(image);
            if (!useColorIcons) {
                Image disableImage = tab.getDisabledImage();
                if (disableImage != null) {
                    disableImage.dispose();
                }
                Display display = tab.getDisplay();
                disableImage = new Image((Device)display, image, 1);
                tab.setDisabledImage(disableImage);
            }
        }
        tab.setToolTipText(toolTip);
        tab.getParent().update();
    }

    public void zoomIn() {
        if (this.isZoomed) {
            return;
        }
        this.isZoomed = true;
        Iterator iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            ((EditorPane)iterator.next()).setZoomed(true);
        }
    }

    public void zoomOut() {
        if (!this.isZoomed) {
            return;
        }
        this.isZoomed = false;
        Iterator iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            ((EditorPane)iterator.next()).setZoomed(false);
        }
    }

    public EditorPane[] getEditors() {
        int nSize = this.editors.size();
        EditorPane[] children = new EditorPane[nSize];
        this.editors.toArray(children);
        return children;
    }
}

