/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.commands.Manager;

public final class KeyBindingService
implements INestableKeyBindingService {
    private SortedMap commandIdToActionMap = new TreeMap();
    private String[] scopes = new String[]{"org.eclipse.ui.globalScope"};
    private final Map nestedServices = new HashMap();
    private IKeyBindingService activeService = null;

    public KeyBindingService(IWorkbenchSite partSite) {
        EditorActionBuilder.ExternalContributor contributor;
        if (partSite instanceof EditorSite && (contributor = (EditorActionBuilder.ExternalContributor)((EditorSite)partSite).getExtensionActionBarContributor()) != null) {
            this.registerExtendedActions(contributor.getExtendedActions());
        }
    }

    IAction getAction(String command) {
        IAction action = null;
        if (this.activeService instanceof KeyBindingService) {
            action = ((KeyBindingService)this.activeService).getAction(command);
        }
        if (action == null) {
            action = (IAction)this.commandIdToActionMap.get(command);
        }
        return action;
    }

    void registerExtendedActions(ActionDescriptor[] actionDescriptors) {
        if (actionDescriptors != null) {
            int i = 0;
            while (i < actionDescriptors.length) {
                PluginAction action;
                ActionDescriptor actionDescriptor = actionDescriptors[i];
                if (actionDescriptor != null && (action = actionDescriptors[i].getAction()) != null && action.getActionDefinitionId() != null) {
                    this.registerAction((IAction)action);
                }
                ++i;
            }
        }
    }

    public String[] getScopes() {
        String[] nestedScopes = this.activeService == null ? (String[])null : this.activeService.getScopes();
        HashSet<String> activeScopes = new HashSet<String>();
        int i = 0;
        while (i < this.scopes.length) {
            activeScopes.add(this.scopes[i]);
            ++i;
        }
        if (nestedScopes != null) {
            i = 0;
            while (i < nestedScopes.length) {
                activeScopes.add(nestedScopes[i]);
                ++i;
            }
        }
        return activeScopes.toArray(new String[activeScopes.size()]);
    }

    public void setScopes(String[] scopes) throws IllegalArgumentException {
        if (scopes == null || scopes.length < 1) {
            throw new IllegalArgumentException();
        }
        this.scopes = (String[])scopes.clone();
        int i = 0;
        while (i < scopes.length) {
            if (scopes[i] == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    public void registerAction(IAction action) {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.commandIdToActionMap.put(command, action);
        }
    }

    public void unregisterAction(IAction action) {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.commandIdToActionMap.remove(command);
        }
    }

    public String getActiveAcceleratorConfigurationId() {
        return Manager.getInstance().getKeyMachine().getConfiguration();
    }

    public String getActiveAcceleratorScopeId() {
        return this.getScopes()[0];
    }

    public void setActiveAcceleratorScopeId(String scopeId) throws IllegalArgumentException {
        this.setScopes(new String[]{scopeId});
    }

    public boolean processKey(KeyEvent event) {
        return false;
    }

    public void enable(boolean enable) {
    }

    public boolean activateKeyBindingService(IWorkbenchSite nestedSite) {
        if (nestedSite == null) {
            if (this.activeService == null) {
                return false;
            }
            this.activeService = null;
            return true;
        }
        IKeyBindingService service = (IKeyBindingService)this.nestedServices.get(nestedSite);
        if (service == null) {
            return false;
        }
        this.activeService = service;
        return true;
    }

    public boolean removeKeyBindingService(IWorkbenchSite nestedSite) {
        IKeyBindingService service = (IKeyBindingService)this.nestedServices.remove(nestedSite);
        if (service == null) {
            return false;
        }
        if (service.equals(this.activeService)) {
            this.activeService = null;
        }
        return true;
    }

    public IKeyBindingService getKeyBindingService(IWorkbenchSite nestedSite) {
        if (nestedSite == null) {
            return null;
        }
        IKeyBindingService service = (IKeyBindingService)this.nestedServices.get(nestedSite);
        if (service == null) {
            service = new KeyBindingService(nestedSite);
            this.nestedServices.put(nestedSite, service);
        }
        return service;
    }
}

