/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;

public class LayoutTree {
    LayoutTreeNode parent;
    LayoutPart part;

    public LayoutTree(LayoutPart part) {
        this.part = part;
    }

    public LayoutPart computeRelation(ArrayList relations) {
        return this.part;
    }

    public void disposeSashes() {
    }

    public LayoutTree find(LayoutPart child) {
        if (this.part != child) {
            return null;
        }
        return this;
    }

    public void findSashes(PartPane.Sashes sashes) {
        if (this.getParent() == null) {
            return;
        }
        this.getParent().findSashes(this, sashes);
    }

    public LayoutPart findBottomRight() {
        return this.part;
    }

    public LayoutTreeNode findSash(LayoutPartSash sash) {
        return null;
    }

    public Rectangle getBounds() {
        return this.part.getBounds();
    }

    public int getMinimumWidth() {
        return this.part.getMinimumWidth();
    }

    public int getMinimumHeight() {
        return this.part.getMinimumHeight();
    }

    public LayoutTreeNode getParent() {
        return this.parent;
    }

    public LayoutTree insert(LayoutPart child, boolean left, LayoutPartSash sash, LayoutPart relative) {
        LayoutTree relativeChild = this.find(relative);
        LayoutTreeNode node = new LayoutTreeNode(sash);
        if (relativeChild == null) {
            node.setChild(left, child);
            node.setChild(!left, this);
            return node;
        }
        LayoutTreeNode oldParent = relativeChild.getParent();
        node.setChild(left, child);
        node.setChild(!left, relativeChild);
        if (oldParent == null) {
            return node;
        }
        oldParent.replaceChild(relativeChild, node);
        return this;
    }

    public boolean isVisible() {
        return !(this.part instanceof PartPlaceholder);
    }

    public void recomputeRatio() {
    }

    public LayoutTree remove(LayoutPart child) {
        LayoutTree tree = this.find(child);
        if (tree == null) {
            return this;
        }
        LayoutTreeNode oldParent = tree.getParent();
        if (oldParent == null) {
            return null;
        }
        if (oldParent.getParent() == null) {
            return oldParent.remove(tree);
        }
        oldParent.remove(tree);
        return this;
    }

    public void setBounds(Rectangle bounds) {
        this.part.setBounds(bounds);
    }

    void setParent(LayoutTreeNode parent) {
        this.parent = parent;
    }

    void setPart(LayoutPart part) {
        this.part = part;
    }

    public String toString() {
        return "(" + this.part.toString() + ")";
    }

    public void updateSashes(Composite parent) {
    }
}

