/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.FolderLayout;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.PlaceholderFolderLayout;
import org.eclipse.ui.internal.RootLayoutContainer;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class PageLayout
implements IPageLayout {
    private ViewFactory viewFactory;
    private LayoutPart editorFolder;
    private boolean editorVisible = true;
    private RootLayoutContainer rootLayoutContainer;
    private Map mapIDtoPart = new HashMap(10);
    private Map mapIDtoFolder = new HashMap(10);
    private Map mapFastViewToWidthRatio = new HashMap(10);
    private ArrayList actionSets = new ArrayList(3);
    private ArrayList newWizardActionIds = new ArrayList(3);
    private ArrayList showViewActionIds = new ArrayList(3);
    private ArrayList perspectiveActionIds = new ArrayList(3);
    private ArrayList fastViews = new ArrayList(3);
    private ArrayList showInPartIds = new ArrayList(3);

    public PageLayout(RootLayoutContainer container, ViewFactory viewFactory, LayoutPart editorFolder) {
        this.viewFactory = viewFactory;
        this.rootLayoutContainer = container;
        this.editorFolder = editorFolder;
        this.prefill();
    }

    public PageLayout() {
    }

    private void add(String newID) {
        try {
            LayoutPart newPart = this.createView(newID);
            this.setRefPart(newID, newPart);
            this.rootLayoutContainer.add(newPart);
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(((Throwable)((Object)e)).getMessage());
        }
    }

    public void addActionSet(String actionSetID) {
        if (!this.actionSets.contains(actionSetID)) {
            this.actionSets.add(actionSetID);
        }
    }

    public void addFastView(String id) {
        this.addFastView(id, -1.0f);
    }

    public void addFastView(String id, float ratio) {
        if (this.checkPartInLayout(id)) {
            return;
        }
        if (id != null) {
            try {
                IViewReference ref = this.viewFactory.createView(id);
                this.fastViews.add(ref);
                if (ratio >= 0.05f && ratio <= 0.95f) {
                    this.mapFastViewToWidthRatio.put(id, new Float(ratio));
                }
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log(((Throwable)((Object)e)).getMessage());
            }
        }
    }

    public void addNewWizardShortcut(String id) {
        if (!this.newWizardActionIds.contains(id)) {
            this.newWizardActionIds.add(id);
        }
    }

    private void addPart(LayoutPart newPart, String partId, int relationship, float ratio, String refId) {
        this.setRefPart(partId, newPart);
        LayoutPart refPart = this.getFolderPart(refId);
        if (refPart == null) {
            refPart = this.getRefPart(refId);
        }
        if (refPart != null) {
            ratio = this.normalizeRatio(ratio);
            this.rootLayoutContainer.add(newPart, this.getPartSashConst(relationship), ratio, refPart);
        } else {
            WorkbenchPlugin.log(WorkbenchMessages.format("PageLayout.missingRefPart", new Object[]{refId}));
            this.rootLayoutContainer.add(newPart);
        }
    }

    public void addPerspectiveShortcut(String id) {
        if (!this.perspectiveActionIds.contains(id)) {
            this.perspectiveActionIds.add(id);
        }
    }

    public void addPlaceholder(String viewId, int relationship, float ratio, String refId) {
        if (this.checkPartInLayout(viewId)) {
            return;
        }
        PartPlaceholder newPart = new PartPlaceholder(viewId);
        this.addPart(newPart, viewId, relationship, ratio, refId);
    }

    public void addShowInPart(String id) {
        if (!this.showInPartIds.contains(id)) {
            this.showInPartIds.add(id);
        }
    }

    public void addShowViewShortcut(String id) {
        if (!this.showViewActionIds.contains(id)) {
            this.showViewActionIds.add(id);
        }
    }

    public void addView(String viewId, int relationship, float ratio, String refId) {
        if (this.checkPartInLayout(viewId)) {
            return;
        }
        try {
            LayoutPart newPart = this.createView(viewId);
            this.addPart(newPart, viewId, relationship, ratio, refId);
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(((Throwable)((Object)e)).getMessage());
        }
    }

    boolean checkPartInLayout(String partId) {
        if (this.getRefPart(partId) != null) {
            WorkbenchPlugin.log(WorkbenchMessages.format("PageLayout.duplicateRefPart", new Object[]{partId}));
            return true;
        }
        int i = 0;
        while (i < this.fastViews.size()) {
            if (((IViewReference)this.fastViews.get(i)).getId().equals(partId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IFolderLayout createFolder(String folderId, int relationship, float ratio, String refId) {
        if (this.checkPartInLayout(folderId)) {
            return new FolderLayout(this, (PartTabFolder)this.getRefPart(folderId), this.viewFactory);
        }
        PartTabFolder folder = new PartTabFolder();
        folder.setID(folderId);
        this.addPart(folder, folderId, relationship, ratio, refId);
        return new FolderLayout(this, folder, this.viewFactory);
    }

    public IPlaceholderFolderLayout createPlaceholderFolder(String folderId, int relationship, float ratio, String refId) {
        if (this.checkPartInLayout(folderId)) {
            return new PlaceholderFolderLayout(this, (ContainerPlaceholder)this.getRefPart(folderId));
        }
        ContainerPlaceholder folder = new ContainerPlaceholder(null);
        folder.setContainer(this.rootLayoutContainer);
        folder.setRealContainer(new PartTabFolder());
        folder.setID(folderId);
        this.addPart(folder, folderId, relationship, ratio, refId);
        return new PlaceholderFolderLayout(this, folder);
    }

    private LayoutPart createView(String partID) throws PartInitException {
        if (partID.equals("org.eclipse.ui.editorss")) {
            return this.editorFolder;
        }
        WorkbenchPartReference ref = (WorkbenchPartReference)((Object)this.viewFactory.createView(partID));
        ViewPane newPart = (ViewPane)ref.getPane();
        if (newPart == null) {
            newPart = new ViewPane((IViewReference)((Object)ref), (WorkbenchPage)ref.getPage());
            ref.setPane(newPart);
        }
        return newPart;
    }

    public ArrayList getActionSets() {
        return this.actionSets;
    }

    public String getEditorArea() {
        return "org.eclipse.ui.editorss";
    }

    public ArrayList getFastViews() {
        return this.fastViews;
    }

    Map getFastViewToWidthRatioMap() {
        return this.mapFastViewToWidthRatio;
    }

    public ArrayList getNewWizardActionIds() {
        return this.newWizardActionIds;
    }

    private int getPartSashConst(int nRelationship) {
        return nRelationship;
    }

    public ArrayList getPerspectiveActionIds() {
        return this.perspectiveActionIds;
    }

    LayoutPart getRefPart(String partID) {
        return (LayoutPart)this.mapIDtoPart.get(partID);
    }

    private PartTabFolder getFolderPart(String viewId) {
        return (PartTabFolder)this.mapIDtoFolder.get(viewId);
    }

    public RootLayoutContainer getRootLayoutContainer() {
        return this.rootLayoutContainer;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public ArrayList getShowViewActionIds() {
        return this.showViewActionIds;
    }

    public boolean isEditorAreaVisible() {
        return this.editorVisible;
    }

    private float normalizeRatio(float in) {
        if (in < 0.05f) {
            in = 0.05f;
        }
        if (in > 0.95f) {
            in = 0.95f;
        }
        return in;
    }

    private void prefill() {
        this.add("org.eclipse.ui.editorss");
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] array = reg.getActionSets();
        int count = array.length;
        int nX = 0;
        while (nX < count) {
            IActionSetDescriptor desc = array[nX];
            if (desc.isInitiallyVisible()) {
                this.addActionSet(desc.getId());
            }
            ++nX;
        }
    }

    public void setEditorAreaVisible(boolean showEditorArea) {
        this.editorVisible = showEditorArea;
    }

    void setRefPart(String partID, LayoutPart part) {
        this.mapIDtoPart.put(partID, part);
    }

    void setFolderPart(String viewId, PartTabFolder folder) {
        this.mapIDtoFolder.put(viewId, folder);
    }

    void setFolderPart(String viewId, ContainerPlaceholder container) {
        LayoutPart tabFolder = container.getRealContainer();
        this.mapIDtoFolder.put(viewId, tabFolder);
    }

    private void stackPart(LayoutPart newPart, String viewId, String refId) {
        this.setRefPart(viewId, newPart);
        PartTabFolder folder = this.getFolderPart(refId);
        if (folder != null) {
            folder.add(newPart);
            this.setFolderPart(viewId, folder);
            return;
        }
        LayoutPart refPart = this.getRefPart(refId);
        if (refPart != null) {
            PartTabFolder newFolder = new PartTabFolder();
            this.rootLayoutContainer.replace(refPart, newFolder);
            newFolder.add(refPart);
            newFolder.add(newPart);
            this.setFolderPart(refId, newFolder);
            this.setFolderPart(viewId, newFolder);
            return;
        }
        WorkbenchPlugin.log(WorkbenchMessages.format("PageLayout.missingRefPart", new Object[]{refId}));
        this.rootLayoutContainer.add(newPart);
    }

    public void stackPlaceholder(String viewId, String refId) {
        if (this.checkPartInLayout(viewId)) {
            return;
        }
        PartPlaceholder newPart = new PartPlaceholder(viewId);
        this.stackPart(newPart, viewId, refId);
    }

    public void stackView(String viewId, String refId) {
        if (this.checkPartInLayout(viewId)) {
            return;
        }
        try {
            LayoutPart newPart = this.createView(viewId);
            this.stackPart(newPart, viewId, refId);
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(((Throwable)((Object)e)).getMessage());
        }
    }

    public int getEditorReuseThreshold() {
        return -1;
    }

    public void setEditorReuseThreshold(int openEditors) {
    }
}

