/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.part.WorkbenchPart;

public abstract class PartPane
extends LayoutPart
implements Listener {
    private boolean isZoomed = false;
    private MenuManager paneMenuManager;
    protected IWorkbenchPartReference partReference;
    protected WorkbenchPage page;
    protected ViewForm control;

    public PartPane(IWorkbenchPartReference partReference, WorkbenchPage workbenchPage) {
        super(partReference.getId());
        this.partReference = partReference;
        this.page = workbenchPage;
        ((WorkbenchPartReference)partReference).setPane(this);
    }

    protected void createChildControl() {
        final IWorkbenchPart[] part = new IWorkbenchPart[]{this.partReference.getPart(false)};
        if (part[0] == null) {
            return;
        }
        if (this.control == null || this.control.getContent() != null) {
            return;
        }
        final Composite content = new Composite((Composite)this.control, 0);
        content.setLayout((Layout)new FillLayout());
        String error = WorkbenchMessages.format("PartPane.unableToCreate", new Object[]{this.partReference.getTitle()});
        Platform.run((ISafeRunnable)new SafeRunnable(error){

            public void run() {
                try {
                    UIStats.start(UIStats.CREATE_PART_CONTROL, PartPane.this.id);
                    part[0].createPartControl(content);
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    UIStats.end(UIStats.CREATE_PART_CONTROL, PartPane.this.id);
                    throw throwable;
                }
                Object var1_3 = null;
                UIStats.end(UIStats.CREATE_PART_CONTROL, PartPane.this.id);
            }

            public void handleException(Throwable e) {
                Workbench wb = (Workbench)WorkbenchPlugin.getDefault().getWorkbench();
                if (!wb.isStarting()) {
                    super.handleException(e);
                }
                Control[] children = content.getChildren();
                int i = 0;
                while (i < children.length) {
                    children[i].dispose();
                    ++i;
                }
                WorkbenchPart newPart = PartPane.this.createErrorPart((WorkbenchPart)part[0]);
                part[0].getSite().setSelectionProvider(null);
                newPart.createPartControl(content);
                ((WorkbenchPartReference)PartPane.this.partReference).setPart(newPart);
                part[0] = newPart;
            }
        });
        this.control.setContent((Control)content);
        this.page.addPart(this.partReference);
        this.page.firePartOpened(part[0]);
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null) {
            return;
        }
        this.control = new ViewForm(parent, this.getStyle());
        this.control.marginWidth = 0;
        this.control.marginHeight = 0;
        this.createTitleBar();
        this.createChildControl();
        this.control.addListener(26, (Listener)this);
    }

    protected abstract WorkbenchPart createErrorPart(WorkbenchPart var1);

    protected abstract void createTitleBar();

    public void dispose() {
        super.dispose();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(26, (Listener)this);
            this.control.dispose();
            this.control = null;
        }
        if (this.paneMenuManager != null) {
            this.paneMenuManager.dispose();
            this.paneMenuManager = null;
        }
    }

    public abstract void doHide();

    protected void doZoom() {
        if (this.getWindow() instanceof IWorkbenchWindow) {
            this.page.toggleZoom(this.partReference);
        }
    }

    public Rectangle getBounds() {
        return this.getControl().getBounds();
    }

    public Control getControl() {
        return this.control;
    }

    public int getMinimumHeight() {
        if (this.control == null || this.control.isDisposed()) {
            return super.getMinimumHeight();
        }
        boolean top = false;
        int leftHeight = 0;
        if (this.control.getTopLeft() != null && !this.control.getTopLeft().isDisposed()) {
            leftHeight = this.control.getTopLeft().computeSize((int)-1, (int)-1).y;
            top = true;
        }
        int centerHeight = 0;
        if (this.control.getTopCenter() != null && !this.control.getTopCenter().isDisposed()) {
            centerHeight = this.control.getTopCenter().computeSize((int)-1, (int)-1).y;
            top = true;
        }
        int rightHeight = 0;
        if (this.control.getTopRight() != null && !this.control.getTopRight().isDisposed()) {
            rightHeight = this.control.getTopRight().computeSize((int)-1, (int)-1).y;
            top = true;
        }
        int topHeight = Math.max(leftHeight, Math.max(centerHeight, rightHeight));
        topHeight = this.control.computeTrim((int)0, (int)0, (int)0, (int)topHeight).height;
        if (top) {
            ++topHeight;
        }
        return topHeight;
    }

    protected ViewForm getPane() {
        return this.control;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    int getStyle() {
        if (this.getContainer() != null && !this.getContainer().allowsBorder()) {
            return 0;
        }
        return 2048;
    }

    protected ViewForm getViewForm() {
        return this.control;
    }

    public void handleEvent(Event event) {
        if (event.type == 26) {
            this.requestActivation();
        }
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public void moveAbove(Control refControl) {
        if (this.getControl() != null) {
            this.getControl().moveAbove(refControl);
        }
    }

    protected void requestActivation() {
        this.page.requestActivation(this.partReference.getPart(true));
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
        if (this.control != null) {
            this.control.setBorderVisible(container == null || container.allowsBorder());
        }
    }

    public void setVisible(boolean makeVisible) {
        super.setVisible(makeVisible);
        if (makeVisible) {
            this.partReference.getPart(true);
        }
    }

    public void setFocus() {
        this.requestActivation();
        IWorkbenchPart part = this.partReference.getPart(true);
        if (part != null) {
            part.setFocus();
        }
    }

    public void setWorkbenchPage(WorkbenchPage workbenchPage) {
        this.page = workbenchPage;
    }

    public void setZoomed(boolean isZoomed) {
        this.isZoomed = isZoomed;
    }

    abstract void shellActivated();

    abstract void shellDeactivated();

    public abstract void showFocus(boolean var1);

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        return this;
    }

    public abstract void showPaneMenu();

    public abstract void showViewMenu();

    protected final void showPaneMenu(Control parent, Point point) {
        if (this.paneMenuManager == null) {
            this.paneMenuManager = new MenuManager();
            this.paneMenuManager.add((IContributionItem)new PaneContribution());
        }
        Menu aMenu = this.paneMenuManager.createContextMenu(parent);
        point = parent.toDisplay(point);
        aMenu.setLocation(point.x, point.y);
        aMenu.setVisible(true);
    }

    protected abstract Sashes findSashes();

    protected void moveSash(final Sash sash) {
        KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                IWorkbenchPart part;
                if ((e.character == '\u001b' || e.character == '\r') && (part = PartPane.this.partReference.getPart(true)) != null) {
                    part.setFocus();
                }
            }
        };
        sash.addFocusListener((FocusListener)new FocusAdapter((KeyListener)listener){
            private final /* synthetic */ KeyListener val$listener;
            {
                this.val$listener = keyListener;
            }

            public void focusGained(FocusEvent e) {
                sash.setBackground(sash.getDisplay().getSystemColor(26));
                sash.addKeyListener(this.val$listener);
            }

            public void focusLost(FocusEvent e) {
                sash.setBackground(null);
                sash.removeKeyListener(this.val$listener);
            }
        });
        sash.setFocus();
    }

    protected void addSizeItem(Menu sizeMenu, String labelKey, final Sash sash) {
        MenuItem item = new MenuItem(sizeMenu, 0);
        item.setText(WorkbenchMessages.getString(labelKey));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartPane.this.moveSash(sash);
            }
        });
        item.setEnabled(!this.isZoomed() && sash != null);
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    protected void addSizeItems(Menu sizeMenu) {
        Sashes sashes = this.findSashes();
        this.addSizeItem(sizeMenu, "PartPane.sizeLeft", sashes.left);
        this.addSizeItem(sizeMenu, "PartPane.sizeRight", sashes.right);
        this.addSizeItem(sizeMenu, "PartPane.sizeTop", sashes.top);
        this.addSizeItem(sizeMenu, "PartPane.sizeBottom", sashes.bottom);
    }

    protected void addPinEditorItem(Menu parent) {
    }

    protected void addMoveItems(Menu parent) {
    }

    protected void addFastViewMenuItem(Menu parent, boolean isFastView) {
    }

    protected void doDock() {
    }

    public static class Sashes {
        public Sash left;
        public Sash right;
        public Sash top;
        public Sash bottom;
    }

    private class PaneContribution
    extends ContributionItem {
        PaneContribution() {
        }

        public boolean isDynamic() {
            return true;
        }

        public void fill(Menu menu, int index) {
            boolean isFastView = PartPane.this.page.getActiveFastView() == PartPane.this.partReference;
            boolean isZoomed = PartPane.this.page.isZoomed();
            boolean canZoom = PartPane.this.getWindow() instanceof IWorkbenchWindow;
            MenuItem item = new MenuItem(menu, 0);
            item.setText(WorkbenchMessages.getString("PartPane.restore"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(this, isZoomed){
                final /* synthetic */ PaneContribution this$1;
                private final /* synthetic */ boolean val$isZoomed;
                {
                    this.this$1 = paneContribution;
                    this.val$isZoomed = bl;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (this.val$isZoomed) {
                        PaneContribution.access$0(this.this$1).doZoom();
                    }
                }
            });
            item.setEnabled(isZoomed);
            item = new MenuItem(menu, 64);
            item.setText(WorkbenchMessages.getString("PartPane.move"));
            Menu moveMenu = new Menu(menu);
            item.setMenu(moveMenu);
            PartPane.this.addMoveItems(moveMenu);
            item = new MenuItem(menu, 64);
            item.setText(WorkbenchMessages.getString("PartPane.size"));
            Menu sizeMenu = new Menu(menu);
            item.setMenu(sizeMenu);
            PartPane.this.addSizeItems(sizeMenu);
            PartPane.this.addFastViewMenuItem(menu, isFastView);
            item = new MenuItem(menu, 0);
            item.setText(WorkbenchMessages.getString("PartPane.maximize"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaneContribution this$1;
                {
                    this.this$1 = paneContribution;
                }

                public void widgetSelected(SelectionEvent e) {
                    PaneContribution.access$0(this.this$1).doZoom();
                }
            });
            item.setEnabled(!isZoomed && canZoom);
            PartPane.this.addPinEditorItem(menu);
            new MenuItem(menu, 2);
            item = new MenuItem(menu, 0);
            item.setText(WorkbenchMessages.getString("PartPane.close"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaneContribution this$1;
                {
                    this.this$1 = paneContribution;
                }

                public void widgetSelected(SelectionEvent e) {
                    PaneContribution.access$0(this.this$1).doHide();
                }
            });
        }

        static /* synthetic */ PartPane access$0(PaneContribution paneContribution) {
            return paneContribution.PartPane.this;
        }
    }
}

