/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.ViewerActionBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class PopupMenuExtender
implements IMenuListener {
    private String menuID;
    private MenuManager menu;
    private SubMenuManager menuWrapper;
    private ISelectionProvider selProvider;
    private IWorkbenchPart part;
    private ViewerActionBuilder staticActionBuilder;

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part) {
        this.menuID = id;
        this.menu = menu;
        this.selProvider = prov;
        this.part = part;
        menu.addMenuListener((IMenuListener)this);
        if (!menu.getRemoveAllWhenShown()) {
            this.menuWrapper = new SubMenuManager((IMenuManager)menu);
            this.menuWrapper.setVisible(true);
        }
        this.readStaticActions();
    }

    private void addObjectActions(IMenuManager mgr) {
        if (this.selProvider != null && ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, this.selProvider)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private void addStaticActions(IMenuManager mgr) {
        if (this.staticActionBuilder != null) {
            this.staticActionBuilder.contribute(mgr, null, true);
        }
    }

    public void menuAboutToShow(IMenuManager mgr) {
        this.testForAdditions();
        if (this.menuWrapper != null) {
            mgr = this.menuWrapper;
            this.menuWrapper.removeAll();
        }
        this.addObjectActions(mgr);
        this.addStaticActions(mgr);
    }

    private void readStaticActions() {
        if (this.menuID != null && this.menuID.length() > 0) {
            this.staticActionBuilder = new ViewerActionBuilder();
            if (!this.staticActionBuilder.readViewerContributions(this.menuID, this.selProvider, this.part)) {
                this.staticActionBuilder = null;
            }
        }
    }

    private void testForAdditions() {
        IContributionItem item = this.menu.find("additions");
        if (item == null) {
            WorkbenchPlugin.log("Context menu missing standard group 'org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS'. (menu id = " + (this.menuID == null ? "???" : this.menuID) + ")  part id = " + (this.part == null ? "???" : this.part.getSite().getId()) + ")");
        }
    }

    public void dispose() {
        if (this.staticActionBuilder != null) {
            this.staticActionBuilder.dispose();
        }
    }
}

