/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SavePerspectiveDialog;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class SavePerspectiveAction
extends Action {
    private IWorkbenchWindow window;

    public SavePerspectiveAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("SavePerspective.text"));
        this.setToolTipText(WorkbenchMessages.getString("SavePerspective.toolTip"));
        this.setEnabled(false);
        this.window = window;
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.save_perspective_action_context");
    }

    public void run() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        PerspectiveDescriptor desc = (PerspectiveDescriptor)page.getPerspective();
        if (desc != null) {
            if (desc.isSingleton()) {
                this.saveSingleton();
            } else {
                this.saveNonSingleton();
            }
        }
    }

    public void saveSingleton() {
        IWorkbenchPage page;
        String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog d = new MessageDialog(this.window.getShell(), WorkbenchMessages.getString("SavePerspective.overwriteTitle"), null, WorkbenchMessages.getString("SavePerspective.singletonQuestion"), 3, buttons, 0);
        if (d.open() == 0 && (page = this.window.getActivePage()) != null) {
            page.savePerspective();
        }
    }

    public void saveNonSingleton() {
        String name;
        PerspectiveRegistry reg = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        SavePerspectiveDialog dlg = new SavePerspectiveDialog(this.window.getShell(), reg);
        IPerspectiveDescriptor description = null;
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null) {
            description = reg.findPerspectiveWithId(page.getPerspective().getId());
        }
        dlg.setInitialSelection(description);
        if (dlg.open() != 0) {
            return;
        }
        PerspectiveDescriptor desc = (PerspectiveDescriptor)dlg.getPersp();
        if (desc == null && (desc = reg.createPerspective(name = dlg.getPerspName(), (PerspectiveDescriptor)description)) == null) {
            MessageDialog.openError((Shell)dlg.getShell(), (String)WorkbenchMessages.getString("SavePerspective.errorTitle"), (String)WorkbenchMessages.getString("SavePerspective.errorMessage"));
            return;
        }
        if (page != null) {
            page.savePerspectiveAs(desc);
        }
    }
}

