/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.Semaphore;
import org.eclipse.ui.internal.WorkbenchMessages;

public class UIWorkspaceLock
extends WorkspaceLock {
    protected Display display;
    protected Thread ui;
    protected Semaphore pendingWork;
    protected boolean pendingWorkStarted;

    public UIWorkspaceLock(IWorkspace workspace, Display display) throws CoreException {
        super(workspace);
        this.display = display;
        this.pendingWorkStarted = false;
    }

    public boolean acquire() throws InterruptedException {
        if (this.isUI()) {
            Thread currentOperation = this.getCurrentOperationThread();
            if (currentOperation != null) {
                if (this.display.getSyncThread() == currentOperation && this.isTreeLocked()) {
                    throw new RuntimeException(WorkbenchMessages.getString("UIWorkspaceLock.errorModDuringNotification"));
                }
                if (this.pendingWork != null && this.pendingWorkStarted && this.pendingWork.getOperationThread() == currentOperation) {
                    if (this.isTreeLocked()) {
                        throw new RuntimeException(WorkbenchMessages.getString("UIWorkspaceLock.errorModDuringNotification"));
                    }
                    return true;
                }
            }
            this.ui = Thread.currentThread();
            this.doPendingWork();
        }
        return super.acquire();
    }

    void addPendingWork(Semaphore work) {
        this.pendingWork = work;
    }

    void doPendingWork() {
        if (this.pendingWork == null) {
            return;
        }
        try {
            this.pendingWorkStarted = true;
            this.pendingWork.getRunnable().run();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            Semaphore temp = this.pendingWork;
            this.pendingWork = null;
            this.pendingWorkStarted = false;
            temp.release();
            throw throwable;
        }
        Object var1_3 = null;
        Semaphore temp = this.pendingWork;
        this.pendingWork = null;
        this.pendingWorkStarted = false;
        temp.release();
    }

    void interruptUI() {
        this.display.getThread().interrupt();
    }

    boolean isCurrentOperation() {
        return this.getCurrentOperationThread() == Thread.currentThread();
    }

    boolean isUI() {
        return !this.display.isDisposed() && this.display.getThread() == Thread.currentThread();
    }

    boolean isUIWaiting() {
        return this.ui != null && Thread.currentThread() != this.ui;
    }

    public void release() {
        if (this.isUI()) {
            this.ui = null;
        }
        super.release();
    }
}

