/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.net.URL;
import java.text.Collator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.SystemSummaryEditorInput;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WelcomeEditorInput;

public class WorkbenchConfigurationInfo {
    private AboutInfo aboutInfo;
    private AboutInfo[] featuresInfo;
    private AboutInfo[] newFeaturesInfo;
    private static final String INSTALLED_FEATURES = "installedFeatures";

    public AboutInfo getAboutInfo() {
        return this.aboutInfo;
    }

    public AboutInfo[] getFeaturesInfo() {
        if (this.featuresInfo == null) {
            this.readFeaturesInfo();
        }
        return this.featuresInfo;
    }

    private AboutInfo[] getNewFeaturesInfo() {
        if (this.newFeaturesInfo == null) {
            this.readFeaturesInfo();
        }
        return this.newFeaturesInfo;
    }

    private Workbench getWorkbench() {
        return (Workbench)PlatformUI.getWorkbench();
    }

    protected void openWelcomeEditors(IWorkbenchWindow window) {
        AboutInfo info = this.getAboutInfo();
        AboutInfo[] newFeatures = this.getNewFeaturesInfo();
        if (WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("WELCOME_DIALOG")) {
            URL url = info.getWelcomePageURL();
            if (url == null) {
                return;
            }
            WorkbenchPlugin.getDefault().getPreferenceStore().setValue("WELCOME_DIALOG", false);
            this.openEditor(window, new WelcomeEditorInput(info), "org.eclipse.ui.internal.dialogs.WelcomeEditor", null);
        } else {
            ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
            int i = 0;
            while (i < newFeatures.length) {
                if (newFeatures[i].getWelcomePageURL() != null) {
                    if (newFeatures[i].getFeatureId() != null && newFeatures[i].getWelcomePerspective() != null) {
                        IPluginDescriptor desc = newFeatures[i].getDescriptor();
                        try {
                            if (desc != null) {
                                desc.getPlugin();
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    welcomeFeatures.add(newFeatures[i]);
                }
                ++i;
            }
            int wCount = this.getWorkbench().getWorkbenchWindowCount();
            int i2 = 0;
            while (i2 < welcomeFeatures.size()) {
                AboutInfo newInfo = (AboutInfo)welcomeFeatures.get(i2);
                String id = newInfo.getWelcomePerspective();
                if (id == null || i2 >= wCount) {
                    this.openEditor(window, new WelcomeEditorInput(newInfo), "org.eclipse.ui.internal.dialogs.WelcomeEditor", id);
                }
                ++i2;
            }
        }
    }

    protected boolean readInfo() {
        String versionedFeatureId;
        IPlatformConfiguration conf = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry primaryFeature = conf.findConfiguredFeatureEntry(versionedFeatureId = conf.getPrimaryFeatureIdentifier());
        if (primaryFeature == null) {
            this.aboutInfo = new AboutInfo(null, null);
        } else {
            String versionedFeaturePluginIdentifier = primaryFeature.getFeaturePluginIdentifier();
            String versionedFeaturePluginVersion = primaryFeature.getFeaturePluginVersion();
            if (versionedFeaturePluginIdentifier == null) {
                this.aboutInfo = new AboutInfo(null, null);
            } else if (versionedFeaturePluginVersion == null) {
                this.aboutInfo = new AboutInfo(versionedFeaturePluginIdentifier, null);
            } else {
                PluginVersionIdentifier mainPluginVersion = null;
                try {
                    mainPluginVersion = new PluginVersionIdentifier(versionedFeaturePluginVersion);
                }
                catch (Exception e) {
                    Status iniStatus = new Status(4, WorkbenchPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Unknown plugin version " + versionedFeatureId, (Throwable)e);
                    WorkbenchPlugin.log("Problem obtaining configuration info ", (IStatus)iniStatus);
                }
                this.aboutInfo = new AboutInfo(versionedFeaturePluginIdentifier, mainPluginVersion);
            }
        }
        boolean success = true;
        try {
            this.aboutInfo.readINIFile();
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Error reading about info file", e.getStatus());
            success = false;
        }
        return success;
    }

    private void readFeaturesInfo() {
        IDialogSettings settings = WorkbenchPlugin.getDefault().getDialogSettings();
        String[] oldFeaturesArray = settings.getArray(INSTALLED_FEATURES);
        List<String> oldFeatures = null;
        if (oldFeaturesArray != null) {
            oldFeatures = Arrays.asList(oldFeaturesArray);
        }
        ArrayList<AboutInfo> aboutInfos = new ArrayList<AboutInfo>();
        ArrayList<AboutInfo> newAboutInfos = new ArrayList<AboutInfo>();
        IPlatformConfiguration platformConfiguration = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] features = platformConfiguration.getConfiguredFeatureEntries();
        String[] idArray = new String[features.length];
        int i = 0;
        while (i < features.length) {
            block11: {
                String versionedId;
                String id = features[i].getFeatureIdentifier();
                String version = features[i].getFeatureVersion();
                PluginVersionIdentifier vid = null;
                if (version != null) {
                    vid = new PluginVersionIdentifier(version);
                }
                idArray[i] = versionedId = String.valueOf(id) + ":" + vid;
                try {
                    AboutInfo info = new AboutInfo(id, vid);
                    aboutInfos.add(info);
                    if (oldFeatures != null && !oldFeatures.contains(versionedId)) {
                        newAboutInfos.add(info);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (!WorkbenchPlugin.DEBUG) break block11;
                    WorkbenchPlugin.log("Error parsing version \"" + vid + "\" for plugin: " + id + " in Workbench.readFeaturesInfo()");
                }
            }
            ++i;
        }
        settings.put(INSTALLED_FEATURES, idArray);
        Collections.sort(aboutInfos, new Comparator(){
            Collator coll = Collator.getInstance();

            public int compare(Object a, Object b) {
                AboutInfo infoA = (AboutInfo)a;
                AboutInfo infoB = (AboutInfo)b;
                int c = this.coll.compare(infoA.getFeatureId(), infoB.getFeatureId());
                if (c == 0) {
                    c = infoA.getVersionId().isGreaterThan(infoB.getVersionId()) ? 1 : -1;
                }
                return c;
            }
        });
        this.featuresInfo = new AboutInfo[aboutInfos.size()];
        aboutInfos.toArray(this.featuresInfo);
        i = 0;
        while (i < this.featuresInfo.length) {
            block12: {
                try {
                    this.featuresInfo[i].readINIFile();
                    if (this.featuresInfo[i].getDescriptor() == null) {
                        ((AbstractCollection)aboutInfos).remove(this.featuresInfo[i]);
                        ((AbstractCollection)newAboutInfos).remove(this.featuresInfo[i]);
                    }
                }
                catch (CoreException e) {
                    if (!WorkbenchPlugin.DEBUG) break block12;
                    WorkbenchPlugin.log("Error reading about info file for feature: " + this.featuresInfo[i].getFeatureId(), e.getStatus());
                }
            }
            ++i;
        }
        this.newFeaturesInfo = new AboutInfo[newAboutInfos.size()];
        newAboutInfos.toArray(this.newFeaturesInfo);
        if (aboutInfos.size() < this.featuresInfo.length) {
            this.featuresInfo = new AboutInfo[aboutInfos.size()];
            aboutInfos.toArray(this.featuresInfo);
        }
    }

    protected AboutInfo[] collectNewFeaturesWithPerspectives() {
        ArrayList<AboutInfo> result = new ArrayList<AboutInfo>();
        AboutInfo[] newFeatures = this.getNewFeaturesInfo();
        int i = 0;
        while (i < newFeatures.length) {
            AboutInfo info = newFeatures[i];
            if (info.getWelcomePerspective() != null && info.getWelcomePageURL() != null) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new AboutInfo[result.size()]);
    }

    private void openEditor(IWorkbenchWindow window, IEditorInput input, String editorId, String perspectiveId) {
        if (this.getWorkbench().getWorkbenchWindowCount() == 0) {
            return;
        }
        IWorkbenchWindow win = window;
        if (perspectiveId != null) {
            IWorkspaceRoot root = WorkbenchPlugin.getPluginWorkspace().getRoot();
            try {
                win = this.getWorkbench().openWorkbenchWindow(perspectiveId, (IAdaptable)root);
                if (win == null) {
                    win = window;
                }
            }
            catch (WorkbenchException workbenchException) {
                if (WorkbenchPlugin.DEBUG) {
                    WorkbenchPlugin.log("Error opening window in Workbench.openEditor(..)");
                }
                return;
            }
        }
        if (win == null) {
            win = this.getWorkbench().getWorkbenchWindows()[0];
        }
        WorkbenchPage page = (WorkbenchPage)win.getActivePage();
        String id = perspectiveId;
        if (id == null) {
            id = WorkbenchPlugin.getDefault().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (page == null) {
            try {
                IWorkspaceRoot root = WorkbenchPlugin.getPluginWorkspace().getRoot();
                page = (WorkbenchPage)window.openPage(id, (IAdaptable)root);
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)WorkbenchMessages.getString("Problems_Opening_Page"), (String)((Throwable)((Object)e)).getMessage(), (IStatus)e.getStatus());
            }
        }
        if (page == null) {
            return;
        }
        if (page.getActivePerspective() == null) {
            try {
                page = (WorkbenchPage)this.getWorkbench().showPerspective(id, win);
            }
            catch (WorkbenchException e) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("QuickStartAction.openEditorException"), (Throwable)((Object)e));
                ErrorDialog.openError((Shell)win.getShell(), (String)WorkbenchMessages.getString("Workbench.openEditorErrorDialogTitle"), (String)WorkbenchMessages.getString("Workbench.openEditorErrorDialogMessage"), (IStatus)status);
                return;
            }
        }
        page.setEditorAreaVisible(true);
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.activate(editor);
            return;
        }
        try {
            page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("QuickStartAction.openEditorException"), (Throwable)((Object)e));
            ErrorDialog.openError((Shell)win.getShell(), (String)WorkbenchMessages.getString("Workbench.openEditorErrorDialogTitle"), (String)WorkbenchMessages.getString("Workbench.openEditorErrorDialogMessage"), (IStatus)status);
        }
    }

    public void openSystemSummaryEditor(IWorkbenchWindow window) {
        this.openEditor(window, new SystemSummaryEditorInput(), "org.eclipse.ui.SystemSummaryEditor", null);
    }
}

