/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.OpenResourceDialog;

public class OpenWorkspaceFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    IWorkbenchWindow workbenchWindow;

    public OpenWorkspaceFileAction() {
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.open_workspace_file_action_context");
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.workbenchWindow = window;
    }

    IFile queryFileResource() {
        IWorkspaceRoot input;
        Shell parent = this.workbenchWindow.getShell();
        OpenResourceDialog dialog = new OpenResourceDialog(parent, (IContainer)(input = ResourcesPlugin.getWorkspace().getRoot()), 1);
        int resultCode = dialog.open();
        if (resultCode != 0) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IFile)) {
            return null;
        }
        return (IFile)result[0];
    }

    public void run(IAction action) {
        IFile file = this.queryFileResource();
        if (file == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.workbenchWindow.getActivePage();
            if (page != null) {
                page.openEditor(file);
            }
        }
        catch (CoreException x) {
            String title = WorkbenchMessages.getString("OpenWorkspaceFileAction.errorTitle");
            String message = WorkbenchMessages.getString("OpenWorkspaceFileAction.errorMessage");
            WorkbenchPlugin.log(title, x.getStatus());
            ErrorDialog.openError((Shell)this.workbenchWindow.getShell(), (String)title, (String)message, (IStatus)x.getStatus());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

