/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import org.eclipse.ui.internal.commands.Util;

public final class ActiveConfiguration
implements Comparable {
    private static final int HASH_FACTOR = 17;
    private static final int HASH_INITIAL = 27;
    private String plugin;
    private String value;

    public static ActiveConfiguration create(String plugin, String value) throws IllegalArgumentException {
        return new ActiveConfiguration(plugin, value);
    }

    private ActiveConfiguration(String plugin, String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.plugin = plugin;
        this.value = value;
    }

    public int compareTo(Object object) {
        ActiveConfiguration activeConfiguration = (ActiveConfiguration)object;
        int compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)activeConfiguration.plugin));
        if (compareTo == 0) {
            compareTo = this.value.compareTo(activeConfiguration.value);
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActiveConfiguration)) {
            return false;
        }
        ActiveConfiguration activeConfiguration = (ActiveConfiguration)object;
        return Util.equals(this.plugin, activeConfiguration.plugin) && this.value.equals(activeConfiguration.value);
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 27;
        result = result * 17 + Util.hashCode(this.plugin);
        result = result * 17 + this.value.hashCode();
        return result;
    }

    public String toString() {
        return this.value;
    }
}

