/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.ui.internal.commands.Util;

public final class Configuration
implements Comparable {
    private static final int HASH_FACTOR = 57;
    private static final int HASH_INITIAL = 67;
    private static Comparator nameComparator;
    private String description;
    private String id;
    private String name;
    private String parent;
    private String plugin;

    public static Configuration create(String description, String id, String name, String parent, String plugin) throws IllegalArgumentException {
        return new Configuration(description, id, name, parent, plugin);
    }

    public static Comparator nameComparator() {
        if (nameComparator == null) {
            nameComparator = new Comparator(){

                public int compare(Object left, Object right) {
                    return Collator.getInstance().compare(((Configuration)left).name, ((Configuration)right).name);
                }
            };
        }
        return nameComparator;
    }

    public static SortedMap sortedMapById(List configurations) throws IllegalArgumentException {
        if (configurations == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Configuration> sortedMap = new TreeMap<String, Configuration>();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Configuration)) {
                throw new IllegalArgumentException();
            }
            Configuration configuration = (Configuration)object;
            sortedMap.put(configuration.id, configuration);
        }
        return sortedMap;
    }

    public static SortedMap sortedMapByName(List configurations) throws IllegalArgumentException {
        if (configurations == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Configuration> sortedMap = new TreeMap<String, Configuration>();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Configuration)) {
                throw new IllegalArgumentException();
            }
            Configuration configuration = (Configuration)object;
            sortedMap.put(configuration.name, configuration);
        }
        return sortedMap;
    }

    private Configuration(String description, String id, String name, String parent, String plugin) throws IllegalArgumentException {
        if (id == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.description = description;
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.plugin = plugin;
    }

    public int compareTo(Object object) {
        Configuration configuration = (Configuration)object;
        int compareTo = this.id.compareTo(configuration.id);
        if (compareTo == 0 && (compareTo = this.name.compareTo(configuration.name)) == 0) {
            Util.compare((Comparable)((Object)this.description), (Comparable)((Object)configuration.description));
            if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.parent), (Comparable)((Object)configuration.parent))) == 0) {
                compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)configuration.plugin));
            }
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)object;
        return Util.equals(this.description, configuration.description) && this.id.equals(configuration.id) && this.name.equals(configuration.name) && Util.equals(this.parent, configuration.parent) && Util.equals(this.plugin, configuration.plugin);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int hashCode() {
        int result = 67;
        result = result * 57 + Util.hashCode(this.description);
        result = result * 57 + this.id.hashCode();
        result = result * 57 + this.name.hashCode();
        result = result * 57 + Util.hashCode(this.parent);
        result = result * 57 + Util.hashCode(this.plugin);
        return result;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.id + ')';
    }
}

