/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.ui.internal.commands.Point;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.Stroke;
import org.eclipse.ui.internal.commands.Util;

public final class GestureSupport {
    private static final ResourceBundle resourceBundle;
    private static final String DOWN = "2";
    private static final String LEFT = "4";
    private static final String RIGHT = "6";
    private static final String STROKE_SEPARATOR = " ";
    private static final String UNKNOWN = "?";
    private static final String UP = "8";
    public static final Stroke STROKE_DOWN;
    public static final Stroke STROKE_LEFT;
    public static final Stroke STROKE_RIGHT;
    public static final Stroke STROKE_UP;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.GestureSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resourceBundle = ResourceBundle.getBundle(clazz.getName());
        STROKE_DOWN = Stroke.create(2);
        STROKE_LEFT = Stroke.create(4);
        STROKE_RIGHT = Stroke.create(6);
        STROKE_UP = Stroke.create(8);
    }

    public static String formatSequence(Sequence sequence, boolean localize) throws IllegalArgumentException {
        if (sequence == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        Iterator iterator = sequence.getStrokes().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            if (i != 0) {
                stringBuffer.append(STROKE_SEPARATOR);
            }
            stringBuffer.append(GestureSupport.formatStroke((Stroke)iterator.next(), localize));
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String formatStroke(Stroke stroke, boolean localize) throws IllegalArgumentException {
        if (stroke == null) {
            throw new IllegalArgumentException();
        }
        if (STROKE_DOWN.equals(stroke)) {
            return localize ? Util.getString(resourceBundle, DOWN) : DOWN;
        }
        if (STROKE_LEFT.equals(stroke)) {
            return localize ? Util.getString(resourceBundle, LEFT) : LEFT;
        }
        if (STROKE_RIGHT.equals(stroke)) {
            return localize ? Util.getString(resourceBundle, RIGHT) : RIGHT;
        }
        if (STROKE_UP.equals(stroke)) {
            return localize ? Util.getString(resourceBundle, UP) : UP;
        }
        return localize ? Util.getString(resourceBundle, UNKNOWN) : UNKNOWN;
    }

    public static Sequence parseSequence(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Stroke> strokes = new ArrayList<Stroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            strokes.add(GestureSupport.parseStroke(stringTokenizer.nextToken()));
        }
        return Sequence.create(strokes);
    }

    public static Stroke parseStroke(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (DOWN.equals(string)) {
            return STROKE_DOWN;
        }
        if (LEFT.equals(string)) {
            return STROKE_LEFT;
        }
        if (RIGHT.equals(string)) {
            return STROKE_RIGHT;
        }
        if (UP.equals(string)) {
            return STROKE_UP;
        }
        return Stroke.create(0);
    }

    public static Sequence recognize(Point[] points, int sensitivity) {
        Stroke stroke = null;
        ArrayList<Stroke> strokes = new ArrayList<Stroke>();
        int x0 = 0;
        int y0 = 0;
        int i = 0;
        while (i < points.length) {
            Point point = points[i];
            if (i == 0) {
                x0 = point.getX();
                y0 = point.getY();
            } else {
                int x1 = point.getX();
                int y1 = point.getY();
                int dx = (x1 - x0) / sensitivity;
                int dy = (y1 - y0) / sensitivity;
                if (dx != 0 || dy != 0) {
                    if (dx > 0 && !STROKE_RIGHT.equals(stroke)) {
                        stroke = STROKE_RIGHT;
                        strokes.add(stroke);
                    } else if (dx < 0 && !STROKE_LEFT.equals(stroke)) {
                        stroke = STROKE_LEFT;
                        strokes.add(stroke);
                    } else if (dy > 0 && !STROKE_DOWN.equals(stroke)) {
                        stroke = STROKE_DOWN;
                        strokes.add(stroke);
                    } else if (dy < 0 && !STROKE_UP.equals(stroke)) {
                        stroke = STROKE_UP;
                        strokes.add(stroke);
                    }
                    x0 = x1;
                    y0 = y1;
                }
            }
            ++i;
        }
        return Sequence.create(strokes);
    }

    private GestureSupport() {
    }
}

