/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.ActiveConfiguration;
import org.eclipse.ui.internal.commands.Category;
import org.eclipse.ui.internal.commands.Command;
import org.eclipse.ui.internal.commands.Configuration;
import org.eclipse.ui.internal.commands.CoreRegistry;
import org.eclipse.ui.internal.commands.ImageFactory;
import org.eclipse.ui.internal.commands.KeySupport;
import org.eclipse.ui.internal.commands.LocalRegistry;
import org.eclipse.ui.internal.commands.Manager;
import org.eclipse.ui.internal.commands.Path;
import org.eclipse.ui.internal.commands.PreferenceRegistry;
import org.eclipse.ui.internal.commands.Scope;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.SequenceBinding;
import org.eclipse.ui.internal.commands.SequenceMachine;
import org.eclipse.ui.internal.commands.SequenceNode;
import org.eclipse.ui.internal.commands.State;
import org.eclipse.ui.internal.commands.Util;

public class KeyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final ResourceBundle resourceBundle;
    private static final String COMMAND_CONFLICT;
    private static final String COMMAND_NOTHING;
    private static final String COMMAND_UNDEFINED;
    private static final int DIFFERENCE_ADD = 0;
    private static final int DIFFERENCE_CHANGE = 1;
    private static final int DIFFERENCE_MINUS = 2;
    private static final int DIFFERENCE_NONE = 3;
    private static final Image IMAGE_BLANK;
    private static final Image IMAGE_CHANGE;
    private static final Image IMAGE_MINUS;
    private static final Image IMAGE_PLUS;
    private static final RGB RGB_CONFLICT;
    private static final RGB RGB_CONFLICT_MINUS;
    private static final RGB RGB_MINUS;
    private static final char SPACE = ' ';
    private Label labelActiveConfiguration;
    private Combo comboActiveConfiguration;
    private Label labelCommands;
    private TreeViewer treeViewerCommands;
    private Label labelName;
    private Text textName;
    private Label labelDescription;
    private Text textDescription;
    private Label labelSequencesForCommand;
    private Table tableSequencesForCommand;
    private Label labelSequence;
    private Combo comboSequence;
    private Label labelScope;
    private Combo comboScope;
    private Label labelConfiguration;
    private Combo comboConfiguration;
    private Button buttonAdd;
    private Button buttonRemove;
    private Button buttonRestore;
    private Label labelCommandsForSequence;
    private Table tableCommandsForSequence;
    private IWorkbench workbench;
    private List categories;
    private SortedMap categoriesById;
    private SortedMap categoriesByName;
    private List commands;
    private SortedMap commandsById;
    private SortedMap commandsByName;
    private List scopes;
    private SortedMap scopesById;
    private SortedMap scopesByName;
    private List coreActiveKeyConfigurations;
    private List coreKeyBindings;
    private List coreKeyConfigurations;
    private List localActiveKeyConfigurations;
    private List localKeyBindings;
    private List localKeyConfigurations;
    private List preferenceActiveKeyConfigurations;
    private List preferenceKeyBindings;
    private List preferenceKeyConfigurations;
    private ActiveConfiguration activeKeyConfiguration;
    private List activeKeyConfigurations;
    private List keyConfigurations;
    private SortedMap keyConfigurationsById;
    private SortedMap keyConfigurationsByName;
    private SortedMap tree;
    private List commandRecords = new ArrayList();
    private List keySequenceRecords = new ArrayList();
    private SortedMap keySequencesByName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.KeyPreferencePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resourceBundle = ResourceBundle.getBundle(clazz.getName());
        COMMAND_CONFLICT = Util.getString(resourceBundle, "commandConflict");
        COMMAND_NOTHING = Util.getString(resourceBundle, "commandNothing");
        COMMAND_UNDEFINED = Util.getString(resourceBundle, "commandUndefined");
        IMAGE_BLANK = ImageFactory.getImage("blank");
        IMAGE_CHANGE = ImageFactory.getImage("change");
        IMAGE_MINUS = ImageFactory.getImage("minus");
        IMAGE_PLUS = ImageFactory.getImage("plus");
        RGB_CONFLICT = new RGB(255, 0, 0);
        RGB_CONFLICT_MINUS = new RGB(255, 160, 160);
        RGB_MINUS = new RGB(160, 160, 160);
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        PreferenceRegistry preferenceRegistry = PreferenceRegistry.getInstance();
        try {
            preferenceRegistry.load();
        }
        catch (IOException iOException) {}
        this.preferenceActiveKeyConfigurations = new ArrayList(preferenceRegistry.getActiveKeyConfigurations());
        this.preferenceKeyBindings = new ArrayList(preferenceRegistry.getKeyBindings());
        Manager.validateSequenceBindings(this.preferenceKeyBindings);
        this.preferenceKeyConfigurations = new ArrayList(preferenceRegistry.getKeyConfigurations());
    }

    public boolean performOk() {
        this.copyFromUI();
        PreferenceRegistry preferenceRegistry = PreferenceRegistry.getInstance();
        preferenceRegistry.setActiveKeyConfigurations(this.preferenceActiveKeyConfigurations);
        preferenceRegistry.setKeyBindings(this.preferenceKeyBindings);
        preferenceRegistry.setKeyConfigurations(this.preferenceKeyConfigurations);
        try {
            preferenceRegistry.save();
        }
        catch (IOException iOException) {}
        Manager.getInstance().reset();
        if (this.workbench instanceof Workbench) {
            ((Workbench)this.workbench).updateActiveKeyBindingService();
        }
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            CoreRegistry coreRegistry = CoreRegistry.getInstance();
            LocalRegistry localRegistry = LocalRegistry.getInstance();
            PreferenceRegistry preferenceRegistry = PreferenceRegistry.getInstance();
            try {
                coreRegistry.load();
            }
            catch (IOException iOException) {}
            try {
                localRegistry.load();
            }
            catch (IOException iOException) {}
            try {
                preferenceRegistry.load();
            }
            catch (IOException iOException) {}
            boolean categoriesChanged = false;
            ArrayList categories = new ArrayList();
            categories.addAll(coreRegistry.getCategories());
            categories.addAll(localRegistry.getCategories());
            categories.addAll(preferenceRegistry.getCategories());
            if (!Util.equals(categories, this.categories)) {
                this.categories = Collections.unmodifiableList(categories);
                this.categoriesById = Collections.unmodifiableSortedMap(Category.sortedMapById(this.categories));
                this.categoriesByName = Collections.unmodifiableSortedMap(Category.sortedMapByName(this.categories));
                categoriesChanged = true;
            }
            boolean commandsChanged = false;
            ArrayList commands = new ArrayList();
            commands.addAll(coreRegistry.getCommands());
            commands.addAll(localRegistry.getCommands());
            commands.addAll(preferenceRegistry.getCommands());
            if (!Util.equals(commands, this.commands)) {
                this.commands = Collections.unmodifiableList(commands);
                this.commandsById = Collections.unmodifiableSortedMap(Command.sortedMapById(this.commands));
                this.commandsByName = Collections.unmodifiableSortedMap(Command.sortedMapByName(this.commands));
                commandsChanged = true;
            }
            if (categoriesChanged || commandsChanged) {
                this.treeViewerCommands.setInput(new Object());
            }
            ArrayList scopes = new ArrayList();
            scopes.addAll(coreRegistry.getScopes());
            scopes.addAll(localRegistry.getScopes());
            scopes.addAll(preferenceRegistry.getScopes());
            if (!Util.equals(scopes, this.scopes)) {
                this.scopes = Collections.unmodifiableList(scopes);
                this.scopesById = Collections.unmodifiableSortedMap(Scope.sortedMapById(this.scopes));
                this.scopesByName = Collections.unmodifiableSortedMap(Scope.sortedMapByName(this.scopes));
                ArrayList<String> names = new ArrayList<String>();
                Iterator iterator = this.scopes.iterator();
                while (iterator.hasNext()) {
                    Scope scope = (Scope)iterator.next();
                    if (scope == null) continue;
                    String name = scope.getName();
                    String parent = scope.getParent();
                    if (parent != null && (scope = (Scope)this.scopesById.get(parent)) != null) {
                        name = MessageFormat.format(Util.getString(resourceBundle, "extends"), name, scope.getName());
                    }
                    names.add(name);
                }
                Collections.sort(names, Collator.getInstance());
                this.comboScope.setItems(names.toArray(new String[names.size()]));
            }
            this.coreActiveKeyConfigurations = new ArrayList(coreRegistry.getActiveKeyConfigurations());
            this.coreKeyBindings = new ArrayList(coreRegistry.getKeyBindings());
            Manager.validateSequenceBindings(this.coreKeyBindings);
            this.coreKeyConfigurations = new ArrayList(coreRegistry.getKeyConfigurations());
            this.localActiveKeyConfigurations = new ArrayList(localRegistry.getActiveKeyConfigurations());
            this.localKeyBindings = new ArrayList(localRegistry.getKeyBindings());
            Manager.validateSequenceBindings(this.localKeyBindings);
            this.localKeyConfigurations = new ArrayList(localRegistry.getKeyConfigurations());
            this.copyToUI();
            this.update();
        } else {
            this.copyFromUI();
        }
        super.setVisible(visible);
    }

    protected Control createContents(Composite parent) {
        return this.createUI(parent);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        MessageBox restoreDefaultsMessageBox = new MessageBox(this.getShell(), 65736);
        restoreDefaultsMessageBox.setText(Util.getString(resourceBundle, "restoreDefaultsMessageBoxText"));
        restoreDefaultsMessageBox.setMessage(Util.getString(resourceBundle, "restoreDefaultsMessageBoxMessage"));
        if (restoreDefaultsMessageBox.open() == 64) {
            this.preferenceActiveKeyConfigurations = new ArrayList();
            this.preferenceKeyBindings = new ArrayList();
            this.preferenceKeyConfigurations = new ArrayList();
            this.copyToUI();
        }
    }

    private void copyFromUI() {
        this.activeKeyConfiguration = null;
        this.preferenceActiveKeyConfigurations = new ArrayList();
        String activeKeyConfigurationId = this.getActiveKeyConfigurationId();
        if (activeKeyConfigurationId != null) {
            this.activeKeyConfiguration = ActiveConfiguration.create(null, activeKeyConfigurationId);
            this.preferenceActiveKeyConfigurations.add(this.activeKeyConfiguration);
        }
        this.preferenceKeyBindings = new ArrayList(this.solve(this.tree));
    }

    private void copyToUI() {
        Iterator<Object> iterator;
        ArrayList activeKeyConfigurations = new ArrayList();
        activeKeyConfigurations.addAll(this.coreActiveKeyConfigurations);
        activeKeyConfigurations.addAll(this.localActiveKeyConfigurations);
        activeKeyConfigurations.addAll(this.preferenceActiveKeyConfigurations);
        if (!Util.equals(activeKeyConfigurations, this.activeKeyConfigurations)) {
            this.activeKeyConfigurations = Collections.unmodifiableList(activeKeyConfigurations);
            this.activeKeyConfiguration = (ActiveConfiguration)this.activeKeyConfigurations.get(this.activeKeyConfigurations.size() - 1);
        }
        ArrayList keyConfigurations = new ArrayList();
        keyConfigurations.addAll(this.coreKeyConfigurations);
        keyConfigurations.addAll(this.localKeyConfigurations);
        keyConfigurations.addAll(this.preferenceKeyConfigurations);
        if (!Util.equals(keyConfigurations, this.keyConfigurations)) {
            this.keyConfigurations = Collections.unmodifiableList(keyConfigurations);
            this.keyConfigurationsById = Collections.unmodifiableSortedMap(Configuration.sortedMapById(this.keyConfigurations));
            this.keyConfigurationsByName = Collections.unmodifiableSortedMap(Configuration.sortedMapByName(this.keyConfigurations));
            ArrayList<String> names = new ArrayList<String>();
            iterator = this.keyConfigurations.iterator();
            while (iterator.hasNext()) {
                Configuration keyConfiguration = (Configuration)iterator.next();
                if (keyConfiguration == null) continue;
                String name = keyConfiguration.getName();
                String parent = keyConfiguration.getParent();
                if (parent != null && (keyConfiguration = (Configuration)this.keyConfigurationsById.get(parent)) != null) {
                    name = MessageFormat.format(Util.getString(resourceBundle, "extends"), name, keyConfiguration.getName());
                }
                names.add(name);
            }
            Collections.sort(names, Collator.getInstance());
            this.comboActiveConfiguration.setItems(names.toArray(new String[names.size()]));
            this.comboConfiguration.setItems(names.toArray(new String[names.size()]));
        }
        this.setActiveKeyConfigurationId(this.activeKeyConfiguration != null ? this.activeKeyConfiguration.getValue() : null);
        TreeSet keyBindingSet = new TreeSet();
        keyBindingSet.addAll(this.coreKeyBindings);
        keyBindingSet.addAll(this.localKeyBindings);
        keyBindingSet.addAll(this.preferenceKeyBindings);
        this.tree = this.build(keyBindingSet);
        this.keySequencesByName = new TreeMap();
        iterator = this.tree.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Sequence)) continue;
            Sequence keySequence = (Sequence)object;
            String name = KeySupport.formatSequence(keySequence, true);
            this.keySequencesByName.put(name, keySequence);
        }
        Set keySequenceNameSet = this.keySequencesByName.keySet();
        this.comboSequence.setItems(keySequenceNameSet.toArray(new String[keySequenceNameSet.size()]));
        this.selectedTreeViewerCommands();
    }

    private Control createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Composite compositeActiveKeyConfiguration = new Composite(composite, 0);
        compositeActiveKeyConfiguration.setFont(composite.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 5;
        compositeActiveKeyConfiguration.setLayout((Layout)gridLayout);
        this.labelActiveConfiguration = new Label(compositeActiveKeyConfiguration, 16384);
        this.labelActiveConfiguration.setFont(compositeActiveKeyConfiguration.getFont());
        this.labelActiveConfiguration.setText(Util.getString(resourceBundle, "labelActiveConfiguration"));
        this.comboActiveConfiguration = new Combo(compositeActiveKeyConfiguration, 8);
        this.comboActiveConfiguration.setFont(compositeActiveKeyConfiguration.getFont());
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.comboActiveConfiguration.setLayoutData((Object)gridData);
        Label labelSeparator = new Label(composite, 258);
        labelSeparator.setLayoutData((Object)new GridData(768));
        Composite compositeAssignment = new Composite(composite, 0);
        compositeAssignment.setFont(composite.getFont());
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 7;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        compositeAssignment.setLayout((Layout)gridLayout);
        compositeAssignment.setLayoutData((Object)new GridData(1808));
        this.labelCommands = new Label(compositeAssignment, 16384);
        this.labelCommands.setFont(compositeAssignment.getFont());
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.labelCommands.setLayoutData((Object)gridData);
        this.labelCommands.setText(Util.getString(resourceBundle, "labelCommands"));
        Composite compositeAssignmentLeft = new Composite(compositeAssignment, 0);
        compositeAssignmentLeft.setFont(compositeAssignment.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        compositeAssignmentLeft.setLayout((Layout)gridLayout);
        compositeAssignmentLeft.setLayoutData((Object)new GridData(1040));
        this.treeViewerCommands = new TreeViewer(compositeAssignmentLeft);
        gridData = new GridData(1808);
        gridData.heightHint = 0;
        gridData.widthHint = 200;
        this.treeViewerCommands.getControl().setLayoutData((Object)gridData);
        this.treeViewerCommands.setContentProvider((IContentProvider)new TreeViewerCommandsContentProvider());
        this.treeViewerCommands.setLabelProvider((IBaseLabelProvider)new TreeViewerCommandsLabelProvider());
        Composite compositeAssignmentRight = new Composite(compositeAssignment, 0);
        compositeAssignmentRight.setFont(compositeAssignment.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        compositeAssignmentRight.setLayout((Layout)gridLayout);
        compositeAssignmentRight.setLayoutData((Object)new GridData(1808));
        Composite compositeAssignmentTitle = new Composite(compositeAssignmentRight, 0);
        compositeAssignmentTitle.setFont(compositeAssignmentRight.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        compositeAssignmentTitle.setLayout((Layout)gridLayout);
        compositeAssignmentTitle.setLayoutData((Object)new GridData(768));
        this.labelName = new Label(compositeAssignmentTitle, 16384);
        this.labelName.setFont(compositeAssignmentTitle.getFont());
        this.labelName.setLayoutData((Object)new GridData(2));
        this.labelName.setText(Util.getString(resourceBundle, "labelName"));
        this.textName = new Text(compositeAssignmentTitle, 16392);
        this.textName.setFont(compositeAssignmentTitle.getFont());
        this.textName.setLayoutData((Object)new GridData(768));
        this.labelDescription = new Label(compositeAssignmentTitle, 16384);
        this.labelDescription.setFont(compositeAssignmentTitle.getFont());
        this.labelDescription.setLayoutData((Object)new GridData(2));
        this.labelDescription.setText(Util.getString(resourceBundle, "labelDescription"));
        this.textDescription = new Text(compositeAssignmentTitle, 16458);
        this.textDescription.setFont(compositeAssignmentTitle.getFont());
        gridData = new GridData(768);
        gridData.heightHint = 30;
        this.textDescription.setLayoutData((Object)gridData);
        this.labelSequencesForCommand = new Label(compositeAssignmentRight, 16384);
        this.labelSequencesForCommand.setFont(compositeAssignmentRight.getFont());
        this.labelSequencesForCommand.setLayoutData((Object)new GridData(768));
        this.labelSequencesForCommand.setText(Util.getString(resourceBundle, "labelSequencesForCommand"));
        this.tableSequencesForCommand = new Table(compositeAssignmentRight, 68352);
        this.tableSequencesForCommand.setFont(compositeAssignmentRight.getFont());
        this.tableSequencesForCommand.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 90;
        this.tableSequencesForCommand.setLayoutData((Object)gridData);
        int width = 0;
        TableColumn tableColumn = new TableColumn(this.tableSequencesForCommand, 0, 0);
        tableColumn.setResizable(false);
        tableColumn.setText("");
        tableColumn.setWidth(20);
        width += tableColumn.getWidth();
        tableColumn = new TableColumn(this.tableSequencesForCommand, 0, 1);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnScope"));
        tableColumn.pack();
        tableColumn.setWidth(tableColumn.getWidth() + 40);
        width += tableColumn.getWidth();
        tableColumn = new TableColumn(this.tableSequencesForCommand, 0, 2);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnConfiguration"));
        tableColumn.pack();
        tableColumn.setWidth(tableColumn.getWidth() + 40);
        width += tableColumn.getWidth();
        tableColumn = new TableColumn(this.tableSequencesForCommand, 0, 3);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnSequence"));
        tableColumn.pack();
        tableColumn.setWidth(Math.max(220, Math.max(440 - width, tableColumn.getWidth() + 20)));
        Composite compositeAssignmentChange = new Composite(compositeAssignmentRight, 0);
        compositeAssignmentChange.setFont(compositeAssignmentRight.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.numColumns = 2;
        compositeAssignmentChange.setLayout((Layout)gridLayout);
        this.labelScope = new Label(compositeAssignmentChange, 16384);
        this.labelScope.setFont(compositeAssignmentChange.getFont());
        this.labelScope.setLayoutData((Object)new GridData(2));
        this.labelScope.setText(Util.getString(resourceBundle, "labelScope"));
        this.comboScope = new Combo(compositeAssignmentChange, 8);
        this.comboScope.setFont(compositeAssignmentChange.getFont());
        gridData = new GridData();
        gridData.widthHint = 200;
        this.comboScope.setLayoutData((Object)gridData);
        this.labelConfiguration = new Label(compositeAssignmentChange, 16384);
        this.labelConfiguration.setFont(compositeAssignmentChange.getFont());
        this.labelConfiguration.setLayoutData((Object)new GridData(2));
        this.labelConfiguration.setText(Util.getString(resourceBundle, "labelConfiguration"));
        this.comboConfiguration = new Combo(compositeAssignmentChange, 8);
        this.comboConfiguration.setFont(compositeAssignmentChange.getFont());
        gridData = new GridData();
        gridData.widthHint = 200;
        this.comboConfiguration.setLayoutData((Object)gridData);
        this.labelSequence = new Label(compositeAssignmentChange, 16384);
        this.labelSequence.setFont(compositeAssignmentChange.getFont());
        this.labelSequence.setLayoutData((Object)new GridData(2));
        this.labelSequence.setText(Util.getString(resourceBundle, "labelSequence"));
        this.comboSequence = new Combo(compositeAssignmentChange, 0);
        this.comboSequence.setFont(compositeAssignmentChange.getFont());
        gridData = new GridData();
        gridData.widthHint = 200;
        this.comboSequence.setLayoutData((Object)gridData);
        Composite spacer = new Composite(compositeAssignmentChange, 0);
        gridData = new GridData();
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 0;
        spacer.setLayoutData((Object)gridData);
        spacer = new Composite(compositeAssignmentChange, 0);
        gridData = new GridData();
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        spacer.setLayoutData((Object)gridData);
        Composite compositeButton = new Composite(compositeAssignmentChange, 0);
        compositeButton.setFont(compositeAssignmentChange.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        compositeButton.setLayout((Layout)gridLayout);
        this.buttonAdd = new Button(compositeButton, 0x1000008);
        this.buttonAdd.setFont(compositeButton.getFont());
        gridData = new GridData();
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        this.buttonAdd.setText(Util.getString(resourceBundle, "buttonAdd"));
        gridData.widthHint = Math.max(widthHint, this.buttonAdd.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonAdd.setLayoutData((Object)gridData);
        this.buttonRemove = new Button(compositeButton, 0x1000008);
        this.buttonRemove.setFont(compositeButton.getFont());
        gridData = new GridData();
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        this.buttonRemove.setText(Util.getString(resourceBundle, "buttonRemove"));
        gridData.widthHint = Math.max(widthHint, this.buttonRemove.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonRemove.setLayoutData((Object)gridData);
        this.buttonRestore = new Button(compositeButton, 0x1000008);
        this.buttonRestore.setFont(compositeButton.getFont());
        gridData = new GridData();
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        this.buttonRestore.setText(Util.getString(resourceBundle, "buttonRestore"));
        gridData.widthHint = Math.max(widthHint, this.buttonRestore.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonRestore.setLayoutData((Object)gridData);
        spacer = new Composite(compositeAssignmentRight, 0);
        gridData = new GridData();
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        spacer.setLayoutData((Object)gridData);
        spacer = new Composite(compositeAssignmentRight, 0);
        gridData = new GridData();
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        spacer.setLayoutData((Object)gridData);
        this.labelCommandsForSequence = new Label(compositeAssignmentRight, 16384);
        this.labelCommandsForSequence.setFont(compositeAssignmentRight.getFont());
        this.labelCommandsForSequence.setLayoutData((Object)new GridData(768));
        this.labelCommandsForSequence.setText(Util.getString(resourceBundle, "labelCommandsForSequence.noSelection"));
        this.tableCommandsForSequence = new Table(compositeAssignmentRight, 68352);
        this.tableCommandsForSequence.setFont(compositeAssignmentRight.getFont());
        this.tableCommandsForSequence.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 60;
        this.tableCommandsForSequence.setLayoutData((Object)gridData);
        width = 0;
        tableColumn = new TableColumn(this.tableCommandsForSequence, 0, 0);
        tableColumn.setResizable(false);
        tableColumn.setText("");
        tableColumn.setWidth(20);
        width += tableColumn.getWidth();
        tableColumn = new TableColumn(this.tableCommandsForSequence, 0, 1);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnScope"));
        tableColumn.pack();
        tableColumn.setWidth(tableColumn.getWidth() + 40);
        width += tableColumn.getWidth();
        tableColumn = new TableColumn(this.tableCommandsForSequence, 0, 2);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnConfiguration"));
        tableColumn.pack();
        tableColumn.setWidth(tableColumn.getWidth() + 40);
        width += tableColumn.getWidth();
        tableColumn = new TableColumn(this.tableCommandsForSequence, 0, 3);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnCommand"));
        tableColumn.pack();
        tableColumn.setWidth(Math.max(220, Math.max(440 - width, tableColumn.getWidth() + 20)));
        this.comboActiveConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedComboActiveKeyConfiguration();
            }
        });
        this.treeViewerCommands.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                KeyPreferencePage.this.doubleClickedTreeViewerCommands();
            }
        });
        this.treeViewerCommands.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                KeyPreferencePage.this.selectedTreeViewerCommands();
            }
        });
        this.tableSequencesForCommand.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                KeyPreferencePage.this.doubleClickedTableKeySequencesForCommand();
            }
        });
        this.tableSequencesForCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedTableKeySequencesForCommand();
            }
        });
        this.comboSequence.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeyPreferencePage.this.modifiedComboKeySequence();
            }
        });
        this.comboSequence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedComboKeySequence();
            }
        });
        this.comboScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedComboScope();
            }
        });
        this.comboConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedComboKeyConfiguration();
            }
        });
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedButtonChange();
            }
        });
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedButtonChange();
            }
        });
        this.buttonRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedButtonChange();
            }
        });
        this.tableCommandsForSequence.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                KeyPreferencePage.this.doubleClickedTableCommandsForKeySequence();
            }
        });
        this.tableCommandsForSequence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedTableCommandsForKeySequence();
            }
        });
        return composite;
    }

    private void selectedComboActiveKeyConfiguration() {
    }

    private void doubleClickedTreeViewerCommands() {
    }

    private void selectedTreeViewerCommands() {
        Object object;
        this.commandRecords.clear();
        ISelection selection = this.treeViewerCommands.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Command) {
            this.buildCommandRecords(this.tree, ((Command)object).getId(), this.commandRecords);
        }
        this.buildTableCommand();
        this.setKeySequence(null);
        this.setScopeId("org.eclipse.ui.globalScope");
        this.setKeyConfigurationId(this.getActiveKeyConfigurationId());
        Sequence keySequence = this.getKeySequence();
        String scopeId = this.getScopeId();
        String keyConfigurationId = this.getKeyConfigurationId();
        this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
        this.update();
    }

    private void doubleClickedTableKeySequencesForCommand() {
    }

    private void selectedTableKeySequencesForCommand() {
        CommandRecord commandRecord = this.getSelectedCommandRecord();
        if (commandRecord != null) {
            this.setScopeId(commandRecord.scope);
            this.setKeyConfigurationId(commandRecord.configuration);
            this.setKeySequence(commandRecord.sequence);
        }
        this.update();
    }

    private void modifiedComboKeySequence() {
        this.selectedComboKeySequence();
    }

    private void selectedComboKeySequence() {
        Sequence keySequence = this.getKeySequence();
        String scopeId = this.getScopeId();
        String keyConfigurationId = this.getKeyConfigurationId();
        this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
        this.keySequenceRecords.clear();
        this.buildSequenceRecords(this.tree, keySequence, this.keySequenceRecords);
        this.buildTableKeySequence();
        this.selectTableKeySequence(scopeId, keyConfigurationId);
        this.update();
    }

    private void selectedComboScope() {
        Sequence keySequence = this.getKeySequence();
        String scopeId = this.getScopeId();
        String keyConfigurationId = this.getKeyConfigurationId();
        this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
        this.selectTableKeySequence(scopeId, keyConfigurationId);
        this.update();
    }

    private void selectedComboKeyConfiguration() {
        Sequence keySequence = this.getKeySequence();
        String scopeId = this.getScopeId();
        String keyConfigurationId = this.getKeyConfigurationId();
        this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
        this.selectTableKeySequence(scopeId, keyConfigurationId);
        this.update();
    }

    private void selectedButtonChange() {
        boolean validKeyConfigurationId;
        Sequence keySequence = this.getKeySequence();
        boolean validKeySequence = keySequence != null && Manager.validateSequence(keySequence);
        String scopeId = this.getScopeId();
        boolean validScopeId = scopeId != null && this.scopesById.get(scopeId) != null;
        String keyConfigurationId = this.getKeyConfigurationId();
        boolean bl = validKeyConfigurationId = keyConfigurationId != null && this.keyConfigurationsById.get(keyConfigurationId) != null;
        if (validKeySequence && validScopeId && validKeyConfigurationId) {
            CommandRecord commandRecord;
            Object object;
            String commandId = null;
            ISelection selection = this.treeViewerCommands.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Command) {
                commandId = ((Command)object).getId();
            }
            if ((commandRecord = this.getSelectedCommandRecord()) == null) {
                this.set(this.tree, keySequence, scopeId, keyConfigurationId, commandId);
            } else if (!commandRecord.customSet.isEmpty()) {
                this.clear(this.tree, keySequence, scopeId, keyConfigurationId);
            } else {
                this.set(this.tree, keySequence, scopeId, keyConfigurationId, null);
            }
            this.commandRecords.clear();
            this.buildCommandRecords(this.tree, commandId, this.commandRecords);
            this.buildTableCommand();
            this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
            this.keySequenceRecords.clear();
            this.buildSequenceRecords(this.tree, keySequence, this.keySequenceRecords);
            this.buildTableKeySequence();
            this.selectTableKeySequence(scopeId, keyConfigurationId);
            this.update();
        }
    }

    private void doubleClickedTableCommandsForKeySequence() {
    }

    private void selectedTableCommandsForKeySequence() {
    }

    private void update() {
        Object object;
        Command command = null;
        ISelection selection = this.treeViewerCommands.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Command) {
            command = (Command)object;
        }
        boolean commandSelected = command != null;
        Sequence keySequence = this.getKeySequence();
        boolean validKeySequence = keySequence != null && Manager.validateSequence(keySequence);
        String scopeId = this.getScopeId();
        boolean validScopeId = scopeId != null && this.scopesById.get(scopeId) != null;
        String keyConfigurationId = this.getKeyConfigurationId();
        boolean validKeyConfigurationId = keyConfigurationId != null && this.keyConfigurationsById.get(keyConfigurationId) != null;
        this.labelName.setEnabled(commandSelected);
        this.textName.setEnabled(commandSelected);
        this.labelDescription.setEnabled(commandSelected);
        this.textDescription.setEnabled(commandSelected);
        this.labelSequencesForCommand.setEnabled(commandSelected);
        this.tableSequencesForCommand.setEnabled(commandSelected);
        this.labelSequence.setEnabled(commandSelected);
        this.comboSequence.setEnabled(commandSelected);
        this.labelScope.setEnabled(commandSelected);
        this.comboScope.setEnabled(commandSelected);
        this.labelConfiguration.setEnabled(commandSelected);
        this.comboConfiguration.setEnabled(commandSelected);
        this.buttonAdd.setEnabled(false);
        this.buttonRemove.setEnabled(false);
        this.buttonRestore.setEnabled(false);
        this.labelCommandsForSequence.setEnabled(validKeySequence);
        this.tableCommandsForSequence.setEnabled(validKeySequence);
        this.textName.setText(commandSelected ? command.getName() : "");
        String description = commandSelected ? command.getDescription() : null;
        this.textDescription.setText(description != null ? description : "");
        CommandRecord commandRecord = this.getSelectedCommandRecord();
        if (commandRecord == null) {
            this.buttonAdd.setEnabled(commandSelected && validKeySequence && validScopeId && validKeyConfigurationId);
        } else if (!commandRecord.customSet.isEmpty() && !commandRecord.defaultSet.isEmpty()) {
            this.buttonRestore.setEnabled(commandSelected && validKeySequence && validScopeId && validKeyConfigurationId);
        } else {
            this.buttonRemove.setEnabled(commandSelected && validKeySequence && validScopeId && validKeyConfigurationId);
        }
        if (validKeySequence) {
            String text = MessageFormat.format(Util.getString(resourceBundle, "labelCommandsForSequence.selection"), String.valueOf('\'') + KeySupport.formatSequence(keySequence, true) + '\'');
            this.labelCommandsForSequence.setText(text);
        } else {
            this.labelCommandsForSequence.setText(Util.getString(resourceBundle, "labelCommandsForSequence.noSelection"));
        }
    }

    private void buildCommandRecords(SortedMap tree, String command, List commandRecords) {
        if (commandRecords != null) {
            commandRecords.clear();
            if (tree != null) {
                Iterator iterator = tree.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Sequence sequence = (Sequence)entry.getKey();
                    Map scopeMap = (Map)entry.getValue();
                    if (scopeMap == null) continue;
                    Iterator iterator2 = scopeMap.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry2 = iterator2.next();
                        String scope = (String)entry2.getKey();
                        Map configurationMap = (Map)entry2.getValue();
                        Iterator iterator3 = configurationMap.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            Map.Entry entry3 = iterator3.next();
                            String configuration = (String)entry3.getKey();
                            CommandSetPair commandSetPair = (CommandSetPair)entry3.getValue();
                            HashSet customSet = new HashSet();
                            HashSet defaultSet = new HashSet();
                            if (commandSetPair.customSet != null) {
                                customSet.addAll(commandSetPair.customSet);
                            }
                            if (commandSetPair.defaultSet != null) {
                                defaultSet.addAll(commandSetPair.defaultSet);
                            }
                            if (!customSet.contains(command) && !defaultSet.contains(command)) continue;
                            CommandRecord commandRecord = new CommandRecord();
                            commandRecord.command = command;
                            commandRecord.sequence = sequence;
                            commandRecord.scope = scope;
                            commandRecord.configuration = configuration;
                            commandRecord.customSet = customSet;
                            commandRecord.defaultSet = defaultSet;
                            commandRecord.calculate();
                            commandRecords.add(commandRecord);
                        }
                    }
                }
            }
        }
    }

    private void buildSequenceRecords(SortedMap tree, Sequence sequence, List sequenceRecords) {
        if (sequenceRecords != null) {
            Map scopeMap;
            sequenceRecords.clear();
            if (tree != null && sequence != null && (scopeMap = (Map)tree.get(sequence)) != null) {
                Iterator iterator = scopeMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String scope = (String)entry.getKey();
                    Map configurationMap = (Map)entry.getValue();
                    Iterator iterator2 = configurationMap.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry2 = iterator2.next();
                        String configuration = (String)entry2.getKey();
                        CommandSetPair commandSetPair = (CommandSetPair)entry2.getValue();
                        HashSet customSet = new HashSet();
                        HashSet defaultSet = new HashSet();
                        if (commandSetPair.customSet != null) {
                            customSet.addAll(commandSetPair.customSet);
                        }
                        if (commandSetPair.defaultSet != null) {
                            defaultSet.addAll(commandSetPair.defaultSet);
                        }
                        SequenceRecord sequenceRecord = new SequenceRecord();
                        sequenceRecord.scope = scope;
                        sequenceRecord.configuration = configuration;
                        sequenceRecord.customSet = customSet;
                        sequenceRecord.defaultSet = defaultSet;
                        sequenceRecord.calculate();
                        sequenceRecords.add(sequenceRecord);
                    }
                }
            }
        }
    }

    private void buildTableCommand() {
        this.tableSequencesForCommand.removeAll();
        int i = 0;
        while (i < this.commandRecords.size()) {
            Command command;
            CommandRecord commandRecord = (CommandRecord)this.commandRecords.get(i);
            Set customSet = commandRecord.customSet;
            Set defaultSet = commandRecord.defaultSet;
            int difference = 3;
            boolean commandConflict = false;
            String alternateCommandId = null;
            boolean alternateCommandConflict = false;
            if (customSet.isEmpty()) {
                if (defaultSet.contains(commandRecord.command)) {
                    commandConflict = commandRecord.defaultConflict;
                }
            } else if (defaultSet.isEmpty()) {
                if (customSet.contains(commandRecord.command)) {
                    difference = 0;
                    commandConflict = commandRecord.customConflict;
                }
            } else if (customSet.contains(commandRecord.command)) {
                difference = 1;
                commandConflict = commandRecord.customConflict;
                alternateCommandId = commandRecord.defaultCommand;
                alternateCommandConflict = commandRecord.defaultConflict;
            } else if (defaultSet.contains(commandRecord.command)) {
                difference = 2;
                commandConflict = commandRecord.defaultConflict;
                alternateCommandId = commandRecord.customCommand;
                alternateCommandConflict = commandRecord.customConflict;
            }
            TableItem tableItem = new TableItem(this.tableSequencesForCommand, 0);
            switch (difference) {
                case 0: {
                    tableItem.setImage(0, IMAGE_PLUS);
                    break;
                }
                case 1: {
                    tableItem.setImage(0, IMAGE_CHANGE);
                    break;
                }
                case 2: {
                    tableItem.setImage(0, IMAGE_MINUS);
                    break;
                }
                case 3: {
                    tableItem.setImage(0, IMAGE_BLANK);
                }
            }
            Scope scope = (Scope)this.scopesById.get(commandRecord.scope);
            tableItem.setText(1, scope != null ? scope.getName() : this.bracket(commandRecord.scope));
            Configuration keyConfiguration = (Configuration)this.keyConfigurationsById.get(commandRecord.configuration);
            tableItem.setText(2, keyConfiguration != null ? keyConfiguration.getName() : this.bracket(commandRecord.configuration));
            boolean conflict = commandConflict || alternateCommandConflict;
            StringBuffer stringBuffer = new StringBuffer();
            if (commandRecord.sequence != null) {
                stringBuffer.append(KeySupport.formatSequence(commandRecord.sequence, true));
            }
            if (commandConflict) {
                stringBuffer.append(String.valueOf(' ') + COMMAND_CONFLICT);
            }
            String alternateCommandName = null;
            alternateCommandName = alternateCommandId == null ? COMMAND_UNDEFINED : (alternateCommandId.length() == 0 ? COMMAND_NOTHING : ((command = (Command)this.commandsById.get(alternateCommandId)) != null ? command.getName() : this.bracket(alternateCommandId)));
            if (alternateCommandConflict) {
                alternateCommandName = String.valueOf(alternateCommandName) + ' ' + COMMAND_CONFLICT;
            }
            stringBuffer.append(' ');
            if (difference == 1) {
                stringBuffer.append(MessageFormat.format(Util.getString(resourceBundle, "was"), alternateCommandName));
            } else if (difference == 2) {
                stringBuffer.append(MessageFormat.format(Util.getString(resourceBundle, "now"), alternateCommandName));
            }
            tableItem.setText(3, stringBuffer.toString());
            if (difference == 2) {
                if (conflict) {
                    tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_CONFLICT_MINUS));
                } else {
                    tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_MINUS));
                }
            } else if (conflict) {
                tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_CONFLICT));
            }
            ++i;
        }
    }

    private void buildTableKeySequence() {
        this.tableCommandsForSequence.removeAll();
        int i = 0;
        while (i < this.keySequenceRecords.size()) {
            Command command;
            Command command2;
            SequenceRecord keySequenceRecord = (SequenceRecord)this.keySequenceRecords.get(i);
            int difference = 3;
            String commandId = null;
            boolean commandConflict = false;
            String alternateCommandId = null;
            boolean alternateCommandConflict = false;
            if (keySequenceRecord.customSet.isEmpty()) {
                commandId = keySequenceRecord.defaultCommand;
                commandConflict = keySequenceRecord.defaultConflict;
            } else {
                commandId = keySequenceRecord.customCommand;
                commandConflict = keySequenceRecord.customConflict;
                if (keySequenceRecord.defaultSet.isEmpty()) {
                    difference = 0;
                } else {
                    difference = 1;
                    alternateCommandId = keySequenceRecord.defaultCommand;
                    alternateCommandConflict = keySequenceRecord.defaultConflict;
                }
            }
            TableItem tableItem = new TableItem(this.tableCommandsForSequence, 0);
            switch (difference) {
                case 0: {
                    tableItem.setImage(0, IMAGE_PLUS);
                    break;
                }
                case 1: {
                    tableItem.setImage(0, IMAGE_CHANGE);
                    break;
                }
                case 2: {
                    tableItem.setImage(0, IMAGE_MINUS);
                    break;
                }
                case 3: {
                    tableItem.setImage(0, IMAGE_BLANK);
                }
            }
            Scope scope = (Scope)this.scopesById.get(keySequenceRecord.scope);
            tableItem.setText(1, scope != null ? scope.getName() : this.bracket(keySequenceRecord.scope));
            Configuration keyConfiguration = (Configuration)this.keyConfigurationsById.get(keySequenceRecord.configuration);
            tableItem.setText(2, keyConfiguration != null ? keyConfiguration.getName() : this.bracket(keySequenceRecord.configuration));
            boolean conflict = commandConflict || alternateCommandConflict;
            StringBuffer stringBuffer = new StringBuffer();
            String commandName = null;
            commandName = commandId == null ? COMMAND_UNDEFINED : (commandId.length() == 0 ? COMMAND_NOTHING : ((command2 = (Command)this.commandsById.get(commandId)) != null ? command2.getName() : this.bracket(commandId)));
            stringBuffer.append(commandName);
            if (commandConflict) {
                stringBuffer.append(String.valueOf(' ') + COMMAND_CONFLICT);
            }
            String alternateCommandName = null;
            alternateCommandName = alternateCommandId == null ? COMMAND_UNDEFINED : (alternateCommandId.length() == 0 ? COMMAND_NOTHING : ((command = (Command)this.commandsById.get(alternateCommandId)) != null ? command.getName() : this.bracket(alternateCommandId)));
            if (alternateCommandConflict) {
                alternateCommandName = String.valueOf(alternateCommandName) + ' ' + COMMAND_CONFLICT;
            }
            stringBuffer.append(' ');
            if (difference == 1) {
                stringBuffer.append(MessageFormat.format(Util.getString(resourceBundle, "was"), alternateCommandName));
            }
            tableItem.setText(3, stringBuffer.toString());
            if (difference == 2) {
                if (conflict) {
                    tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_CONFLICT_MINUS));
                } else {
                    tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_MINUS));
                }
            } else if (conflict) {
                tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_CONFLICT));
            }
            ++i;
        }
    }

    private void selectTableCommand(String scopeId, String keyConfigurationId, Sequence keySequence) {
        int selection = -1;
        int i = 0;
        while (i < this.commandRecords.size()) {
            CommandRecord commandRecord = (CommandRecord)this.commandRecords.get(i);
            if (Util.equals(scopeId, commandRecord.scope) && Util.equals(keyConfigurationId, commandRecord.configuration) && Util.equals(keySequence, commandRecord.sequence)) {
                selection = i;
                break;
            }
            ++i;
        }
        if (this.tableSequencesForCommand.getSelectionCount() > 1) {
            this.tableSequencesForCommand.deselectAll();
        }
        if (selection != this.tableSequencesForCommand.getSelectionIndex()) {
            if (selection == -1 || selection >= this.tableSequencesForCommand.getItemCount()) {
                this.tableSequencesForCommand.deselectAll();
            } else {
                this.tableSequencesForCommand.select(selection);
            }
        }
    }

    private void selectTableKeySequence(String scopeId, String keyConfigurationId) {
        int selection = -1;
        int i = 0;
        while (i < this.keySequenceRecords.size()) {
            SequenceRecord keySequenceRecord = (SequenceRecord)this.keySequenceRecords.get(i);
            if (Util.equals(scopeId, keySequenceRecord.scope) && Util.equals(keyConfigurationId, keySequenceRecord.configuration)) {
                selection = i;
                break;
            }
            ++i;
        }
        if (this.tableCommandsForSequence.getSelectionCount() > 1) {
            this.tableCommandsForSequence.deselectAll();
        }
        if (selection != this.tableCommandsForSequence.getSelectionIndex()) {
            if (selection == -1 || selection >= this.tableCommandsForSequence.getItemCount()) {
                this.tableCommandsForSequence.deselectAll();
            } else {
                this.tableCommandsForSequence.select(selection);
            }
        }
    }

    private CommandRecord getSelectedCommandRecord() {
        int selection = this.tableSequencesForCommand.getSelectionIndex();
        if (selection >= 0 && selection < this.commandRecords.size() && this.tableSequencesForCommand.getSelectionCount() == 1) {
            return (CommandRecord)this.commandRecords.get(selection);
        }
        return null;
    }

    private SequenceRecord getSelectedKeySequenceRecord() {
        int selection = this.tableCommandsForSequence.getSelectionIndex();
        if (selection >= 0 && selection < this.keySequenceRecords.size() && this.tableCommandsForSequence.getSelectionCount() == 1) {
            return (SequenceRecord)this.keySequenceRecords.get(selection);
        }
        return null;
    }

    private Sequence getKeySequence() {
        Sequence keySequence = null;
        String name = this.comboSequence.getText();
        keySequence = (Sequence)this.keySequencesByName.get(name);
        if (keySequence == null) {
            keySequence = KeySupport.parseSequence(name, true);
        }
        return keySequence;
    }

    private void setKeySequence(Sequence keySequence) {
        this.comboSequence.setText(keySequence != null ? KeySupport.formatSequence(keySequence, true) : "");
    }

    private String getScopeId() {
        int selection = this.comboScope.getSelectionIndex();
        ArrayList scopes = new ArrayList(this.scopesByName.values());
        if (selection >= 0 && selection < scopes.size()) {
            Scope scope = (Scope)scopes.get(selection);
            return scope.getId();
        }
        return null;
    }

    private void setScopeId(String scopeId) {
        this.comboScope.clearSelection();
        this.comboScope.deselectAll();
        if (scopeId != null) {
            ArrayList scopes = new ArrayList(this.scopesByName.values());
            int i = 0;
            while (i < scopes.size()) {
                Scope scope = (Scope)scopes.get(i);
                if (scope.getId().equals(scopeId)) {
                    this.comboScope.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private String getActiveKeyConfigurationId() {
        int selection = this.comboActiveConfiguration.getSelectionIndex();
        ArrayList keyConfigurations = new ArrayList(this.keyConfigurationsByName.values());
        if (selection >= 0 && selection < keyConfigurations.size()) {
            Configuration keyConfiguration = (Configuration)keyConfigurations.get(selection);
            return keyConfiguration.getId();
        }
        return null;
    }

    private void setActiveKeyConfigurationId(String keyConfigurationId) {
        this.comboActiveConfiguration.clearSelection();
        this.comboActiveConfiguration.deselectAll();
        if (keyConfigurationId != null) {
            ArrayList keyConfigurations = new ArrayList(this.keyConfigurationsByName.values());
            int i = 0;
            while (i < keyConfigurations.size()) {
                Configuration keyConfiguration = (Configuration)keyConfigurations.get(i);
                if (keyConfiguration.getId().equals(keyConfigurationId)) {
                    this.comboActiveConfiguration.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private String getKeyConfigurationId() {
        int selection = this.comboConfiguration.getSelectionIndex();
        ArrayList keyConfigurations = new ArrayList(this.keyConfigurationsByName.values());
        if (selection >= 0 && selection < keyConfigurations.size()) {
            Configuration keyConfiguration = (Configuration)keyConfigurations.get(selection);
            return keyConfiguration.getId();
        }
        return null;
    }

    private void setKeyConfigurationId(String keyConfigurationId) {
        this.comboConfiguration.clearSelection();
        this.comboConfiguration.deselectAll();
        if (keyConfigurationId != null) {
            ArrayList keyConfigurations = new ArrayList(this.keyConfigurationsByName.values());
            int i = 0;
            while (i < keyConfigurations.size()) {
                Configuration keyConfiguration = (Configuration)keyConfigurations.get(i);
                if (keyConfiguration.getId().equals(keyConfigurationId)) {
                    this.comboConfiguration.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private String bracket(String string) {
        return string != null ? String.valueOf('[') + string + ']' : "[]";
    }

    private SortedMap build(SortedSet sequenceBindingSet) {
        TreeMap tree = new TreeMap();
        Iterator<Object> iterator = sequenceBindingSet.iterator();
        while (iterator.hasNext()) {
            HashSet<String> commandSet;
            TreeMap<State, HashSet<String>> platformLocaleMap;
            TreeMap rankMap;
            TreeMap configurationMap;
            SequenceBinding sequenceBinding = (SequenceBinding)iterator.next();
            Sequence sequence = sequenceBinding.getSequence();
            String configuration = sequenceBinding.getConfiguration();
            String command = sequenceBinding.getCommand();
            Path locale = SequenceMachine.getPathForLocale(sequenceBinding.getLocale());
            Path platform = SequenceMachine.getPathForPlatform(sequenceBinding.getPlatform());
            ArrayList<Path> paths = new ArrayList<Path>();
            paths.add(platform);
            paths.add(locale);
            State platformLocale = State.create(paths);
            Integer rank = new Integer(sequenceBinding.getRank());
            String scope = sequenceBinding.getScope();
            TreeMap scopeMap = (TreeMap)tree.get(sequence);
            if (scopeMap == null) {
                scopeMap = new TreeMap();
                tree.put(sequence, scopeMap);
            }
            if ((configurationMap = (TreeMap)scopeMap.get(scope)) == null) {
                configurationMap = new TreeMap();
                scopeMap.put(scope, configurationMap);
            }
            if ((rankMap = (TreeMap)configurationMap.get(configuration)) == null) {
                rankMap = new TreeMap();
                configurationMap.put(configuration, rankMap);
            }
            if ((platformLocaleMap = (TreeMap<State, HashSet<String>>)rankMap.get(rank)) == null) {
                platformLocaleMap = new TreeMap<State, HashSet<String>>();
                rankMap.put(rank, platformLocaleMap);
            }
            if ((commandSet = (HashSet<String>)platformLocaleMap.get(platformLocale)) == null) {
                commandSet = new HashSet<String>();
                platformLocaleMap.put(platformLocale, commandSet);
            }
            commandSet.add(command);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(SequenceMachine.getSystemPlatform());
        paths.add(SequenceMachine.getSystemLocale());
        State platformLocale = State.create(paths);
        iterator = tree.values().iterator();
        while (iterator.hasNext()) {
            SortedMap scopeMap = (SortedMap)iterator.next();
            Iterator iterator2 = scopeMap.values().iterator();
            while (iterator2.hasNext()) {
                SortedMap configurationMap = (SortedMap)iterator2.next();
                Iterator iterator3 = configurationMap.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry entry = iterator3.next();
                    entry.setValue(this.solveRankMap((SortedMap)entry.getValue(), platformLocale));
                }
            }
        }
        return tree;
    }

    private CommandSetPair solveRankMap(SortedMap rankMap, State platformLocale) {
        CommandSetPair commandSetPair = new CommandSetPair();
        Iterator iterator = rankMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer rank = (Integer)entry.getKey();
            SortedMap platformLocaleMap = (SortedMap)entry.getValue();
            Set commandSet = this.solvePlatformLocaleMap(platformLocaleMap, platformLocale);
            if (rank == 0) {
                commandSetPair.customSet = commandSet;
                continue;
            }
            if (commandSetPair.defaultSet != null) continue;
            commandSetPair.defaultSet = commandSet;
        }
        return commandSetPair;
    }

    private Set solvePlatformLocaleMap(SortedMap platformLocaleMap, State platformLocale) {
        int bestDefinedMatch = -1;
        Set bestDefinedCommandSet = null;
        int bestUndefinedMatch = -1;
        Set bestUndefinedCommandSet = null;
        Iterator iterator = platformLocaleMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            State testPlatformLocale = (State)entry.getKey();
            Set testCommandSet = (Set)entry.getValue();
            int testMatch = testPlatformLocale.match(platformLocale);
            if (testMatch < 0) continue;
            String testCommand = SequenceNode.solveCommandSet(testCommandSet);
            if (testCommand != null) {
                if (bestDefinedMatch != -1 && testMatch >= bestDefinedMatch) continue;
                bestDefinedMatch = testMatch;
                bestDefinedCommandSet = testCommandSet;
                continue;
            }
            if (bestUndefinedMatch != -1 && testMatch >= bestUndefinedMatch) continue;
            bestUndefinedMatch = testMatch;
            bestUndefinedCommandSet = testCommandSet;
        }
        return bestDefinedMatch >= 0 ? bestDefinedCommandSet : bestUndefinedCommandSet;
    }

    private SortedSet solve(SortedMap tree) {
        TreeSet<SequenceBinding> sequenceBindingSet = new TreeSet<SequenceBinding>();
        Iterator iterator = tree.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Sequence sequence = (Sequence)entry.getKey();
            SortedMap scopeMap = (SortedMap)entry.getValue();
            Iterator iterator2 = scopeMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                String scope = (String)entry2.getKey();
                SortedMap configurationMap = (SortedMap)entry2.getValue();
                Iterator iterator3 = configurationMap.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry entry3 = iterator3.next();
                    String configuration = (String)entry3.getKey();
                    CommandSetPair commandSetPair = (CommandSetPair)entry3.getValue();
                    Set customSet = commandSetPair.customSet;
                    if (customSet == null) continue;
                    Iterator iterator4 = customSet.iterator();
                    while (iterator4.hasNext()) {
                        String command = (String)iterator4.next();
                        sequenceBindingSet.add(SequenceBinding.create(configuration, command, "", "", null, 0, scope, sequence));
                    }
                }
            }
        }
        return sequenceBindingSet;
    }

    private void set(SortedMap tree, Sequence sequence, String scope, String configuration, String command) {
        CommandSetPair commandSetPair;
        TreeMap<String, CommandSetPair> configurationMap;
        TreeMap scopeMap = (TreeMap)tree.get(sequence);
        if (scopeMap == null) {
            scopeMap = new TreeMap();
            tree.put(sequence, scopeMap);
        }
        if ((configurationMap = (TreeMap<String, CommandSetPair>)scopeMap.get(scope)) == null) {
            configurationMap = new TreeMap<String, CommandSetPair>();
            scopeMap.put(scope, configurationMap);
        }
        if ((commandSetPair = (CommandSetPair)configurationMap.get(configuration)) == null) {
            commandSetPair = new CommandSetPair();
            configurationMap.put(configuration, commandSetPair);
        }
        HashSet<String> customSet = new HashSet<String>();
        customSet.add(command);
        commandSetPair.customSet = customSet;
    }

    private void clear(SortedMap tree, Sequence sequence, String scope, String configuration) {
        CommandSetPair commandSetPair;
        SortedMap configurationMap;
        SortedMap scopeMap = (SortedMap)tree.get(sequence);
        if (scopeMap != null && (configurationMap = (SortedMap)scopeMap.get(scope)) != null && (commandSetPair = (CommandSetPair)configurationMap.get(configuration)) != null) {
            commandSetPair.customSet = null;
            if (commandSetPair.defaultSet == null) {
                configurationMap.remove(configuration);
                if (configurationMap.isEmpty()) {
                    scopeMap.remove(scope);
                    if (scopeMap.isEmpty()) {
                        tree.remove(sequence);
                    }
                }
            }
        }
    }

    private final class CommandSetPair {
        Set customSet;
        Set defaultSet;

        CommandSetPair() {
        }
    }

    private final class CommandRecord {
        String command;
        Sequence sequence;
        String scope;
        String configuration;
        Set customSet;
        Set defaultSet;
        boolean customConflict = false;
        String customCommand = null;
        boolean defaultConflict = false;
        String defaultCommand = null;

        CommandRecord() {
        }

        void calculate() {
            if (this.customSet.size() > 1) {
                this.customConflict = true;
            } else if (!this.customSet.isEmpty()) {
                this.customCommand = (String)this.customSet.iterator().next();
            }
            if (this.defaultSet.size() > 1) {
                this.defaultConflict = true;
            } else if (!this.defaultSet.isEmpty()) {
                this.defaultCommand = (String)this.defaultSet.iterator().next();
            }
        }
    }

    private final class SequenceRecord {
        String scope;
        String configuration;
        Set customSet;
        Set defaultSet;
        boolean customConflict = false;
        String customCommand = null;
        boolean defaultConflict = false;
        String defaultCommand = null;

        SequenceRecord() {
        }

        void calculate() {
            if (this.customSet.size() > 1) {
                this.customConflict = true;
            } else if (!this.customSet.isEmpty()) {
                this.customCommand = (String)this.customSet.iterator().next();
            }
            if (this.defaultSet.size() > 1) {
                this.defaultConflict = true;
            } else if (!this.defaultSet.isEmpty()) {
                this.defaultCommand = (String)this.defaultSet.iterator().next();
            }
        }
    }

    private class TreeViewerCommandsContentProvider
    implements ITreeContentProvider {
        TreeViewerCommandsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Command> children;
            block5: {
                ArrayList commands;
                block4: {
                    children = new ArrayList<Command>();
                    commands = new ArrayList(KeyPreferencePage.this.commands);
                    Collections.sort(commands, Command.nameComparator());
                    if (!(parentElement instanceof Category)) break block4;
                    Category category = (Category)parentElement;
                    int i = 0;
                    while (i < commands.size()) {
                        Command command = (Command)commands.get(i);
                        if (category.getId().equals(command.getCategory())) {
                            children.add(command);
                        }
                        ++i;
                    }
                    break block5;
                }
                if (parentElement != null) break block5;
                ArrayList categories = new ArrayList(KeyPreferencePage.this.categories);
                Collections.sort(categories, Category.nameComparator());
                children.addAll(categories);
                int i = 0;
                while (i < commands.size()) {
                    Command command = (Command)commands.get(i);
                    if (command.getCategory() == null) {
                        children.add(command);
                    }
                    ++i;
                }
            }
            return children.toArray();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(null);
        }

        public Object getParent(Object element) {
            String category;
            if (element instanceof Command && KeyPreferencePage.this.categoriesById != null && (category = ((Command)element).getCategory()) != null) {
                return KeyPreferencePage.this.categoriesById.get(category);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length >= 1;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TreeViewerCommandsLabelProvider
    extends LabelProvider {
        TreeViewerCommandsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Category) {
                return ((Category)element).getName();
            }
            if (element instanceof Command) {
                return ((Command)element).getName();
            }
            return super.getText(element);
        }
    }
}

