/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.AbstractMutableRegistry;
import org.eclipse.ui.internal.commands.Persistence;

public final class LocalRegistry
extends AbstractMutableRegistry {
    private static final String PATH = "org.eclipse.ui.commands.xml";
    private static final int RANK_LOCAL = 1;
    private static final String TAG_ROOT = "org.eclipse.ui.commands";
    public static LocalRegistry instance;

    public static LocalRegistry getInstance() {
        if (instance == null) {
            instance = new LocalRegistry();
        }
        return instance;
    }

    private LocalRegistry() {
    }

    public void load() throws IOException {
        IPath path = WorkbenchPlugin.getDefault().getStateLocation();
        path = path.append(PATH);
        File file = path.toFile();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            try {
                XMLMemento memento = XMLMemento.createReadRoot(reader);
                this.activeGestureConfigurations = Collections.unmodifiableList(Persistence.readActiveConfigurations(memento, "activeGestureConfiguration", null));
                this.activeKeyConfigurations = Collections.unmodifiableList(Persistence.readActiveConfigurations(memento, "activeKeyConfiguration", null));
                this.categories = Collections.unmodifiableList(Persistence.readCategories(memento, "category", null));
                this.commands = Collections.unmodifiableList(Persistence.readCommands(memento, "command", null));
                this.gestureBindings = Collections.unmodifiableList(Persistence.readBindings(memento, "gestureBinding", null, 1));
                this.gestureConfigurations = Collections.unmodifiableList(Persistence.readConfigurations(memento, "gestureConfiguration", null));
                this.keyBindings = Collections.unmodifiableList(Persistence.readBindings(memento, "keyBinding", null, 1));
                this.keyConfigurations = Collections.unmodifiableList(Persistence.readConfigurations(memento, "keyConfiguration", null));
                this.scopes = Collections.unmodifiableList(Persistence.readScopes(memento, "scope", null));
            }
            catch (WorkbenchException workbenchException) {
                throw new IOException();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ((Reader)reader).close();
            throw throwable;
        }
        Object var5_7 = null;
        ((Reader)reader).close();
    }

    public void save() throws IOException {
        XMLMemento xmlMemento = XMLMemento.createWriteRoot(TAG_ROOT);
        Persistence.writeActiveConfigurations(xmlMemento, "activeGestureConfiguration", this.activeGestureConfigurations);
        Persistence.writeActiveConfigurations(xmlMemento, "activeKeyConfiguration", this.activeKeyConfigurations);
        Persistence.writeCategories(xmlMemento, "category", this.categories);
        Persistence.writeCommands(xmlMemento, "command", this.commands);
        Persistence.writeBindings(xmlMemento, "gestureBinding", this.gestureBindings);
        Persistence.writeConfigurations(xmlMemento, "gestureConfiguration", this.gestureConfigurations);
        Persistence.writeBindings(xmlMemento, "keyBinding", this.keyBindings);
        Persistence.writeConfigurations(xmlMemento, "keyConfiguration", this.keyConfigurations);
        Persistence.writeScopes(xmlMemento, "scope", this.scopes);
        IPath path = WorkbenchPlugin.getDefault().getStateLocation();
        path = path.append(PATH);
        File file = path.toFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            xmlMemento.save(writer);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ((Writer)writer).close();
            throw throwable;
        }
        Object var5_7 = null;
        ((Writer)writer).close();
    }
}

