/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.commands.ActiveConfiguration;
import org.eclipse.ui.internal.commands.Category;
import org.eclipse.ui.internal.commands.Command;
import org.eclipse.ui.internal.commands.Configuration;
import org.eclipse.ui.internal.commands.KeySupport;
import org.eclipse.ui.internal.commands.Scope;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.SequenceBinding;
import org.eclipse.ui.internal.commands.Stroke;

final class Persistence {
    static final String PACKAGE_BASE = "commands";
    static final String PACKAGE_FULL = "org.eclipse.ui.commands";
    static final String TAG_ACTIVE_GESTURE_CONFIGURATION = "activeGestureConfiguration";
    static final String TAG_ACTIVE_KEY_CONFIGURATION = "activeKeyConfiguration";
    static final String TAG_CATEGORY = "category";
    static final String TAG_COMMAND = "command";
    static final String TAG_DESCRIPTION = "description";
    static final String TAG_GESTURE_BINDING = "gestureBinding";
    static final String TAG_GESTURE_CONFIGURATION = "gestureConfiguration";
    static final String TAG_ID = "id";
    static final String TAG_KEY_BINDING = "keyBinding";
    static final String TAG_KEY_CONFIGURATION = "keyConfiguration";
    static final String TAG_CONFIGURATION = "configuration";
    static final String TAG_SEQUENCE = "sequence";
    static final String TAG_STRING = "string";
    static final String TAG_STROKE = "stroke";
    static final String TAG_LOCALE = "locale";
    static final String TAG_NAME = "name";
    static final String TAG_PARENT = "parent";
    static final String TAG_PLATFORM = "platform";
    static final String TAG_PLUGIN = "plugin";
    static final String TAG_SCOPE = "scope";
    static final String TAG_VALUE = "value";
    static final Integer ZERO = new Integer(0);
    static final Sequence ZERO_LENGTH_SEQUENCE = Sequence.create();

    static ActiveConfiguration readActiveConfiguration(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        String value = memento.getString(TAG_VALUE);
        if (value == null) {
            value = "";
        }
        return ActiveConfiguration.create(plugin, value);
    }

    static List readActiveConfigurations(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ActiveConfiguration> list = new ArrayList<ActiveConfiguration>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readActiveConfiguration(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static Category readCategory(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = "";
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = "";
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return Category.create(description, id, name, plugin);
    }

    static List readCategories(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Category> list = new ArrayList<Category>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readCategory(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static Command readCommand(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String category = memento.getString(TAG_CATEGORY);
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = "";
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = "";
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return Command.create(category, description, id, name, plugin);
    }

    static List readCommands(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Command> list = new ArrayList<Command>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readCommand(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static SequenceBinding readBinding(IMemento memento, String pluginOverride, int rank) throws IllegalArgumentException {
        String platform;
        String locale;
        String string;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String command = memento.getString(TAG_COMMAND);
        String configuration = memento.getString(TAG_CONFIGURATION);
        if (configuration == null) {
            configuration = memento.getString(TAG_KEY_CONFIGURATION);
        }
        if (configuration == null) {
            configuration = "";
        }
        Sequence sequence = null;
        IMemento mementoSequence = memento.getChild(TAG_SEQUENCE);
        if (mementoSequence != null) {
            sequence = Persistence.readSequence(mementoSequence);
        } else {
            string = memento.getString(TAG_STRING);
            if (string != null) {
                try {
                    sequence = KeySupport.parseSequence(string, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (sequence == null) {
            mementoSequence = memento.getChild("keySequence");
            if (mementoSequence != null) {
                sequence = Persistence.readSequence(mementoSequence);
            } else {
                string = memento.getString("keyString");
                if (string != null) {
                    try {
                        sequence = KeySupport.parseSequence(string, false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        if (sequence == null) {
            sequence = ZERO_LENGTH_SEQUENCE;
        }
        if ((locale = memento.getString(TAG_LOCALE)) == null) {
            locale = "";
        }
        if ((platform = memento.getString(TAG_PLATFORM)) == null) {
            platform = "";
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        String scope = memento.getString(TAG_SCOPE);
        if (scope == null) {
            scope = "";
        }
        return SequenceBinding.create(configuration, command, locale, platform, plugin, rank, scope, sequence);
    }

    static List readBindings(IMemento memento, String name, String pluginOverride, int rank) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<SequenceBinding> list = new ArrayList<SequenceBinding>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readBinding(mementos[i], pluginOverride, rank));
            ++i;
        }
        return list;
    }

    static Configuration readConfiguration(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = "";
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = "";
        }
        String parent = memento.getString(TAG_PARENT);
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return Configuration.create(description, id, name, parent, plugin);
    }

    static List readConfigurations(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Configuration> list = new ArrayList<Configuration>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readConfiguration(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static Sequence readSequence(IMemento memento) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(TAG_STROKE);
        if (mementos == null) {
            mementos = memento.getChildren("keyStroke");
        }
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Stroke> strokes = new ArrayList<Stroke>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            strokes.add(Persistence.readStroke(mementos[i]));
            ++i;
        }
        return Sequence.create(strokes);
    }

    static Stroke readStroke(IMemento memento) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        Integer value = memento.getInteger(TAG_VALUE);
        if (value == null) {
            value = ZERO;
        }
        return Stroke.create(value);
    }

    static Scope readScope(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = "";
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = "";
        }
        String parent = memento.getString(TAG_PARENT);
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return Scope.create(description, id, name, parent, plugin);
    }

    static List readScopes(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Scope> list = new ArrayList<Scope>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readScope(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static void writeActiveConfiguration(IMemento memento, ActiveConfiguration activeConfiguration) throws IllegalArgumentException {
        if (memento == null || activeConfiguration == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_PLUGIN, activeConfiguration.getPlugin());
        memento.putString(TAG_VALUE, activeConfiguration.getValue());
    }

    static void writeActiveConfigurations(IMemento memento, String name, List activeConfigurations) throws IllegalArgumentException {
        if (memento == null || name == null || activeConfigurations == null) {
            throw new IllegalArgumentException();
        }
        activeConfigurations = new ArrayList(activeConfigurations);
        Iterator iterator = activeConfigurations.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof ActiveConfiguration) continue;
            throw new IllegalArgumentException();
        }
        iterator = activeConfigurations.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActiveConfiguration(memento.createChild(name), (ActiveConfiguration)iterator.next());
        }
    }

    static void writeCategory(IMemento memento, Category category) throws IllegalArgumentException {
        if (memento == null || category == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_DESCRIPTION, category.getDescription());
        memento.putString(TAG_ID, category.getId());
        memento.putString(TAG_NAME, category.getName());
        memento.putString(TAG_PLUGIN, category.getPlugin());
    }

    static void writeCategories(IMemento memento, String name, List categories) throws IllegalArgumentException {
        if (memento == null || name == null || categories == null) {
            throw new IllegalArgumentException();
        }
        categories = new ArrayList(categories);
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Category) continue;
            throw new IllegalArgumentException();
        }
        iterator = categories.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCategory(memento.createChild(name), (Category)iterator.next());
        }
    }

    static void writeCommand(IMemento memento, Command command) throws IllegalArgumentException {
        if (memento == null || command == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_CATEGORY, command.getCategory());
        memento.putString(TAG_DESCRIPTION, command.getDescription());
        memento.putString(TAG_ID, command.getId());
        memento.putString(TAG_NAME, command.getName());
        memento.putString(TAG_PLUGIN, command.getPlugin());
    }

    static void writeCommands(IMemento memento, String name, List commands) throws IllegalArgumentException {
        if (memento == null || name == null || commands == null) {
            throw new IllegalArgumentException();
        }
        commands = new ArrayList(commands);
        Iterator iterator = commands.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Command) continue;
            throw new IllegalArgumentException();
        }
        iterator = commands.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCommand(memento.createChild(name), (Command)iterator.next());
        }
    }

    static void writeBinding(IMemento memento, SequenceBinding sequenceBinding) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_COMMAND, sequenceBinding.getCommand());
        memento.putString(TAG_CONFIGURATION, sequenceBinding.getConfiguration());
        Persistence.writeSequence(memento.createChild(TAG_SEQUENCE), sequenceBinding.getSequence());
        memento.putString(TAG_LOCALE, sequenceBinding.getLocale());
        memento.putString(TAG_PLATFORM, sequenceBinding.getPlatform());
        memento.putString(TAG_PLUGIN, sequenceBinding.getPlugin());
        memento.putString(TAG_SCOPE, sequenceBinding.getScope());
    }

    static void writeBindings(IMemento memento, String name, List sequenceBindings) throws IllegalArgumentException {
        if (memento == null || name == null || sequenceBindings == null) {
            throw new IllegalArgumentException();
        }
        sequenceBindings = new ArrayList(sequenceBindings);
        Iterator iterator = sequenceBindings.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof SequenceBinding) continue;
            throw new IllegalArgumentException();
        }
        iterator = sequenceBindings.iterator();
        while (iterator.hasNext()) {
            Persistence.writeBinding(memento.createChild(name), (SequenceBinding)iterator.next());
        }
    }

    static void writeConfiguration(IMemento memento, Configuration configuration) throws IllegalArgumentException {
        if (memento == null || configuration == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_DESCRIPTION, configuration.getDescription());
        memento.putString(TAG_ID, configuration.getId());
        memento.putString(TAG_NAME, configuration.getName());
        memento.putString(TAG_PARENT, configuration.getParent());
        memento.putString(TAG_PLUGIN, configuration.getPlugin());
    }

    static void writeConfigurations(IMemento memento, String name, List configurations) throws IllegalArgumentException {
        if (memento == null || name == null || configurations == null) {
            throw new IllegalArgumentException();
        }
        configurations = new ArrayList(configurations);
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Configuration) continue;
            throw new IllegalArgumentException();
        }
        iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Persistence.writeConfiguration(memento.createChild(name), (Configuration)iterator.next());
        }
    }

    static void writeSequence(IMemento memento, Sequence sequence) throws IllegalArgumentException {
        if (memento == null || sequence == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = sequence.getStrokes().iterator();
        while (iterator.hasNext()) {
            Persistence.writeStroke(memento.createChild(TAG_STROKE), (Stroke)iterator.next());
        }
    }

    static void writeStroke(IMemento memento, Stroke stroke) throws IllegalArgumentException {
        if (memento == null || stroke == null) {
            throw new IllegalArgumentException();
        }
        memento.putInteger(TAG_VALUE, stroke.getValue());
    }

    static void writeScope(IMemento memento, Scope scope) throws IllegalArgumentException {
        if (memento == null || scope == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_DESCRIPTION, scope.getDescription());
        memento.putString(TAG_ID, scope.getId());
        memento.putString(TAG_NAME, scope.getName());
        memento.putString(TAG_PARENT, scope.getParent());
        memento.putString(TAG_PLUGIN, scope.getPlugin());
    }

    static void writeScopes(IMemento memento, String name, List scopes) throws IllegalArgumentException {
        if (memento == null || name == null || scopes == null) {
            throw new IllegalArgumentException();
        }
        scopes = new ArrayList(scopes);
        Iterator iterator = scopes.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Scope) continue;
            throw new IllegalArgumentException();
        }
        iterator = scopes.iterator();
        while (iterator.hasNext()) {
            Persistence.writeScope(memento.createChild(name), (Scope)iterator.next());
        }
    }

    private Persistence() {
    }
}

