/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.Util;

public final class SequenceBinding
implements Comparable {
    private static final int HASH_FACTOR = 107;
    private static final int HASH_INITIAL = 117;
    private String configuration;
    private String command;
    private String locale;
    private String platform;
    private String plugin;
    private int rank;
    private String scope;
    private Sequence sequence;

    public static SequenceBinding create(String configuration, String command, String locale, String platform, String plugin, int rank, String scope, Sequence sequence) throws IllegalArgumentException {
        return new SequenceBinding(configuration, command, locale, platform, plugin, rank, scope, sequence);
    }

    private SequenceBinding(String configuration, String command, String locale, String platform, String plugin, int rank, String scope, Sequence sequence) throws IllegalArgumentException {
        if (configuration == null || locale == null || platform == null || rank < 0 || scope == null || sequence == null) {
            throw new IllegalArgumentException();
        }
        this.configuration = configuration;
        this.command = command;
        this.locale = locale;
        this.platform = platform;
        this.plugin = plugin;
        this.rank = rank;
        this.scope = scope;
        this.sequence = sequence;
    }

    public int compareTo(Object object) {
        SequenceBinding sequenceBinding = (SequenceBinding)object;
        int compareTo = this.configuration.compareTo(sequenceBinding.configuration);
        if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.command), (Comparable)((Object)sequenceBinding.command))) == 0 && (compareTo = this.locale.compareTo(sequenceBinding.locale)) == 0 && (compareTo = this.platform.compareTo(sequenceBinding.platform)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)sequenceBinding.plugin))) == 0 && (compareTo = this.rank - sequenceBinding.rank) == 0 && (compareTo = this.scope.compareTo(sequenceBinding.scope)) == 0) {
            compareTo = this.sequence.compareTo(sequenceBinding.sequence);
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SequenceBinding)) {
            return false;
        }
        SequenceBinding sequenceBinding = (SequenceBinding)object;
        return this.configuration.equals(sequenceBinding.configuration) && Util.equals(this.command, sequenceBinding.command) && this.locale.equals(sequenceBinding.locale) && this.platform.equals(sequenceBinding.platform) && Util.equals(this.plugin, sequenceBinding.plugin) && this.rank == sequenceBinding.rank && this.scope.equals(sequenceBinding.scope) && this.sequence.equals(sequenceBinding.sequence);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getCommand() {
        return this.command;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int getRank() {
        return this.rank;
    }

    public String getScope() {
        return this.scope;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int hashCode() {
        int result = 117;
        result = result * 107 + this.configuration.hashCode();
        result = result * 107 + Util.hashCode(this.command);
        result = result * 107 + this.locale.hashCode();
        result = result * 107 + this.platform.hashCode();
        result = result * 107 + Util.hashCode(this.plugin);
        result = result * 107 + this.rank;
        result = result * 107 + this.scope.hashCode();
        result = result * 107 + this.sequence.hashCode();
        return result;
    }
}

