/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.swt.SWT;
import org.eclipse.ui.internal.commands.Configuration;
import org.eclipse.ui.internal.commands.Path;
import org.eclipse.ui.internal.commands.Scope;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.SequenceBinding;
import org.eclipse.ui.internal.commands.SequenceNode;
import org.eclipse.ui.internal.commands.State;

public final class SequenceMachine {
    private static final String LOCALE_SEPARATOR = "_";
    private static final Locale SYSTEM_LOCALE = Locale.getDefault();
    private static final String SYSTEM_PLATFORM = SWT.getPlatform();
    private Map commandMap;
    private Map commandMapForMode;
    private SortedSet sequenceBindingSet;
    private String configuration = "";
    private SortedMap configurationMap = new TreeMap();
    private SortedMap sequenceMap;
    private SortedMap sequenceMapForMode;
    private Sequence mode;
    private SortedMap scopeMap = new TreeMap();
    private String[] scopes;
    private boolean solved;
    private SortedMap tree;

    public static SequenceMachine create() {
        return new SequenceMachine();
    }

    static SortedMap buildPathMapForConfigurationMap(SortedMap configurationMap) {
        TreeMap<String, Path> pathMap = new TreeMap<String, Path>();
        Iterator iterator = configurationMap.keySet().iterator();
        while (iterator.hasNext()) {
            Path path;
            String id = (String)iterator.next();
            if (id == null || (path = SequenceMachine.getPathForConfiguration(id, configurationMap)) == null) continue;
            pathMap.put(id, path);
        }
        return pathMap;
    }

    static SortedMap buildPathMapForScopeMap(SortedMap scopeMap) {
        TreeMap<String, Path> pathMap = new TreeMap<String, Path>();
        Iterator iterator = scopeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Path path;
            String id = (String)iterator.next();
            if (id == null || (path = SequenceMachine.getPathForScope(id, scopeMap)) == null) continue;
            pathMap.put(id, path);
        }
        return pathMap;
    }

    static Path getPathForConfiguration(String id, Map configurationMap) {
        Path path = null;
        if (id != null) {
            ArrayList<String> strings = new ArrayList<String>();
            while (id != null) {
                if (strings.contains(id)) {
                    return null;
                }
                Configuration configuration = (Configuration)configurationMap.get(id);
                if (configuration == null) {
                    return null;
                }
                strings.add(0, id);
                id = configuration.getParent();
            }
            path = Path.create(strings);
        }
        return path;
    }

    static Path getPathForLocale(String locale) {
        Path path = null;
        if (locale != null) {
            ArrayList<String> strings = new ArrayList<String>();
            if ((locale = locale.trim()).length() > 0) {
                StringTokenizer st = new StringTokenizer(locale, LOCALE_SEPARATOR);
                while (st.hasMoreElements()) {
                    String string = ((String)st.nextElement()).trim();
                    if (string == null) continue;
                    strings.add(string);
                }
            }
            path = Path.create(strings);
        }
        return path;
    }

    static Path getPathForPlatform(String platform) {
        Path path = null;
        if (platform != null) {
            ArrayList<String> strings = new ArrayList<String>();
            if ((platform = platform.trim()).length() > 0) {
                strings.add(platform);
            }
            path = Path.create(strings);
        }
        return path;
    }

    static Path getPathForScope(String id, Map scopeMap) {
        Path path = null;
        if (id != null) {
            ArrayList<String> strings = new ArrayList<String>();
            while (id != null) {
                if (strings.contains(id)) {
                    return null;
                }
                Scope scope = (Scope)scopeMap.get(id);
                if (scope == null) {
                    return null;
                }
                strings.add(0, id);
                id = scope.getParent();
            }
            path = Path.create(strings);
        }
        return path;
    }

    static Path getSystemLocale() {
        return SYSTEM_LOCALE != null ? SequenceMachine.getPathForLocale(SYSTEM_LOCALE.toString()) : null;
    }

    static Path getSystemPlatform() {
        return SequenceMachine.getPathForPlatform(SYSTEM_PLATFORM);
    }

    private SequenceMachine() {
        this.sequenceBindingSet = new TreeSet();
        this.scopes = new String[]{""};
        this.mode = Sequence.create();
    }

    public Map getCommandMap() {
        if (this.commandMap == null) {
            this.solve();
            this.commandMap = Collections.unmodifiableMap(SequenceNode.toCommandMap(this.getSequenceMap()));
        }
        return this.commandMap;
    }

    public Map getCommandMapForMode() {
        if (this.commandMapForMode == null) {
            this.solve();
            TreeMap tree = SequenceNode.find(this.tree, this.mode);
            if (tree == null) {
                tree = new TreeMap();
            }
            this.commandMapForMode = Collections.unmodifiableMap(SequenceNode.toCommandMap(this.getSequenceMapForMode()));
        }
        return this.commandMapForMode;
    }

    public SortedSet getSequenceBindingSet() {
        return this.sequenceBindingSet;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public SortedMap getConfigurationMap() {
        return this.configurationMap;
    }

    public Sequence getFirstSequenceForCommand(String command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        SortedSet sequenceSet = (SortedSet)this.getCommandMap().get(command);
        if (sequenceSet != null && !sequenceSet.isEmpty()) {
            return (Sequence)sequenceSet.first();
        }
        return null;
    }

    public SortedMap getSequenceMap() {
        if (this.sequenceMap == null) {
            this.solve();
            this.sequenceMap = Collections.unmodifiableSortedMap(SequenceNode.toSequenceMap(this.tree, Sequence.create()));
        }
        return this.sequenceMap;
    }

    public SortedMap getSequenceMapForMode() {
        if (this.sequenceMapForMode == null) {
            this.solve();
            TreeMap tree = SequenceNode.find(this.tree, this.mode);
            if (tree == null) {
                tree = new TreeMap();
            }
            this.sequenceMapForMode = Collections.unmodifiableSortedMap(SequenceNode.toSequenceMap(tree, this.mode));
        }
        return this.sequenceMapForMode;
    }

    public Sequence getMode() {
        return this.mode;
    }

    public SortedMap getScopeMap() {
        return this.scopeMap;
    }

    public String[] getScopes() {
        return (String[])this.scopes.clone();
    }

    public boolean setBindingSet(SortedSet sequenceBindingSet) throws IllegalArgumentException {
        if (sequenceBindingSet == null) {
            throw new IllegalArgumentException();
        }
        sequenceBindingSet = new TreeSet(sequenceBindingSet);
        Iterator iterator = sequenceBindingSet.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof SequenceBinding) continue;
            throw new IllegalArgumentException();
        }
        if (this.sequenceBindingSet.equals(sequenceBindingSet)) {
            return false;
        }
        this.sequenceBindingSet = Collections.unmodifiableSortedSet(sequenceBindingSet);
        this.invalidateTree();
        return true;
    }

    public boolean setConfiguration(String configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        if (this.configuration.equals(configuration)) {
            return false;
        }
        this.configuration = configuration;
        this.invalidateSolution();
        return true;
    }

    public boolean setConfigurationMap(SortedMap configurationMap) throws IllegalArgumentException {
        if (configurationMap == null) {
            throw new IllegalArgumentException();
        }
        configurationMap = new TreeMap(configurationMap);
        Iterator iterator = configurationMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey() instanceof String && entry.getValue() instanceof Path) continue;
            throw new IllegalArgumentException();
        }
        if (this.configurationMap.equals(configurationMap)) {
            return false;
        }
        this.configurationMap = Collections.unmodifiableSortedMap(configurationMap);
        this.invalidateTree();
        return true;
    }

    public boolean setMode(Sequence mode) throws IllegalArgumentException {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        if (this.mode.equals(mode)) {
            return false;
        }
        this.mode = mode;
        this.invalidateMode();
        return true;
    }

    public boolean setScopeMap(SortedMap scopeMap) throws IllegalArgumentException {
        if (scopeMap == null) {
            throw new IllegalArgumentException();
        }
        scopeMap = new TreeMap(scopeMap);
        Iterator iterator = scopeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey() instanceof String && entry.getValue() instanceof Path) continue;
            throw new IllegalArgumentException();
        }
        if (this.scopeMap.equals(scopeMap)) {
            return false;
        }
        this.scopeMap = Collections.unmodifiableSortedMap(scopeMap);
        this.invalidateTree();
        return true;
    }

    public boolean setScopes(String[] scopes) throws IllegalArgumentException {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException();
        }
        scopes = (String[])scopes.clone();
        int i = 0;
        while (i < scopes.length) {
            if (scopes[i] == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        if (Arrays.equals(this.scopes, scopes)) {
            return false;
        }
        this.scopes = scopes;
        this.invalidateSolution();
        return true;
    }

    private void build() {
        if (this.tree == null) {
            this.tree = new TreeMap();
            Iterator iterator = this.sequenceBindingSet.iterator();
            while (iterator.hasNext()) {
                Path configuration;
                SequenceBinding sequenceBinding = (SequenceBinding)iterator.next();
                Path scope = (Path)this.scopeMap.get(sequenceBinding.getScope());
                if (scope == null || (configuration = (Path)this.configurationMap.get(sequenceBinding.getConfiguration())) == null) continue;
                ArrayList<Path> paths = new ArrayList<Path>();
                paths.add(scope);
                paths.add(configuration);
                State scopeConfiguration = State.create(paths);
                paths = new ArrayList();
                paths.add(SequenceMachine.getPathForPlatform(sequenceBinding.getPlatform()));
                paths.add(SequenceMachine.getPathForLocale(sequenceBinding.getLocale()));
                State platformLocale = State.create(paths);
                SequenceNode.add(this.tree, sequenceBinding, scopeConfiguration, platformLocale);
            }
        }
    }

    private void invalidateMode() {
        this.commandMapForMode = null;
        this.sequenceMapForMode = null;
    }

    private void invalidateSolution() {
        this.solved = false;
        this.commandMap = null;
        this.sequenceMap = null;
        this.invalidateMode();
    }

    private void invalidateTree() {
        this.tree = null;
        this.invalidateSolution();
    }

    private void solve() {
        if (!this.solved) {
            this.build();
            State[] scopeConfigurations = new State[this.scopes.length];
            Path configuration = (Path)this.configurationMap.get(this.configuration);
            if (configuration == null) {
                configuration = Path.create();
            }
            int i = 0;
            while (i < this.scopes.length) {
                Path scope = (Path)this.scopeMap.get(this.scopes[i]);
                if (scope == null) {
                    scope = Path.create();
                }
                ArrayList<Path> paths = new ArrayList<Path>();
                paths.add(scope);
                paths.add(configuration);
                scopeConfigurations[i] = State.create(paths);
                ++i;
            }
            ArrayList<Path> paths = new ArrayList<Path>();
            paths.add(SequenceMachine.getSystemPlatform());
            paths.add(SequenceMachine.getSystemLocale());
            State platformLocale = State.create(paths);
            SequenceNode.solve(this.tree, scopeConfigurations, new State[]{platformLocale});
            this.solved = true;
        }
    }
}

