/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecorationReference;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class DecorationScheduler {
    private Map resultCache = new HashMap();
    private List awaitingDecoration = new ArrayList();
    private Set pendingUpdate = new HashSet();
    private Object resultLock = new Object();
    private Map awaitingDecorationValues = new HashMap();
    private DecoratorManager decoratorManager;
    private boolean shutdown = false;
    private Thread decoratorUpdateThread;

    DecorationScheduler(DecoratorManager manager) {
        this.decoratorManager = manager;
    }

    public String decorateWithText(String text, Object element, Object adaptedElement) {
        if (element == null) {
            return text;
        }
        DecorationResult decoration = (DecorationResult)this.resultCache.get(element);
        if (decoration == null) {
            this.queueForDecoration(element, adaptedElement, false);
            return text;
        }
        return decoration.decorateWithText(text);
    }

    synchronized void queueForDecoration(Object element, Object adaptedElement, boolean forceUpdate) {
        if (this.decoratorUpdateThread == null) {
            this.createDecoratorThread();
            this.decoratorUpdateThread.start();
        }
        if (!this.awaitingDecorationValues.containsKey(element)) {
            DecorationReference reference = new DecorationReference(element, adaptedElement);
            reference.setForceUpdate(forceUpdate);
            this.awaitingDecorationValues.put(element, reference);
            this.awaitingDecoration.add(element);
            this.notifyAll();
        }
    }

    public Image decorateWithOverlays(Image image, Object element, Object adaptedElement) {
        if (element == null) {
            return image;
        }
        DecorationResult decoration = (DecorationResult)this.resultCache.get(element);
        if (decoration == null) {
            this.queueForDecoration(element, adaptedElement, false);
            return image;
        }
        return decoration.decorateWithOverlays(image, this.decoratorManager.getLightweightManager().getOverlayCache());
    }

    public void decorated() {
        if (!this.shutdown) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (DecorationScheduler.this.pendingUpdate.isEmpty()) {
                        return;
                    }
                    Object object = DecorationScheduler.this.resultLock;
                    synchronized (object) {
                        Object[] elements = DecorationScheduler.this.pendingUpdate.toArray(new Object[DecorationScheduler.this.pendingUpdate.size()]);
                        DecorationScheduler.this.pendingUpdate.clear();
                        DecorationScheduler.this.decoratorManager.fireListeners(new LabelProviderChangedEvent((IBaseLabelProvider)DecorationScheduler.this.decoratorManager, elements));
                        if (DecorationScheduler.this.awaitingDecoration.isEmpty()) {
                            DecorationScheduler.this.resultCache.clear();
                        }
                    }
                }
            });
        }
    }

    void shutdown() {
        this.shutdown = true;
        DecorationScheduler decorationScheduler = this;
        synchronized (decorationScheduler) {
            this.notifyAll();
        }
        try {
            if (this.decoratorUpdateThread != null) {
                this.decoratorUpdateThread.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized DecorationReference next() {
        try {
            if (this.shutdown) {
                return null;
            }
            while (true) {
                if (this.shutdown || !this.awaitingDecoration.isEmpty()) {
                    if (!this.shutdown) break;
                    return null;
                }
                this.wait();
            }
            Object element = this.awaitingDecoration.remove(0);
            return (DecorationReference)this.awaitingDecorationValues.remove(element);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private void createDecoratorThread() {
        Runnable decorationRunnable = new Runnable(){

            public void run() {
                while (true) {
                    DecorationReference reference = DecorationScheduler.this.next();
                    DecorationBuilder cacheResult = new DecorationBuilder();
                    if (reference == null) {
                        return;
                    }
                    Object element = reference.getElement();
                    Object adapted = reference.getAdaptedElement();
                    boolean elementIsCached = true;
                    DecorationResult adaptedResult = null;
                    Object object = DecorationScheduler.this.resultLock;
                    synchronized (object) {
                        elementIsCached = DecorationScheduler.this.resultCache.containsKey(element);
                        if (elementIsCached) {
                            DecorationScheduler.this.pendingUpdate.add(element);
                        }
                        if (adapted != null) {
                            adaptedResult = (DecorationResult)DecorationScheduler.this.resultCache.get(adapted);
                        }
                    }
                    if (!elementIsCached) {
                        if (adapted != null) {
                            if (adaptedResult == null) {
                                DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(adapted, cacheResult);
                                if (cacheResult.hasValue()) {
                                    adaptedResult = cacheResult.createResult();
                                }
                            } else {
                                cacheResult.applyResult(adaptedResult);
                                adaptedResult = null;
                            }
                        }
                        DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(element, cacheResult);
                        if (cacheResult.hasValue() || reference.shouldForceUpdate()) {
                            object = DecorationScheduler.this.resultLock;
                            synchronized (object) {
                                if (adaptedResult != null) {
                                    DecorationScheduler.this.resultCache.put(adapted, adaptedResult);
                                }
                                if (cacheResult.hasValue()) {
                                    DecorationScheduler.this.resultCache.put(element, cacheResult.createResult());
                                }
                                DecorationScheduler.this.pendingUpdate.add(element);
                            }
                        }
                    }
                    if (!DecorationScheduler.this.awaitingDecoration.isEmpty()) continue;
                    DecorationScheduler.this.decorated();
                }
            }
        };
        this.decoratorUpdateThread = new Thread(decorationRunnable, "Decoration");
        this.decoratorUpdateThread.setDaemon(true);
        this.decoratorUpdateThread.setPriority(1);
    }

    void clearResults() {
        Object object = this.resultLock;
        synchronized (object) {
            this.resultCache.clear();
        }
    }
}

