/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

class DecoratorOverlayIcon
extends CompositeImageDescriptor {
    private Image base;
    private ImageDescriptor[] overlays;
    private Point size;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;

    public DecoratorOverlayIcon(Image base, ImageDescriptor[] overlays, Point size) {
        this.base = base;
        this.overlays = overlays;
        this.size = size;
    }

    protected void drawOverlays(ImageDescriptor[] overlays) {
        Point size = this.getSize();
        int i = 0;
        while (i < overlays.length) {
            ImageDescriptor overlay = overlays[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, size.x - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, size.y - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, size.x - overlayData.width, size.y - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DecoratorOverlayIcon)) {
            return false;
        }
        DecoratorOverlayIcon other = (DecoratorOverlayIcon)((Object)o);
        return this.base.equals((Object)other.base) && Arrays.equals(this.overlays, other.overlays);
    }

    public int hashCode() {
        int code = this.base.hashCode();
        int i = 0;
        while (i < this.overlays.length) {
            if (this.overlays[i] != null) {
                code ^= this.overlays[i].hashCode();
            }
            ++i;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageDescriptor underlay = this.overlays[4];
        if (underlay != null) {
            this.drawImage(underlay.getImageData(), 0, 0);
        }
        this.drawImage(this.base.getImageData(), 0, 0);
        this.drawOverlays(this.overlays);
    }

    protected Point getSize() {
        return this.size;
    }
}

