/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.AboutFeaturesDialog;
import org.eclipse.ui.internal.dialogs.AboutPluginsDialog;
import org.eclipse.ui.internal.dialogs.ProductInfoDialog;

public class AboutDialog
extends ProductInfoDialog {
    private static final int MAX_IMAGE_WIDTH_FOR_TEXT = 250;
    private static final int FEATURES_ID = 1025;
    private static final int PLUGINS_ID = 1026;
    private static final int INFO_ID = 1027;
    private IWorkbenchWindow window;
    private Workbench workbench;
    private Image image;
    private AboutInfo aboutInfo;
    private ArrayList images = new ArrayList();
    private StyledText text;

    public AboutDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this.window = window;
        this.workbench = (Workbench)window.getWorkbench();
        this.aboutInfo = this.workbench.getConfigurationInfo().getAboutInfo();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                new AboutFeaturesDialog(this.getShell()).open();
                return;
            }
            case 1026: {
                new AboutPluginsDialog(this.getShell()).open();
                return;
            }
            case 1027: {
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        AboutDialog.this.workbench.getConfigurationInfo().openSystemSummaryEditor(AboutDialog.this.window);
                    }
                });
                this.close();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        if (this.image != null) {
            this.image.dispose();
        }
        int i = 0;
        while (i < this.images.size()) {
            ((Image)this.images.get(i)).dispose();
            ++i;
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String name = this.aboutInfo.getProductName();
        if (name != null) {
            newShell.setText(WorkbenchMessages.format("AboutDialog.shellTitle", new Object[]{name}));
        }
        WorkbenchHelp.setHelp((Control)newShell, "org.eclipse.ui.about_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1025, WorkbenchMessages.getString("AboutDialog.featureInfo"), false);
        this.createButton(parent, 1026, WorkbenchMessages.getString("AboutDialog.pluginInfo"), false);
        this.createButton(parent, 1027, WorkbenchMessages.getString("AboutDialog.systemInfo"), false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        String aboutText;
        this.setHandCursor(new Cursor((Device)parent.getDisplay(), 21));
        this.setBusyCursor(new Cursor((Device)parent.getDisplay(), 1));
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AboutDialog.this.getHandCursor() != null) {
                    AboutDialog.this.getHandCursor().dispose();
                }
                if (AboutDialog.this.getBusyCursor() != null) {
                    AboutDialog.this.getBusyCursor().dispose();
                }
            }
        });
        ImageDescriptor imageDescriptor = this.aboutInfo.getAboutImage();
        if (imageDescriptor != null) {
            this.image = imageDescriptor.createImage();
        }
        if ((this.image == null || this.image.getBounds().width <= 250) && (aboutText = this.aboutInfo.getAboutText()) != null) {
            this.setItem(this.scan(aboutText));
        }
        Composite outer = (Composite)super.createDialogArea(parent);
        outer.setSize(outer.computeSize(-1, -1));
        GridLayout layout = new GridLayout();
        outer.setLayout((Layout)layout);
        outer.setLayoutData((Object)new GridData(1808));
        Composite topContainer = new Composite(outer, 0);
        layout = new GridLayout();
        layout.numColumns = this.image == null || this.getItem() == null ? 1 : 2;
        layout.marginWidth = 0;
        topContainer.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        topContainer.setLayoutData((Object)data);
        if (this.image != null) {
            Label imageLabel = new Label(topContainer, 0);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = false;
            imageLabel.setLayoutData((Object)data);
            imageLabel.setImage(this.image);
        }
        if (this.getItem() != null) {
            this.text = new StyledText(topContainer, 10);
            this.text.setCaret(null);
            this.text.setFont(parent.getFont());
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = true;
            this.text.setText(this.getItem().getText());
            this.text.setLayoutData((Object)data);
            this.text.setCursor(null);
            this.text.setBackground(topContainer.getBackground());
            this.setLinkRanges(this.text, this.getItem().getLinkRanges());
            this.addListeners(this.text);
        }
        Label bar = new Label(outer, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        Composite featureContainer = new Composite(outer, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        featureContainer.setLayout((Layout)rowLayout);
        data = new GridData();
        data.horizontalAlignment = 4;
        featureContainer.setLayoutData((Object)data);
        AboutInfo[] infoArray = this.getFeaturesInfo();
        int i = 0;
        while (i < infoArray.length) {
            ImageDescriptor desc = infoArray[i].getFeatureImage();
            Image image = null;
            if (desc != null) {
                Button button = new Button(featureContainer, 0x800008);
                button.setData((Object)infoArray[i]);
                image = desc.createImage();
                this.images.add(image);
                button.setImage(image);
                String name = infoArray[i].getProviderName();
                if (name == null) {
                    name = "";
                }
                button.setToolTipText(name);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        AboutFeaturesDialog d = new AboutFeaturesDialog(AboutDialog.this.getShell());
                        d.setInitialSelection((AboutInfo)event.widget.getData());
                        d.open();
                    }
                });
            }
            ++i;
        }
        bar = new Label(outer, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        return outer;
    }

    private AboutInfo[] getFeaturesInfo() {
        AboutInfo[] rawArray = this.workbench.getConfigurationInfo().getFeaturesInfo();
        ArrayList<AboutInfo> infoList = new ArrayList<AboutInfo>();
        int i = 0;
        while (i < rawArray.length) {
            if (rawArray[i].getProviderName() != null && rawArray[i].getFeatureImageName() != null) {
                infoList.add(rawArray[i]);
            }
            ++i;
        }
        AboutInfo[] infoArray = infoList.toArray(new AboutInfo[infoList.size()]);
        infoList = new ArrayList();
        int i2 = 0;
        while (i2 < infoArray.length) {
            boolean add = true;
            int j = 0;
            while (j < infoList.size()) {
                AboutInfo current = (AboutInfo)infoList.get(j);
                if (current.getProviderName().equals(infoArray[i2].getProviderName()) && current.getFeatureImageName().equals(infoArray[i2].getFeatureImageName())) {
                    Long crc1 = current.getFeatureImageCRC();
                    Long crc2 = infoArray[i2].getFeatureImageCRC();
                    if (crc1 != null && crc1.equals(crc2)) {
                        add = false;
                        break;
                    }
                }
                ++j;
            }
            if (add) {
                infoList.add(infoArray[i2]);
            }
            ++i2;
        }
        ((AbstractCollection)infoList).remove(this.aboutInfo);
        return infoList.toArray(new AboutInfo[infoList.size()]);
    }
}

